/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.lotmainfile.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.BOSExpressionContext;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;

public class LotMainFileConfigHelper {
    private static final Log logger = LogFactory.getLog(LotMainFileConfigHelper.class);

    public static boolean isUseLotMainFile() {
        DynamicObject checkEnableLotMainFileParam = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_scmcapplevelparam", (String)"enable", (QFilter[])new QFilter("number", "=", (Object)"INV0003").toArray());
        if (checkEnableLotMainFileParam != null) {
            return checkEnableLotMainFileParam.getBoolean("enable");
        }
        return false;
    }

    public static int getUnqctrl() {
        DynamicObject lotCodeuniRangeConf = BusinessDataServiceHelper.loadSingleFromCache((String)"msmod_lotmfunirangeconf", (String)"uniquerange", (QFilter[])new QFilter[0]);
        if (lotCodeuniRangeConf != null) {
            return lotCodeuniRangeConf.getInt("uniquerange");
        }
        return 0;
    }

    public static String getIdent(String colpath) {
        String[] colnodes = colpath.split("\\.");
        return colnodes[colnodes.length - 1];
    }

    public static String getBasedataTabletype(String billtype, String fieldCol) {
        Map fieldTypes = MetadataServiceHelper.getDataEntityType((String)billtype).getAllFields();
        IDataEntityProperty fieldProp = (IDataEntityProperty)fieldTypes.get(LotMainFileConfigHelper.getIdent(fieldCol));
        if (fieldProp instanceof BasedataProp) {
            return ((BasedataProp)fieldProp).getBaseEntityId();
        }
        return "";
    }

    public static Collection<DynamicObject> getLotMainFileBillConfig(String billtype, boolean orderbyGenlot) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"msmod_lotbillconf", (QFilter[])new QFilter("srcbillobj", "=", (Object)billtype).and("enable", "=", (Object)Boolean.TRUE).toArray());
        Comparator<DynamicObject> comparator = null;
        comparator = orderbyGenlot ? new LotBillconfGenlotComparator() : new LotBillconfMovedirctionComparator();
        return cfgs.values().stream().sorted(comparator).collect(Collectors.toList());
    }

    public static Set<DynamicObject> getLotMainFileBillConfigByBillAndLotId(String billtype, String entrytype, DynamicObject bill, String lotidField) {
        Collection<DynamicObject> cfgs = LotMainFileConfigHelper.getLotMainFileBillConfigByLotid(billtype, entrytype, lotidField);
        HashSet<DynamicObject> cfgDynamicObject = new HashSet<DynamicObject>(10);
        for (DynamicObject cfg : cfgs) {
            if (!LotMainFileConfigHelper.isDynamicObjectMatchCfg(billtype, bill, cfg)) continue;
            cfgDynamicObject.add(cfg);
        }
        return cfgDynamicObject;
    }

    public static Set<DynamicObject> getLotMainFileBillConfigByBillAndLotNum(String billtype, String entrytype, DynamicObject bill, String lotnumField) {
        Collection<DynamicObject> cfgs = LotMainFileConfigHelper.getLotMainFileBillConfigByLotnum(billtype, entrytype, lotnumField);
        HashSet<DynamicObject> cfgDynamicObject = new HashSet<DynamicObject>(10);
        for (DynamicObject cfg : cfgs) {
            if (!LotMainFileConfigHelper.isDynamicObjectMatchCfg(billtype, bill, cfg)) continue;
            cfgDynamicObject.add(cfg);
        }
        return cfgDynamicObject;
    }

    public static boolean isDynamicObjectMatchCfg(String billtype, DynamicObject billObj, DynamicObject cfg) {
        String jsonCondition = cfg.getString("billfilter");
        if (jsonCondition == null || jsonCondition.isEmpty() || billtype == null) {
            return true;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        if (filterCondition.getFilterRow().isEmpty()) {
            return true;
        }
        MainEntityType mainType = (MainEntityType)billObj.getDataEntityType();
        FilterBuilder builder = new FilterBuilder(mainType, filterCondition);
        String[] script = builder.buildFilterScript();
        BOSExpression expr = new BOSExpression(script[0]);
        RowDataModel rowModel = new RowDataModel(billtype, mainType);
        BOSExpressionContext expContext = new BOSExpressionContext(rowModel);
        expContext.getRowDataModel().setRowContext((Object)billObj, 0);
        Boolean result = (Boolean)CalcExprParser.getExpressionValue((BOSExpression)expr, (ExpressionContext)expContext, (FunctionManage)FunctionManage.get());
        return result;
    }

    private static Collection<DynamicObject> getLotMainFileBillConfigByLotid(String billtype, String entrytype, String lotidField) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"msmod_lotbillconf", (QFilter[])new QFilter("srcbillobj", "=", (Object)billtype).and("srcbillentry", "=", (Object)entrytype).and("lotidfield", "=", (Object)lotidField).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return cfgs.values().stream().sorted(new LotBillconfMovedirctionComparator()).collect(Collectors.toList());
    }

    private static Collection<DynamicObject> getLotMainFileBillConfigByLotnum(String billtype, String entrytype, String lotnumField) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"msmod_lotbillconf", (QFilter[])new QFilter("srcbillobj", "=", (Object)billtype).and("srcbillentry", "=", (Object)entrytype).and("lotnumberfield", "=", (Object)lotnumField).and("enable", "=", (Object)Boolean.TRUE).toArray());
        return cfgs.values().stream().sorted(new LotBillconfMovedirctionComparator()).collect(Collectors.toList());
    }

    public static QFilter parseBillFilter(String jsonCondition, String billtype) {
        if (jsonCondition == null || jsonCondition.isEmpty() || billtype == null) {
            return null;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)billtype), condition);
        fb.buildFilter();
        return fb.getQFilter();
    }

    public static Map<String, Set<String>> getBillCfgsMatchMap(String billtype, Collection<DynamicObject> cfgs, List<Long> billIds) {
        HashMap<String, Set<String>> billCfgsMap = new HashMap<String, Set<String>>(billIds.size() * 2);
        for (DynamicObject cfg : cfgs) {
            StringBuilder identPreBuilder = new StringBuilder(cfg.getString("lotidfield")).append('-').append(cfg.getString("movedirection")).append('-');
            String identPre = identPreBuilder.toString();
            QFilter filter = new QFilter("id", "in", billIds);
            QFilter cfgFilter = LotMainFileConfigHelper.parseBillFilter(cfg.getString("billfilter"), billtype);
            if (cfgFilter != null) {
                filter.and(cfgFilter);
            }
            DynamicObjectCollection bills = QueryServiceHelper.query((String)billtype, (String)"id", (QFilter[])filter.toArray());
            for (DynamicObject bill : bills) {
                Long billId = bill.getLong("id");
                String ident = identPre + billId;
                Set cfgSet = billCfgsMap.getOrDefault(ident, new HashSet());
                cfgSet.add(cfg.getString("number"));
                if (billCfgsMap.containsKey(ident)) continue;
                billCfgsMap.put(ident, cfgSet);
            }
        }
        return billCfgsMap;
    }

    public static LinkedHashMap<String, DynamicObject> getLotmainfMaps(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("mainfentry");
        LinkedHashMap<String, DynamicObject> maps = new LinkedHashMap<String, DynamicObject>(entries.size());
        for (DynamicObject entry : entries) {
            if ("material".equals(entry.getString("mainfcol"))) continue;
            maps.put(entry.getString("mainfcol"), entry);
        }
        return maps;
    }

    public static LinkedHashMap<String, String> getTrackMaps(DynamicObject cfg) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("trackentry");
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>(entries.size());
        for (DynamicObject entry : entries) {
            maps.put(entry.getString("trackcol"), entry.getString("tracksrcbillcol"));
        }
        return maps;
    }

    public static LinkedHashMap<String, String> getReturnConditonMaps(DynamicObject cfg, String param) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("lotmfreturnentry");
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>(entries.size());
        for (DynamicObject entry : entries) {
            if (!entry.getBoolean(param) || "material".equals(entry.getString("lotmfreturncol"))) continue;
            maps.put(entry.getString("lotmfreturncol"), entry.getString("lotmfreturnsrcbillcol"));
        }
        return maps;
    }

    public static String getEntryPath(String billtype, String entrytype) {
        String parentEntry = LotMainFileConfigHelper.getParentEntryName(billtype, entrytype);
        if (parentEntry != null) {
            return parentEntry + '.' + entrytype;
        }
        return entrytype;
    }

    public static String getParentEntryName(String billtype, String entrytype) {
        if (billtype == null || entrytype == null) {
            return null;
        }
        MainEntityType meta = MetadataServiceHelper.getDataEntityType((String)billtype);
        EntityType entry = (EntityType)meta.getAllEntities().get(entrytype);
        IDataEntityType parent = entry.getParent();
        if (parent instanceof MainEntityType) {
            return null;
        }
        return parent.getName();
    }

    public static String getParamField(DynamicObject cfg, String param) {
        if (cfg == null) {
            return null;
        }
        DynamicObjectCollection mainFileInfo = cfg.getDynamicObjectCollection("mainfentry");
        for (DynamicObject entryObj : mainFileInfo) {
            if (!param.equals(entryObj.getString("mainfcol"))) continue;
            return entryObj.getString("mainfsrcbillcol");
        }
        return "";
    }

    public static Object getDynamicVal(DynamicObject billObj, DynamicObject entryObj, String param, Boolean paramFlag) {
        Object dynamicVal;
        String[] paramNodes = param.split("\\.");
        if (paramNodes.length > 1) {
            int paramLength = param.length();
            dynamicVal = entryObj.get(param.substring(param.lastIndexOf(".") + 1, paramLength));
        } else {
            dynamicVal = billObj.get(param);
        }
        if (dynamicVal == null) {
            return null;
        }
        if (dynamicVal instanceof DynamicObject && paramFlag.booleanValue()) {
            return ((DynamicObject)dynamicVal).getPkValue();
        }
        return dynamicVal;
    }

    public static long genId(String tablename) {
        return DB.genLongId((String)tablename);
    }

    public static long[] batchGenId(String tablename, int count) {
        return DB.genLongIds((String)tablename, (int)count);
    }

    public static Map<String, Object> getColDefaultValues(LinkedHashMap<String, DynamicObject> lotMainFileMaps) {
        if (lotMainFileMaps == null || lotMainFileMaps.isEmpty()) {
            return null;
        }
        HashMap<String, Object> defaultValues = new HashMap<String, Object>(lotMainFileMaps.size());
        Map lotMainFileFields = MetadataServiceHelper.getDataEntityType((String)"bd_lot").getAllFields();
        for (Map.Entry<String, DynamicObject> col : lotMainFileMaps.entrySet()) {
            DynamicObject value = col.getValue();
            String billCol = value.getString("mainfsrcbillcol");
            defaultValues.put(billCol, LotMainFileConfigHelper.getColDefaultValue((IDataEntityProperty)lotMainFileFields.get(col.getKey())));
        }
        return defaultValues;
    }

    private static Object getColDefaultValue(IDataEntityProperty iDataEntityProperty) {
        if (iDataEntityProperty instanceof BooleanProp) {
            return "0";
        }
        if (iDataEntityProperty instanceof TextProp) {
            return "";
        }
        if (iDataEntityProperty instanceof LongProp) {
            return 0L;
        }
        if (iDataEntityProperty instanceof DecimalProp) {
            return 0;
        }
        return null;
    }

    public static void delRepeatLot() {
        int unqCtrl = LotMainFileConfigHelper.getUnqctrl();
        if (unqCtrl == 0) {
            return;
        }
        DBRoute scmRoute = new DBRoute("scm");
        String ruleSql = "select t.fsrcbillobj,t.fsrcbillentry,t.flotidfield from t_msmod_lotbillconf t where fenable = '1'";
        HashMap ruleAttrs = new HashMap(100);
        try (DataSet ruleSet = DB.queryDataSet((String)LotMainFileConfigHelper.class.getName(), (DBRoute)scmRoute, (String)ruleSql);){
            for (Row row : ruleSet) {
                String srcbillobj = row.getString("fsrcbillobj");
                String srcbillentry = row.getString("fsrcbillentry");
                String lotidfield = row.getString("flotidfield");
                String key = srcbillobj + '#' + srcbillentry + '#' + lotidfield;
                String lotidfieldkey = LotMainFileConfigHelper.getPure(lotidfield);
                MainEntityType billtypeMeta = MetadataServiceHelper.getDataEntityType((String)srcbillobj);
                EntityType entrytypeMeta = (EntityType)billtypeMeta.getAllEntities().get(srcbillentry);
                String billTablename = billtypeMeta.getAlias();
                String entryTablename = entrytypeMeta.getAlias();
                String billidCol = billtypeMeta.getPrimaryKey().getAlias();
                String entryidCol = entrytypeMeta.getPrimaryKey().getAlias();
                String lotidCol = ((IDataEntityProperty)billtypeMeta.getAllFields().get(lotidfieldkey)).getAlias();
                String updateSql = "update " + entryTablename + " set " + lotidCol + " = ? where " + entryidCol + " = ?";
                String billRoute = billtypeMeta.getDBRouteKey();
                HashMap<String, String> ruleAttr = new HashMap<String, String>(4);
                ruleAttr.put("updateSql", updateSql);
                ruleAttr.put("billTablename", billTablename);
                ruleAttr.put("billidCol", billidCol);
                ruleAttr.put("billRoute", billRoute);
                ruleAttrs.put(key, ruleAttr);
            }
        }
        StringBuilder repeatFieldsBuilder = new StringBuilder("fnumber,fmasterfiletypeid");
        if (unqCtrl == 2 || unqCtrl == 4) {
            repeatFieldsBuilder.append(",fmaterialid");
        }
        if (unqCtrl == 3 || unqCtrl == 4) {
            repeatFieldsBuilder.append(",fcreateorgid");
        }
        String repeatSql = "select " + repeatFieldsBuilder + ",count(1) as count from t_bd_lot " + "group by " + repeatFieldsBuilder + " having count(1) > 1";
        StringBuilder lotSqlBuilder = new StringBuilder("select t.fid as lotid,m.fid as trackid,m.flotidfield,m.fbillentityid,m.fbillid,m.fbillentrytype,m.fbillentryid ").append("from t_bd_lot t left join t_bd_lotmovetrack m on t.fid = m.flotid ").append("where t.fnumber = ? and t.fmasterfiletypeid = ? ");
        if (unqCtrl == 2 || unqCtrl == 4) {
            lotSqlBuilder.append("and t.fmaterialid = ? ");
        }
        if (unqCtrl == 3 || unqCtrl == 4) {
            lotSqlBuilder.append("and t.fcreateorgid = ? ");
        }
        lotSqlBuilder.append("order by t.fid,m.fid");
        String lotSql = lotSqlBuilder.toString();
        String updTrkSql = "update t_bd_lotmovetrack set flotid = ? where fid = ?";
        try (DataSet repeatSet = DB.queryDataSet((String)LotMainFileConfigHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)repeatSql);){
            for (Row row : repeatSet) {
                String lotnum = row.getString("fnumber");
                Long masterfiletypeid = row.getLong("fmasterfiletypeid");
                Long materialid = 0L;
                Long createorgid = 0L;
                if (unqCtrl == 2 || unqCtrl == 4) {
                    materialid = row.getLong("fmaterialid");
                }
                if (unqCtrl == 3 || unqCtrl == 4) {
                    createorgid = row.getLong("fcreateorgid");
                }
                Integer count = row.getInteger("count");
                long firstLotId = 0L;
                ArrayList<Object[]> updTrkParams = new ArrayList<Object[]>(20);
                HashSet<Long> needDelLotIds = new HashSet<Long>(4);
                ArrayList<Object> lotParamList = new ArrayList<Object>(4);
                lotParamList.add(lotnum);
                lotParamList.add(masterfiletypeid);
                if (unqCtrl == 2 || unqCtrl == 4) {
                    lotParamList.add(materialid);
                }
                if (unqCtrl == 3 || unqCtrl == 4) {
                    lotParamList.add(createorgid);
                }
                Object[] lotParams = lotParamList.toArray();
                try {
                    TXHandle tx = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        try (DataSet lotSet = LotMainFileConfigHelper.delRepeatGetLotDataSets(lotSql, lotParams);){
                            for (Row lotRow : lotSet) {
                                long lotid = lotRow.getLong("lotid");
                                if (firstLotId == 0L) {
                                    firstLotId = lotid;
                                }
                                if (lotid == firstLotId) continue;
                                needDelLotIds.add(lotid);
                                Long trackid = lotRow.getLong("trackid");
                                if (trackid == null || trackid.equals(0L)) continue;
                                updTrkParams.add(new Object[]{firstLotId, trackid});
                                String billtype = lotRow.getString("fbillentityid");
                                String entrytype = lotRow.getString("fbillentrytype");
                                String lotidfield = lotRow.getString("flotidfield");
                                String key = billtype + '#' + entrytype + '#' + lotidfield;
                                Map ruleAttr = (Map)ruleAttrs.get(key);
                                if (ruleAttr == null || ruleAttr.isEmpty()) continue;
                                String updateSql = (String)ruleAttr.get("updateSql");
                                String billTablename = (String)ruleAttr.get("billTablename");
                                String billidCol = (String)ruleAttr.get("billidCol");
                                String billRoute = (String)ruleAttr.get("billRoute");
                                Long billid = lotRow.getLong("fbillid");
                                Long entryid = lotRow.getLong("fbillentryid");
                                TXHandle tx0 = TX.requiresNew();
                                Throwable throwable2 = null;
                                try {
                                    ShardingHintContext ctx = ShardingHintContext.createAndSet((String)billTablename, (HintCondition[])new HintCondition[]{new HintCondition(billidCol, FilterType.eq, (Object)billid)});
                                    Throwable throwable3 = null;
                                    try {
                                        LotMainFileConfigHelper.delRepeatExecuteSql(new DBRoute(billRoute), updateSql, new Object[]{firstLotId, entryid});
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3 = throwable4;
                                        throw throwable4;
                                    }
                                    finally {
                                        if (ctx == null) continue;
                                        if (throwable3 != null) {
                                            try {
                                                ctx.close();
                                            }
                                            catch (Throwable throwable5) {
                                                throwable3.addSuppressed(throwable5);
                                            }
                                            continue;
                                        }
                                        ctx.close();
                                    }
                                }
                                catch (Throwable throwable6) {
                                    throwable2 = throwable6;
                                    throw throwable6;
                                }
                                finally {
                                    if (tx0 == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            tx0.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable2.addSuppressed(throwable7);
                                        }
                                        continue;
                                    }
                                    tx0.close();
                                }
                            }
                        }
                        if (updTrkParams.size() > 0) {
                            LotMainFileConfigHelper.delRepeatExecuteBatch(DBRoute.basedata, updTrkSql, updTrkParams);
                            updTrkParams.clear();
                        }
                        if (needDelLotIds.size() <= 0) continue;
                        SqlBuilder delLotSqlBuilder = new SqlBuilder();
                        delLotSqlBuilder.append("delete from t_bd_lot where ", new Object[0]).appendIn("fid", needDelLotIds.toArray());
                        LotMainFileConfigHelper.delRepeatExecuteSql(DBRoute.basedata, delLotSqlBuilder);
                        needDelLotIds.clear();
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable9) {
                                throwable.addSuppressed(throwable9);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    public static void buildUnqIndex() {
        int unqCtrl = LotMainFileConfigHelper.getUnqctrl();
        if (unqCtrl != 0) {
            String dropSql = "EXEC p_DropIdx 'IDX_BD_LOT_UNIQUE', 'T_BD_LOT'";
            DB.execute((DBRoute)DBRoute.basedata, (String)dropSql);
            StringBuilder createSqlBuilder = new StringBuilder("CREATE UNIQUE INDEX IDX_BD_LOT_UNIQUE ON T_BD_LOT ( ").append("FNUMBER,FMASTERFILETYPEID");
            if (unqCtrl == 2 || unqCtrl == 4) {
                createSqlBuilder.append(",FMATERIALID");
            }
            if (unqCtrl == 3 || unqCtrl == 4) {
                createSqlBuilder.append(",FCREATEORGID");
            }
            createSqlBuilder.append(" )");
            DB.execute((DBRoute)DBRoute.basedata, (String)createSqlBuilder.toString());
        }
    }

    private static String getPure(String currentValue) {
        int lastIndex = currentValue.lastIndexOf(46);
        if (lastIndex != -1) {
            return currentValue.substring(lastIndex + 1);
        }
        return currentValue;
    }

    private static DataSet delRepeatGetLotDataSets(String lotSql, Object[] lotParams) {
        return DB.queryDataSet((String)LotMainFileConfigHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)lotSql, (Object[])lotParams);
    }

    private static void delRepeatExecuteSql(DBRoute route, SqlBuilder sqlBuilder) {
        DB.execute((DBRoute)route, (SqlBuilder)sqlBuilder);
    }

    private static void delRepeatExecuteSql(DBRoute route, String sql, Object[] params) {
        DB.execute((DBRoute)route, (String)sql, (Object[])params);
    }

    private static void delRepeatExecuteBatch(DBRoute route, String sql, List<Object[]> params) {
        DB.executeBatch((DBRoute)route, (String)sql, params);
    }

    private static class LotBillconfGenlotComparator
    implements Comparator<DynamicObject> {
        private LotBillconfGenlotComparator() {
        }

        @Override
        public int compare(DynamicObject cfg1, DynamicObject cfg2) {
            Boolean genlot2;
            Boolean genlot1 = cfg1.getBoolean("genlot");
            if (genlot1.equals(genlot2 = Boolean.valueOf(cfg2.getBoolean("genlot")))) {
                long result = (Long)cfg1.getPkValue() - (Long)cfg2.getPkValue();
                return result > 0L ? 1 : (result < 0L ? -1 : 0);
            }
            return genlot1 != false ? -1 : 1;
        }
    }

    private static class LotBillconfMovedirctionComparator
    implements Comparator<DynamicObject> {
        private LotBillconfMovedirctionComparator() {
        }

        @Override
        public int compare(DynamicObject cfg1, DynamicObject cfg2) {
            String movedirection2;
            String movedirection1 = cfg1.getString("movedirection");
            if (movedirection1.equals(movedirection2 = cfg2.getString("movedirection"))) {
                long result = (Long)cfg1.getPkValue() - (Long)cfg2.getPkValue();
                return result > 0L ? 1 : (result < 0L ? -1 : 0);
            }
            return "B".equals(movedirection1) ? -1 : 1;
        }
    }
}

