/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.lotmainfile.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscommon.lotmainfile.biz.LotMainFileGenerator;
import kd.mpscmm.mscommon.lotmainfile.biz.LotMainFileOperateGenerator;
import kd.mpscmm.mscommon.lotmainfile.biz.LotMainFileOperator;
import kd.mpscmm.mscommon.lotmainfile.biz.LotMainFileUnhandleOperator;
import kd.mpscmm.mscommon.lotmainfile.helper.LotMainFileConfigHelper;
import kd.mpscmm.mscommon.lotmainfile.mservice.api.LotMainFileService;

public class LotMainFileServiceImpl
implements LotMainFileService {
    private static final Log logger = LogFactory.getLog(LotMainFileServiceImpl.class);

    @Override
    public Map<Integer, String> saveLotMainFileByBillOperate(String operate, DynamicObject bill, DynamicObjectCollection entry, String lotidField) {
        HashMap<Integer, String> msgMap = new HashMap<Integer, String>(10);
        this.checkParams(operate, bill, entry, lotidField);
        boolean isUseLotMainFile = LotMainFileConfigHelper.isUseLotMainFile();
        if (isUseLotMainFile) {
            this.checkSaveBill(bill);
            String billtype = bill.getDataEntityType().getName();
            String entryType = entry.getDynamicObjectType().getName();
            Set<DynamicObject> cfgDynamicObject = LotMainFileConfigHelper.getLotMainFileBillConfigByBillAndLotId(billtype, entryType, bill, lotidField);
            this.checkDumplicate(cfgDynamicObject);
            for (DynamicObject cfg : cfgDynamicObject) {
                Boolean genlot = cfg.getBoolean("genlot");
                HashSet<Long> removeEntryIdsSet = new HashSet<Long>(10);
                if (!genlot.booleanValue()) continue;
                this.checkUniquerRange(bill, entry, msgMap, cfg, removeEntryIdsSet);
                LotMainFileGenerator.build(cfg, bill, entry, removeEntryIdsSet).saveLotMainFileExec(msgMap);
            }
        }
        return msgMap;
    }

    @Override
    public QFilter getLotMainfFileFilter(DynamicObject bill, DynamicObject entry, String lotidField) {
        return this.getLotMainfFileFilterInner(bill, entry, lotidField, false);
    }

    @Override
    public QFilter getLotMainfFileFilterByLotnum(DynamicObject bill, DynamicObject entry, String lotnumField) {
        return this.getLotMainfFileFilterInner(bill, entry, lotnumField, true);
    }

    private QFilter getLotMainfFileFilterInner(DynamicObject bill, DynamicObject entry, String lotField, boolean isUseLotnum) {
        if (lotField == null || lotField.isEmpty() || bill == null || entry == null) {
            return null;
        }
        String billtype = bill.getDataEntityType().getName();
        String entryType = entry.getDynamicObjectType().getName();
        Set<DynamicObject> cfgs = null;
        cfgs = isUseLotnum ? LotMainFileConfigHelper.getLotMainFileBillConfigByBillAndLotNum(billtype, entryType, bill, lotField) : LotMainFileConfigHelper.getLotMainFileBillConfigByBillAndLotId(billtype, entryType, bill, lotField);
        if (cfgs.size() > 0) {
            String[] split;
            String eOrgCol;
            MainEntityType mainEntityType;
            IDataEntityProperty prop;
            DynamicObject cfg = new ArrayList<DynamicObject>(cfgs).get(0);
            LinkedHashMap<String, String> conditonMaps = LotMainFileConfigHelper.getReturnConditonMaps(cfg, "selectcondition");
            String materialcol = LotMainFileConfigHelper.getParamField(cfg, "material");
            String orgCol = LotMainFileConfigHelper.getParamField(cfg, "createorg");
            DynamicObject masterial = (DynamicObject)LotMainFileConfigHelper.getDynamicVal(bill, entry, materialcol, false);
            Long materialmasterid = null;
            if (masterial != null) {
                materialmasterid = masterial.getDynamicObject("masterid").getLong("id");
            }
            QFilter filter = new QFilter("material", "=", materialmasterid);
            if (conditonMaps.size() > 0) {
                for (Map.Entry<String, String> condition : conditonMaps.entrySet()) {
                    Object conditionVal = LotMainFileConfigHelper.getDynamicVal(bill, entry, condition.getValue(), true);
                    if (conditionVal == null || conditionVal instanceof String && StringUtils.isBlank((String)((String)conditionVal))) continue;
                    filter.and(condition.getKey(), "=", conditionVal);
                }
            }
            Long masterfiletypeid = cfg.getDynamicObject("masterfiletype").getLong("id");
            filter.and("masterfiletype", "=", (Object)masterfiletypeid);
            boolean isOrgIsolate = QueryServiceHelper.exists((String)"sbs_scmcapplevelparam", (QFilter[])new QFilter("number", "=", (Object)"INV0011").and("enable", "=", (Object)true).toArray());
            if (isOrgIsolate && StringUtils.isNotBlank((String)orgCol) && (prop = (mainEntityType = MetadataServiceHelper.getDataEntityType((String)billtype)).findProperty(eOrgCol = (split = orgCol.split("\\."))[split.length - 1])) != null) {
                IDataEntityType parent = prop.getParent();
                DynamicObject org = null;
                org = parent instanceof EntryType ? entry.getDynamicObject(eOrgCol) : bill.getDynamicObject(prop);
                if (org == null) {
                    return new QFilter("1", "!=", (Object)1);
                }
                filter.and("currentorgid", "=", org.getPkValue());
            }
            return filter;
        }
        return null;
    }

    @Override
    public Map<String, String> getReturnParamMapping(DynamicObject bill, DynamicObject entry, String lotidField) {
        String entryType;
        LinkedHashMap<String, String> returnBillMaps = new LinkedHashMap<String, String>(10);
        if (lotidField == null || lotidField.isEmpty() || bill == null || entry == null) {
            return returnBillMaps;
        }
        String billtype = bill.getDataEntityType().getName();
        Set<DynamicObject> cfgDynamicObject = LotMainFileConfigHelper.getLotMainFileBillConfigByBillAndLotId(billtype, entryType = entry.getDynamicObjectType().getName(), bill, lotidField);
        if (cfgDynamicObject.size() > 0) {
            ArrayList<DynamicObject> listCfgDynamicObject = new ArrayList<DynamicObject>(cfgDynamicObject);
            returnBillMaps = LotMainFileConfigHelper.getReturnConditonMaps((DynamicObject)listCfgDynamicObject.get(0), "returnbill");
        }
        return returnBillMaps;
    }

    private void checkSaveBill(DynamicObject bill) {
        boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
        Object pkValue = bill.getPkValue();
        if (pkValue == null || pkValue.equals(0L) || !isFromDataBase) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u4fdd\u5b58\uff0c\u65e0\u6cd5\u6dfb\u52a0\u6279\u53f7\u4e3b\u6863\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"CanNotHandleLotMainFileBillNotSave", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
        }
    }

    private void checkDumplicate(Set<DynamicObject> cfgDynamicObject) {
        ArrayList<String> inMovedirection = new ArrayList<String>(2);
        ArrayList<String> outMovedirection = new ArrayList<String>(2);
        for (DynamicObject cfg : cfgDynamicObject) {
            String movedirection = cfg.getString("movedirection");
            if ("A".equals(movedirection)) {
                inMovedirection.add(cfg.getString("number"));
                continue;
            }
            outMovedirection.add(cfg.getString("number"));
        }
        if (inMovedirection.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u65f6\u5339\u914d\u4e86\u591a\u4e2a\u6279\u53f7\u670d\u52a1\u914d\u7f6e\uff0c\u6279\u53f7\u670d\u52a1\u914d\u7f6e\u7f16\u7801\u4e3a\uff1a%s\u3002", (String)"CfgDynamicObjectRepeat", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[]{((Object)inMovedirection).toString()}));
        }
        if (outMovedirection.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u65f6\u5339\u914d\u4e86\u591a\u4e2a\u6279\u53f7\u670d\u52a1\u914d\u7f6e\uff0c\u6279\u53f7\u670d\u52a1\u914d\u7f6e\u7f16\u7801\u4e3a\uff1a%s\u3002", (String)"CfgDynamicObjectRepeat", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[]{((Object)outMovedirection).toString()}));
        }
    }

    private void checkUniquerRange(DynamicObject bill, DynamicObjectCollection entry, Map<Integer, String> msgMap, DynamicObject cfg, Set<Long> removeEntryIdsSet) {
        String orgField = LotMainFileConfigHelper.getParamField(cfg, "createorg");
        String materialField = LotMainFileConfigHelper.getParamField(cfg, "material");
        String lotnumberField = LotMainFileConfigHelper.getParamField(cfg, "number");
        for (DynamicObject entryObj : entry) {
            boolean enableLot;
            Long org = (Long)LotMainFileConfigHelper.getDynamicVal(bill, entryObj, orgField, true);
            DynamicObject material = (DynamicObject)LotMainFileConfigHelper.getDynamicVal(bill, entryObj, materialField, false);
            if (org == null || material == null) {
                removeEntryIdsSet.add(entryObj.getLong("id"));
                msgMap.put(entryObj.getInt("seq"), "ERROR" + String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ec4\u7ec7\u6216\u7269\u6599\u4e3a\u7a7a\u3002", (String)"LotMainFileServiceImpl_OrgOrMaterialIsNull", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]), entryObj.getInt("seq")));
                continue;
            }
            String materialtype = material.getDataEntityType().getName();
            if (materialtype.equals("bd_materialinventoryinfo") && !(enableLot = material.getBoolean("enablelot"))) {
                removeEntryIdsSet.add(entryObj.getLong("id"));
                continue;
            }
            String lotnumber = (String)LotMainFileConfigHelper.getDynamicVal(bill, entryObj, lotnumberField, false);
            if (!StringUtils.isEmpty((String)lotnumber)) continue;
            removeEntryIdsSet.add(entryObj.getLong("id"));
        }
    }

    @Override
    public Map<String, Map<String, Map<String, Long>>> genLotByOperate(String billtype, String operate, List<Long> billids) {
        this.checkParams(billtype, billids, operate);
        if ("submit".equals(operate)) {
            Collection<DynamicObject> cfgs = LotMainFileConfigHelper.getLotMainFileBillConfig(billtype, true);
            Map<String, Set<String>> billCfgsMap = LotMainFileConfigHelper.getBillCfgsMatchMap(billtype, cfgs, billids);
            for (Map.Entry<String, Set<String>> billCfgsEntry : billCfgsMap.entrySet()) {
                Set<String> cfgSet = billCfgsEntry.getValue();
                if (cfgSet.size() <= 1) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u540c\u65f6\u5339\u914d\u4e86\u591a\u4e2a\u6279\u53f7\u670d\u52a1\u914d\u7f6e\uff0c\u6279\u53f7\u670d\u52a1\u914d\u7f6e\u7f16\u7801\u4e3a\uff1a%s\u3002", (String)"CfgDynamicObjectRepeat", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[]{cfgSet.toString()}));
            }
            try {
                Map<String, Map<String, Map<String, Long>>> allLotMatchMap = this.callGenLotMainFileExec(billids, operate, cfgs);
                return allLotMatchMap;
            }
            catch (Exception e) {
                logger.info("genLotByOperate first time error");
                Map<String, Map<String, Map<String, Long>>> allLotMatchMap = this.callGenLotMainFileExec(billids, operate, cfgs);
                return allLotMatchMap;
            }
        }
        return Collections.emptyMap();
    }

    private Map<String, Map<String, Map<String, Long>>> callGenLotMainFileExec(List<Long> billids, String operate, Collection<DynamicObject> cfgs) {
        HashMap<String, Map<String, Map<String, Long>>> allLotMatchMap = new HashMap<String, Map<String, Map<String, Long>>>(billids.size());
        HashMap<String, Set<Long>> hasHandleBillMap = new HashMap<String, Set<Long>>(2);
        HashMap<String, Map<String, Long>> allLotnumMap = new HashMap<String, Map<String, Long>>();
        for (DynamicObject cfg : cfgs) {
            LotMainFileOperateGenerator.build(cfg, billids, operate, hasHandleBillMap).genLotMainFileExec(allLotnumMap, allLotMatchMap);
        }
        return allLotMatchMap;
    }

    @Override
    public Map<String, Map<String, Map<String, Long>>> genLotBySingleOperate(String billtype, String operate, DynamicObject billobj) {
        if ("submit".equals(operate)) {
            Collection<DynamicObject> cfgs = LotMainFileConfigHelper.getLotMainFileBillConfig(billtype, true);
            HashMap<String, Set> billCfgsMap = new HashMap<String, Set>(2);
            HashSet<DynamicObject> matchCfgs = new HashSet<DynamicObject>(cfgs.size());
            for (DynamicObject dynamicObject : cfgs) {
                if (!LotMainFileConfigHelper.isDynamicObjectMatchCfg(billtype, billobj, dynamicObject)) continue;
                String identkey = dynamicObject.getString("lotidfield") + '-' + dynamicObject.getString("movedirection");
                Set cfgSet = billCfgsMap.getOrDefault(identkey, new HashSet(3));
                cfgSet.add(dynamicObject.getString("number"));
                if (!billCfgsMap.containsKey(identkey)) {
                    billCfgsMap.put(identkey, cfgSet);
                }
                matchCfgs.add(dynamicObject);
            }
            for (Map.Entry entry : billCfgsMap.entrySet()) {
                Set cfgSet = (Set)entry.getValue();
                if (cfgSet.size() <= 1) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u540c\u65f6\u5339\u914d\u4e86\u591a\u4e2a\u6279\u53f7\u670d\u52a1\u914d\u7f6e\uff0c\u6279\u53f7\u670d\u52a1\u914d\u7f6e\u7f16\u7801\u4e3a\uff1a%s\u3002", (String)"CfgDynamicObjectRepeat", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[]{cfgSet.toString()}));
            }
            try {
                Map<String, Map<String, Map<String, Long>>> allLotMatchMap = this.callSingleGenLotMainFileExec(billobj, operate, matchCfgs);
                return allLotMatchMap;
            }
            catch (Exception e) {
                logger.info("genLotBySingleOperate first time error");
                Map<String, Map<String, Map<String, Long>>> map = this.callSingleGenLotMainFileExec(billobj, operate, matchCfgs);
                return map;
            }
        }
        return Collections.emptyMap();
    }

    private Map<String, Map<String, Map<String, Long>>> callSingleGenLotMainFileExec(DynamicObject billobj, String operate, Set<DynamicObject> matchCfgs) {
        HashMap<String, Map<String, Map<String, Long>>> allLotMatchMap = new HashMap<String, Map<String, Map<String, Long>>>(1);
        HashMap<String, Set<Long>> hasHandleBillMap = new HashMap<String, Set<Long>>(2);
        HashMap<String, Map<String, Long>> allLotnumMap = new HashMap<String, Map<String, Long>>();
        for (DynamicObject cfg : matchCfgs) {
            LotMainFileOperateGenerator.buildBySingleDynamicObject(cfg, billobj, operate, hasHandleBillMap).genLotMainFileExec(allLotnumMap, allLotMatchMap);
        }
        return allLotMatchMap;
    }

    @Override
    public void handleLotByOperate(String billtype, String operate, List<Long> billids) {
        this.checkParams(billtype, billids, operate);
        if ("audit".equals(operate)) {
            Collection<DynamicObject> cfgs = LotMainFileConfigHelper.getLotMainFileBillConfig(billtype, false);
            HashMap<String, Set<Long>> hasHandleBillMap = new HashMap<String, Set<Long>>(2);
            for (DynamicObject cfg : cfgs) {
                LotMainFileOperator.build(cfg, billids, operate, hasHandleBillMap).operateExec();
            }
        } else if ("unaudit".equals(operate)) {
            LotMainFileUnhandleOperator.build(billtype, billids, operate).operateExec();
        }
    }

    @Override
    public Boolean isUseLotMainFile() {
        return LotMainFileConfigHelper.isUseLotMainFile();
    }

    @Override
    public Integer getUnqctrl() {
        return LotMainFileConfigHelper.getUnqctrl();
    }

    @Override
    public Set<DynamicObject> getLotMainFileBillConfigByBillAndLotNum(String billtype, String entrytype, DynamicObject bill, String lotnumField) {
        return LotMainFileConfigHelper.getLotMainFileBillConfigByBillAndLotNum(billtype, entrytype, bill, lotnumField);
    }

    private void checkParams(String billType, List<Long> billIds, String operate) {
        if (billType == null || billType.isEmpty() || billIds == null || billIds.isEmpty() || operate == null || operate.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LotMainFileServiceParamEmpty", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
        }
    }

    private void checkParams(String operate, DynamicObject bill, DynamicObjectCollection entry, String lotidField) {
        if (lotidField == null || lotidField.isEmpty() || bill == null || entry == null || operate == null || operate.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"LotMainFileServiceParamEmpty", (String)"mpscmm-mscommon-lotmainfile", (Object[])new Object[0]));
        }
    }
}

