/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.kdtx.backwfservice;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.AutoBilParam;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWfParam;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.UnWfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.UnWriteOffTaskHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DefaultEcServiceIdempotentProperties;
import kd.mpscmm.mscommon.writeoff.common.util.OperationUtil;
import org.apache.commons.collections.CollectionUtils;

public class AutoGenerateBillDeleteService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(AutoGenerateBillDeleteService.class);

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        BackWfParam backWfParam = (BackWfParam)param;
        Long taskId = backWfParam.getTaskId();
        try (TraceSpan span = Tracer.create((String)"AutoGenerateBillDeleteService", (String)"doExecute");){
            this.doAutoGenerateDeleteService((BackWfParam)param);
            UnWriteOffTaskHelper.updateSuccessTaskInfo((Long)taskId);
        }
        catch (Exception e) {
            UnWriteOffTaskHelper.updateFailTaskInfo((Long)taskId, (Exception)e);
            throw e;
        }
        return null;
    }

    private void doAutoGenerateDeleteService(BackWfParam param) {
        logger.info("\u8fdb\u5165\u65b9\u6cd5AutoGenerateBillDeleteService");
        BackWfParam ecParam = param;
        CommonHelper.setUserId();
        String billType = ecParam.getBillNumber();
        logger.info("AutoGenerateBillDeleteService\u5220\u9664\u81ea\u52a8\u751f\u6210\u5355:{}", (Object)billType);
        UnWfPluginExtFactory unWfPluginExtFactory = new UnWfPluginExtFactory();
        List autoBillList = ecParam.getAutoBilParams();
        for (AutoBilParam wfTypeAutoBills : autoBillList) {
            Long wfTypeId = wfTypeAutoBills.getWfTypeId();
            List idList = wfTypeAutoBills.getId();
            unWfPluginExtFactory.autoBillDelete(wfTypeAutoBills.getBillType(), idList, wfTypeId);
            QFilter qFilter = new QFilter("id", "in", (Object)idList);
            List idListDb = QueryServiceHelper.queryPrimaryKeys((String)billType, (QFilter[])qFilter.toArray(), null, (int)-1);
            if (CollectionUtils.isEmpty((Collection)idListDb)) continue;
            Object[] ids = idListDb.toArray(new Object[idListDb.size()]);
            OperateOption option = OperateOption.create();
            option.setVariableValue("backwriteoff_tag", "true");
            OperationUtil.invokeOperation((Object[])ids, (String)"delete", (String)billType, (OperateOption)option);
        }
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultEcServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }
}

