/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.kdtx.backwfservice;

import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWfParam;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.ECServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.UnWriteOffTaskHelper;
import kd.mpscmm.mscommon.writeoff.common.util.DefaultEcServiceIdempotentProperties;
import org.apache.commons.collections.MapUtils;

public class ReWfBackWriteService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(ReWfBackWriteService.class);
    private static final String END_WRITE_BACK = "endWriteBack";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        BackWfParam backWfParam = (BackWfParam)param;
        Long taskId = backWfParam.getTaskId();
        try (TraceSpan span = Tracer.create((String)"ReWfBackWriteService", (String)"doExecute");){
            if (UnWriteOffTaskHelper.isSuccessWriteBack((long)taskId)) {
                logger.info("doUnBackWriteService \u53cd\u5199\u5df2\u7ecf\u6267\u884c\u6210\u529f,taskId:{}", (Object)taskId);
                DtxResponse dtxResponse = null;
                return dtxResponse;
            }
            this.doUnBackWriteService((BackWfParam)param);
            UnWriteOffTaskHelper.updateSuccessTaskInfo((Long)taskId);
            return null;
        }
        catch (Exception e) {
            UnWriteOffTaskHelper.updateFailTaskInfo((Long)taskId, (Exception)e);
            throw e;
        }
    }

    private void doUnBackWriteService(BackWfParam param) {
        logger.info("\u8fdb\u5165\u65b9\u6cd5ReWfBackWriteService");
        BackWfParam ecParam = param;
        CommonHelper.setUserId();
        String dbRout = ecParam.getDbRout();
        logger.info("ReWfBackWriteService\u8bf7\u6c42\u53cd\u5199\u5e93:{}", (Object)dbRout);
        Map param1 = ecParam.getParam();
        DBRoute route = new DBRoute(dbRout);
        Map recordSerMap = ecParam.getRecordMap();
        for (Map.Entry<String, List<Object[]>> entry : param1.entrySet()) {
            this.doBackSql(route, entry);
        }
        if (MapUtils.isNotEmpty((Map)recordSerMap)) {
            BackWfParam backWfParam = new BackWfParam();
            backWfParam.setDbRout(dbRout);
            backWfParam.setSelectFields(ecParam.getSelectFields());
            backWfParam.setRecordMap(recordSerMap);
            backWfParam.setPluginMethodName(END_WRITE_BACK);
            ECServiceHelper.execute((String)"msmod_backwriteoff", (String)"msmod_backwf_plugin", (String)"mpscmm", (String)"mscommon", (String)"BackWfPluginService", (Param)backWfParam);
        }
    }

    private void doBackSql(DBRoute route, Map.Entry<String, List<Object[]>> param2) {
        DB.executeBatch((DBRoute)route, (String)param2.getKey(), param2.getValue());
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultEcServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }
}

