/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.kdtx.backwfservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.engine.core.backwriteoff.entity.BackWfParam;
import kd.mpscmm.mscommon.writeoff.business.engine.core.factory.UnWfPluginExtFactory;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteoffTemplateTypeEnum;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.ECServiceHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.UnWriteOffTaskHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffRecordHelper;
import kd.mpscmm.mscommon.writeoff.common.lock.MutexLockUtils;
import kd.mpscmm.mscommon.writeoff.common.util.BotpLinkHelper;
import kd.mpscmm.mscommon.writeoff.common.util.CommonUtils;
import kd.mpscmm.mscommon.writeoff.common.util.DefaultEcServiceIdempotentProperties;
import kd.mpscmm.mscommon.writeoff.common.util.DynamicObjectUtil;
import kd.mpscmm.mscommon.writeoff.common.util.WfConnectUtil;
import kd.mpscmm.mscommon.writeoff.lang.EngineLang;
import org.apache.commons.collections.CollectionUtils;

public class WriteOffRecordDeleteService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(WriteOffRecordDeleteService.class);
    private static final String AP_FINAPBILL = "ap_finapbill";
    private static final String AR_REVCFMBILL = "ar_revcfmbill";
    private static final String CA_CAL_SERVICE = "caCalService";
    private static final String CA_SCM = "ca_scm";

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        BackWfParam backWfParam = (BackWfParam)param;
        Long taskId = backWfParam.getTaskId();
        try (TraceSpan span = Tracer.create((String)"WriteOffRecordDeleteService", (String)"doExecute");){
            this.doWfRecordDeleteService((BackWfParam)param);
            this.deleteWfRecordSeqLock(backWfParam.getWfRecordSeqLocks());
            UnWriteOffTaskHelper.updateSuccessTaskInfo((Long)taskId);
        }
        catch (Exception e) {
            UnWriteOffTaskHelper.updateFailTaskInfo((Long)taskId, (Exception)e);
            throw e;
        }
        return null;
    }

    private void deleteWfRecordSeqLock(Set<String> wfRecordSeqLocks) {
        if (CollectionUtils.isEmpty(wfRecordSeqLocks)) {
            return;
        }
        MutexLockUtils.releaseLock(wfRecordSeqLocks);
    }

    private void doWfRecordDeleteService(BackWfParam ecParam) {
        logger.info("\u8fdb\u5165\u65b9\u6cd5WriteOffRecordDeleteService");
        CommonHelper.setUserId();
        String billType = ecParam.getBillNumber();
        logger.info("WriteOffRecordDeleteService\u53cd\u6838\u9500\u5220\u9664\u6838\u9500\u8bb0\u5f55:{},\u662f\u5426\u51b2\u9500:{}", (Object)billType, (Object)ecParam.getChargeOff());
        List<DynamicObject> recordList = this.getRecords(billType, ecParam.getRecordIds());
        if (CollectionUtils.isNotEmpty(recordList)) {
            Set<Long> ids = recordList.stream().map(n -> (Long)n.getPkValue()).collect(Collectors.toSet());
            logger.info("\u53cd\u6838\u9500\u5220\u9664\u6838\u9500\u8bb0\u5f55\u6210\u529f\uff0c\u5355\u636e\u7c7b\u578b:" + billType + "\uff0c\u5355\u636eid\uff1a" + ids);
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
            if (ecParam.getChargeOff() != null && ecParam.getChargeOff().booleanValue()) {
                this.doBackPlugin(ecParam.getTypeId(), recordList, Boolean.TRUE);
                WriteoffTemplateTypeEnum wfTemplateType = WriteOffRecordHelper.getWfTemplateTypeByChildEntity((String)billType);
                if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == wfTemplateType) {
                    this.mainAssRecordCaDeal(ecParam, recordList, ids, wfTemplateType);
                } else if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN == wfTemplateType || WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT == wfTemplateType) {
                    this.UdAndLrCaDeal(recordList, wfTemplateType);
                }
            } else {
                this.doBackPlugin(ecParam.getTypeId(), recordList, Boolean.FALSE);
                try (TXHandle tx = TX.requiresNew();){
                    DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])ids.toArray());
                }
            }
            logger.info("\u53cd\u6838\u9500\u5220\u9664\u6838\u9500\u8bb0\u5f55\u6210\u529f");
        }
    }

    private void UdAndLrCaDeal(List<DynamicObject> recordList, WriteoffTemplateTypeEnum wfTemplateType) {
        for (DynamicObject record : recordList) {
            this.copyCaRecord(record, wfTemplateType);
            record.set("hadwrittenoff", (Object)Boolean.TRUE);
        }
        DynamicObject[] records = recordList.toArray(new DynamicObject[recordList.size()]);
        SaveServiceHelper.update((DynamicObject[])records);
    }

    private void mainAssRecordCaDeal(BackWfParam ecParam, List<DynamicObject> recordList, Set<Long> ids, WriteoffTemplateTypeEnum wfTemplateType) {
        ArrayList<DynamicObject> caRecords = new ArrayList<DynamicObject>(16);
        for (DynamicObject record : recordList) {
            DynamicObject copyRecord = this.copyCaRecord(record, wfTemplateType);
            caRecords.add(copyRecord);
            DynamicObjectCollection entryList = record.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryList) {
                entry.set("e_hadwrittenoff", (Object)Boolean.TRUE);
            }
        }
        DynamicObject[] records = recordList.toArray(new DynamicObject[recordList.size()]);
        SaveServiceHelper.update((DynamicObject[])records);
        Map paramMap = ecParam.getParamMap();
        String caBillType = (String)paramMap.get("caBillType");
        String caType = (String)paramMap.get("caType");
        if (CA_SCM.equals(caType)) {
            return;
        }
        Map caBillIdMapping = (Map)paramMap.get("caBillIdMapping");
        CommonParam commonParam = new CommonParam();
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("billentitykey", caBillType);
        map.put("mains", caBillIdMapping == null ? null : new ArrayList(caBillIdMapping.keySet()));
        map.put("assts", caBillIdMapping == null ? null : new ArrayList(caBillIdMapping.values()));
        commonParam.put((Object)"verifymap", map);
        if (AP_FINAPBILL.equals(caBillType)) {
            ECServiceHelper.execute((String)"ca_redbuleverify", (String)"redbuleverify", (String)"fi", (String)"ap", (String)"fi", (String)"ApWrittenOffRedBuleVerifyECService", (Param)commonParam);
        }
        if (AR_REVCFMBILL.equals(caBillType)) {
            ECServiceHelper.execute((String)"ca_redbuleverify", (String)"redbuleverify", (String)"fi", (String)"ar", (String)"fi", (String)"ArWrittenOffRedBuleVerifyECService", (Param)commonParam);
        }
        logger.info("\u51b2\u9500\u540e\u8c03\u7528\u6838\u7b97\u63a5\u53e3");
        List caIds = caRecords.stream().map(n -> (Long)n.getPkValue()).collect(Collectors.toList());
        ecParam.setVerifyRecordIds(ids);
        ecParam.setRedVerifyRecordIds(caIds);
        ecParam.setPluginMethodName(CA_CAL_SERVICE);
        ECServiceHelper.execute((String)"msmod_backwriteoff", (String)"msmod_backwf_plugin", (String)"mpscmm", (String)"mscommon", (String)"BackWfPluginService", (Param)ecParam);
    }

    private DynamicObject copyCaRecord(DynamicObject record, WriteoffTemplateTypeEnum wfTemplateType) {
        DynamicObject copyRecord = (DynamicObject)OrmUtils.clone((IDataEntityBase)record, (boolean)true, (boolean)true);
        DynamicObjectUtil.setBillId((DynamicObject)copyRecord);
        this.copyBillSetHeadField(record, copyRecord, wfTemplateType);
        DynamicObjectCollection copyBillEntryList = this.copyBillSetEntryField(record, copyRecord, wfTemplateType);
        BotpLinkHelper.clearBillLink((DynamicObject)copyRecord);
        BotpLinkHelper.clearBillEntryLink((DynamicObjectCollection)copyBillEntryList);
        BotpLinkHelper.addBillLink((DynamicObject)record, (DynamicObject)copyRecord);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{copyRecord});
        return copyRecord;
    }

    private void copyBillSetHeadField(DynamicObject srcBill, DynamicObject copyData, WriteoffTemplateTypeEnum wfTemplateType) {
        String billType = srcBill.getDataEntityType().getName();
        List proList = CommonUtils.getAmoutAndQtyFieldList((DynamicObject)copyData, (String)billType);
        for (String field : proList) {
            BigDecimal bigDecimal = srcBill.getBigDecimal(field);
            if (bigDecimal == null) continue;
            copyData.set(field, (Object)BigDecimal.ZERO.subtract(bigDecimal));
        }
        if (WriteoffTemplateTypeEnum.TEMPLATE_UP_DOWN == wfTemplateType || WriteoffTemplateTypeEnum.TEMPLATE_LEFT_RIGHT == wfTemplateType) {
            copyData.set("iswrittenoff", (Object)Boolean.TRUE);
        }
    }

    private DynamicObjectCollection copyBillSetEntryField(DynamicObject srcBill, DynamicObject copyData, WriteoffTemplateTypeEnum wfTemplateType) {
        String billEntryKey = "entry";
        DynamicObjectCollection copyBillEntryList = copyData.getDynamicObjectCollection(billEntryKey);
        List proList = CommonUtils.getAmoutAndQtyFieldList((DynamicObject)copyData, (String)billEntryKey);
        String billNoKey = ((BillEntityType)copyData.getDataEntityType()).getBillNo();
        String origBillNo = srcBill.getString(billNoKey);
        String remark = WfConnectUtil.strConnect((String[])new String[]{EngineLang.chargeOff(), origBillNo});
        for (int i = 0; i < copyBillEntryList.size(); ++i) {
            DynamicObject copyEntry = (DynamicObject)copyBillEntryList.get(i);
            if (WriteoffTemplateTypeEnum.TEMPLATE_MAIN_ASSIST == wfTemplateType) {
                copyEntry.set("e_writtenoffremark", (Object)remark);
                copyEntry.set("e_iswrittenoff", (Object)Boolean.TRUE);
                copyEntry.set("e_hadwrittenoff", (Object)Boolean.FALSE);
            }
            for (String field : proList) {
                BigDecimal value = copyEntry.getBigDecimal(field);
                if (value == null) continue;
                copyEntry.set(field, (Object)BigDecimal.ZERO.subtract(value));
            }
        }
        return copyBillEntryList;
    }

    private void doBackPlugin(Long wfTypeId, List<DynamicObject> records, Boolean isCa) {
        new UnWfPluginExtFactory().beforeWfRecordDelete(records, wfTypeId, isCa);
    }

    private List<DynamicObject> getRecords(String billType, List<Object> ids) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)dataEntityType);
        if (load != null && load.length > 0) {
            return Arrays.asList(load);
        }
        return Collections.emptyList();
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        IdempotentProperties idempotentProperties = DefaultEcServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
        idempotentProperties.setAlivedTime(Long.valueOf(60000L));
        return idempotentProperties;
    }
}

