/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.kdtx.feeshareservice;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.consumer.ECServiceHelper;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.common.consts.WfSnapShootConst;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffLogHelper;
import kd.mpscmm.mscommon.writeoff.common.kdtxargs.WfParam;
import kd.mpscmm.mscommon.writeoff.common.util.DefaultEcServiceIdempotentProperties;
import org.apache.commons.collections.CollectionUtils;

public class FeeShareWriteBackService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(FeeShareWriteBackService.class);
    private static final String END_WRITE_BACK = "endWriteBack";

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        try (TraceSpan span = Tracer.create((String)"BackWriteService", (String)"doExecute");){
            this.doBackWriteService((WfParam)param);
        }
        return null;
    }

    private void doBackWriteService(WfParam param) {
        logger.info("BackWriteService\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)param));
        CommonHelper.setUserId();
        long logId = param.getLogId();
        try {
            if (!WriteOffLogHelper.isSuccessWriteBack((long)logId)) {
                try (TXHandle tx = TX.requiresNew();){
                    this.executeSQLWithParam(param);
                    WriteOffLogHelper.updateTaskLogWriteBack((long)logId, (String)param.getDbRout());
                }
            } else {
                logger.info("BackWriteService \u53cd\u5199\u5df2\u7ecf\u6267\u884c\u6210\u529f\u3002 logid\uff1a" + logId);
            }
            this.deleteSnap(param);
            WriteOffLogHelper.updateTaskLogSuccess((long)logId);
        }
        catch (Exception e) {
            WriteOffLogHelper.updateTaskLogFailInfo((long)logId, (Exception)e);
            throw e;
        }
    }

    private void doBackPlugin(WfParam ecParam) {
        String dbRout = ecParam.getDbRout();
        Map recordSerMap = ecParam.getRecordMap();
        if (recordSerMap == null || recordSerMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : recordSerMap.entrySet()) {
            String[] keys = ((String)entry.getKey()).split("#");
            Long wfTypeId = Long.valueOf(keys[0]);
            String billNumber = keys[1];
            List ids = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)ids)) continue;
            WfParam params = new WfParam();
            params.setDbRout(dbRout);
            params.setValue(String.valueOf(wfTypeId));
            params.setBillNumber(billNumber);
            params.setPluginMethodName(END_WRITE_BACK);
            params.setIds(ids);
            params.setWfExtParams(ecParam.getWfExtParams());
            ECServiceHelper.execute((String)"msmod_writeoff", (String)"msmod_writeoff_plugin", (String)"mpscmm", (String)"mscommon", (String)ecParam.getDbRout(), (String)"WriteOffPluginService", (Param)params);
        }
    }

    private void deleteSnap(WfParam ecParam) {
        Set snapIds = ecParam.getSnapShootIds();
        try (TXHandle handle1 = TX.requiresNew();){
            if (snapIds != null && !snapIds.isEmpty()) {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)WfSnapShootConst.ENTITY), (Object[])snapIds.toArray());
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        logger.info("BackWriteService\u5220\u9664\u5feb\u7167\u5b8c\u6210");
    }

    private void executeSQLWithParam(WfParam ecParam) {
        String dbRout = ecParam.getDbRout();
        DBRoute route = new DBRoute(dbRout);
        Map param1 = ecParam.getParam();
        for (Map.Entry<String, List<Object[]>> entry : param1.entrySet()) {
            this.exeucteSQL(route, entry);
        }
    }

    private void exeucteSQL(DBRoute route, Map.Entry<String, List<Object[]>> param2) {
        DB.executeBatch((DBRoute)route, (String)param2.getKey(), param2.getValue());
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultEcServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }
}

