/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.kdtx.wfservice;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.manager.WriteOffParamManager;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffLogHelper;
import kd.mpscmm.mscommon.writeoff.common.kdtxargs.WfParam;
import kd.mpscmm.mscommon.writeoff.common.util.DefaultEcServiceIdempotentProperties;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.PluginFactory;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.WriteOffPluginProxy;

public class AutoGenerateBillService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(AutoGenerateBillService.class);
    private static final ThreadPool POOL = ThreadPools.newFixedThreadPool((String)"autoBillGenera", (int)100);

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        try (TraceSpan span = Tracer.create((String)"AutoGenerateBillService", (String)"doExecute");){
            this.doAutoGenerateService((WfParam)param);
        }
        return null;
    }

    private void doAutoGenerateService(WfParam param) throws ExecutionException, InterruptedException {
        WfParam ecParam = param;
        CommonHelper.setUserId();
        try {
            this.execute(ecParam);
            WriteOffLogHelper.updateTaskLogSuccess((long)ecParam.getLogId());
        }
        catch (Exception e) {
            WriteOffLogHelper.updateTaskLogFail((long)ecParam.getLogId(), (Exception)e);
            throw e;
        }
    }

    private void execute(WfParam ecParam) throws ExecutionException, InterruptedException {
        DynamicObject[] autoBills;
        logger.info("AutoGenerateBillService\u8bf7\u6c42\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)ecParam));
        Long wfTypeId = ecParam.getWfTypeId();
        DynamicObject wfTypeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)wfTypeId, (String)"msmod_writeofftype");
        WriteOffTypeConfig writeOffTypeConfig = WriteOffTypeConfig.build((DynamicObject)wfTypeObj);
        writeOffTypeConfig.setWfExtParams(ecParam.getWfExtParams());
        final WriteOffPluginProxy writeOffPluginProxy = new PluginFactory(null).createWriteOffPluginProxy(writeOffTypeConfig);
        if (writeOffPluginProxy.getAllPlugins().isEmpty()) {
            logger.info("AutoGenerateBillService\uff1a\u65e0\u63d2\u4ef6\u6267\u884c");
            return;
        }
        if (WriteOffParamManager.autoBillFullLoad()) {
            logger.info("AutoGenerateBillService\uff1a\u5168\u5b57\u6bb5\u52a0\u8f7d");
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)ecParam.getBillNumber());
            autoBills = BusinessDataServiceHelper.load((Object[])ecParam.getIds().toArray(), (DynamicObjectType)dataEntityType);
        } else {
            logger.info("AutoGenerateBillService\uff1a\u4ec5\u52a0\u8f7did,billno");
            autoBills = BusinessDataServiceHelper.load((String)ecParam.getBillNumber(), (String)"id, billno", (QFilter[])new QFilter("id", "in", (Object)ecParam.getIds()).toArray());
        }
        final String requestId = RequestContext.get().getRequestId();
        Future future = POOL.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                RequestContext.get().setRequestId(requestId);
                writeOffPluginProxy.afterWfAutoGenerate(Arrays.asList(autoBills));
                return true;
            }
        });
        future.get();
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultEcServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }
}

