/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.kdtx.wfservice;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.mscommon.writeoff.business.config.vo.WriteOffTypeConfig;
import kd.mpscmm.mscommon.writeoff.common.consts.WriteOffTypeIdConst;
import kd.mpscmm.mscommon.writeoff.common.helper.CommonHelper;
import kd.mpscmm.mscommon.writeoff.common.helper.WriteOffLogHelper;
import kd.mpscmm.mscommon.writeoff.common.kdtxargs.WfParam;
import kd.mpscmm.mscommon.writeoff.common.util.DefaultEcServiceIdempotentProperties;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.PluginFactory;
import kd.mpscmm.mscommon.writeoff.ext.defaultplugin.proxy.WriteOffPluginProxy;

public class WriteOffRecordService
extends BaseECService
implements IdempotentService {
    private static final Log logger = LogFactory.getLog(WriteOffRecordService.class);

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        logger.info("\u5f00\u59cb\u6267\u884cWriteOffRecordService\u3002");
        WfParam ecParam = (WfParam)param;
        CommonHelper.setUserId();
        try (TraceSpan span = Tracer.create((String)"WriteOffRecordService", (String)"doExecute");){
            this.execute(ecParam);
            WriteOffLogHelper.updateTaskLogSuccess((long)ecParam.getLogId());
        }
        catch (Exception e) {
            WriteOffLogHelper.updateTaskLogFail((long)ecParam.getLogId(), (Exception)e);
            throw e;
        }
        logger.info("\u7ed3\u675f\u6267\u884cWriteOffRecordService\u3002");
        return null;
    }

    private void execute(WfParam ecParam) {
        RequestContext requestContext = RequestContext.get();
        if (requestContext.getUserId() == null) {
            requestContext.setUserId("1");
        }
        Long wfTypeId = ecParam.getWfTypeId();
        String recordEntity = ecParam.getBillNumber();
        WriteOffPluginProxy proxy = new PluginFactory(null).createWriteOffPluginProxy(WriteOffTypeConfig.buildById((Long)wfTypeId), ecParam.getIsWfMode());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)recordEntity);
        DynamicObject[] records = null;
        if (WriteOffTypeIdConst.HXLB_SALE.equals(wfTypeId) || WriteOffTypeIdConst.HXLB_PUR.equals(wfTypeId)) {
            HashSet<String> loadFields = new HashSet<String>(16);
            loadFields.add("id");
            loadFields.add("writeofftypeid");
            Set pluginFields = (Set)proxy.preparePropKey().get(recordEntity);
            if (pluginFields != null) {
                loadFields.addAll(pluginFields);
            }
            logger.info("WriteOffRecordService \u91c7\u8d2d/\u9500\u552e\u6838\u9500 \u9650\u5b9a\u52a0\u8f7d\u5b57\u6bb5\uff1a" + loadFields);
            EntityType subEntityType = dataEntityType.getSubEntityType(loadFields);
            records = BusinessDataServiceHelper.load((Object[])ecParam.getIds().toArray(), (DynamicObjectType)subEntityType);
        } else {
            records = BusinessDataServiceHelper.load((Object[])ecParam.getIds().toArray(), (DynamicObjectType)dataEntityType);
        }
        logger.info("\u5f00\u59cb\u6267\u884cafterWfRecordStrategy\u3002");
        proxy.afterWfRecordStrategy(Arrays.asList(records));
        logger.info("\u7ed3\u675f\u6267\u884cafterWfRecordStrategy\u3002");
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object o1) {
        return DefaultEcServiceIdempotentProperties.generate((String)((Object)((Object)this)).getClass().getName(), (Object)param);
    }
}

