/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SchemeSortSubentryUpgradeServiceImpl
implements IUpgradeService {
    public static final String INSERT_SQL = "insert into t_msmod_sch_sortsubentry (FDetailID,fentryid,fseq,fsub_wf_scheme,fsub_priority,fsub_rbpriority,fsub_whole,fsub_unilateral,fsub_equalsfirst,fsub_onlyequals)values(?,?,?,?,?,?,?,?,?,?)";
    private Set<Long> ids = new HashSet<Long>(1024);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        DataSet relDs;
        List<Object[]> params;
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        if (this.subEntryIsEmpty(scmRoute) && !(params = this.buildInsertParams(relDs = this.getRelationDs(scmRoute))).isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)INSERT_SQL, params);
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private boolean subEntryIsEmpty(DBRoute scmRoute) {
        String sql = "select FDetailID from t_msmod_sch_sortsubentry";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        return tableSet.isEmpty();
    }

    private List<Object[]> buildInsertParams(DataSet relDs) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        HashMap<Long, Long> entry2Seq = new HashMap<Long, Long>(16);
        for (Row row : relDs) {
            Long fdetailid = this.getDetailId();
            Long fentryid = row.getLong("fentryid");
            Long fwriteoffscheme = row.getLong("fwriteoffscheme");
            Long fseq = (Long)entry2Seq.get(fentryid);
            if (fseq == null) {
                fseq = 1L;
            }
            entry2Seq.put(fentryid, fseq + 1L);
            Long fpriority = row.getLong("fpriority");
            String frbpriority = row.getString("frbpriority");
            String fwhole = row.getString("fwhole");
            String funilateral = row.getString("funilateral");
            String fequalsfirst = row.getString("fequalsfirst");
            String fonlyequals = row.getString("fonlyequals");
            params.add(new Object[]{fdetailid, fentryid, fseq, fwriteoffscheme, fpriority, frbpriority, fwhole, funilateral, fequalsfirst, fonlyequals});
        }
        return params;
    }

    private Long getDetailId() {
        if (this.ids.isEmpty()) {
            long[] idArr;
            for (long id : idArr = DB.genLongIds((String)"t_msmod_sch_sortsubentry", (int)1000)) {
                this.ids.add(id);
            }
        }
        Iterator<Long> iterator = this.ids.iterator();
        Long id = iterator.next();
        iterator.remove();
        return id;
    }

    private DataSet getRelationDs(DBRoute scmRoute) {
        String sql = "select a.fid,a.fentryid,b.fseq,b.fwriteoffscheme,b.fpriority,b.frbpriority,b.fwhole,b.funilateral,b.fequalsfirst,b.fonlyequals from t_msmod_scheme_billentry a left join t_msmod_scheme_sortentry b on a.fid = b.fid order by a.fid,b.fpriority";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        return tableSet;
    }
}

