/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class WriteOffTypeSortUpgradeServiceImpl
implements IUpgradeService {
    public static final String UPDATE_SQL = "update t_msmod_wf_sort_entry set fseq = ?,fwriteofftypeid = ? where fentryid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        DataSet relDS = this.getRelationDS(scmRoute);
        List<Object[]> params = this.buildUpdateParams(relDS);
        if (!params.isEmpty()) {
            DB.executeBatch((DBRoute)scmRoute, (String)UPDATE_SQL, params);
        }
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private List<Object[]> buildUpdateParams(DataSet relDS) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        HashMap<Long, Long> fid2Seq = new HashMap<Long, Long>(16);
        for (Row row : relDS) {
            Long fid = row.getLong("fid");
            Long fentryid = row.getLong("fentryid");
            Long fwriteofftypeid = row.getLong("fwriteofftypeid");
            Long fseq = (Long)fid2Seq.get(fid);
            if (fseq == null) {
                fseq = 1L;
            }
            fid2Seq.put(fid, fseq + 1L);
            params.add(new Object[]{fseq, fwriteofftypeid, fentryid});
        }
        return params;
    }

    private DataSet getRelationDS(DBRoute scmRoute) {
        String sql = "select a.fid,a.fentryid,a.fseq,a.fpriority,b.fwriteofftypeid from t_msmod_wf_sort_entry a left join t_msmod_schemeset b on a.fwriteofftype = b.fid order by a.fid,a.fpriority";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)sql);
        return tableSet;
    }
}

