/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.report;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class RebateRep
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public static final String pkValue = "id";
    private Log logger = LogFactory.getLog(RebateRep.class);
    public static final String F_parent = "parent";
    public static final String F_countryarea = "countryarea";
    public static final String F_country = "search_country";
    public static final String F_areadept = "search_rpareadep";
    public static final String F_rptoffice = "search_rprepresent";
    public final String[] f7FieldKeys = new String[]{"search_country", "search_rpareadep", "search_rprepresent"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addF7Listeners(this.f7FieldKeys);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterItemInfo startfilter = queryParam.getFilter().getFilterItem("isbudgetfinish");
        if (startfilter != null) {
            startfilter.setValue((Object)0);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Date debatetime = queryParam.getFilter().getDate("debatetime");
        for (DynamicObject row : rowData) {
            if ("true".equals(row.get("istax"))) {
                row.set("istax", (Object)"Y");
            } else {
                row.set("istax", (Object)"N");
            }
            if ("true".equals(row.get("isbudgetfinishend"))) {
                row.set("isbudgetfinishend", (Object)"Y");
            } else {
                row.set("isbudgetfinishend", (Object)"N");
            }
            try {
                QFilter filters;
                DynamicObject[] itemClass;
                if (debatetime != null) continue;
                ArrayList<DynamicObject> ics = new ArrayList<DynamicObject>();
                String productnumber = row.getString("productnumber");
                if (productnumber.length() > 0 && (itemClass = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)pkValue, (QFilter[])(filters = new QFilter("number", "=", (Object)productnumber)).toArray())).length > 0) {
                    Long pid = (Long)itemClass[0].getPkValue();
                    this.getItemClassByParent(pid, ics);
                    ics.remove(0);
                    for (int i = 0; i < ics.size(); ++i) {
                        row.set("productclass" + (ics.size() - i), ((DynamicObject)ics.get(i)).get("name"));
                    }
                }
                row.set("brand", (Object)"Honor");
                BigDecimal actualunitrebate = new BigDecimal(0);
                QFilter qf = new QFilter("billno", "=", row.get("billno"));
                DynamicObject[] rebatepreList = BusinessDataServiceHelper.load((String)"occpic_rebateprebudget", (String)pkValue, (QFilter[])qf.toArray());
                List<Object> fidList = RebateRep.getRebatestatementMap(rebatepreList[0].getPkValue());
                if (fidList.size() > 0) {
                    Object rebateId = fidList.get(0);
                    DynamicObject rebatestatement = BusinessDataServiceHelper.loadSingle((Object)rebateId, (String)"occpic_rebatestatement");
                    row.set("paytype", (Object)rebatestatement.getString("paytype"));
                    actualunitrebate = rebatestatement.getBigDecimal("entryentity.actualunitrebate");
                    row.set("actualunitrebate", (Object)actualunitrebate);
                }
                BigDecimal profitrate = row.getBigDecimal("profitrate").divide(new BigDecimal(100), 2, 0);
                BigDecimal perunamount = row.getBigDecimal("adjustendamount").divide(row.getBigDecimal("entconsignqty"), 2, 0);
                row.set("perunamount", (Object)perunamount);
                BigDecimal adjustconsignqty = row.getBigDecimal("adjustconsignqty");
                BigDecimal adrebateone = adjustconsignqty.multiply(perunamount);
                BigDecimal adrebatetwo = row.getBigDecimal("adjustsaleamount").multiply(profitrate);
                BigDecimal adjustcrebateamount = adrebateone.add(adrebatetwo);
                row.set("effectadjustamount", (Object)adjustcrebateamount);
                BigDecimal adjustendamount = row.getBigDecimal("adjustendamount");
                BigDecimal effectamount = adjustendamount.subtract(adjustcrebateamount);
                row.set("effectamount", (Object)effectamount);
                BigDecimal setamount = row.getBigDecimal("adjustconsignqty").add(row.getBigDecimal("consignqty")).subtract(row.getBigDecimal("enthasbudgetqty"));
                BigDecimal settleadjustamount = setamount.multiply(actualunitrebate);
                row.set("settleadjustamount", (Object)settleadjustamount);
                BigDecimal enthasbudgetamount = row.getBigDecimal("adjustendsettleamount").subtract(settleadjustamount);
                row.set("enthasbudgetamount", (Object)enthasbudgetamount);
                BigDecimal entrebateamount = effectamount.subtract(enthasbudgetamount);
                row.set("entrebateamount", (Object)entrebateamount);
                String rate = "0";
                String rparea = row.getString("arenamecode");
                if ("CN".equals(rparea)) {
                    rate = "0.13";
                    row.set("taxrate", (Object)"13%");
                } else {
                    row.set("taxrate", (Object)"0%");
                }
                BigDecimal rateall = new BigDecimal(rate).add(new BigDecimal(1));
                row.set("prosaleamountistax", (Object)entrebateamount.divide(rateall, 2, 0));
                BigDecimal adjustrebateamount = row.getBigDecimal("adjustendamount").subtract(row.getBigDecimal("adjustendsettleamount"));
                row.set("adjustrebateamount", (Object)adjustrebateamount);
                row.set("adjustrebateamountnotax", (Object)adjustrebateamount.divide(rateall, 2, 0));
            }
            catch (Exception e) {
                this.logger.info("\u8fd4\u5229\u9884\u63d0\u62a5\u8868\u62a5\u9519:", (Object)e);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        QFilter qFilter = null;
        switch (key) {
            case "search_rpareadep": {
                this.getModel().setValue(F_rptoffice, null);
                this.getModel().setValue(F_country, null);
                break;
            }
            case "search_rprepresent": {
                DynamicObject rpmodel = (DynamicObject)this.getModel().getValue(F_areadept);
                if (rpmodel == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5730\u533a\u90e8\u3002", (String)"RebateRep_0", (String)"occ-occpic-report", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                long parentId = rpmodel == null ? 0L : Long.parseLong(rpmodel.getPkValue().toString());
                qFilter = new QFilter(F_parent, "=", (Object)parentId);
                break;
            }
            case "search_country": {
                DynamicObject tofmodel;
                DynamicObject ctymodel = (DynamicObject)this.getModel().getValue(F_areadept);
                if (ctymodel == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5730\u533a\u90e8\u3002", (String)"RebateRep_0", (String)"occ-occpic-report", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                ArrayList<Object> countryIds = new ArrayList<Object>(1);
                DynamicObject country = ctymodel.getDynamicObject(F_countryarea);
                if (country != null) {
                    countryIds.add(country.getPkValue());
                }
                if ((tofmodel = (DynamicObject)this.getModel().getValue(F_rptoffice)) == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ee3\u8868\u5904\u3002", (String)"RebateRep_1", (String)"occ-occpic-report", (Object[])new Object[0]));
                    event.setCancel(true);
                    return;
                }
                country = tofmodel.getDynamicObject(F_countryarea);
                if (country != null) {
                    countryIds.add(country.getPkValue());
                }
                qFilter = new QFilter(pkValue, "in", countryIds);
                break;
            }
        }
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void addF7Listeners(String[] f7Keys) {
        for (String key : f7Keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private static List<Object> getRebatestatementMap(Object pkid) {
        StringBuilder sql = new StringBuilder();
        sql.append("select FTBILLID from t_occpic_rebatestatement_tc where FSBILLID= ? ");
        return (List)DB.query((DBRoute)DBRoute.of((String)"drp"), (String)sql.toString(), (Object[])new Object[]{pkid}, (ResultSetHandler)new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet rs) throws Exception {
                HashSet<Long> results = new HashSet<Long>(rs.getFetchSize());
                while (rs.next()) {
                    results.add(rs.getLong("FTBILLID"));
                }
                return new ArrayList<Object>(results);
            }
        });
    }

    private void getItemClassByParent(long pid, List<DynamicObject> ics) {
        QFilter filters = new QFilter(pkValue, "=", (Object)pid);
        DynamicObject[] itemClass = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id,parent", (QFilter[])filters.toArray());
        if (itemClass != null && itemClass.length > 0 && ics.size() < 5) {
            DynamicObject ic = itemClass[0];
            long nextPid = ic.getLong("parent_id");
            ics.add(ic);
            this.getItemClassByParent(nextPid, ics);
        }
    }
}

