/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.common.rebateprebudge;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.occpic.common.rebateprebudge.TotalAmount;
import kd.occ.occpic.common.rebateprebudge.calculator.AbstractCalculator;
import kd.occ.occpic.common.rebateprebudge.calculator.CalculatorFactory;

public class CalculatorHelper {
    public static final void calc(DynamicObject dynamicObject) {
        try {
            CalculatorHelper.setName(dynamicObject);
            String rebateType = dynamicObject.getString("rebatetype");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            int maxSize = dynamicObjectCollection.size();
            AbstractCalculator calculator = CalculatorFactory.getCalculate(rebateType);
            DynamicObject currency = dynamicObject.getDynamicObject("rpprecurrency");
            calculator.setCurrency(currency);
            TotalAmount totalAmount = CalculatorHelper.getTotalAmount(dynamicObjectCollection);
            BigDecimal totalQty = BigDecimal.ZERO;
            BigDecimal totalRebateAmount = BigDecimal.ZERO;
            for (int i = 0; i < maxSize; ++i) {
                DynamicObject rowData = (DynamicObject)dynamicObjectCollection.get(i);
                BigDecimal rebateAmount = calculator.calculate(rowData, totalAmount, i == maxSize - 1);
                rowData.set("rebateamount", (Object)rebateAmount);
                rowData.set("actualunitrebate", (Object)(rowData.getBigDecimal("consignqty").compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : rebateAmount.divide(rowData.getBigDecimal("consignqty"), CalculatorHelper.getPricePrecision(currency), RoundingMode.HALF_DOWN)));
                totalQty = totalQty.add(rowData.getBigDecimal("consignqty"));
                totalRebateAmount = totalRebateAmount.add(rebateAmount);
            }
            dynamicObject.set("totalproconsignqty", (Object)totalQty);
            dynamicObject.set("totalrebateamount", (Object)totalRebateAmount);
        }
        catch (Exception e) {
            throw new RuntimeException(dynamicObject.getString("name") + "," + dynamicObject.getString("rebatetype") + "," + e.getMessage(), e);
        }
    }

    private static final void setName(DynamicObject dynamicObject) {
        DynamicObject channel = dynamicObject.getDynamicObject("channel");
        DynamicObject rebatecustomer = dynamicObject.getDynamicObject("rebatecustomer");
        DynamicObject rebatepolicy = dynamicObject.getDynamicObject("rebatepolicy");
        Date rpbegindate = dynamicObject.getDate("rpbegindate");
        String name = CalculatorHelper.getLocalName(channel) + CalculatorHelper.getLocalName(rebatecustomer) + "_" + (rebatepolicy != null ? rebatepolicy.getString("name") : "") + "_" + (rpbegindate != null ? DateUtil.getDateFormat((Date)rpbegindate) : "");
        dynamicObject.set("name", (Object)(name.length() > 200 ? name.substring(0, 200) : name));
    }

    private static final String getLocalName(DynamicObject dataObj) {
        return dataObj != null ? dataObj.getLocaleString("name").getLocaleValue() : "";
    }

    private static final int getPricePrecision(DynamicObject currency) {
        int priceprecision = 2;
        if (currency != null) {
            priceprecision = currency.getInt("priceprecision");
        }
        return priceprecision;
    }

    private static final TotalAmount getTotalAmount(DynamicObjectCollection dynamicObjectCollection) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject rowData : dynamicObjectCollection) {
            totalAmount = totalAmount.add(rowData.getBigDecimal("saleamount"));
        }
        return new TotalAmount(totalAmount);
    }
}

