/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.opplugin.rebate.policy;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.business.helper.QuickChangeHelper;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocbase.opplugin.base.OcBaseOperationServicePlugIn;
import kd.occ.occpic.opplugin.rebate.validators.RebatePolicyValidator;

public class RebatePolicyEditOp
extends OcBaseOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new RebatePolicyValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List cols = e.getFieldKeys();
        cols.add("name");
        cols.add("billno");
        cols.add("starttime");
        cols.add("endtime");
        cols.add("kpi");
        cols.add("calscopetype");
        cols.add("targetcaltype");
        cols.add("nrebatetype");
        cols.add("nladdertype");
        cols.add("entryentity.seq");
        cols.add("entryentity.minamount");
        cols.add("entryentity.maxamount");
        cols.add("entryentity.minachive");
        cols.add("entryentity.maxachive");
        cols.add("entryentity.minqty");
        cols.add("entryentity.maxqty");
        cols.add("entryentity.rebatepercent");
        cols.add("entryentity.rebateamount");
        cols.add("entryentity.fixedamount");
        cols.add("itemformulaentity.seq");
        cols.add("itemformulaentity.group");
        cols.add("itemformulaentity.itemminamount");
        cols.add("itemformulaentity.itemmaxamount");
        cols.add("itemformulaentity.itemminachive");
        cols.add("itemformulaentity.itemmaxachive");
        cols.add("itemformulaentity.itemminqty");
        cols.add("itemformulaentity.itemmaxqty");
        cols.add("itemformulaentity.itemrebatepercent");
        cols.add("itemformulaentity.itemrebateamount");
        cols.add("itemformulaentity.itemfixedamount");
        cols.add("itemformulaentity.itemblamount");
        cols.add("itemformulaentity.itemblqty");
        cols.add("itemclassentity.id");
        cols.add("incomecusentity.blamount");
        cols.add("incomecusentity.blqty");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] policyArray;
        super.beginOperationTransaction(e);
        for (DynamicObject policy : policyArray = e.getDataEntities()) {
            QuickChangeHelper.setDataStatus((DynamicObject)policy, (OperateOption)this.getOption());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (QuickChangeHelper.isQuickChange((OperateOption)this.getOption())) {
            Object[] policyIdArray = Arrays.stream(e.getDataEntities()).filter(r -> {
                String pushType = r.getString("pushtype");
                return "B".equals(pushType) || "A".equals(pushType);
            }).map(DataEntityBase::getPkValue).toArray();
            if (policyIdArray != null && policyIdArray.length > 0) {
                OperationServiceHelper.executeOperate((String)"pushandsave", (String)"occpic_rebatepolicy", (Object[])policyIdArray, (OperateOption)CommonUtils.getOperateOption());
            }
            QuickChangeHelper.afterExecuteOperationTransaction((OperateOption)this.getOption());
        }
    }
}

