/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.opplugin.rebate.rebatebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.opplugin.base.OcBaseOperationServicePlugIn;
import kd.occ.occpic.mservice.RebateServiceImpl;
import kd.occ.occpic.opplugin.rebate.rebatebill.validators.AdjustAmountSaveValidator;

public class AdjustAmountSubmitplugin
extends OcBaseOperationServicePlugIn {
    public static final String occpic_balanceadjust = "occpic_balanceadjust";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AdjustAmountSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List cols = e.getFieldKeys();
        cols.add("currency");
        cols.add("org");
        cols.add("signparty");
        cols.add("billstatus");
        cols.add("entryentity");
        cols.add("entryentity.customer");
        cols.add("entryentity.accounttype");
        cols.add("entryentity.currency");
        cols.add("entryentity.channel");
        cols.add("entryentity.adjustamount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] collect = e.getDataEntities();
        RebateServiceImpl rebateTool = new RebateServiceImpl();
        ArrayList<AccountRecord> accountRecordList = new ArrayList<AccountRecord>(collect.length);
        for (int i = 0; i < collect.length; ++i) {
            DynamicObjectCollection entry = collect[i].getDynamicObjectCollection("entryentity");
            for (int j = 0; j < entry.size(); ++j) {
                DynamicObject obj = (DynamicObject)entry.get(j);
                AccountRecord accountRecord = new AccountRecord();
                accountRecord.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"channel"));
                accountRecord.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)collect[i], (String)"org"));
                accountRecord.setCustomerId(DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"customer"));
                accountRecord.setAreaDeptId(DynamicObjectUtils.getPkValue((DynamicObject)collect[i], (String)"areadept"));
                accountRecord.setOfficeId(DynamicObjectUtils.getPkValue((DynamicObject)collect[i], (String)"rptoffice"));
                accountRecord.setCountryId(DynamicObjectUtils.getPkValue((DynamicObject)collect[i], (String)"country"));
                accountRecord.setAccountType(DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"accounttype"));
                accountRecord.setAmount(obj.getBigDecimal("adjustamount"));
                accountRecord.setSourceBillId(DynamicObjectUtils.getPkValue((DynamicObject)collect[i]));
                accountRecord.setSourceEntryId(DynamicObjectUtils.getPkValue((DynamicObject)collect[i]));
                accountRecord.setSourceBillNo(collect[i].getString("billno"));
                accountRecord.setBillType("C");
                accountRecord.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)obj, (String)"currency"));
                if (obj.getBigDecimal("adjustamount").compareTo(BigDecimal.ZERO) >= 0) continue;
                accountRecord.setAmount(obj.getBigDecimal("adjustamount").abs());
                accountRecordList.add(accountRecord);
            }
        }
        rebateTool.batchUpdateOccupyAmountAndRecord4Order(accountRecordList);
    }
}

