/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.opplugin.rebate.rebatestatement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.entity.AccountRecord;
import kd.occ.ocbase.common.entity.ServiceResult;
import kd.occ.ocbase.common.enums.AccountUpdateTypeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.SysParamsUtil;

public class RbStatementPay
extends AbstractOperationServicePlugIn {
    public static final String pkValue = "id";
    public static final String enrtyId = "enrtyId";
    public static final String idKey = "_id";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("paytype");
        e.getFieldKeys().add("rebatetype");
        e.getFieldKeys().add("salechannel");
        e.getFieldKeys().add("customer");
        e.getFieldKeys().add("isbatchsettle");
        e.getFieldKeys().add("country");
        e.getFieldKeys().add("areadept");
        e.getFieldKeys().add("office");
        e.getFieldKeys().add("channel");
        e.getFieldKeys().add("rebatepolicy");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("stmcurrency");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("statementdate");
        e.getFieldKeys().add("account");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("sourceorderid");
        e.getFieldKeys().add("sourceorderentryid");
        e.getFieldKeys().add("price");
        e.getFieldKeys().add("saleamount");
        e.getFieldKeys().add("perunitrebateamount");
        e.getFieldKeys().add("rebateamount");
        e.getFieldKeys().add("chncustomer");
        e.getFieldKeys().add("occupyamount");
        e.getFieldKeys().add("availablebalance");
        e.getFieldKeys().add("benefitcustomer");
        e.getFieldKeys().add("echncustomer");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        if (bills == null || bills.length == 0) {
            return;
        }
        ArrayList<AccountRecord> accountRecordList = new ArrayList<AccountRecord>(100);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(100);
        for (int i = 0; i < bills.length; ++i) {
            DynamicObjectCollection dyObjectCollection;
            DynamicObject bill = bills[i];
            if (!"B".equals(bill.getString("paytype")) || !"C".equals(bill.getString("billstatus")) || CollectionUtils.isEmpty((Collection)(dyObjectCollection = bill.getDynamicObjectCollection("entryentity")))) continue;
            accountRecordList.addAll(this.batchUpdateRebateAccounts(bill, dyObjectCollection));
            paramsList.add(new Object[]{DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"account"), bill.getPkValue()});
        }
        if (!CollectionUtils.isEmpty(paramsList)) {
            this.getRebateServiceResultList(accountRecordList);
            DB.executeBatch((DBRoute)new DBRoute("drp"), (String)"update t_occpic_rebatestatement set fbillstatus = 'D' ,faccountid= ? where fid = ? ", paramsList);
            this.getOperationResult().setSuccessPkIds(paramsList.stream().map(r -> r[1]).collect(Collectors.toList()));
        }
        if (SysParamsUtil.isEnableBalModel()) {
            paramsList = new ArrayList(0);
            for (DynamicObject bill : bills) {
                long billId = DynamicObjectUtils.getPkValue((DynamicObject)bill);
                DynamicObjectCollection entryColl = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)bill, (String)"entryentity");
                if (entryColl == null || entryColl.size() <= 0) continue;
                for (DynamicObject entryItem : entryColl) {
                    long entryId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem);
                    QFilter qFilter = new QFilter("sourcebill", "=", (Object)"occpic_rebatestatement");
                    qFilter.and("sourcebillid", "=", (Object)billId);
                    qFilter.and("sourceentryid", "=", (Object)entryId);
                    String selectFields = "id,occupyamount,balance,availablebalance";
                    DynamicObject rebateAccount = QueryServiceHelper.queryOne((String)"ocdbd_rebateaccount", (String)selectFields, (QFilter[])qFilter.toArray());
                    if (rebateAccount == null) continue;
                    paramsList.add(new Object[]{DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"occupyamount"), DynamicObjectUtils.getBigDecimal((DynamicObject)rebateAccount, (String)"availablebalance"), billId, entryId});
                }
            }
            if (paramsList.size() > 0) {
                DB.executeBatch((DBRoute)new DBRoute("drp"), (String)"update t_occpic_rebatestmentry set foccupyamount = ? ,favailablebalance= ? where fid = ? and fentryid = ?", paramsList);
            }
        }
    }

    private List<AccountRecord> batchUpdateRebateAccounts(DynamicObject bill, DynamicObjectCollection detailList) {
        boolean isbatchsettle = bill.getBoolean("isbatchsettle");
        String rebatetype = bill.getString("rebatetype");
        ArrayList<AccountRecord> accountRecordList = new ArrayList<AccountRecord>(detailList.size());
        for (DynamicObject entry : detailList) {
            AccountRecord accountRecord = new AccountRecord();
            accountRecord.setBillType("A");
            accountRecord.setBillEntity("occpic_rebatestatement");
            if (isbatchsettle) {
                accountRecord.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"benefitcustomer"));
                accountRecord.setCustomerId(DynamicObjectUtils.getPkValue((DynamicObject)entry, (String)"echncustomer"));
            } else {
                accountRecord.setChannelId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"channel"));
                accountRecord.setCustomerId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"chncustomer"));
            }
            if (StringUtils.equals((CharSequence)rebatetype, (CharSequence)"A")) {
                accountRecord.setOrgId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"org"));
            } else {
                accountRecord.setReceiveChannelId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"salechannel"));
            }
            accountRecord.setAccountType(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"account"));
            accountRecord.setAmount(entry.getBigDecimal("rebateamount"));
            accountRecord.setSourceBillId(DynamicObjectUtils.getPkValue((DynamicObject)bill));
            accountRecord.setSourceBillNo(bill.getString("billno"));
            accountRecord.setSourceEntryId(DynamicObjectUtils.getPkValue((DynamicObject)entry));
            accountRecord.setCurrencyId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"stmcurrency"));
            accountRecord.setCountryId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"country"));
            accountRecord.setAreaDeptId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"areadept"));
            accountRecord.setOfficeId(DynamicObjectUtils.getPkValue((DynamicObject)bill, (String)"office"));
            accountRecord.setPoolType(rebatetype);
            accountRecord.setUpdateType(AccountUpdateTypeEnum.balanceAdjust.getValue());
            accountRecord.setIsAutoCreateRebateAccount(true);
            accountRecordList.add(accountRecord);
        }
        return accountRecordList;
    }

    private List<ServiceResult> getRebateServiceResultList(List<AccountRecord> accountRecordList) {
        return (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"occba", (String)"Occba_RebateAccountPoolService", (String)"batchUpdateRebateAccountList", (Object[])new Object[]{accountRecordList});
    }
}

