/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.opplugin.rebate.validators;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.occ.ocbase.common.model.CheckResult;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.validator.BatchFastValidator;

public class RebateBillValidator
extends BatchFastValidator {
    public void submit(ExtendedDataEntity[] datas) {
        if (!this.isFromListPage()) {
            this.save(datas);
        }
    }

    public void save(ExtendedDataEntity[] datas) {
        ArrayList<ExtendedDataEntity> afterSingleCheceds = new ArrayList<ExtendedDataEntity>(datas.length);
        CheckResult cr = null;
        String type = null;
        for (int i = 0; i < datas.length; ++i) {
            cr = this.chechSave4Single(datas[i]);
            if (!cr.isSuccess()) {
                this.addFatalErrorMessage(datas[i], cr.getMsg());
                continue;
            }
            type = datas[i].getDataEntity().getString("rebatetype");
            if (!"2".equals(type)) continue;
            afterSingleCheceds.add(datas[i]);
        }
        this.batchCheckBeforeSave(afterSingleCheceds);
    }

    private void batchCheckBeforeSave(List<ExtendedDataEntity> eDatas) {
        if (eDatas.isEmpty()) {
            return;
        }
        ArrayList<Object> attrValueList = new ArrayList<Object>(eDatas.size());
        DynamicObjectCollection entrys = null;
        DynamicObject attrValue = null;
        for (ExtendedDataEntity eData : eDatas) {
            entrys = eData.getDataEntity().getDynamicObjectCollection("detail");
            for (DynamicObject entry : entrys) {
                attrValue = entry.getDynamicObject("attrvalue");
                if (attrValue == null) {
                    attrValueList.add(null);
                    continue;
                }
                attrValueList.add(attrValue.get("id"));
            }
        }
    }

    private CheckResult chechSave4Single(ExtendedDataEntity data) {
        boolean isLegal;
        DynamicObject accountType;
        String settmentType;
        DynamicObject de = data.getDataEntity();
        String number = de.getString("billno");
        if (number == null || "".equals(number.trim())) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5f55\u5165\u6216\u8005\u914d\u7f6e\u7f16\u7801\u89c4\u5219", (String)"RebateBillValidator_0", (String)"occ-occpic-opplugin", (Object[])new Object[0]));
        }
        DynamicObject owner = de.getDynamicObject("owner");
        if (owner == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"RebateBillValidator_1", (String)"occ-occpic-opplugin", (Object[])new Object[0]));
        }
        DynamicObject customer = de.getDynamicObject("customer");
        if (customer == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8ba2\u8d27\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"RebateBillValidator_2", (String)"occ-occpic-opplugin", (Object[])new Object[0]));
        }
        String billFrom = de.getString("billfrom");
        if (!"2".equals(billFrom) && !"1".equals(billFrom)) {
            de.set("billfrom", (Object)"2");
        }
        if (!"1".equals(settmentType = de.getString("settmenttype"))) {
            de.set("settmenttype", (Object)"1");
        }
        if ((accountType = de.getDynamicObject("accounttype")) == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8d26\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"RebateBillValidator_3", (String)"occ-occpic-opplugin", (Object[])new Object[0]));
        }
        boolean relation = this.getVc().isAuthRelation(owner.get("id"), customer.get("id"));
        if (!relation) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u3010%1$s\u3011\u548c\u8ba2\u8d27\u6e20\u9053\u3010%2$s\u3011\u4e0d\u6ee1\u8db3\u8ba2\u8d27\u5173\u7cfb", (String)"RebateBillValidator_4", (String)"occ-occpic-opplugin", (Object[])new Object[0]), (Object[])new Object[]{owner.get("name"), customer.get("name")});
        }
        DynamicObject saler = de.getDynamicObject("saler");
        if (saler != null && !(isLegal = this.getVc().isLegalSaler(owner.get("id"), customer.get("id"), saler.get("id")))) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u3010%1$s\u3011\u548c\u8ba2\u8d27\u6e20\u9053\u3010%2$s\u3011\uff1a\u4e0d\u5b58\u5728\u4e1a\u52a1\u5458\u3010%3$s\u3011", (String)"RebateBillValidator_5", (String)"occ-occpic-opplugin", (Object[])new Object[0]), (Object[])new Object[]{owner.get("name"), customer.get("name"), saler.get("name")});
        }
        DynamicObjectCollection entrys = de.getDynamicObjectCollection("detail");
        if (entrys.size() == 0) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u5206\u5f55\u81f3\u5c11\u8981\u6709\u4e00\u6761\u8fd4\u5229\u660e\u7ec6", (String)"RebateBillValidator_6", (String)"occ-occpic-opplugin", (Object[])new Object[0]));
        }
        String type = de.getString("rebatetype");
        if (type == null) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8fd4\u5229\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"RebateBillValidator_7", (String)"occ-occpic-opplugin", (Object[])new Object[0]));
        }
        if ("1".equals(type)) {
            return this.checkEntryRebateAmount(entrys);
        }
        if ("2".equals(type)) {
            return this.checkEntryRebateItem(owner, customer, entrys);
        }
        return CheckResult.returnFalse((String)(ResManager.loadKDString((String)"\u8fd4\u5229\u7c7b\u578b\uff1a%1$s \u6570\u636e\u4e0d\u5408\u6cd5", (String)"RebateBillValidator_8", (String)"occ-occpic-opplugin", (Object[])new Object[0]) + type));
    }

    private CheckResult checkOrSetFromDateAndToDate(DynamicObject entry) {
        Date toDate;
        Date fromDate = entry.getDate("fromdate");
        if (fromDate == null) {
            fromDate = DateUtil.formatDate((String)"2000-01-01", (String)"yyyy-MM-dd");
            entry.set("fromdate", (Object)fromDate);
        }
        if ((toDate = entry.getDate("todate")) == null) {
            toDate = DateUtil.formatDate((String)"2099-12-31", (String)"yyyy-MM-dd");
            entry.set("todate", (Object)toDate);
        }
        if (toDate.before(fromDate)) {
            return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u7b2c%\u884c\u5206\u5f55\uff1a\u5931\u6548\u65e5\u671f\u3010%\u3011\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65e5\u671f\u3010%\u3011", (String)"RebateBillValidator_9", (String)"occ-occpic-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entry.get("seq"), DateUtil.getDateFormat((Date)fromDate), DateUtil.getDateFormat((Date)toDate)});
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkEntryRebateAmount(DynamicObjectCollection entrys) {
        DynamicObject entry = null;
        BigDecimal amount = null;
        DynamicObject item = null;
        CheckResult result = null;
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            entry = (DynamicObject)entrys.get(i);
            amount = entry.getBigDecimal("amount");
            if (BigDecimal.ZERO.compareTo(amount) == 0) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8fd4\u73b0\u91d1\uff1a\u7b2c%1$s\u884c\u5206\u5f55\u91d1\u989d\u4e0d\u80fd\u4e3a0", (String)"RebateBillValidator_10", (String)"occ-occpic-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entry.get("seq")});
            }
            item = entry.getDynamicObject("item");
            if (item != null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8fd4\u73b0\u91d1\uff1a\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u5546\u54c1\u5fc5\u987b\u4e3a\u7a7a", (String)"RebateBillValidator_11", (String)"occ-occpic-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entry.get("seq")});
            }
            entry.set("attrvalue", null);
            entry.set("unit", null);
            entry.set("qty", (Object)0);
            entry.set("outqty", (Object)0);
            result = this.checkOrSetFromDateAndToDate(entry);
            if (result.isSuccess()) continue;
            return result;
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkEntryRebateItem(DynamicObject owner, DynamicObject customer, DynamicObjectCollection entrys) {
        DynamicObject entry = null;
        BigDecimal amount = null;
        BigDecimal qty = null;
        DynamicObject item = null;
        DynamicObject unit = null;
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            entry = (DynamicObject)entrys.get(i);
            qty = entry.getBigDecimal("qty");
            if (BigDecimal.ZERO.compareTo(qty) == 0) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8fd4\u5546\u54c1\uff1a\u7b2c%1$s\u884c\u5206\u5f55\u6570\u91cf\u4e0d\u80fd\u4e3a0", (String)"RebateBillValidator_12", (String)"occ-occpic-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entry.get("seq")});
            }
            amount = entry.getBigDecimal("amount");
            if (BigDecimal.ZERO.compareTo(amount) != 0) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8fd4\u5546\u54c1\uff1a\u7b2c%1$s\u884c\u5206\u5f55\u91d1\u989d\u5fc5\u987b\u4e3a0", (String)"RebateBillValidator_13", (String)"occ-occpic-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entry.get("seq")});
            }
            item = entry.getDynamicObject("item");
            if (item == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8fd4\u5546\u54c1\uff1a\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a", (String)"RebateBillValidator_14", (String)"occ-occpic-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entry.get("seq")});
            }
            unit = entry.getDynamicObject("unit");
            if (unit == null) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8fd4\u5546\u54c1\uff1a\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"RebateBillValidator_15", (String)"occ-occpic-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entry.get("seq")});
            }
            if (!this.getVc().isSaleControlItem(owner.get("id"), customer.get("id"), item.get("id"))) {
                return CheckResult.returnFalse((String)ResManager.loadKDString((String)"\u8fd4\u5546\u54c1\uff1a\u7b2c%1$s\u884c\u5206\u5f55,\u9500\u552e\u6e20\u9053\u3010%2$s\u3011\u548c\u8ba2\u8d27\u6e20\u9053\u3010%3$s\u3011\u8ba2\u8d27\u5173\u7cfb\u4e2d\uff0c\u5546\u54c1\u3010%4$s\u3011\u4e0d\u53ef\u9500", (String)"RebateBillValidator_16", (String)"occ-occpic-opplugin", (Object[])new Object[0]), (Object[])new Object[]{entry.get("seq"), owner.get("name"), customer.get("name"), item.get("name")});
            }
            this.checkOrSetFromDateAndToDate(entry);
        }
        return CheckResult.returnTrue();
    }
}

