/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.advancerebate;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;

public class AdvanceRebateEdit
extends OcbaseBillPlugin {
    private static Log logger = LogFactory.getLog(AdvanceRebateEdit.class);

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "item": {
                this.changeValueByItemChange(changeData);
                break;
            }
            case "unit": {
                this.changeValueByUnitChange(changeData);
                break;
            }
            case "qty": 
            case "payqty": {
                break;
            }
            case "balanceqty": {
                break;
            }
        }
    }

    private void changeValueByUnitChange(ChangeData[] changeData) {
        for (ChangeData changeUnit : changeData) {
            DynamicObject item = (DynamicObject)this.getModel().getValue("item");
            DynamicObject newUnit = (DynamicObject)changeUnit.getNewValue();
            BigDecimal unitQty = (BigDecimal)this.getModel().getValue("baseqty");
            this.updateChangeDataBaseQty(item, newUnit, unitQty, changeUnit.getRowIndex());
        }
    }

    private void updateChangeDataBaseQty(DynamicObject item, DynamicObject unit, BigDecimal unitQty, int rowIndex) {
        long itemId = this.getPkValue(item);
        long unitId = this.getPkValue(unit);
        BigDecimal baseQty = this.getBaseQty(itemId, unitId, unitQty);
        this.getModel().setValue("baseqty", (Object)baseQty, rowIndex);
    }

    private void changeValueByItemChange(ChangeData[] changeData) {
        int rowIndex = 0;
        for (ChangeData changeItem : changeData) {
            rowIndex = changeItem.getRowIndex();
            this.clearValue(rowIndex);
            DynamicObject item = (DynamicObject)changeItem.getNewValue();
            if (item == null) continue;
            this.getModel().setValue("baseunit", (Object)item.getLong("baseunit.id"), rowIndex);
        }
    }

    private void clearValue(int rowIndex) {
        this.getModel().setValue("qty", null, rowIndex);
        this.getModel().setValue("unit", null, rowIndex);
        this.getModel().setValue("payqty", null, rowIndex);
        this.getModel().setValue("balanceqty", null, rowIndex);
        this.getModel().setValue("unconditionprice", null, rowIndex);
        this.getModel().setValue("conditionprice", null, rowIndex);
        this.getModel().setValue("advprice", null, rowIndex);
        this.getModel().setValue("postatus", null, rowIndex);
        this.getModel().setValue("paustatus", null, rowIndex);
        this.getModel().setValue("baseunit", null, rowIndex);
        this.getModel().setValue("basepayqty", null, rowIndex);
        this.getModel().setValue("basebalanceqty", null, rowIndex);
        this.getModel().setValue("advqty", null, rowIndex);
        this.getModel().setValue("baseadvqty", null, rowIndex);
        this.getModel().setValue("baseqty", null, rowIndex);
    }

    private BigDecimal getBaseQty(long itemId, long unitId, BigDecimal unitQty) {
        try {
            return this.getUnitFormHandler().getBaseQty((Object)itemId, unitQty, (Object)unitId);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return BigDecimal.ZERO;
        }
    }

    public void addF7Listener(BeforeF7SelectListener arg0, String ... arg1) {
        super.addF7Listener(arg0, arg1);
    }

    public void setF7Filter(String f7Name, QFilter filter) {
        super.setF7Filter(f7Name, filter);
    }

    private long getPkValue(DynamicObject arg) {
        if (arg == null) {
            return 0L;
        }
        return arg.getLong("id");
    }
}

