/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.rebate.rebatepolicy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.business.helper.ReturnOrderHelper;
import kd.occ.ocbase.common.enums.Enable;
import kd.occ.ocbase.common.enums.LadderTypeEnums;
import kd.occ.ocbase.common.enums.occpic.CalScopeType;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.QueryUtil;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;
import kd.occ.occpic.business.rebate.RebateHelper;

public class RebatePolicyEdit
extends OcbaseBillPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener((BeforeF7SelectListener)this, new String[]{"conditongroup", "channelclass", "channel", "customerclass", "customer", "itemclass", "item", "materialclass", "material", "kpi"});
    }

    public void afterCreateNewData(EventObject e) {
        long accountOrgId;
        super.afterCreateNewData(e);
        boolean isRequireLoadRefence = false;
        DynamicObject policy = this.getModel().getDataEntity();
        long bizOrgId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)policy, (String)"bizorg");
        if (bizOrgId > 0L && policy.getDynamicObject("balanceorg") == null && (accountOrgId = ReturnOrderHelper.getSettleOrgIdBySaleOrg((long)bizOrgId)) > 0L) {
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)policy, (String)"balanceorg", (long)accountOrgId);
            isRequireLoadRefence = true;
        }
        if (policy.getDynamicObject("unit") == null) {
            DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)policy, (String)"unit", (long)11L);
            isRequireLoadRefence = true;
        }
        if (isRequireLoadRefence) {
            BusinessDataServiceHelper.loadRefence((Object[])new Object[]{policy}, (IDataEntityType)policy.getDynamicObjectType());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        super.beforeF7Select(e);
        switch (key = e.getProperty().getName()) {
            case "conditongroup": {
                this.addF7DistinctFilter(e, "itemformulaentity", "conditongroup");
                break;
            }
            case "channelclass": {
                this.mutexBeforeF7Select(e, key, "channel", "incomecusentity", ResManager.loadKDString((String)"\u6e20\u9053\u5206\u7c7b\u4e0e\u6e20\u9053\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u3002", (String)"RebatePolicyEdit_0", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                break;
            }
            case "channel": {
                this.mutexBeforeF7Select(e, key, "channelclass", "incomecusentity", ResManager.loadKDString((String)"\u6e20\u9053\u5206\u7c7b\u4e0e\u6e20\u9053\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u3002", (String)"RebatePolicyEdit_0", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                break;
            }
            case "customerclass": {
                this.mutexBeforeF7Select(e, key, "customer", "incomecusentity", ResManager.loadKDString((String)"\u5ba2\u6237\u5206\u7c7b\u4e0e\u5ba2\u6237\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u3002", (String)"RebatePolicyEdit_1", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                break;
            }
            case "customer": {
                this.mutexBeforeF7Select(e, key, "customerclass", "incomecusentity", ResManager.loadKDString((String)"\u5ba2\u6237\u5206\u7c7b\u4e0e\u5ba2\u6237\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u3002", (String)"RebatePolicyEdit_1", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                break;
            }
            case "itemclass": {
                this.mutexBeforeF7Select(e, key, "item", "itemclassentity", ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u4e0e\u5546\u54c1\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u3002", (String)"RebatePolicyEdit_2", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                break;
            }
            case "item": {
                this.mutexBeforeF7Select(e, key, "itemclass", "itemclassentity", ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u4e0e\u5546\u54c1\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u3002", (String)"RebatePolicyEdit_2", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                break;
            }
            case "materialclass": {
                this.mutexBeforeF7Select(e, key, "material", "itemclassentity", ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u4e0e\u7269\u6599\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u3002", (String)"RebatePolicyEdit_3", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                break;
            }
            case "material": {
                this.mutexBeforeF7Select(e, key, "materialclass", "itemclassentity", ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u4e0e\u7269\u6599\u53ea\u80fd\u7ef4\u62a4\u4e00\u4e2a\u3002", (String)"RebatePolicyEdit_3", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void mutexBeforeF7Select(BeforeF7SelectEvent e, String aKey, String bKey, String entity, String message) {
        if (this.getValue(bKey, e.getRow()) != null) {
            this.getView().showMessage(message);
            e.setCancel(true);
        } else {
            this.addF7DistinctFilter(e, entity, aKey);
        }
    }

    private void addF7DistinctFilter(BeforeF7SelectEvent e, String entity, String f7) {
        Set idSet = this.getModel().getEntryEntity(entity).stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)f7)).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(idSet)) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "not in", idSet));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = this.getRowIndex(e);
        switch (key) {
            case "kpi": {
                this.kpiChanged((DynamicObject)newValue);
                break;
            }
            case "conditongroup": 
            case "itemblqty": 
            case "itemblamount": {
                int[] indexArray;
                for (int index : indexArray = this.findSameGroupIndexArrayForItemFormulaEntity(rowIndex)) {
                    if (index == rowIndex) continue;
                    this.setValue(key, newValue, index, false);
                }
                break;
            }
            case "maxamount": 
            case "maxachive": 
            case "maxqty": 
            case "itemmaxamount": 
            case "itemmaxachive": 
            case "itemmaxqty": {
                this.handleMaxEntryKeyChanged(e, key);
                break;
            }
            case "minamount": 
            case "minachive": 
            case "minqty": 
            case "itemminamount": 
            case "itemminachive": 
            case "itemminqty": {
                this.handleMinEntryKeyChanged(e, key);
                break;
            }
        }
        this.propertyChanged2QuickChange(e);
    }

    private void clearEntity(String entity, boolean isAddFist) {
        this.getModel().deleteEntryData(entity);
        if (isAddFist) {
            if ("itemformulaentity".equals(entity)) {
                this.getModel().insertEntryRow("itemformulaentity", 0);
                this.setValue("group", 1, 0);
            } else {
                this.getModel().createNewEntryRow(entity);
            }
        }
    }

    private void kpiChanged(DynamicObject kpi) {
        this.clearEntity("incomecusentity", kpi != null);
        this.clearEntity("entryentity", false);
        this.clearEntity("itemclassentity", false);
        this.clearEntity("itemformulaentity", false);
        this.setValue("rebateclass", kpi == null ? null : kpi.get("rebateclass"));
        if (kpi == null) {
            this.clearEntity("incomecusentity", false);
            this.clearEntity("entryentity", false);
            this.clearEntity("itemclassentity", false);
            this.clearEntity("itemformulaentity", false);
            this.setValue("rebateclass", null);
            this.setValue("laddertype", null);
            this.setValue("targetcaltype", null);
            this.setValue("rebatetype", null);
            this.setValue("calscopetype", null);
            this.setValue("calbilltype", null);
        } else {
            this.clearEntity("incomecusentity", true);
            CalScopeType calScopeType = CalScopeType.parse((String)kpi.getString("calscopetype"));
            if (calScopeType != null) {
                switch (calScopeType) {
                    case ALL: {
                        this.clearEntity("entryentity", true);
                        this.clearEntity("itemclassentity", true);
                        this.clearEntity("itemformulaentity", false);
                        break;
                    }
                    case GROUP: {
                        this.clearEntity("entryentity", false);
                        this.clearEntity("itemclassentity", false);
                        this.clearEntity("itemformulaentity", true);
                    }
                }
            } else {
                this.clearEntity("entryentity", false);
                this.clearEntity("itemclassentity", false);
                this.clearEntity("itemformulaentity", false);
            }
            this.setValue("rebateclass", kpi.get("rebateclass"));
            this.setValue("laddertype", kpi.get("laddertype"));
            this.setValue("targetcaltype", kpi.get("targetcaltype"));
            this.setValue("rebatetype", kpi.get("rebatetype"));
            this.setValue("calscopetype", kpi.get("calscopetype"));
            this.setValue("calbilltype", kpi.get("calbilltype"));
        }
    }

    private void handleMinEntryKeyChanged(PropertyChangedArgs e, String minKey) {
        BigDecimal maxValue;
        int row = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        String maxKey = minKey.replace("min", "max");
        BigDecimal minValue = (BigDecimal)newValue;
        if (minValue == null) {
            minValue = BigDecimal.ZERO;
        }
        if ((maxValue = (BigDecimal)this.getValue(maxKey, row)) != null && BigDecimal.ZERO.compareTo(maxValue) != 0 && minValue.compareTo(maxValue) >= 0) {
            this.setValue(minKey, oldValue, row, false);
        }
        if (row > 0) {
            if (minKey.contains("item")) {
                BigDecimal lastMaxValue;
                if (((Integer)this.getValue("group", row)).intValue() == ((Integer)this.getValue("group", row - 1)).intValue() && (lastMaxValue = (BigDecimal)this.getValue(maxKey, row - 1)) != null && BigDecimal.ZERO.compareTo(lastMaxValue) != 0 && minValue.compareTo(lastMaxValue) < 0) {
                    this.setValue(minKey, oldValue, row, false);
                }
            } else {
                BigDecimal lastMaxValue = (BigDecimal)this.getValue(maxKey, row - 1);
                if (lastMaxValue != null && BigDecimal.ZERO.compareTo(lastMaxValue) != 0 && minValue.compareTo(lastMaxValue) < 0) {
                    this.setValue(minKey, oldValue, row, false);
                }
            }
        }
    }

    private void handleMaxEntryKeyChanged(PropertyChangedArgs e, String maxKey) {
        int row = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        String minKey = maxKey.replace("max", "min");
        BigDecimal maxValue = (BigDecimal)newValue;
        if (maxValue != null && BigDecimal.ZERO.compareTo(maxValue) != 0) {
            BigDecimal minValue = (BigDecimal)this.getValue(minKey, row);
            if (maxValue.compareTo(minValue) > 0) {
                this.setNextLevelMinByMax(minKey, maxKey, maxValue, oldValue, row);
            } else {
                this.setValue(maxKey, oldValue, row);
            }
        }
    }

    private void setNextLevelMinByMax(String minKey, String maxKey, BigDecimal maxValue, Object oldValue, int row) {
        String entity;
        int nextRow = row + 1;
        String string = entity = minKey.contains("item") ? "itemformulaentity" : "entryentity";
        if (this.getModel().getEntryRowCount(entity) > nextRow) {
            int[] indexArray;
            if (entity.equals("itemformulaentity") && Arrays.binarySearch(indexArray = this.findSameGroupIndexArrayForItemFormulaEntity(row), nextRow) < 0) {
                return;
            }
            BigDecimal nextMaxValue = (BigDecimal)this.getValue(maxKey, nextRow);
            if (nextMaxValue != null && BigDecimal.ZERO.compareTo(nextMaxValue) != 0 && maxValue.compareTo(nextMaxValue) >= 0) {
                this.setValue(maxKey, null, row);
                this.setValue(minKey, null, nextRow);
            } else {
                this.setValue(minKey, maxValue, nextRow);
            }
        }
    }

    private int[] findSameGroupIndexArrayForItemFormulaEntity(int rowIndex) {
        ArrayList<Integer> bbb = new ArrayList<Integer>(10);
        int group = (Integer)this.getValue("group", rowIndex);
        for (int i = rowIndex - 1; i >= 0 && group == (Integer)this.getValue("group", i); --i) {
            bbb.add(i);
        }
        bbb.add(rowIndex);
        int itemFormulaEntitySize = this.getModel().getEntryRowCount("itemformulaentity");
        for (int i = rowIndex + 1; i < itemFormulaEntitySize && group == (Integer)this.getValue("group", i); ++i) {
            bbb.add(i);
        }
        return bbb.stream().mapToInt(Integer::intValue).toArray();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "productadd": {
                this.showConditonGroupAddView();
                break;
            }
            case "groupadd": {
                int itemFormulaEntitySize = this.getModel().getEntryRowCount("itemformulaentity");
                int group = 1;
                if (itemFormulaEntitySize > 1) {
                    int last2Index = itemFormulaEntitySize - 2;
                    group = (Integer)this.getValue("group", last2Index);
                    ++group;
                }
                int lastIndex = itemFormulaEntitySize - 1;
                this.setValue("group", group, lastIndex);
                break;
            }
            case "leveladd": {
                int itemFormulaEntitySize = this.getModel().getEntryRowCount("itemformulaentity");
                if (itemFormulaEntitySize > 0) {
                    int lastGroupIndex = this.getModel().getEntryCurrentRowIndex("itemformulaentity");
                    for (int nextGroupIndex = lastGroupIndex + 1; nextGroupIndex < itemFormulaEntitySize && ((Integer)this.getValue("group", lastGroupIndex)).intValue() == ((Integer)this.getValue("group", lastGroupIndex + 1)).intValue(); ++nextGroupIndex) {
                        ++lastGroupIndex;
                    }
                    int insertIndex = lastGroupIndex + 1;
                    this.getModel().insertEntryRow("itemformulaentity", insertIndex);
                    this.setValue("group", this.getValue("group", lastGroupIndex), insertIndex, false);
                    this.setValue("itemblqty", this.getValue("itemblqty", lastGroupIndex), insertIndex, false);
                    this.setValue("itemblamount", this.getValue("itemblamount", lastGroupIndex), insertIndex, false);
                    this.setValue("conditongroup", this.getValue("conditongroup", lastGroupIndex), insertIndex, false);
                    this.setValue("itemblamount", this.getValue("itemblamount", lastGroupIndex), insertIndex, false);
                    this.setValue("itemblqty", this.getValue("itemblqty", lastGroupIndex), insertIndex, false);
                    this.setValue("itemminamount", this.getValue("itemmaxamount", lastGroupIndex), insertIndex, false);
                    this.setValue("itemminqty", this.getValue("itemmaxqty", lastGroupIndex), insertIndex, false);
                    this.setValue("itemminachive", this.getValue("itemmaxachive", lastGroupIndex), insertIndex, false);
                    break;
                }
                this.getModel().insertEntryRow("itemformulaentity", 0);
                this.setValue("group", 1, 0);
                break;
            }
            case "itemformuladelete": {
                this.handleItemFormulaDetele();
                break;
            }
            case "newformularow": {
                int formulaEntitySize = this.getModel().getEntryRowCount("entryentity");
                if (formulaEntitySize <= 1) break;
                int lastIndex = formulaEntitySize - 1;
                int last2Index = lastIndex - 1;
                this.setValue("minamount", this.getValue("maxamount", last2Index), lastIndex, false);
                this.setValue("minqty", this.getValue("maxqty", last2Index), lastIndex, false);
                this.setValue("minachive", this.getValue("maxachive", last2Index), lastIndex, false);
                break;
            }
            case "save": 
            case "submit": {
                if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("incomecusentity"))) {
                    this.getModel().createNewEntryRow("incomecusentity");
                }
                if (!CalScopeType.ALL.toString().equals(this.getStringValue("calscopetype"))) break;
                if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("itemclassentity"))) {
                    this.getModel().createNewEntryRow("itemclassentity");
                }
                if (!CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("entryentity"))) break;
                this.getModel().createNewEntryRow("entryentity");
                break;
            }
            case "customergroup": {
                ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"ocdbd_customgroup", (boolean)true);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "customergroup"));
                showParameter.setCustomParam("enable", (Object)Enable.ENABLE.toString());
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "custompush": {
                RebateHelper.showCustomPushTarget((IFormView)this.getView(), (Object[])new Object[]{this.getModel().getDataEntity().getPkValue()}, (String)this.getStringValue("settperiod"), (Date)((Date)this.getValue("starttime")), (Date)((Date)this.getValue("endtime")));
                break;
            }
        }
    }

    private void handleItemFormulaDetele() {
        int curRowIndex;
        DynamicObject kpi = this.getF7Value("kpi");
        if (kpi != null && (curRowIndex = this.getModel().getEntryCurrentRowIndex("itemformulaentity")) >= 0) {
            if (DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)kpi, (String)"laddertype") == LadderTypeEnums.ACHIEVEMENT.getTypeId() || DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)kpi, (String)"laddertype") == LadderTypeEnums.NORMAL.getTypeId()) {
                int[] indexArray = this.findSameGroupIndexArrayForItemFormulaEntity(curRowIndex);
                indexArray = Arrays.stream(indexArray).sorted().toArray();
                this.handleGroupChangeOnDelete((Integer)this.getValue("group", curRowIndex), indexArray[indexArray.length - 1]);
                this.getModel().deleteEntryRows("itemformulaentity", indexArray);
            } else {
                this.handleGroupChangeOnDelete((Integer)this.getValue("group", curRowIndex), curRowIndex);
                this.getModel().deleteEntryRow("itemformulaentity", curRowIndex);
            }
        }
    }

    private void handleGroupChangeOnDelete(int deleteGroup, int lastDeleteIndex) {
        int maxSize = this.getModel().getEntryRowCount("itemformulaentity");
        for (int i = lastDeleteIndex + 1; i < maxSize; ++i) {
            int group = (Integer)this.getValue("group", i);
            if (group <= deleteGroup) continue;
            this.setValue("group", group - 1, i);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        switch (evt.getActionId()) {
            case "productadd": {
                if (evt.getReturnData() == null) break;
                this.getModel().createNewEntryRow("itemformulaentity");
                int itemFormulaEntitySize = this.getModel().getEntryRowCount("itemformulaentity");
                int group = 1;
                if (itemFormulaEntitySize > 1) {
                    int last2Index = itemFormulaEntitySize - 2;
                    group = (Integer)this.getValue("group", last2Index);
                    ++group;
                }
                int lastIndex = itemFormulaEntitySize - 1;
                this.setValue("group", group, lastIndex);
                this.setValue("conditongroup", evt.getReturnData(), lastIndex);
                break;
            }
            case "customergroup": {
                Set customerGroupIdSet;
                if (evt.getReturnData() == null || CollectionUtils.isEmpty(customerGroupIdSet = ((ListSelectedRowCollection)evt.getReturnData()).stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet()))) break;
                DynamicObject[] customerGroupArray = QueryUtil.loadArray((Object[])customerGroupIdSet.toArray(), (String)"ocdbd_customgroup", (String[])new String[0]);
                Map<Long, DynamicObject> channelIdMap = Arrays.stream(customerGroupArray).flatMap(r -> r.getDynamicObjectCollection("commentryentity").stream()).map(r -> DynamicObjectUtils.getDynamicObject((DynamicObject)r, (String)"channelid")).collect(Collectors.toMap(r -> DynamicObjectUtils.getPkValue((DynamicObject)r), r -> r, (t1, t2) -> t1));
                DynamicObjectCollection incomeCusEntityCol = this.getModel().getEntryEntity("incomecusentity");
                Set existChannelIdSet = incomeCusEntityCol.stream().map(r -> DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)r, (String)"channel")).filter(r -> r > 0L).collect(Collectors.toSet());
                for (Long l : existChannelIdSet) {
                    channelIdMap.remove(l);
                }
                if (!CollectionUtils.isEmpty(channelIdMap)) {
                    for (Map.Entry entry : channelIdMap.entrySet()) {
                        DynamicObject addNewEntity = incomeCusEntityCol.addNew();
                        addNewEntity.set("channel", entry.getValue());
                        DynamicObjectUtils.setDynamicObjectLPkValue((DynamicObject)addNewEntity, (String)"channel", (long)((Long)entry.getKey()));
                    }
                    ArrayList<DynamicObject> emptyRowList = new ArrayList<DynamicObject>(incomeCusEntityCol.size());
                    for (DynamicObject incomeCusEntity : incomeCusEntityCol) {
                        if (DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)incomeCusEntity, (String)"channel") != 0L || DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)incomeCusEntity, (String)"channelclass") != 0L) continue;
                        emptyRowList.add(incomeCusEntity);
                    }
                    if (!CollectionUtils.isEmpty(emptyRowList)) {
                        incomeCusEntityCol.removeAll(emptyRowList);
                    }
                    this.getModel().updateEntryCache(incomeCusEntityCol);
                    this.getView().updateView("incomecusentity");
                    break;
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u5ba2\u6237\u7ec4\u6e20\u9053\u5728\u8fd4\u5229\u5bf9\u8c61\u4e2d\u5df2\u5b58\u5728\u3002", (String)"RebatePolicyEdit_4", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void showConditonGroupAddView() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("ocdbd_conditongroup");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "productadd"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    protected String[] getQuickChangeDisvisibleFieldIdArray2EditAndAudit() {
        return new String[]{"bar_new", "bar_print"};
    }

    protected String[] getQuickChangeDisvisibleFieldIdArray2Edit() {
        return new String[]{"bar_del", "bar_submit"};
    }

    protected String[] getQuickChangeUnenableFieldIdArray() {
        return new String[]{"name", "balanceorg", "settperiod", "daterange", "currency", "kpi", "description", "itemclassentity", "entryentity", "entryentity", "itemformulaentity", "itemclassadd", "delitemclass", "formularowadd", "formularowdelete", "productadd", "groupadd", "itemformuladelete", "leveladd", "customergroup"};
    }

    protected void doQuickChangeViewControl() {
        super.doQuickChangeViewControl();
        this.setEnableSavedIncomeCusEntityRow(false);
    }

    protected void doQuickChangeViewControl2Unaudit() {
        super.doQuickChangeViewControl2Unaudit();
        this.setEnableSavedIncomeCusEntityRow(true);
    }

    private void setEnableSavedIncomeCusEntityRow(boolean isEnable) {
        int incomeCusEntitySize = this.getModel().getEntryRowCount("incomecusentity");
        if (incomeCusEntitySize > 0) {
            for (int i = 0; i < incomeCusEntitySize; ++i) {
                DynamicObject incomeCusEntity = this.getModel().getEntryRowEntity("incomecusentity", i);
                if (incomeCusEntity.getLong("id") <= 0L) continue;
                this.getView().setEnable(Boolean.valueOf(isEnable), i, new String[]{"channelclass", "channel", "customerclass", "customer", "blamount", "blqty"});
            }
        }
    }

    protected void beforeDoOperation2QuickChange(BeforeDoOperationEventArgs e) {
        if ("deleteincomecus".equals(((FormOperate)e.getSource()).getOperateKey())) {
            int[] rowIndexArray = ((EntryGrid)this.getView().getControl("incomecusentity")).getSelectRows();
            ArrayList<Integer> deleteRowIndexList = new ArrayList<Integer>(rowIndexArray.length);
            for (int rowIndex : rowIndexArray) {
                DynamicObject row = this.getModel().getEntryRowEntity("incomecusentity", rowIndex);
                if (row != null && row.getLong("id") > 0L) continue;
                deleteRowIndexList.add(rowIndex);
            }
            if (rowIndexArray.length != deleteRowIndexList.size()) {
                e.setCancel(true);
                this.getModel().deleteEntryRows("incomecusentity", deleteRowIndexList.stream().mapToInt(Integer::intValue).toArray());
            }
        }
    }
}

