/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.rebatebill;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.occ.ocbase.formplugin.base.OcbaseFormPlugin;
import kd.occ.ocbase.formplugin.template.BeForeF7Template;
import kd.occ.ocbase.formplugin.template.FormTemplate;
import kd.occ.occpic.formplugin.RebateBaseEdit;

public class RebateBillEdit
extends RebateBaseEdit
implements BeforeF7SelectListener {
    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void afterCreateNewData(EventObject e) {
        if (!this.isFromImport()) {
            this.initPageDefaultValues();
        }
    }

    private void initPageDefaultValues() {
        FormTemplate.initDefaultOwner((OcbaseFormPlugin)this);
        FormTemplate.initAccountType((OcbaseFormPlugin)this, (String)"accounttype");
    }

    public void afterBindData(EventObject e) {
        this.reSetBtnVisable();
        this.reSetColsVisable();
    }

    private void reSetBtnVisable() {
        String status = this.getStringValue("billstatus");
        if ("D".equals(status)) {
            this.setDisVisible(new String[]{"bar_del", "bar_save", "bar_modify", "bar_submit", "bar_audit", "saveandnew", "bar_more"});
            this.setVisible(new String[]{"bar_new", "toaccount", "bar_close"});
        } else if ("E".equals(status)) {
            this.setDisVisible(new String[]{"bar_del", "bar_save", "bar_modify", "bar_submit", "bar_audit", "saveandnew", "bar_more", "toaccount"});
            this.setVisible(new String[]{"bar_new", "bar_close"});
        }
    }

    public void initialize() {
        this.addF7Listener(this, new String[]{"owner", "customer", "item", "attrvalue", "unit", "saler", "accounttype"});
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        int index = this.getRowIndex(e);
        switch (key) {
            case "owner": {
                this.ownerChanged(e);
                break;
            }
            case "customer": {
                this.customerChanged(e);
                break;
            }
            case "item": {
                this.itemChanged(e, index);
                break;
            }
            case "amount": {
                this.amountChanged(e, index);
                break;
            }
            case "rebatetype": {
                this.rebateTypeChanged(e);
                break;
            }
            case "fromdate": {
                this.fromDateChanged(e);
                break;
            }
            case "todate": {
                this.toDateChanged(e);
                break;
            }
            default: {
                this.triggerChangeEvent = true;
            }
        }
    }

    private void toDateChanged(PropertyChangedArgs e) {
        Date fromDate;
        int index = this.getRowIndex(e);
        DynamicObject row = this.getModel().getEntryRowEntity("detail", index);
        Date toDate = row.getDate("todate");
        if (toDate != null && (fromDate = row.getDate("fromdate")) != null && toDate.before(fromDate)) {
            this.setValue("todate", e.getChangeSet()[0].getOldValue(), index);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65e5\u671f", (String)"RebateBillEdit_0", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void fromDateChanged(PropertyChangedArgs e) {
        Date toDate;
        int index = this.getRowIndex(e);
        DynamicObject row = this.getModel().getEntryRowEntity("detail", index);
        Date fromDate = row.getDate("fromdate");
        if (fromDate != null && (toDate = row.getDate("todate")) != null && toDate.before(fromDate)) {
            this.setValue("fromdate", e.getChangeSet()[0].getOldValue(), index);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f", (String)"RebateBillEdit_1", (String)"occ-occpic-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void rebateTypeChanged(PropertyChangedArgs e) {
        this.reSetEntryRow();
        this.reSetColsVisable();
    }

    private void reSetColsVisable() {
        boolean isRebateAmount = "1".equals(this.getStringValue("rebatetype"));
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(isRebateAmount), new String[]{"amount"});
        view.setVisible(Boolean.valueOf(!isRebateAmount), new String[]{"item"});
        view.setVisible(Boolean.valueOf(!isRebateAmount), new String[]{"unit"});
        view.setVisible(Boolean.valueOf(!isRebateAmount), new String[]{"attrvalue"});
        view.setVisible(Boolean.valueOf(!isRebateAmount), new String[]{"qty"});
        view.setVisible(Boolean.valueOf(!isRebateAmount), new String[]{"outqty"});
        view.setVisible(Boolean.valueOf(!isRebateAmount), new String[]{"itemmodel"});
    }

    private void amountChanged(PropertyChangedArgs e, int index) {
        this.setValue("item", null, index);
        this.reset4ItemChanged(index);
    }

    protected void reset4ItemChanged(int index) {
        this.setValue("unit", null, index);
        this.setValue("attrvalue", null, index);
        this.setValue("qty", 0, index);
        this.setValue("outqty", 0, index);
    }

    private void itemChanged(PropertyChangedArgs e, int index) {
        Object itemId = e.getChangeSet()[0].getNewValue();
        if (itemId == null) {
            this.reset4ItemChanged(index);
        } else {
            this.load4ItemChanged(index);
        }
        this.setValue("amount", 0, index);
    }

    private void load4ItemChanged(int index) {
        Object itemPK = this.getEntryF7PKValue("detail", "item", index);
        Object unit = this.getUnitFormHandler().getSaleUnitId(itemPK);
        this.setValue("unit", unit, index);
    }

    private void customerChanged(PropertyChangedArgs e) {
        this.reSetEntryRow();
    }

    private void reSetEntryRow() {
        this.getModel().deleteEntryData("detail");
        this.getModel().createNewEntryRow("detail");
    }

    private void ownerChanged(PropertyChangedArgs e) {
        this.setCustomerF7Value(null);
        this.reSetEntryRow();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                BeForeF7Template.beforeOwnerF7((OcbaseFormPlugin)this, (BeforeF7SelectEvent)e);
                break;
            }
            case "customer": {
                BeForeF7Template.beforeCustomerF7((OcbaseFormPlugin)this, (BeforeF7SelectEvent)e);
                break;
            }
            case "item": {
                BeForeF7Template.beforeItemF7((OcbaseFormPlugin)this, (BeforeF7SelectEvent)e, (String)"detail");
                break;
            }
            case "attrvalue": {
                break;
            }
            case "unit": {
                BeForeF7Template.beforeUnitF7((OcbaseFormPlugin)this, (BeforeF7SelectEvent)e, (String)"detail");
                break;
            }
            case "saler": {
                BeForeF7Template.beforeSalerF7((OcbaseFormPlugin)this, (BeforeF7SelectEvent)e);
            }
            case "accounttype": {
                BeForeF7Template.beforeAccountTypeF7((OcbaseFormPlugin)this, (BeforeF7SelectEvent)e);
                break;
            }
        }
    }
}

