/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.occpic.formplugin.rebatebudgetbill;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.formplugin.botp.AbstractConvertPlugin;
import kd.occ.ocbase.formplugin.botp.ConvertArgs;
import kd.occ.ocbase.formplugin.botp.ConvertRowArgs;
import kd.occ.occpic.business.helper.RebatePreHelper;
import kd.occ.occpic.common.rebateprebudge.CalculatorHelper;

public class RebatePreAutoCalcConvertPlugin
extends AbstractConvertPlugin {
    public void compareBill(DynamicObject newDataObject, DynamicObject existDataObject, ConvertArgs args) {
    }

    public void compareRow(DynamicObject newRowDataObject, DynamicObject existRowDataObject, ConvertRowArgs args) {
        if (newRowDataObject == null) {
            args.setDelete(true);
        }
    }

    public void beforeSave(DynamicObject dynamicObject) {
        CalculatorHelper.calc((DynamicObject)dynamicObject);
        this.sortAndSetRowDetail(dynamicObject);
    }

    private void sortAndSetRowDetail(DynamicObject dynamicObject) {
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        List<DynamicObject> sortedList = entryEntity.stream().sorted(Comparator.comparing(v -> ((DynamicObject)v).getInt("repolicytgtgroup")).thenComparing(Comparator.comparing(v -> ((DynamicObject)v).getDate("deliveytime")).reversed())).collect(Collectors.toList());
        entryEntity.clear();
        int i = 0;
        Map<String, Long> itemIdFromMaterialData = this.loadItemIdFromMaterial(sortedList);
        for (DynamicObject sortedRow : sortedList) {
            sortedRow.set("seq", (Object)i++);
            RebatePreHelper.setRate((DynamicObject)sortedRow);
            sortedRow.set("iteminfo_Id", (Object)itemIdFromMaterialData.getOrDefault(sortedRow.getString("material_Id"), 0L));
            entryEntity.add((Object)sortedRow);
        }
    }

    private Map<String, Long> loadItemIdFromMaterial(List<DynamicObject> entryEntity) {
        HashMap<String, Long> itemMaps = new HashMap<String, Long>();
        if (entryEntity.size() == 0) {
            return itemMaps;
        }
        List itemIds = entryEntity.stream().map(v -> v.getLong("material_Id")).collect(Collectors.toList());
        QFilter filter = new QFilter("material", "in", itemIds);
        DynamicObjectCollection materialIdList = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)"material,id", (QFilter[])filter.toArray());
        if (materialIdList == null || materialIdList.size() == 0) {
            return itemMaps;
        }
        materialIdList.stream().forEach(v -> itemMaps.put(v.getString("material"), v.getLong("id")));
        return itemMaps;
    }
}

