/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import org.apache.commons.collections4.CollectionUtils;

public class ImportProjTeamUtils {
    private static final String STAFF_TYPE_KEY = "stafftype";
    private static final String USERF7FORMID = "bos_usertreelistf7";
    private static final String BACK_USERF7 = "back_userf7";
    private static final String MEMBER = "member";
    private static final String ROLE = "role";
    private static final String ENTRY = "entry";
    private static List<String> mustFillColumnList = null;

    private static String getOutStaffType() {
        return ResManager.loadKDString((String)"\u5916\u90e8\u4eba\u5458", (String)"ImportProjTeamUtils_0", (String)"pmgt-pmas-common", (Object[])new Object[0]);
    }

    public static void openUserMultiSelectPage(AbstractBillPlugIn plugIn) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
        parameter.setFormId(USERF7FORMID);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugIn, BACK_USERF7));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        plugIn.getView().showForm((FormShowParameter)parameter);
    }

    public static void openImportExcelPage(AbstractBillPlugIn plugIn, String formId, Map<String, Object> params, String closeCallbackKey) {
        FormShowParameter importExcelFormParameter = new FormShowParameter();
        importExcelFormParameter.setFormId(formId);
        Map customParams = importExcelFormParameter.getCustomParams();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            customParams.put(entry.getKey(), entry.getValue());
        }
        importExcelFormParameter.getOpenStyle().setShowType(ShowType.Modal);
        importExcelFormParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugIn, closeCallbackKey));
        plugIn.getView().showForm(importExcelFormParameter);
    }

    public static Map<String, Object> matchUserRole(JSONArray jsonArray) {
        Long matchedUserId;
        ArrayList<String> nameList = new ArrayList<String>(jsonArray.size());
        for (Object jsonObject : jsonArray) {
            JSONArray jsonRowArray = (JSONArray)jsonObject;
            for (Object field : jsonRowArray) {
                JSONObject fieldObj = (JSONObject)field;
                String columnKey = fieldObj.getString("columnKey");
                String value = fieldObj.getString("cellValue");
                if (!StringUtils.equals((CharSequence)MEMBER, (CharSequence)columnKey) || !StringUtils.isNotEmpty((CharSequence)value)) continue;
                nameList.add(value);
            }
        }
        QFilter qFilter = new QFilter("name", "in", nameList);
        qFilter.and("name", "is not null", null);
        DynamicObject[] allUsers = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,phone,number", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, ArrayList<Long>> userNameToIdsMap = new HashMap<String, ArrayList<Long>>();
        for (DynamicObject obj : allUsers) {
            String name = obj.getString("name");
            Long id = (Long)obj.getPkValue();
            ArrayList<Long> idList = (ArrayList<Long>)userNameToIdsMap.get(name);
            if (idList == null) {
                idList = new ArrayList<Long>();
                userNameToIdsMap.put(name, idList);
            }
            idList.add(id);
        }
        HashMap<String, Long> phoneToIdMap = new HashMap<String, Long>(16);
        HashMap<Long, String> idToPhoneMap = new HashMap<Long, String>(16);
        for (DynamicObject obj : allUsers) {
            String phone = obj.getString("phone");
            Long id = (Long)obj.getPkValue();
            phoneToIdMap.put(phone, id);
            idToPhoneMap.put(id, phone);
        }
        HashMap<String, Long> empNumToIdMap = new HashMap<String, Long>(16);
        for (DynamicObject obj : allUsers) {
            String number = obj.getString("number");
            Long id = (Long)obj.getPkValue();
            empNumToIdMap.put(number, id);
        }
        HashSet<Long> matchedUserIds = new HashSet<Long>();
        ArrayList matchedList = new ArrayList();
        ArrayList<JSONArray> outerStaffList = new ArrayList<JSONArray>();
        JSONArray matchFailedList = new JSONArray();
        for (Object obj : jsonArray) {
            boolean isOuterStaff = false;
            JSONArray jsonRowArray = (JSONArray)obj;
            isOuterStaff = ImportProjTeamUtils.isOutStaffType(jsonRowArray);
            matchedUserId = null;
            boolean isMatched = false;
            HashMap<String, Object> objInfoMap = new HashMap<String, Object>();
            for (Object field : jsonRowArray) {
                JSONObject failMsg;
                String jsonStr;
                String msg;
                JSONObject fieldJsonObj = (JSONObject)field;
                String columnKey = fieldJsonObj.getString("columnKey");
                String columnName = fieldJsonObj.getString("columnName");
                String value = fieldJsonObj.getString("cellValue");
                objInfoMap.put(columnKey, value);
                if (ImportProjTeamUtils.getMustFillColumnList().contains(columnKey) && StringUtils.isBlank((CharSequence)value)) {
                    isMatched = false;
                    String msg2 = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"ImportProjTeamUtils_12", (String)"pmgt-pmas-common", (Object[])new Object[0]), columnName.substring(0, columnName.length() - 1));
                    String nameJson = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u63d0\u793a", (String)"ImportProjTeamUtils_2", (String)"pmgt-pmas-common", (Object[])new Object[0]);
                    JSONObject failMsg2 = new JSONObject();
                    failMsg2.put("columnKey", (Object)"failmsg");
                    failMsg2.put("columnName", (Object)nameJson);
                    failMsg2.put("cellValue", (Object)msg2);
                    jsonRowArray.add((Object)failMsg2);
                    break;
                }
                if (MEMBER.equals(columnKey)) {
                    ArrayList idList = (ArrayList)userNameToIdsMap.get(value);
                    if (idList != null && idList.size() == 1) {
                        isMatched = true;
                        matchedUserId = (Long)idList.get(0);
                        continue;
                    }
                    if (idList == null || idList.size() <= 1) {
                        msg = String.format(ResManager.loadKDString((String)"\u4eba\u5458%s\u4e0d\u5b58\u5728\u3002", (String)"ImportProjTeamUtils_3", (String)"pmgt-pmas-common", (Object[])new Object[0]), value);
                        jsonStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u63d0\u793a", (String)"ImportProjTeamUtils_2", (String)"pmgt-pmas-common", (Object[])new Object[0]);
                        failMsg = new JSONObject();
                        failMsg.put("columnKey", (Object)"failmsg");
                        failMsg.put("columnName", (Object)jsonStr);
                        failMsg.put("cellValue", (Object)msg);
                        jsonRowArray.add((Object)failMsg);
                        break;
                    }
                }
                if (isMatched) continue;
                if ("telno".equals(columnKey)) {
                    if (StringUtils.isBlank((CharSequence)value)) continue;
                    Long telnoUserId = (Long)phoneToIdMap.get(value);
                    if (telnoUserId != null) {
                        isMatched = true;
                        matchedUserId = telnoUserId;
                        continue;
                    }
                }
                if (!"empnum".equals(columnKey)) continue;
                Long empNumUserId = (Long)empNumToIdMap.get(value);
                if (!StringUtils.isBlank((CharSequence)value) && empNumUserId != null) {
                    isMatched = true;
                    matchedUserId = empNumUserId;
                    continue;
                }
                msg = ResManager.loadKDString((String)"\u5b58\u5728\u540c\u540d\u4eba\u5458\uff0c\u6839\u636e\u8054\u7cfb\u7535\u8bdd\u548c\u5de5\u53f7\u4f9d\u7136\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ImportProjTeamUtils_4", (String)"pmgt-pmas-common", (Object[])new Object[0]);
                jsonStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u63d0\u793a", (String)"ImportProjTeamUtils_2", (String)"pmgt-pmas-common", (Object[])new Object[0]);
                failMsg = JSONObject.parseObject((String)("{'columnKey':'failmsg','columnName':'" + jsonStr + "','cellValue':'" + msg + "'}"));
                jsonRowArray.add((Object)failMsg);
                break;
            }
            if (isMatched) {
                if (isOuterStaff) {
                    outerStaffList.add(jsonRowArray);
                    continue;
                }
                objInfoMap.put("matchedUserId", matchedUserId);
                matchedList.add(objInfoMap);
                matchedUserIds.add(matchedUserId);
                continue;
            }
            JSONObject jsonObject = ImportProjTeamUtils.jsonArrayToJsonObject(jsonRowArray);
            matchFailedList.add((Object)jsonObject);
        }
        DynamicObjectCollection roles = QueryServiceHelper.query((String)"perm_role", (String)"id,name", (QFilter[])new QFilter[0]);
        HashMap<String, Object> rolNamesMap = new HashMap<String, Object>();
        for (DynamicObject role : roles) {
            rolNamesMap.put(role.getString("name"), role.get("id"));
        }
        Iterator iterator = matchedList.iterator();
        while (iterator.hasNext()) {
            Map matchedMap = (Map)iterator.next();
            matchedUserId = (Long)matchedMap.get("matchedUserId");
            String roleName = (String)matchedMap.get(ROLE);
            if (!StringUtils.isNotBlank((CharSequence)roleName)) continue;
            boolean isMatchedRole = false;
            if (rolNamesMap.containsKey(roleName)) {
                isMatchedRole = true;
                matchedMap.put("matchedRoleId", rolNamesMap.get(roleName));
            }
            if (isMatchedRole) continue;
            String memberName = (String)matchedMap.get(MEMBER);
            matchedMap.put("failmsg", String.format(ResManager.loadKDString((String)"%1$s\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5177\u5907%2$s\u89d2\u8272\u3002", (String)"ImportProjTeamUtils_5", (String)"pmgt-pmas-common", (Object[])new Object[0]), memberName, roleName));
            matchedMap.remove("matchedUserId");
            JSONObject failedJson = ImportProjTeamUtils.mapToJsonObject(matchedMap);
            matchFailedList.add((Object)failedJson);
            iterator.remove();
            matchedUserIds.remove(matchedUserId);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("matchedList", matchedList);
        result.put("matchFailedList", matchFailedList);
        result.put("matchedUserIds", matchedUserIds);
        result.put("idPhones", idToPhoneMap);
        result.put("outerStaffs", outerStaffList);
        return result;
    }

    private static boolean isOutStaffType(JSONArray fieldArray) {
        for (Object field : fieldArray) {
            JSONObject fieldObj = (JSONObject)field;
            String columnKey = fieldObj.getString("columnKey");
            String value = fieldObj.getString("cellValue");
            if (!StringUtils.equals((CharSequence)STAFF_TYPE_KEY, (CharSequence)columnKey) || !StringUtils.equals((CharSequence)ImportProjTeamUtils.getOutStaffType(), (CharSequence)value)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getMustFillColumn() {
        List<String> mustFillColumn = Collections.singletonList(MEMBER);
        return mustFillColumn;
    }

    public static List<String> getMustFillColumnList() {
        return mustFillColumnList;
    }

    private static JSONObject jsonArrayToJsonObject(JSONArray jsonArray) {
        JSONObject object = new JSONObject();
        for (Object obj : jsonArray) {
            JSONObject fieldObj = (JSONObject)obj;
            String columnKey = fieldObj.getString("columnKey");
            String value = fieldObj.getString("cellValue");
            object.put(columnKey, (Object)value);
        }
        return object;
    }

    public static JSONObject mapToJsonObject(Map<String, Object> map) {
        JSONObject object = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            object.put(entry.getKey(), entry.getValue());
        }
        return object;
    }

    public static boolean isUserRoleUnique(AbstractBillPlugIn plugIn, int rowIndex, Map<String, String> paraMap) {
        long count;
        List members;
        boolean isUnique = true;
        String pMember = paraMap.get(MEMBER);
        String pRole = paraMap.get(ROLE);
        String pEntry = paraMap.get(ENTRY);
        DynamicObject member = (DynamicObject)plugIn.getView().getModel().getValue(pMember, rowIndex);
        DynamicObject role = (DynamicObject)plugIn.getView().getModel().getValue(pRole, rowIndex);
        DynamicObjectCollection entries = plugIn.getView().getModel().getEntryEntity(pEntry);
        if (member != null) {
            members = entries.stream().filter(o -> member.getPkValue().equals(o.getDynamicObject(pMember) == null ? null : o.getDynamicObject(pMember).getPkValue())).collect(Collectors.toList());
            if (role != null && (count = members.stream().filter(o -> role.getPkValue().equals(o.getDynamicObject(pRole) == null ? null : o.getDynamicObject(pRole).getPkValue())).count()) > 1L) {
                isUnique = false;
            }
        }
        if (role != null) {
            members = entries.stream().filter(o -> role.getPkValue().equals(o.getDynamicObject(pRole) == null ? null : o.getDynamicObject(pRole).getPkValue())).collect(Collectors.toList());
            if (member != null && (count = members.stream().filter(o -> member.getPkValue().equals(o.getDynamicObject(pMember) == null ? null : o.getDynamicObject(pMember).getPkValue())).count()) > 1L) {
                isUnique = false;
            }
        }
        if (!isUnique) {
            plugIn.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4eba\u5458\uff1a%1$s\u3002\u89d2\u8272\uff1a%2$s\u3002\u5df2\u5728\u7533\u8bf7\u660e\u7ec6\u4e2d\u3002", (String)"ImportProjTeamUtils_13", (String)"pmgt-pmas-common", (Object[])new Object[0]), member.getString("name"), role.getString("name")));
            plugIn.getView().getModel().setValue(pRole, null, rowIndex);
        }
        return isUnique;
    }

    public static void fillOutStaffEntry(List<JSONArray> outerStaffList, IDataModel model, IFormView view) {
        if (CollectionUtils.isEmpty(outerStaffList)) {
            return;
        }
        List outerStaffMapList = outerStaffList.stream().map(lineFieldArray -> {
            HashMap<String, String> outerStaffMap = new HashMap<String, String>(lineFieldArray.size());
            for (Object field : lineFieldArray) {
                JSONObject fieldObj = (JSONObject)field;
                String columnKey = fieldObj.getString("columnKey");
                String value = fieldObj.getString("cellValue");
                outerStaffMap.put(columnKey, value);
            }
            return outerStaffMap;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(outerStaffMapList)) {
            return;
        }
        ArrayList<String> memberList = new ArrayList<String>();
        for (Map staffMap : outerStaffMapList) {
            if (!staffMap.containsKey(MEMBER)) continue;
            memberList.add((String)staffMap.get(MEMBER));
        }
        List<DynamicObject> userInfoList = ImportProjTeamUtils.getUserInfoListByName(memberList);
        ArrayList<String> roleList = new ArrayList<String>();
        for (Map staffMap : outerStaffMapList) {
            if (!staffMap.containsKey(ROLE)) continue;
            roleList.add((String)staffMap.get(ROLE));
        }
        Map<String, DynamicObject> roleInfoMap = ImportProjTeamUtils.getRoleInfoByName(roleList);
        model.deleteEntryData("chteamouterentry");
        model.beginInit();
        for (Map member : outerStaffMapList) {
            int rowIndex = model.createNewEntryRow("chteamouterentry");
            DynamicObject partner = ImportProjTeamUtils.getUserInfoByNameOrNumber(userInfoList, (String)member.get(MEMBER), (String)member.get("empnum"));
            model.setValue("outchpartner", (Object)partner, rowIndex);
            if (partner != null) {
                model.setValue("outchbizpartner", (Object)ImportProjTeamUtils.getBizPartner(partner.getPkValue()), rowIndex);
            }
            model.setValue("outchroleobj", (Object)roleInfoMap.get(member.get(ROLE)), rowIndex);
            model.setValue("outchtelno", member.get("telno"), rowIndex);
            model.setValue("outchnote", member.get("note"), rowIndex);
        }
        model.endInit();
        view.updateView("chteamouterentry");
    }

    public static void finishImport(JSONArray jsonArray, IDataModel model, IFormView view, String[] failHeader, String[] failColumnkey) {
        int failCount;
        if (jsonArray == null || jsonArray.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\u3002\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u5339\u914d\u6216\u8005\u5bfc\u5165\u6587\u4ef6\u7684\u5185\u5bb9\u662f\u5426\u4e3a\u7a7a\u3002", (String)"ImportProjTeamUtils_14", (String)"pmgt-pmas-common", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> resultMap = ImportProjTeamUtils.matchUserRole(jsonArray);
        List matchedList = (List)resultMap.get("matchedList");
        JSONArray matchFailedList = (JSONArray)resultMap.get("matchFailedList");
        Set matchedUserIds = (Set)resultMap.get("matchedUserIds");
        Map idPhones = (Map)resultMap.get("idPhones");
        List outerStaffList = (List)resultMap.get("outerStaffs");
        ImportProjTeamUtils.fillOutStaffEntry(outerStaffList, model, view);
        DynamicObject projObj = (DynamicObject)model.getValue("project");
        QFilter filter = new QFilter("project", "=", projObj.getPkValue());
        filter.and(MEMBER, "in", (Object)matchedUserIds);
        DynamicObjectCollection prtojNowMember = QueryServiceHelper.query((String)"pmas_nowteam", (String)"member,role", (QFilter[])new QFilter[]{filter});
        Map<Long, List<DynamicObject>> memberRoles = prtojNowMember.stream().collect(Collectors.groupingBy(o -> o.getLong(MEMBER)));
        Iterator iterator = matchedList.iterator();
        while (iterator.hasNext()) {
            Map entry = (Map)iterator.next();
            Long matchedUserId = (Long)entry.get("matchedUserId");
            String matchedRoleId = (String)entry.get("matchedRoleId");
            String memberName = (String)entry.get(MEMBER);
            String roleName = (String)entry.get(ROLE);
            String telno = (String)entry.get("telno");
            List<DynamicObject> roles = memberRoles.get(matchedUserId);
            boolean isExists = false;
            if (roles != null) {
                for (DynamicObject role : roles) {
                    String roleId = role.get(ROLE).toString();
                    if (!StringUtils.isNotBlank((CharSequence)matchedRoleId) || !matchedRoleId.equals(roleId)) continue;
                    isExists = true;
                    entry.put("failmsg", String.format(ResManager.loadKDString((String)"\u59d3\u540d\uff1a%1$s\uff0c\u89d2\u8272\uff1a%2$s\uff0c\u5df2\u5b58\u5728\u4e8e\u8be5\u9879\u76ee\u56e2\u961f\u4e2d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ImportProjTeamUtils_15", (String)"pmgt-pmas-common", (Object[])new Object[0]), memberName, roleName));
                    entry.remove("matchedRoleId");
                    JSONObject failObj = ImportProjTeamUtils.mapToJsonObject(entry);
                    matchFailedList.add((Object)failObj);
                    iterator.remove();
                }
            }
            if (isExists || !StringUtils.isBlank((CharSequence)telno)) continue;
            String phone = (String)idPhones.get(matchedUserId);
            entry.put("telno", phone);
        }
        int successCount = matchedList.size();
        if (successCount > 0) {
            model.deleteEntryData("chteamentry");
            model.beginInit();
            for (Map member : matchedList) {
                int rowIndex = model.createNewEntryRow("chteamentry");
                model.setValue("chmember", member.get("matchedUserId"), rowIndex);
                model.setValue("chrole", member.get("matchedRoleId"), rowIndex);
                long orgId = UserServiceHelper.getUserMainOrgId((long)((Long)member.get("matchedUserId")));
                DynamicObject mainOrg = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org", (String)"id,name,number");
                if (mainOrg != null) {
                    model.setValue("chorg", (Object)mainOrg, rowIndex);
                    DynamicObject superOrg = OrgTreeUtils.getSuperCompanyOrg((long)((Long)mainOrg.getPkValue()));
                    if (superOrg != null) {
                        model.setValue("chcompany", (Object)superOrg, rowIndex);
                    }
                }
                model.setValue("chtelno", member.get("telno"), rowIndex);
                model.setValue("chnote", member.get("note"), rowIndex);
            }
            model.endInit();
            view.updateView("chteamentry");
        }
        if ((failCount = matchFailedList.size()) > 0) {
            String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"ImportProjTeamUtils_9", (String)"pmgt-pmas-common", (Object[])new Object[0]);
            String sheetName = ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"ImportProjTeamUtils_9", (String)"pmgt-pmas-common", (Object[])new Object[0]);
            String exportUrl = POIHelper.exportExcel((String)fileName, (String)sheetName, (String[])failHeader, (String[])failColumnkey, ImportProjTeamUtils.getMustFillColumn(), (JSONArray)matchFailedList);
            view.download(exportUrl);
            view.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u884c\uff0c\u5bfc\u5165\u5931\u8d25%2$s\u884c\uff0c\u8bf7\u68c0\u67e5\u300a\u5bfc\u5165\u7ed3\u679c.xls\u300b\u3002", (String)"ImportProjTeamUtils_10", (String)"pmgt-pmas-common", (Object[])new Object[0]), successCount + outerStaffList.size(), failCount), Integer.valueOf(3000));
        } else {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ImportProjTeamUtils_11", (String)"pmgt-pmas-common", (Object[])new Object[0]));
        }
    }

    public static void finishImportAdd(JSONArray jsonArray, IDataModel model, IFormView view, String[] failHeader, String[] failColumnkey) {
        int failCount;
        if (jsonArray == null || jsonArray.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\u3002\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u5339\u914d\u6216\u8005\u5bfc\u5165\u6587\u4ef6\u7684\u5185\u5bb9\u662f\u5426\u4e3a\u7a7a\u3002", (String)"ImportProjTeamUtils_14", (String)"pmgt-pmas-common", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> resultMap = ImportProjTeamUtils.matchUserRole(jsonArray);
        List matchedList = (List)resultMap.get("matchedList");
        JSONArray matchFailedList = (JSONArray)resultMap.get("matchFailedList");
        Set matchedUserIds = (Set)resultMap.get("matchedUserIds");
        Map idPhones = (Map)resultMap.get("idPhones");
        List outerStaffList = (List)resultMap.get("outerStaffs");
        ImportProjTeamUtils.fillOutStaffEntryAdd(outerStaffList, model, view);
        DynamicObject projObj = (DynamicObject)model.getValue("project");
        QFilter filter = new QFilter("project", "=", projObj.getPkValue());
        filter.and(MEMBER, "in", (Object)matchedUserIds);
        DynamicObjectCollection prtojNowMember = QueryServiceHelper.query((String)"pmas_nowteam", (String)"member,role", (QFilter[])new QFilter[]{filter});
        Map<Long, List<DynamicObject>> memberRoles = prtojNowMember.stream().collect(Collectors.groupingBy(o -> o.getLong(MEMBER)));
        Iterator iterator = matchedList.iterator();
        while (iterator.hasNext()) {
            Map entry = (Map)iterator.next();
            Long matchedUserId = (Long)entry.get("matchedUserId");
            String matchedRoleId = (String)entry.get("matchedRoleId");
            String memberName = (String)entry.get(MEMBER);
            String roleName = (String)entry.get(ROLE);
            String telno = (String)entry.get("telno");
            List<DynamicObject> roles = memberRoles.get(matchedUserId);
            boolean isExists = false;
            if (roles != null) {
                for (DynamicObject role : roles) {
                    String roleId = role.get(ROLE).toString();
                    if (!StringUtils.isNotBlank((CharSequence)matchedRoleId) || !matchedRoleId.equals(roleId)) continue;
                    isExists = true;
                    entry.put("failmsg", String.format(ResManager.loadKDString((String)"\u59d3\u540d\uff1a%1$s\uff0c\u89d2\u8272\uff1a%2$s\uff0c\u5df2\u5b58\u5728\u4e8e\u8be5\u9879\u76ee\u56e2\u961f\u4e2d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ImportProjTeamUtils_15", (String)"pmgt-pmas-common", (Object[])new Object[0]), memberName, roleName));
                    entry.remove("matchedRoleId");
                    JSONObject failObj = ImportProjTeamUtils.mapToJsonObject(entry);
                    matchFailedList.add((Object)failObj);
                    iterator.remove();
                }
            }
            if (isExists || !StringUtils.isBlank((CharSequence)telno)) continue;
            String phone = (String)idPhones.get(matchedUserId);
            entry.put("telno", phone);
        }
        int successCount = matchedList.size();
        if (successCount > 0) {
            model.deleteEntryData("tmemberentry");
            model.beginInit();
            for (Map member : matchedList) {
                long orgId;
                DynamicObject mainOrg;
                int rowIndex = model.createNewEntryRow("tmemberentry");
                model.setValue(MEMBER, member.get("matchedUserId"), rowIndex);
                model.setValue(ROLE, member.get("matchedRoleId"), rowIndex);
                model.setValue("isoriginal", (Object)Boolean.TRUE, rowIndex);
                model.setValue("telno", member.get("telno"), rowIndex);
                model.setValue("note", member.get("note"), rowIndex);
                if (member.get("matchedUserId") == null || (mainOrg = BusinessDataServiceHelper.loadSingle((Object)(orgId = UserServiceHelper.getUserMainOrgId((long)((Long)member.get("matchedUserId")))), (String)"bos_org", (String)"id,name,number")) == null) continue;
                model.setValue("insideorg", (Object)mainOrg, rowIndex);
                DynamicObject superOrg = OrgTreeUtils.getSuperCompanyOrg((long)((Long)mainOrg.getPkValue()));
                if (superOrg == null) continue;
                model.setValue("insidecompany", (Object)superOrg, rowIndex);
            }
            model.endInit();
            view.updateView("tmemberentry");
        }
        if ((failCount = matchFailedList.size()) > 0) {
            String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"ImportProjTeamUtils_9", (String)"pmgt-pmas-common", (Object[])new Object[0]);
            String sheetName = ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"ImportProjTeamUtils_9", (String)"pmgt-pmas-common", (Object[])new Object[0]);
            String exportUrl = POIHelper.exportExcel((String)fileName, (String)sheetName, (String[])failHeader, (String[])failColumnkey, ImportProjTeamUtils.getMustFillColumn(), (JSONArray)matchFailedList);
            view.download(exportUrl);
            view.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u884c\uff0c\u5bfc\u5165\u5931\u8d25%2$s\u884c\uff0c\u8bf7\u68c0\u67e5\u300a\u5bfc\u5165\u7ed3\u679c.xls\u300b\u3002", (String)"ImportProjTeamUtils_10", (String)"pmgt-pmas-common", (Object[])new Object[0]), successCount + outerStaffList.size(), failCount), Integer.valueOf(3000));
        } else {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ImportProjTeamUtils_11", (String)"pmgt-pmas-common", (Object[])new Object[0]));
        }
    }

    public static void fillOutStaffEntryAdd(List<JSONArray> outerStaffList, IDataModel model, IFormView view) {
        if (CollectionUtils.isEmpty(outerStaffList)) {
            return;
        }
        List outerStaffMapList = outerStaffList.stream().map(lineFieldArray -> {
            HashMap<String, String> outerStaffMap = new HashMap<String, String>(lineFieldArray.size());
            for (Object field : lineFieldArray) {
                JSONObject fieldObj = (JSONObject)field;
                String columnKey = fieldObj.getString("columnKey");
                String value = fieldObj.getString("cellValue");
                outerStaffMap.put(columnKey, value);
            }
            return outerStaffMap;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(outerStaffMapList)) {
            return;
        }
        ArrayList<String> memberList = new ArrayList<String>();
        for (Map staffMap : outerStaffMapList) {
            if (!staffMap.containsKey(MEMBER)) continue;
            memberList.add((String)staffMap.get(MEMBER));
        }
        List<DynamicObject> userInfoList = ImportProjTeamUtils.getUserInfoListByName(memberList);
        ArrayList<String> roleList = new ArrayList<String>();
        for (Map staffMap : outerStaffMapList) {
            if (!staffMap.containsKey(ROLE)) continue;
            roleList.add((String)staffMap.get(ROLE));
        }
        Map<String, DynamicObject> roleInfoMap = ImportProjTeamUtils.getRoleInfoByName(roleList);
        model.deleteEntryData("outtmemberentry");
        model.beginInit();
        for (Map member : outerStaffMapList) {
            int rowIndex = model.createNewEntryRow("outtmemberentry");
            DynamicObject partner = ImportProjTeamUtils.getUserInfoByNameOrNumber(userInfoList, (String)member.get(MEMBER), (String)member.get("empnum"));
            model.setValue("outpartner", (Object)partner, rowIndex);
            if (partner != null) {
                model.setValue("outbizparter", (Object)ImportProjTeamUtils.getBizPartner(partner.getPkValue()), rowIndex);
            }
            model.setValue("outroleobj", (Object)roleInfoMap.get(member.get(ROLE)), rowIndex);
            model.setValue("outtelno", member.get("telno"), rowIndex);
            model.setValue("outnote", member.get("note"), rowIndex);
        }
        model.endInit();
        view.updateView("outtmemberentry");
    }

    public static void fillOutStaffEntryApp(List<JSONArray> outerStaffList, IDataModel model, IFormView view) {
        if (CollectionUtils.isEmpty(outerStaffList)) {
            return;
        }
        List outerStaffMapList = outerStaffList.stream().map(lineFieldArray -> {
            HashMap<String, String> outerStaffMap = new HashMap<String, String>(lineFieldArray.size());
            for (Object field : lineFieldArray) {
                JSONObject fieldObj = (JSONObject)field;
                String columnKey = fieldObj.getString("columnKey");
                String value = fieldObj.getString("cellValue");
                outerStaffMap.put(columnKey, value);
            }
            return outerStaffMap;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(outerStaffMapList)) {
            return;
        }
        ArrayList<String> memberList = new ArrayList<String>();
        for (Map staffMap : outerStaffMapList) {
            if (!staffMap.containsKey(MEMBER)) continue;
            memberList.add((String)staffMap.get(MEMBER));
        }
        List<DynamicObject> userInfoList = ImportProjTeamUtils.getUserInfoListByName(memberList);
        ArrayList<String> roleList = new ArrayList<String>();
        for (Map staffMap : outerStaffMapList) {
            if (!staffMap.containsKey(ROLE)) continue;
            roleList.add((String)staffMap.get(ROLE));
        }
        Map<String, DynamicObject> roleInfoMap = ImportProjTeamUtils.getRoleInfoByName(roleList);
        model.deleteEntryData("teamouterstaffentity");
        model.beginInit();
        for (Map member : outerStaffMapList) {
            int rowIndex = model.createNewEntryRow("teamouterstaffentity");
            DynamicObject partner = ImportProjTeamUtils.getUserInfoByNameOrNumber(userInfoList, (String)member.get(MEMBER), (String)member.get("empnum"));
            model.setValue("outteampartner", (Object)partner, rowIndex);
            if (partner != null) {
                model.setValue("outbizpartner", (Object)ImportProjTeamUtils.getBizPartner(partner.getPkValue()), rowIndex);
            }
            model.setValue("outroleobj", (Object)roleInfoMap.get(member.get(ROLE)), rowIndex);
            model.setValue("outerteamtelno", member.get("telno"), rowIndex);
            model.setValue("outerteamdescription", member.get("note"), rowIndex);
        }
        model.endInit();
        view.updateView("teamouterstaffentity");
    }

    public static void finishImportApp(JSONArray jsonArray, IDataModel model, IFormView view, String[] failHeader, String[] failColumnkey) {
        int failCount;
        if (jsonArray == null || jsonArray.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\u3002\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u5339\u914d\u6216\u8005\u5bfc\u5165\u6587\u4ef6\u7684\u5185\u5bb9\u662f\u5426\u4e3a\u7a7a\u3002", (String)"ImportProjTeamUtils_14", (String)"pmgt-pmas-common", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> resultMap = ImportProjTeamUtils.matchUserRole(jsonArray);
        List matchedList = (List)resultMap.get("matchedList");
        JSONArray matchFailedList = (JSONArray)resultMap.get("matchFailedList");
        Set matchedUserIds = (Set)resultMap.get("matchedUserIds");
        Map idPhones = (Map)resultMap.get("idPhones");
        List outerStaffList = (List)resultMap.get("outerStaffs");
        ImportProjTeamUtils.fillOutStaffEntryApp(outerStaffList, model, view);
        for (Map entry : matchedList) {
            Long matchedUserId = (Long)entry.get("matchedUserId");
            String telno = (String)entry.get("telno");
            if (!StringUtils.isBlank((CharSequence)telno)) continue;
            String phone = (String)idPhones.get(matchedUserId);
            entry.put("telno", phone);
        }
        int successCount = matchedList.size();
        if (successCount > 0) {
            model.deleteEntryData("proappteamentity");
            model.beginInit();
            for (Map member : matchedList) {
                long orgId;
                DynamicObject mainOrg;
                int rowIndex = model.createNewEntryRow("proappteamentity");
                model.setValue("teamuser", member.get("matchedUserId"), rowIndex);
                model.setValue("teamrole", member.get("matchedRoleId"), rowIndex);
                model.setValue("teamtelno", member.get("telno"), rowIndex);
                model.setValue("teamdescription", member.get("note"), rowIndex);
                if (member.get("matchedUserId") == null || (mainOrg = BusinessDataServiceHelper.loadSingle((Object)(orgId = UserServiceHelper.getUserMainOrgId((long)((Long)member.get("matchedUserId")))), (String)"bos_org", (String)"id,name,number")) == null) continue;
                model.setValue("teamorg", (Object)mainOrg, rowIndex);
                DynamicObject superOrg = OrgTreeUtils.getSuperCompanyOrg((long)((Long)mainOrg.getPkValue()));
                if (superOrg == null) continue;
                model.setValue("teamcompany", (Object)superOrg, rowIndex);
            }
            model.endInit();
            view.updateView("proappteamentity");
        }
        if ((failCount = matchFailedList.size()) > 0) {
            String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"ImportProjTeamUtils_9", (String)"pmgt-pmas-common", (Object[])new Object[0]);
            String sheetName = ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"ImportProjTeamUtils_9", (String)"pmgt-pmas-common", (Object[])new Object[0]);
            String exportUrl = POIHelper.exportExcel((String)fileName, (String)sheetName, (String[])failHeader, (String[])failColumnkey, ImportProjTeamUtils.getMustFillColumn(), (JSONArray)matchFailedList);
            view.download(exportUrl);
            view.showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u884c\uff0c\u5bfc\u5165\u5931\u8d25%2$s\u884c\uff0c\u8bf7\u68c0\u67e5\u300a\u5bfc\u5165\u7ed3\u679c.xls\u300b\u3002", (String)"ImportProjTeamUtils_10", (String)"pmgt-pmas-common", (Object[])new Object[0]), successCount + outerStaffList.size(), failCount), Integer.valueOf(3000));
        } else {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ImportProjTeamUtils_11", (String)"pmgt-pmas-common", (Object[])new Object[0]));
        }
    }

    public static void fillOutStaffEntryTeam(List<JSONArray> outerStaffList, IDataModel model, IFormView view) {
        if (CollectionUtils.isEmpty(outerStaffList)) {
            return;
        }
        List outerStaffMapList = outerStaffList.stream().map(lineFieldArray -> {
            HashMap<String, String> outerStaffMap = new HashMap<String, String>(lineFieldArray.size());
            for (Object field : lineFieldArray) {
                JSONObject fieldObj = (JSONObject)field;
                String columnKey = fieldObj.getString("columnKey");
                String value = fieldObj.getString("cellValue");
                outerStaffMap.put(columnKey, value);
            }
            return outerStaffMap;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(outerStaffMapList)) {
            return;
        }
        ArrayList<String> memberList = new ArrayList<String>();
        for (Map staffMap : outerStaffMapList) {
            if (!staffMap.containsKey(MEMBER)) continue;
            memberList.add((String)staffMap.get(MEMBER));
        }
        List<DynamicObject> userInfoList = ImportProjTeamUtils.getUserInfoListByName(memberList);
        ArrayList<String> roleList = new ArrayList<String>();
        for (Map staffMap : outerStaffMapList) {
            if (!staffMap.containsKey(ROLE)) continue;
            roleList.add((String)staffMap.get(ROLE));
        }
        Map<String, DynamicObject> roleInfoMap = ImportProjTeamUtils.getRoleInfoByName(roleList);
        model.deleteEntryData("outerteamentry");
        model.beginInit();
        for (Map member : outerStaffMapList) {
            int rowIndex = model.createNewEntryRow("outerteamentry");
            DynamicObject partner = ImportProjTeamUtils.getUserInfoByNameOrNumber(userInfoList, (String)member.get(MEMBER), (String)member.get("empnum"));
            model.setValue("outpartner", (Object)partner, rowIndex);
            if (partner != null) {
                model.setValue("outbizpartner", (Object)ImportProjTeamUtils.getBizPartner(partner.getPkValue()), rowIndex);
            }
            model.setValue("outroleobj", (Object)roleInfoMap.get(member.get(ROLE)), rowIndex);
            model.setValue("outerteamtelno", member.get("telno"), rowIndex);
            model.setValue("outerteamdescription", member.get("note"), rowIndex);
        }
        model.endInit();
        view.updateView("outerteamentry");
    }

    public static void finishImportTeam(JSONArray jsonArray, IDataModel model, IFormView view, String[] failHeader, String[] failColumnkey) {
        int failCount;
        if (jsonArray == null || jsonArray.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\u3002\u8bf7\u68c0\u67e5\u6a21\u677f\u662f\u5426\u5339\u914d\u6216\u8005\u5bfc\u5165\u6587\u4ef6\u7684\u5185\u5bb9\u662f\u5426\u4e3a\u7a7a\u3002", (String)"ImportProjTeamUtils_14", (String)"pmgt-pmas-common", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> resultMap = ImportProjTeamUtils.matchUserRole(jsonArray);
        List matchedList = (List)resultMap.get("matchedList");
        JSONArray matchFailedList = (JSONArray)resultMap.get("matchFailedList");
        Set matchedUserIds = (Set)resultMap.get("matchedUserIds");
        Map idPhones = (Map)resultMap.get("idPhones");
        List outerStaffList = (List)resultMap.get("outerStaffs");
        ImportProjTeamUtils.fillOutStaffEntryTeam(outerStaffList, model, view);
        DynamicObject projObj = (DynamicObject)model.getValue("project");
        QFilter filter = new QFilter("project", "=", projObj.getPkValue());
        filter.and(MEMBER, "in", (Object)matchedUserIds);
        DynamicObjectCollection projNowMember = QueryServiceHelper.query((String)"pmas_nowteam", (String)"member,role", (QFilter[])new QFilter[]{filter});
        Map<Long, List<DynamicObject>> memberRoles = projNowMember.stream().collect(Collectors.groupingBy(o -> o.getLong(MEMBER)));
        Iterator iterator = matchedList.iterator();
        while (iterator.hasNext()) {
            Map matchedMap = (Map)iterator.next();
            Long matchedUserId = (Long)matchedMap.get("matchedUserId");
            String matchedRoleId = (String)matchedMap.get("matchedRoleId");
            String memberName = (String)matchedMap.get(MEMBER);
            String roleName = (String)matchedMap.get(ROLE);
            String telno = (String)matchedMap.get("telno");
            List<DynamicObject> roles = memberRoles.get(matchedUserId);
            boolean isExists = false;
            if (roles != null) {
                for (DynamicObject role : roles) {
                    String roleId = role.get(ROLE).toString();
                    if (!StringUtils.isNotBlank((CharSequence)matchedRoleId) || !matchedRoleId.equals(roleId)) continue;
                    isExists = true;
                    matchedMap.put("failmsg", String.format(ResManager.loadKDString((String)"\u59d3\u540d\uff1a%1$s\uff0c\u89d2\u8272\uff1a%2$s\uff0c\u5df2\u5b58\u5728\u4e8e\u8be5\u9879\u76ee\u56e2\u961f\u4e2d\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ImportProjTeamUtils_15", (String)"pmgt-pmas-common", (Object[])new Object[0]), memberName, roleName));
                    matchedMap.remove("matchedRoleId");
                    JSONObject failObj = ImportProjTeamUtils.mapToJsonObject(matchedMap);
                    matchFailedList.add((Object)failObj);
                    iterator.remove();
                }
            }
            if (isExists || !StringUtils.isBlank((CharSequence)telno)) continue;
            String phone = (String)idPhones.get(matchedUserId);
            matchedMap.put("telno", phone);
        }
        int successCount = matchedList.size();
        if (successCount > 0) {
            model.deleteEntryData("teamentry");
            model.beginInit();
            for (Map member : matchedList) {
                long orgId;
                DynamicObject mainOrg;
                int rowIndex = model.createNewEntryRow("teamentry");
                model.setValue(MEMBER, member.get("matchedUserId"), rowIndex);
                model.setValue(ROLE, member.get("matchedRoleId"), rowIndex);
                model.setValue("telno", member.get("telno"), rowIndex);
                model.setValue("note", member.get("note"), rowIndex);
                if (member.get("matchedUserId") == null || (mainOrg = BusinessDataServiceHelper.loadSingle((Object)(orgId = UserServiceHelper.getUserMainOrgId((long)((Long)member.get("matchedUserId")))), (String)"bos_org", (String)"id,name,number")) == null) continue;
                model.setValue("entryorg", (Object)mainOrg, rowIndex);
                DynamicObject superOrg = OrgTreeUtils.getSuperCompanyOrg((long)((Long)mainOrg.getPkValue()));
                if (superOrg == null) continue;
                model.setValue("entrycompany", (Object)superOrg, rowIndex);
            }
            model.endInit();
            view.updateView("teamentry");
        }
        if ((failCount = matchFailedList.size()) > 0) {
            String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"ImportProjTeamUtils_9", (String)"pmgt-pmas-common", (Object[])new Object[0]);
            String sheetName = ResManager.loadKDString((String)"\u5bfc\u5165\u7ed3\u679c", (String)"ImportProjTeamUtils_9", (String)"pmgt-pmas-common", (Object[])new Object[0]);
            String exportUrl = POIHelper.exportExcel((String)fileName, (String)sheetName, (String[])failHeader, (String[])failColumnkey, ImportProjTeamUtils.getMustFillColumnList(), (JSONArray)matchFailedList);
            view.download(exportUrl);
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u884c\uff0c\u5bfc\u5165\u5931\u8d25%2$s\u884c\uff0c\u8bf7\u68c0\u67e5\u300a\u5bfc\u5165\u7ed3\u679c.xls\u300b\u3002", (String)"ImportProjTeamUtils_10", (String)"pmgt-pmas-common", (Object[])new Object[0]), successCount + outerStaffList.size(), failCount), Integer.valueOf(3000));
        } else {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ImportProjTeamUtils_11", (String)"pmgt-pmas-common", (Object[])new Object[0]));
        }
    }

    public static List<DynamicObject> getUserInfoListByName(List<String> userNameList) {
        QFilter nameFilter = new QFilter("name", "in", userNameList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] userInfo = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,phone,number", (QFilter[])new QFilter[]{nameFilter, enableFilter});
        return Arrays.asList(userInfo);
    }

    public static DynamicObject getUserInfoByNameOrNumber(List<DynamicObject> userList, String name, String number) {
        DynamicObject userByName = null;
        ArrayList<DynamicObject> usersByNumber = new ArrayList<DynamicObject>();
        for (DynamicObject user : userList) {
            if (!user.getString("name").equals(name)) continue;
            if (userByName == null) {
                userByName = user;
                continue;
            }
            userByName = null;
            break;
        }
        if (userByName == null && number != null) {
            for (DynamicObject user : userList) {
                if (!user.getString("number").equals(number)) continue;
                usersByNumber.add(user);
            }
            if (usersByNumber.size() > 1) {
                for (DynamicObject user : usersByNumber) {
                    if (!user.getString("name").equals(name)) continue;
                    userByName = user;
                    break;
                }
            } else if (!usersByNumber.isEmpty()) {
                userByName = (DynamicObject)usersByNumber.get(0);
            }
        }
        if (userByName == null) {
            for (DynamicObject user : userList) {
                if (!user.getString("name").equals(name)) continue;
                userByName = user;
                break;
            }
        }
        return userByName;
    }

    public static Map<String, DynamicObject> getRoleInfoByName(List<String> roleNameList) {
        QFilter qFilter = new QFilter("name", "in", roleNameList);
        DynamicObject[] roleInfo = BusinessDataServiceHelper.load((String)"perm_role", (String)"id,name,phone,number", (QFilter[])new QFilter[]{qFilter});
        return Arrays.stream(roleInfo).collect(Collectors.toMap(dyn -> dyn.getString("name"), dyn -> dyn, (existingValue, newValue) -> existingValue));
    }

    public static DynamicObject getBizPartner(Object partnerId) {
        QFilter qFilter = new QFilter("user.id", "=", partnerId);
        DynamicObject partnerUser = BusinessDataServiceHelper.loadSingle((String)"bos_bizpartneruser", (String)"id,bizpartner", (QFilter[])new QFilter[]{qFilter});
        return partnerUser != null ? partnerUser.getDynamicObject("bizpartner") : null;
    }

    static {
        if (mustFillColumnList == null) {
            mustFillColumnList = new ArrayList<String>();
            mustFillColumnList.add(MEMBER);
            mustFillColumnList.add(STAFF_TYPE_KEY);
        }
    }
}

