/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;

public class ApprovalAmtModifyHelper {
    public static void setFieldMustInputAndDateMask(String splitType, IFormView view) {
        boolean isTotalSplit = SplitTypeEnum.TOTALAMTSPLIT.getValue().equals(splitType);
        BasedataEdit ctrlOutItem = (BasedataEdit)view.getControl("ctrloutitem");
        ctrlOutItem.setMustInput(!isTotalSplit);
        TextEdit ctrloutitemname = (TextEdit)view.getControl("ctrloutitemname");
        ctrloutitemname.setMustInput(!isTotalSplit);
        if (StringUtils.equals((CharSequence)splitType, (CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue())) {
            IClientViewProxy viewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
            viewProxy.invokeControlMethod("controlinfoentry", "setColEditorProp", new Object[]{"undertakeperiod", "mask", "YYYY"});
            view.updateView("controlinfoentry");
        }
    }

    public static void setControlInfoEntry(DynamicObject approval, IDataModel model, IFormView view) {
        DynamicObjectCollection realBudgetEntry;
        String budgetControlMode = approval.getString("budgetcontrolmode");
        if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue())) {
            return;
        }
        String splitType = approval.getString("splittype");
        ApprovalAmtModifyHelper.setFieldMustInputAndDateMask(splitType, view);
        model.deleteEntryData("controlinfoentry");
        model.deleteEntryData("realbudgetentry");
        DynamicObject project = (DynamicObject)model.getValue("project");
        QFilter qFilter = new QFilter("project", "=", project.getPkValue());
        qFilter.and(new QFilter("isvalid", "=", (Object)Boolean.TRUE));
        DynamicObject budgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection realInfoEntry = budgetRecord.getDynamicObjectCollection("realbudgetentry");
        if (realInfoEntry != null && realInfoEntry.size() > 0) {
            DynamicObjectCollection modifyControlInfoEntry = model.getEntryEntity("controlinfoentry");
            int rowIndex = 0;
            BigDecimal sumAmount = BigDecimal.ZERO;
            for (DynamicObject controlInfo : realInfoEntry) {
                DynamicObject modifyControlInfo = new DynamicObject(modifyControlInfoEntry.getDynamicObjectType());
                modifyControlInfo.set("ctrloutitem", controlInfo.get("realbudgetitem"));
                modifyControlInfo.set("ctrloutitemname", controlInfo.get("realprobudgetname"));
                modifyControlInfo.set("undertakeorg", controlInfo.get("realundertakeorg"));
                modifyControlInfo.set("undertakeperiod", controlInfo.get("realundertakeperiod"));
                modifyControlInfo.set("entryproname", controlInfo.get("realproname"));
                BigDecimal underTakeAmt = controlInfo.getBigDecimal("realundertakeamt");
                sumAmount = sumAmount.add(underTakeAmt);
                modifyControlInfo.set("undertakeamt", (Object)underTakeAmt);
                modifyControlInfo.set("afterundertakeamt", (Object)underTakeAmt);
                modifyControlInfo.set("entrypronumber", controlInfo.get("realpronumber"));
                modifyControlInfo.set("entryproid", controlInfo.get("realproid"));
                modifyControlInfo.set("isentryadd", (Object)false);
                modifyControlInfoEntry.add((Object)modifyControlInfo);
                view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"ctrloutitem", "ctrloutitemname", "undertakeorg", "undertakeperiod", "entryproname"});
                ++rowIndex;
            }
            for (DynamicObject modifyControlInfo : modifyControlInfoEntry) {
                BigDecimal underTakeAmt = modifyControlInfo.getBigDecimal("afterundertakeamt");
                if (sumAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                modifyControlInfo.set("undertakeratio", (Object)underTakeAmt.divide(sumAmount, 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)));
            }
            model.updateEntryCache(modifyControlInfoEntry);
            view.updateView("controlinfoentry");
        }
        if ((realBudgetEntry = approval.getDynamicObjectCollection("realbudgetentry")) != null && realBudgetEntry.size() > 0) {
            model.batchCreateNewEntryRow("realbudgetentry", realBudgetEntry.size());
            model.beginInit();
            for (int i = 0; i < realBudgetEntry.size(); ++i) {
                DynamicObject realBudget = (DynamicObject)realBudgetEntry.get(i);
                model.setValue("realbudgetitem", realBudget.get("realbudgetitem"), i);
                model.setValue("realprobudgetname", realBudget.get("realprobudgetname"), i);
                model.setValue("realproid", realBudget.get("realproid"), i);
                model.setValue("realproname", realBudget.get("realproname"), i);
                model.setValue("realpronumber", realBudget.get("realpronumber"), i);
                model.setValue("realundertakeamt", realBudget.get("realundertakeamt"), i);
                model.setValue("realundertakeorg", realBudget.get("realundertakeorg"), i);
                model.setValue("realundertakeperiod", realBudget.get("realundertakeperiod"), i);
                model.setValue("usedamt", realBudget.get("usedamt"), i);
            }
            model.endInit();
            view.updateView("realbudgetentry");
        }
    }
}

