/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.AuditStatusEnum;
import kd.pmgt.pmbs.common.enums.BillTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import org.apache.commons.collections4.CollectionUtils;

public class ProjTeamOpHelper {
    public static void beforeDoSubmitOp(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        String operationKey = e.getOperationKey();
        for (DynamicObject obj : dataEntities = e.getDataEntities()) {
            if (BillTypeEnum.NEW.getValue().equals(obj.getString("type"))) {
                DynamicObjectCollection entries = obj.getDynamicObjectCollection("teamentry");
                if (!entries.isEmpty()) continue;
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s\u3002\u56e2\u961f\u65e0\u6210\u5458\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"ProjTeamOpHelper_0", (String)"pmgt-pmas-business", (Object[])new Object[0]), obj.getString("billno")));
                break;
            }
            if (!BillTypeEnum.ADJUST.getValue().equals(obj.getString("type"))) continue;
            boolean fromDatabase = obj.getDataEntityState().getFromDatabase();
            if (fromDatabase && (Long)obj.getPkValue() != 0L) {
                obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"pmas_teamadjust");
            }
            DynamicObjectCollection chdEntries = obj.getDynamicObjectCollection("chdteamentry");
            DynamicObjectCollection outChdEntries = obj.getDynamicObjectCollection("outchdteamentry");
            DynamicObjectCollection chEntries = obj.getDynamicObjectCollection("chteamentry");
            DynamicObjectCollection outChEntries = obj.getDynamicObjectCollection("chteamouterentry");
            if (chEntries.isEmpty() && outChEntries.isEmpty()) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s\u3002\u201c\u56e2\u961f\u8c03\u6574\u660e\u7ec6\u201d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"ProjTeamOpHelper_1", (String)"pmgt-pmas-business", (Object[])new Object[0]), obj.getString("billno")));
                break;
            }
            if (!chdEntries.isEmpty() || !outChdEntries.isEmpty()) continue;
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s\u3002\u56e2\u961f\u8c03\u6574\u540e\u65e0\u6210\u5458\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"ProjTeamOpHelper_2", (String)"pmgt-pmas-business", (Object[])new Object[0]), obj.getString("billno")));
            break;
        }
    }

    public static void beforeDoUnaudit(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        String operationKey = e.getOperationKey();
        for (DynamicObject obj : dataEntities = e.getDataEntities()) {
            Object projectId = obj.getDynamicObject("project").getPkValue();
            if (BillTypeEnum.NEW.getValue().equals(obj.getString("type"))) {
                QFilter proFilter = new QFilter("project", "=", projectId);
                QFilter typeFilter = new QFilter("type", "=", (Object)BillTypeEnum.ADJUST);
                DynamicObjectCollection query = QueryServiceHelper.query((String)"pmas_teamadjust", (String)"id,billname,billno,billstatus", (QFilter[])new QFilter[]{proFilter, typeFilter});
                if (!query.isEmpty()) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s\u3002\u8c03\u6574\u5355\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProjTeamOpHelper_3", (String)"pmgt-pmas-business", (Object[])new Object[0]), obj.getString("billno")));
                    break;
                }
            } else if (BillTypeEnum.ADJUST.getValue().equals(obj.getString("type"))) {
                obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"pmas_teamadjust");
                DynamicObject proObj = obj.getDynamicObject("project");
                QFilter proFilter = new QFilter("project", "=", proObj.getPkValue());
                QFilter dateFilter = new QFilter("createtime", ">", obj.get("auditdate"));
                DynamicObjectCollection query = QueryServiceHelper.query((String)"pmas_teamadjust", (String)"id,billname,billno,billstatus", (QFilter[])new QFilter[]{proFilter, dateFilter});
                if (!query.isEmpty()) {
                    e.setCancel(true);
                    e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s\u3002\u8c03\u6574\u5355\u5df2\u5b58\u5728\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProjTeamOpHelper_4", (String)"pmgt-pmas-business", (Object[])new Object[0]), obj.getString("billno")));
                    break;
                }
            }
            QFilter filter = new QFilter("project", "=", projectId);
            filter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            filter.and("auditstatus", "=", (Object)AuditStatusEnum.AUDITED.getValue());
            DynamicObjectCollection query1 = QueryServiceHelper.query((String)"pmas_addtmemberbill", (String)"", (QFilter[])new QFilter[]{filter});
            if (query1.isEmpty()) continue;
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s\u3002\u9879\u76ee\u5df2\u5b58\u5728\u5ba1\u6838\u540c\u610f\u7684\u6dfb\u52a0\u56e2\u961f\u6210\u5458\u5355\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002\u8bf7\u76f4\u63a5\u8c03\u6574\u56e2\u961f\u3002", (String)"ProjTeamOpHelper_5", (String)"pmgt-pmas-business", (Object[])new Object[0]), obj.getString("billno")));
            break;
        }
    }

    public static void doBeginUnAudit(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> teamMembers = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> outTeamMembers = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> proApproveList = new ArrayList<DynamicObject>(10);
        for (DynamicObject obj : dataEntities) {
            ArrayList<Object> managerIdList = new ArrayList<Object>();
            DynamicObject project = obj.getDynamicObject("project");
            Object projectId = project.getPkValue();
            if (BillTypeEnum.NEW.getValue().equals(obj.getString("type"))) {
                DeleteServiceHelper.delete((String)"pmas_nowteam", (QFilter[])new QFilter[]{new QFilter("project", "=", projectId)});
                DeleteServiceHelper.delete((String)"pmas_outnowteam", (QFilter[])new QFilter[]{new QFilter("project", "=", projectId)});
            } else if (BillTypeEnum.ADJUST.getValue().equals(obj.getString("type"))) {
                Object member2;
                obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"pmas_teamadjust");
                DeleteServiceHelper.delete((String)"pmas_nowteam", (QFilter[])new QFilter[]{new QFilter("project", "=", projectId)});
                DynamicObjectCollection members = obj.getDynamicObjectCollection("nowteamentry");
                for (Object member2 : members) {
                    DynamicObject nowteam = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_nowteam"));
                    nowteam.set("project", projectId);
                    DynamicObject memberObj = member2.getDynamicObject("member");
                    nowteam.set("member", (Object)memberObj);
                    nowteam.set("role", member2.get("role"));
                    boolean isChargePre = member2.getBoolean("ischargepre");
                    nowteam.set("ischarge", (Object)isChargePre);
                    nowteam.set("telno", member2.get("telno"));
                    nowteam.set("description", member2.get("note"));
                    nowteam.set("org", member2.get("entryorg"));
                    nowteam.set("company", member2.get("entrycompany"));
                    if (isChargePre) {
                        managerIdList.add(memberObj.getPkValue());
                    }
                    teamMembers.add(nowteam);
                }
                DeleteServiceHelper.delete((String)"pmas_outnowteam", (QFilter[])new QFilter[]{new QFilter("project", "=", projectId)});
                DynamicObjectCollection outMembers = obj.getDynamicObjectCollection("outnowteamentry");
                member2 = outMembers.iterator();
                while (member2.hasNext()) {
                    DynamicObject outMember = (DynamicObject)member2.next();
                    DynamicObject outNowteam = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_outnowteam"));
                    outNowteam.set("project", projectId);
                    outNowteam.set("member", outMember.get("outmember"));
                    outNowteam.set("role", outMember.get("outrole"));
                    outNowteam.set("telno", outMember.get("outtelno"));
                    outNowteam.set("description", outMember.get("outnote"));
                    outNowteam.set("outpartner", outMember.get("outpartner"));
                    outNowteam.set("roleobj", outMember.get("outroleobj"));
                    outTeamMembers.add(outNowteam);
                }
            }
            QFilter billFilter = new QFilter("billno", "=", project.get("number"));
            QFilter proFilter = new QFilter("pro", "=", project.getPkValue());
            billFilter.or(proFilter);
            DynamicObject proApprove = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"id, promanager", (QFilter[])new QFilter[]{billFilter});
            if (proApprove == null) continue;
            ProjTeamOpHelper.setProManagerField(proApprove, managerIdList);
            proApproveList.add(proApprove);
        }
        SaveServiceHelper.save((DynamicObject[])proApproveList.toArray(new DynamicObject[proApproveList.size()]));
        if (!CollectionUtils.isEmpty(teamMembers)) {
            SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmas_nowteam"), (Object[])teamMembers.toArray(new DynamicObject[teamMembers.size()]));
        }
        if (!CollectionUtils.isEmpty(outTeamMembers)) {
            SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmas_outnowteam"), (Object[])outTeamMembers.toArray(new DynamicObject[outTeamMembers.size()]));
        }
    }

    public static void setProManagerField(DynamicObject dataEntity, List managerList) {
        MainEntityType mainType = (MainEntityType)dataEntity.getDataEntityType();
        MulBasedataProp mulBasedataProp = (MulBasedataProp)mainType.findProperty("promanager");
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObjectCollection managerCols = (DynamicObjectCollection)mulBasedataProp.getValue((Object)dataEntity);
        managerCols.clear();
        if (managerList != null) {
            for (Object id : managerList) {
                DynamicObject newBasedataObj = BusinessDataServiceHelper.loadSingleFromCache(id, (DynamicObjectType)basedataProp.getDynamicComplexPropertyType());
                DynamicObject newRow = new DynamicObject(subEntityType);
                managerCols.add((Object)newRow);
                basedataProp.setValue((Object)newRow, (Object)newBasedataObj);
            }
        }
    }

    public static void doBeginAudit(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> teamMembers = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> outTeamMembers = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> proApproveList = new ArrayList<DynamicObject>(10);
        for (DynamicObject obj : dataEntities) {
            DynamicObject nowteam;
            Object member2;
            DynamicObjectCollection members;
            ArrayList<Object> managerIdList = new ArrayList<Object>();
            DynamicObject project = obj.getDynamicObject("project");
            Object projectId = project.getPkValue();
            if (BillTypeEnum.NEW.getValue().equals(obj.getString("type"))) {
                members = obj.getDynamicObjectCollection("teamentry");
                for (Object member2 : members) {
                    nowteam = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_nowteam"));
                    nowteam.set("project", projectId);
                    DynamicObject memberObj = member2.getDynamicObject("member");
                    nowteam.set("member", (Object)memberObj);
                    nowteam.set("role", member2.get("role"));
                    nowteam.set("telno", member2.get("telno"));
                    boolean isCharge = member2.getBoolean("ischarge");
                    nowteam.set("ischarge", (Object)isCharge);
                    nowteam.set("description", member2.get("note"));
                    if (isCharge) {
                        managerIdList.add(memberObj.getPkValue());
                    }
                    teamMembers.add(nowteam);
                }
                DynamicObjectCollection outMembers = obj.getDynamicObjectCollection("outerteamentry");
                member2 = outMembers.iterator();
                while (member2.hasNext()) {
                    DynamicObject outMmember = (DynamicObject)member2.next();
                    DynamicObject outNowteam = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_outnowteam"));
                    outNowteam.set("project", projectId);
                    outNowteam.set("member", outMmember.get("outerteamuser"));
                    outNowteam.set("role", outMmember.get("outteamrole"));
                    outNowteam.set("telno", outMmember.get("outerteamtelno"));
                    outNowteam.set("description", outMmember.get("outerteamdescription"));
                    outNowteam.set("outpartner", outMmember.get("outpartner"));
                    outNowteam.set("roleobj", outMmember.get("outroleobj"));
                    outNowteam.set("outbizparter", outMmember.get("outbizpartner"));
                    outTeamMembers.add(outNowteam);
                }
            } else if (BillTypeEnum.ADJUST.getValue().equals(obj.getString("type"))) {
                obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"pmas_teamadjust");
                DeleteServiceHelper.delete((String)"pmas_nowteam", (QFilter[])new QFilter[]{new QFilter("project", "=", projectId)});
                members = obj.getDynamicObjectCollection("chdteamentry");
                for (Object member2 : members) {
                    nowteam = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_nowteam"));
                    nowteam.set("project", projectId);
                    DynamicObject chdMemberObj = member2.getDynamicObject("chdmember");
                    nowteam.set("member", member2.get("chdmember"));
                    nowteam.set("role", member2.get("chdrole"));
                    nowteam.set("telno", member2.get("chdtelno"));
                    boolean ischargechd = member2.getBoolean("ischargechd");
                    nowteam.set("ischarge", (Object)ischargechd);
                    nowteam.set("description", member2.get("chdnote"));
                    if (ischargechd) {
                        managerIdList.add(chdMemberObj.getPkValue());
                    }
                    teamMembers.add(nowteam);
                }
                DeleteServiceHelper.delete((String)"pmas_outnowteam", (QFilter[])new QFilter[]{new QFilter("project", "=", projectId)});
                DynamicObjectCollection outmembers = obj.getDynamicObjectCollection("outchdteamentry");
                member2 = outmembers.iterator();
                while (member2.hasNext()) {
                    DynamicObject outmember = (DynamicObject)member2.next();
                    DynamicObject outnowteam = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_outnowteam"));
                    outnowteam.set("project", projectId);
                    outnowteam.set("member", outmember.get("outchdmember"));
                    outnowteam.set("role", outmember.get("outchdrole"));
                    outnowteam.set("telno", outmember.get("outchdtelno"));
                    outnowteam.set("description", outmember.get("outchdnote"));
                    outnowteam.set("outpartner", outmember.get("outchdpartner"));
                    outnowteam.set("roleobj", outmember.get("outchdroleobj"));
                    outnowteam.set("outbizparter", outmember.get("outchdbizpartner"));
                    outTeamMembers.add(outnowteam);
                }
            }
            QFilter billFilter = new QFilter("billno", "=", project.get("number"));
            QFilter proFilter = new QFilter("pro", "=", project.getPkValue());
            billFilter.or(proFilter);
            DynamicObject proApprove = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (String)"id, promanager", (QFilter[])new QFilter[]{billFilter});
            if (proApprove == null) continue;
            ProjTeamOpHelper.setProManagerField(proApprove, managerIdList);
            proApproveList.add(proApprove);
        }
        SaveServiceHelper.save((DynamicObject[])proApproveList.toArray(new DynamicObject[proApproveList.size()]));
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmas_nowteam"), (Object[])teamMembers.toArray(new DynamicObject[teamMembers.size()]));
        SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmas_outnowteam"), (Object[])outTeamMembers.toArray(new DynamicObject[outTeamMembers.size()]));
    }
}

