/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.business.helper.projadjust;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmas.business.helper.projadjust.GenerateParam;
import kd.pmgt.pmas.business.helper.projadjust.IGenerateTeamAdjust;
import kd.pmgt.pmbs.common.enums.TeamAdjustDescEnum;
import kd.pmgt.pmbs.common.enums.TeamAdjustTypeEnum;
import org.apache.commons.collections4.CollectionUtils;

public class ChLeaderGenerateTeamAdjust
implements IGenerateTeamAdjust {
    @Override
    public void updateChTeamentry(DynamicObject teamAdjustObj, GenerateParam generateParam, TeamAdjustDescEnum descEnum) {
        DynamicObjectCollection chteamentryObjs = teamAdjustObj.getDynamicObjectCollection("chteamentry");
        DynamicObject newChteamEntry = chteamentryObjs.addNew();
        newChteamEntry.set("chmember", (Object)generateParam.getProjLeaderObj());
        newChteamEntry.set("chrole", (Object)ProjectApprovalHelper.getProjLeaderRoleObj());
        newChteamEntry.set("chtelno", (Object)generateParam.getTelNo());
        newChteamEntry.set("chnote", (Object)TeamAdjustDescEnum.CHANGE_LEADER.getDesc());
        newChteamEntry.set("ischargech", (Object)Boolean.TRUE);
        newChteamEntry.set("changetype", (Object)TeamAdjustTypeEnum.IN);
        if (generateParam.getOriProjLeaderObj() != null) {
            DynamicObject delChteamEntry = chteamentryObjs.addNew();
            delChteamEntry.set("chmember", (Object)generateParam.getOriProjLeaderObj());
            delChteamEntry.set("chrole", (Object)ProjectApprovalHelper.getProjLeaderRoleObj());
            delChteamEntry.set("chtelno", (Object)generateParam.getOriTelNo());
            delChteamEntry.set("chnote", (Object)TeamAdjustDescEnum.CHANGE_LEADER.getDesc());
            delChteamEntry.set("ischargech", (Object)Boolean.TRUE);
            delChteamEntry.set("changetype", (Object)TeamAdjustTypeEnum.OUT);
            teamAdjustObj.set("chteamentry", (Object)chteamentryObjs);
        }
    }

    @Override
    public void updateChdTeamEntry(DynamicObject teamAdjustObj) {
        DynamicObject addNewObj;
        DynamicObjectCollection chdteamentryObjs = teamAdjustObj.getDynamicObjectCollection("chdteamentry");
        DynamicObjectCollection nowMembers = teamAdjustObj.getDynamicObjectCollection("nowteamentry");
        DynamicObjectCollection chteamentryObjs = teamAdjustObj.getDynamicObjectCollection("chteamentry");
        for (DynamicObject nowMember : nowMembers) {
            DynamicObject adjustObj = ChLeaderGenerateTeamAdjust.getAdjustObj(chteamentryObjs, nowMember);
            if (adjustObj == null) {
                addNewObj = new DynamicObject(chdteamentryObjs.getDynamicObjectType());
                addNewObj.set("chdmember", nowMember.get("member"));
                addNewObj.set("chdrole", nowMember.get("role"));
                addNewObj.set("chdtelno", (Object)nowMember.getString("telno"));
                addNewObj.set("chdnote", nowMember.get("note"));
                addNewObj.set("ischargechd", nowMember.get("ischargepre"));
                chdteamentryObjs.add((Object)addNewObj);
                continue;
            }
            String changeType = adjustObj.getString("changetype");
            if (TeamAdjustTypeEnum.OUT.getValue().equals(changeType) || !TeamAdjustTypeEnum.IN.getValue().equals(changeType)) continue;
            DynamicObject addNewObj2 = new DynamicObject(chdteamentryObjs.getDynamicObjectType());
            addNewObj2.set("chdmember", adjustObj.get("chmember"));
            addNewObj2.set("chdrole", adjustObj.get("chrole"));
            addNewObj2.set("chdtelno", (Object)adjustObj.getString("chtelno"));
            addNewObj2.set("chdnote", adjustObj.get("chnote"));
            addNewObj2.set("ischargechd", adjustObj.get("ischargech"));
            chdteamentryObjs.add((Object)addNewObj2);
        }
        for (DynamicObject chObj : chteamentryObjs) {
            String changeType = chObj.getString("changetype");
            if (!TeamAdjustTypeEnum.IN.getValue().equals(changeType)) continue;
            addNewObj = new DynamicObject(chdteamentryObjs.getDynamicObjectType());
            addNewObj.set("chdmember", chObj.get("chmember"));
            addNewObj.set("chdrole", chObj.get("chrole"));
            addNewObj.set("chdtelno", (Object)chObj.getString("chtelno"));
            addNewObj.set("chdnote", chObj.get("chnote"));
            addNewObj.set("ischargechd", chObj.get("ischargech"));
            chdteamentryObjs.add((Object)addNewObj);
        }
        teamAdjustObj.set("chdteamentry", (Object)chdteamentryObjs);
    }

    private static DynamicObject getAdjustObj(DynamicObjectCollection chteamentryObjs, DynamicObject nowTeamMember) {
        if (CollectionUtils.isEmpty((Collection)chteamentryObjs)) {
            return null;
        }
        List adjustList = chteamentryObjs.stream().filter(chObj -> {
            DynamicObject chMemberObj = chObj.getDynamicObject("chmember");
            DynamicObject nowMemberObj = nowTeamMember.getDynamicObject("member");
            DynamicObject chMemberRole = chObj.getDynamicObject("chrole");
            DynamicObject nowMemberRole = nowTeamMember.getDynamicObject("role");
            String changeType = chObj.getString("changetype");
            return chMemberObj != null && nowMemberObj != null && chMemberObj.getPkValue().equals(nowMemberObj.getPkValue()) && chMemberRole != null && nowMemberRole != null && chMemberRole.getPkValue().equals(nowMemberRole.getPkValue()) && !TeamAdjustTypeEnum.IN.getValue().equals(changeType);
        }).collect(Collectors.toList());
        return CollectionUtils.isEmpty(adjustList) ? null : (DynamicObject)adjustList.get(0);
    }
}

