/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.business.helper.projadjust;

import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmas.business.helper.projadjust.GenerateParam;
import kd.pmgt.pmbs.common.enums.BillTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TeamAdjustDescEnum;

public interface IGenerateTeamAdjust {
    default public OperationResult generateTeamAdjust(GenerateParam generateParam, TeamAdjustDescEnum descEnum) {
        DynamicObject teamAdjustObj = this.createTeamAdjust(generateParam.getProjectObj(), descEnum);
        this.updateNowTeamEntry(teamAdjustObj, generateParam.getPreNowTeamMenbers());
        this.updateOutNowEntry(teamAdjustObj, generateParam.getPreOutNowTeamMenbers());
        this.updateChTeamentry(teamAdjustObj, generateParam, descEnum);
        this.updateOutChTeamentry(teamAdjustObj, generateParam, descEnum);
        this.updateChdTeamEntry(teamAdjustObj);
        this.updateOutChdTeamEntry(teamAdjustObj);
        OperationResult generateResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmas_teamadjust", (DynamicObject[])new DynamicObject[]{teamAdjustObj}, (OperateOption)OperateOption.create());
        return generateResult;
    }

    default public DynamicObject createTeamAdjust(DynamicObject projectObj, TeamAdjustDescEnum descEnum) {
        DynamicObject teamAdjustObj = BusinessDataServiceHelper.newDynamicObject((String)"pmas_teamadjust");
        teamAdjustObj.set("project", (Object)projectObj);
        teamAdjustObj.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        teamAdjustObj.set("type", (Object)BillTypeEnum.ADJUST);
        DynamicObject nowTeamObj = ProjectApprovalHelper.getNowTeamObj(projectObj.getPkValue());
        if (nowTeamObj != null) {
            teamAdjustObj.set("proleader", (Object)nowTeamObj.getDynamicObject("member"));
            teamAdjustObj.set("leaderconttype", nowTeamObj.get("telno"));
        }
        projectObj = BusinessDataServiceHelper.loadSingleFromCache((Object)projectObj.getPkValue(), (String)"bd_project");
        teamAdjustObj.set("org", (Object)projectObj.getDynamicObject("pmascreateorg"));
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"pmas_teamadjust", (DynamicObject)teamAdjustObj, (String)String.valueOf(RequestContext.get().getOrgId()));
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)teamAdjustObj);
        teamAdjustObj.set("billno", (Object)number);
        if (descEnum != null) {
            teamAdjustObj.set("description", (Object)descEnum.getDesc());
        }
        teamAdjustObj.set("creator", (Object)RequestContext.get().getCurrUserId());
        teamAdjustObj.set("createtime", (Object)TimeServiceHelper.now());
        teamAdjustObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        teamAdjustObj.set("modifytime", (Object)TimeServiceHelper.now());
        teamAdjustObj.set("auditor", (Object)RequestContext.get().getCurrUserId());
        teamAdjustObj.set("auditdate", (Object)TimeServiceHelper.now());
        long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)RequestContext.get().getCurrUserId());
        if (userMainOrgId != 0L) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)userMainOrgId, (String)"bos_org");
            teamAdjustObj.set("createorg", (Object)org);
        }
        return teamAdjustObj;
    }

    default public void updateNowTeamEntry(DynamicObject teamAdjustObj, DynamicObject[] preNowTeamMenbers) {
        if (preNowTeamMenbers == null || preNowTeamMenbers.length == 0) {
            return;
        }
        DynamicObjectCollection nowTeamEntry = teamAdjustObj.getDynamicObjectCollection("nowteamentry");
        for (DynamicObject nowteam : preNowTeamMenbers) {
            DynamicObject addNewObj = nowTeamEntry.addNew();
            addNewObj.set("member", nowteam.get("member"));
            addNewObj.set("role", nowteam.get("role"));
            addNewObj.set("telno", nowteam.get("telno"));
            addNewObj.set("note", nowteam.get("description"));
            addNewObj.set("ischargepre", nowteam.get("ischarge"));
        }
        teamAdjustObj.set("nowteamentry", (Object)nowTeamEntry);
    }

    default public void updateOutNowEntry(DynamicObject teamAdjustObj, DynamicObject[] preOutNowTeamMenbers) {
        if (preOutNowTeamMenbers == null || preOutNowTeamMenbers.length == 0) {
            return;
        }
        DynamicObjectCollection nowteamentryObjs = teamAdjustObj.getDynamicObjectCollection("outnowteamentry");
        for (DynamicObject preOutNowMember : preOutNowTeamMenbers) {
            DynamicObject newNowteamEntry = nowteamentryObjs.addNew();
            newNowteamEntry.set("outmember", preOutNowMember.get("member"));
            newNowteamEntry.set("outrole", preOutNowMember.get("role"));
            newNowteamEntry.set("outtelno", preOutNowMember.get("telno"));
            newNowteamEntry.set("outnote", preOutNowMember.get("description"));
            newNowteamEntry.set("outpartner", preOutNowMember.get("outpartner"));
            newNowteamEntry.set("outbizpartner", preOutNowMember.get("outbizparter"));
            newNowteamEntry.set("outroleobj", preOutNowMember.get("roleobj"));
        }
        teamAdjustObj.set("outnowteamentry", (Object)nowteamentryObjs);
    }

    default public void updateChTeamentry(DynamicObject dbTeamAdjust, GenerateParam generateParam, TeamAdjustDescEnum descEnum) {
    }

    default public void updateOutChTeamentry(DynamicObject teamAdjustObj, GenerateParam generateParam, TeamAdjustDescEnum descEnum) {
    }

    default public void updateChdTeamEntry(DynamicObject teamAdjustObj) {
        DynamicObjectCollection nowTeamEntrys = teamAdjustObj.getDynamicObjectCollection("nowteamentry");
        DynamicObjectCollection chdTeamEntrys = teamAdjustObj.getDynamicObjectCollection("chdteamentry");
        for (DynamicObject nowteam : nowTeamEntrys) {
            DynamicObject addChdNewObj = chdTeamEntrys.addNew();
            addChdNewObj.set("chdmember", nowteam.get("member"));
            addChdNewObj.set("chdrole", nowteam.get("role"));
            addChdNewObj.set("chdtelno", nowteam.get("telno"));
            addChdNewObj.set("chdnote", nowteam.get("note"));
            addChdNewObj.set("ischargechd", nowteam.get("ischargepre"));
        }
        teamAdjustObj.set("chdteamentry", (Object)chdTeamEntrys);
    }

    default public void updateOutChdTeamEntry(DynamicObject teamAdjustObj) {
        DynamicObjectCollection outNowTeamEntrys = teamAdjustObj.getDynamicObjectCollection("outnowteamentry");
        DynamicObjectCollection outChdTeamEntrys = teamAdjustObj.getDynamicObjectCollection("outchdteamentry");
        for (DynamicObject outNowteam : outNowTeamEntrys) {
            DynamicObject addOutChdNewObj = outChdTeamEntrys.addNew();
            addOutChdNewObj.set("outchdmember", outNowteam.get("outmember"));
            addOutChdNewObj.set("outchdrole", outNowteam.get("outrole"));
            addOutChdNewObj.set("outchdtelno", outNowteam.get("outtelno"));
            addOutChdNewObj.set("outchdnote", outNowteam.get("outnote"));
            addOutChdNewObj.set("outchdpartner", outNowteam.get("outpartner"));
            addOutChdNewObj.set("outchdbizpartner", outNowteam.get("outbizpartner"));
            addOutChdNewObj.set("outchdroleobj", outNowteam.get("outroleobj"));
        }
        teamAdjustObj.set("outchdteamentry", (Object)outChdTeamEntrys);
    }
}

