/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.project;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pmgt.pmas.business.helper.ApproveContext;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmas.business.helper.ProjectAuditHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetCtrlEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.approval.ApprovalStatusEnum;
import kd.pmgt.pmbs.servicehelper.BudgetCtrlHelper;

public class ProAppAuditOp
extends AbstractOperationServicePlugIn {
    private static final String REPORT = "report";
    private static final String FAIL = "fail";
    private static final String NO_PASS = "nopass";
    private static final String APP_AUDIT_BILLNO_SDF = "MMddHHmmss";
    private static final String APP_AUDIT_BILLNAME_SDF = "MMdd";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("proapp");
        e.getFieldKeys().add("reportstatus");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("lastauditid");
        e.getFieldKeys().add("isreport");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String key = this.getOperateKey();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                switch (key) {
                    case "unaudit": {
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            this.validateAudit(dataEntity);
                        }
                        break;
                    }
                }
            }

            private void validateAudit(ExtendedDataEntity dataEntity) {
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                if (!StringUtils.isEmpty((CharSequence)dynamicObject.getString("reportstatus"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6709\u5173\u8054\u7684\u4e0a\u7ea7\u5ba1\u6279\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ProAppAuditOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.equals((CharSequence)dynamicObject.getString("billstatus"), (CharSequence)StatusEnum.CHECKED.getValue())) {
                    List enabledProcessInfoList = WorkflowServiceHelper.getEnabledProcesses((DynamicObject)dynamicObject, null);
                    if (enabledProcessInfoList != null && enabledProcessInfoList.size() > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ProAppAuditOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    }
                    DynamicObject proApp = dynamicObject.getDynamicObject("proapp");
                    if (StringUtils.equals((CharSequence)(proApp = BusinessDataServiceHelper.loadSingle((Object)proApp.getPkValue(), (String)"pmas_pro_approval")).getString("approvalstatus"), (CharSequence)ApprovalStatusEnum.FAIL.getValue())) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5ba1\u6279\u7ed3\u8bba\u4e3a\u201c\u9a73\u56de\u201d\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ProAppAuditOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.equals((CharSequence)proApp.getString("approvalstatus"), (CharSequence)ApprovalStatusEnum.NO_PASS.getValue())) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5ba1\u6279\u7ed3\u8bba\u4e3a\u201c\u4e0d\u901a\u8fc7\u201d\u7684\u5355\u636e\uff0c\u4e0d\u53ef\u53cd\u5ba1\u6838\u3002", (String)"ProAppAuditOp_3", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.equals((CharSequence)proApp.getString("approvalstatus"), (CharSequence)ApprovalStatusEnum.ONGOING.getValue())) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5ba1\u6279\u7ed3\u8bba\u4e3a\u201c\u5ba1\u6279\u4e2d\u201d\u7684\u5355\u636e\uff0c\u4e0d\u53ef\u53cd\u5ba1\u6838\u3002", (String)"ProAppAuditOp_4", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                for (DynamicObject dynamicObject : dataEntities) {
                    this.beforeAudit(dynamicObject);
                }
                break;
            }
            case "unaudit": {
                for (DynamicObject dynamicObject : dataEntities) {
                    this.beforeUnAudit(dynamicObject);
                }
                break;
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        DynamicObject[] dynamicObjects = e.getDataEntities();
        switch (operateKey) {
            case "audit": {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    this.beginAudit(dynamicObject);
                }
                break;
            }
            case "unaudit": {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    this.beginUnAudit(dynamicObject);
                }
                break;
            }
            case "report": {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    this.beginReport(dynamicObject);
                }
                break;
            }
            case "fail": {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    this.beginFail(dynamicObject, ApprovalStatusEnum.FAIL.getValue());
                }
                break;
            }
            case "nopass": {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    this.beginFail(dynamicObject, ApprovalStatusEnum.NO_PASS.getValue());
                }
                break;
            }
        }
    }

    private void beforeAudit(DynamicObject dynamicObject) {
        if (!dynamicObject.getBoolean("isreport")) {
            DynamicObject proApp = dynamicObject.getDynamicObject("proapp");
            proApp = BusinessDataServiceHelper.loadSingle((Object)proApp.getPkValue(), (String)"pmas_pro_approval");
            DynamicObject proStatus = BusinessDataServiceHelper.loadSingle((Object)ProjectStatusEnum.APPROVAL_IN.getId(), (String)"bd_projectstatus");
            proApp.set("prostatus", (Object)proStatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proApp});
        }
    }

    private void beforeUnAudit(DynamicObject dynamicObject) {
        DynamicObject proApp = dynamicObject.getDynamicObject("proapp");
        proApp = BusinessDataServiceHelper.loadSingle((Object)proApp.getPkValue(), (String)"pmas_pro_approval");
        DynamicObject pro = proApp.getDynamicObject("pro");
        ProjectApprovalHelper.checkOccurUnSysBiz((DynamicObject)pro);
        ProjectApprovalHelper.deleteRelateBizExclude((DynamicObject)proApp, (DynamicObject)pro);
        proApp = BusinessDataServiceHelper.loadSingle((Object)proApp.getPkValue(), (String)"pmas_pro_approval");
        DeleteServiceHelper.delete((String)"pmas_prostatus", (QFilter[])new QFilter[]{new QFilter("proapproval", "=", proApp.getPkValue())});
        if (StringUtils.equals((CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue(), (CharSequence)proApp.getString("budgetcontrolmode"))) {
            try {
                BudgetCtrlHelper.invokeAdjustInterface((DynamicObject)proApp, (BudgetCtrlEnum)BudgetCtrlEnum.UNAUDIT);
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getMessage());
            }
            ProjectApprovalHelper.occupyAmount((DynamicObject)proApp, (String)"unaudit");
        }
        ProjectApprovalHelper.updateBudgetRecordField(null, (DynamicObject)proApp, (String)"submit");
    }

    private void beginAudit(DynamicObject dynamicObject) {
        if (!dynamicObject.getBoolean("isreport")) {
            DynamicObject proApp = dynamicObject.getDynamicObject("proapp");
            proApp = BusinessDataServiceHelper.loadSingle((Object)proApp.getPkValue(), (String)"pmas_pro_approval");
            ApproveContext context = new ApproveContext();
            context.setApprovePro(proApp);
            context.setSysPro(proApp.getDynamicObject("pro"));
            ProjectApprovalHelper.syncProjectProposalAndBudgetDataBase((DynamicObject)proApp);
            ProjectApprovalHelper.synProjLeader((DynamicObject)context.getApprovePro());
            ProjectApprovalHelper.updateDownFlowBill((ApproveContext)context);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{context.getApprovePro()});
            DynamicObject pro = proApp.getDynamicObject("pro");
            if (pro != null) {
                DynamicObject proStatus = BusinessDataServiceHelper.loadSingle((Object)ProjectStatusEnum.APPROVAL_IN.getId(), (String)"bd_projectstatus");
                pro = BusinessDataServiceHelper.loadSingle((Object)pro.getPkValue(), (String)"bd_project");
                pro.set("prostatus", (Object)proStatus);
                try (TXHandle h = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pro});
                    }
                    catch (Exception exception) {
                        h.markRollback();
                        throw exception;
                    }
                }
            }
            ProjectAuditHelper.setProAppApprovalStatus((DynamicObject)dynamicObject, (String)ApprovalStatusEnum.PASS.getValue());
        }
        ProjectAuditHelper.setLastProAppReportStatus((DynamicObject)dynamicObject, (String)ApprovalStatusEnum.PASS.getValue());
    }

    private void beginUnAudit(DynamicObject dynamicObject) {
        DynamicObject proApp = dynamicObject.getDynamicObject("proapp");
        proApp = BusinessDataServiceHelper.loadSingle((Object)proApp.getPkValue(), (String)"pmas_pro_approval");
        ProjectApprovalHelper.deleteProjectProposalAndBudgetDataBase((DynamicObject)proApp);
        ProjectAuditHelper.setLastProAppReportStatus((DynamicObject)dynamicObject, (String)ApprovalStatusEnum.ONGOING.getValue());
        ProjectAuditHelper.setProAppApprovalStatus((DynamicObject)dynamicObject, (String)ApprovalStatusEnum.ONGOING.getValue());
        DynamicObject pro = proApp.getDynamicObject("pro");
        if (pro != null) {
            DynamicObject proStatus = BusinessDataServiceHelper.loadSingle((Object)ProjectStatusEnum.SUSPEND.getId(), (String)"bd_projectstatus");
            pro = BusinessDataServiceHelper.loadSingle((Object)pro.getPkValue(), (String)"bd_project");
            pro.set("prostatus", (Object)proStatus);
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{pro});
                }
                catch (Exception exception) {
                    h.markRollback();
                    throw exception;
                }
            }
        }
    }

    private void beginReport(DynamicObject dynamicObject) {
        DynamicObject proAppAudit = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_pro_app_audit"));
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"pmas_pro_app_audit", (DynamicObject)proAppAudit, (String)String.valueOf(RequestContext.get().getOrgId()));
        Date now = new Date();
        DynamicObject proApp = dynamicObject.getDynamicObject("proapp");
        proApp = BusinessDataServiceHelper.loadSingle((Object)proApp.getPkValue(), (String)"pmas_pro_approval");
        if (null != codeRuleInfo) {
            proAppAudit.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)proAppAudit));
        } else {
            SimpleDateFormat billNoSdf = new SimpleDateFormat(APP_AUDIT_BILLNO_SDF);
            proAppAudit.set("billno", (Object)String.join((CharSequence)"LXHZ", proApp.getString("billno"), billNoSdf.format(now)));
        }
        SimpleDateFormat billNameSdf = new SimpleDateFormat(APP_AUDIT_BILLNAME_SDF);
        proAppAudit.set("billname", (Object)String.format(ResManager.loadKDString((String)"%1$s\u7684\u6838\u51c6\u5ba1\u6279%2$s", (String)"ProAppAuditOp_5", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), proApp.getLocaleString("billname").getLocaleValue(), billNameSdf.format(now)));
        proAppAudit.set("org", (Object)dynamicObject.getDynamicObject("reportorg"));
        proAppAudit.set("lastreportorg", (Object)dynamicObject.getDynamicObject("org"));
        proAppAudit.set("lastauditid", dynamicObject.getPkValue());
        proAppAudit.set("proapp", (Object)proApp);
        proAppAudit.set("creator", (Object)RequestContext.get().getCurrUserId());
        proAppAudit.set("modifier", (Object)RequestContext.get().getCurrUserId());
        proAppAudit.set("createtime", (Object)now);
        proAppAudit.set("modifytime", (Object)now);
        proAppAudit.set("billstatus", (Object)"A");
        proAppAudit.set("createorg", (Object)dynamicObject.getDynamicObject("createorg"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proAppAudit});
        proAppAudit = BusinessDataServiceHelper.loadSingle((Object)proAppAudit.getPkValue(), (String)"pmas_pro_app_audit");
        List enabledProcessInfoList = WorkflowServiceHelper.getEnabledProcesses((DynamicObject)proAppAudit, (String)"submit");
        if (enabledProcessInfoList != null && enabledProcessInfoList.size() > 0) {
            OperationServiceHelper.executeOperate((String)"submit", (String)"pmas_pro_app_audit", (DynamicObject[])new DynamicObject[]{proAppAudit}, (OperateOption)OperateOption.create());
        }
        dynamicObject.set("reportstatus", (Object)ApprovalStatusEnum.ONGOING.getValue());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void beginFail(DynamicObject dynamicObject, String approvalStatus) {
        ProjectAuditHelper.setLastProAppReportStatus((DynamicObject)dynamicObject, (String)approvalStatus);
        ProjectAuditHelper.setProAppApprovalStatus((DynamicObject)dynamicObject, (String)approvalStatus);
        DynamicObject proApp = dynamicObject.getDynamicObject("proapp");
        if (proApp != null) {
            proApp = BusinessDataServiceHelper.loadSingle((Object)proApp.getPkValue(), (String)"pmas_pro_approval");
            ProjectApprovalHelper.returnOccupyAmtAndClearRecord((DynamicObject)proApp, (String)"audit", (String)"unsubmitoccupy");
            ProjectApprovalHelper.updateBudgetRecordField(null, (DynamicObject)proApp, (String)"auditrefuse");
        }
        dynamicObject.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        dynamicObject.set("auditor", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("auditdate", (Object)new Date());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
    }
}

