/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.project;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmas.opplugin.base.AbstractPmasValidator;
import kd.pmgt.pmbs.common.enums.InvestBudgetEnum;

public class ProApprovalApplyOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        MainEntityType dataEntityType = this.billEntityType;
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)property;
                DynamicObjectType entryType = entryProp.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProps = entryType.getProperties();
                for (IDataEntityProperty prop : entryProps) {
                    e.getFieldKeys().add(prop.getName());
                }
                continue;
            }
            e.getFieldKeys().add(property.getName());
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        boolean isAddValid = false;
        for (AbstractValidator val : validators) {
            String key = val.getOperateKey();
            if (!"submit".equals(key) && !"unaudit".equals(key)) continue;
            isAddValid = true;
            break;
        }
        if (isAddValid) {
            e.addValidator((AbstractValidator)new AbstractPmasValidator(){

                public void validate() {
                    for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                        ProApprovalApplyOp.this.checkValidator(this, dataEntity);
                    }
                }
            });
        }
    }

    protected void checkValidator(AbstractPmasValidator abstractValidator, ExtendedDataEntity dataEntity) {
        String key = abstractValidator.getOperateKey();
        DynamicObject entity = dataEntity.getDataEntity();
        switch (key) {
            case "submit": {
                this.submitValidator(abstractValidator, dataEntity);
                break;
            }
            case "unaudit": {
                boolean selfResearch;
                boolean studyApply;
                boolean isApproval = QueryServiceHelper.exists((String)"pmas_pro_approval", (QFilter[])new QFilter[]{new QFilter("approvalapply", "=", entity.getPkValue())});
                if (isApproval) {
                    abstractValidator.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9879\u76ee\u7acb\u9879\u5355\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProApprovalApplyOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), dataEntity.getBillNo()));
                }
                if (studyApply = QueryServiceHelper.exists((String)"pmfs_projectreport", (QFilter[])new QFilter[]{new QFilter("project", "=", entity.getPkValue())})) {
                    abstractValidator.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9879\u76ee\u53ef\u7814\u7533\u62a5\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProApprovalApplyOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), dataEntity.getBillNo()));
                }
                if (!(selfResearch = QueryServiceHelper.exists((String)"pmfs_selfresearch", (QFilter[])new QFilter[]{new QFilter("project", "=", entity.getPkValue())}))) break;
                abstractValidator.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9879\u76ee\u81ea\u7814\u8bf7\u793a\u5f15\u7528\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ProApprovalApplyOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), dataEntity.getBillNo()));
                break;
            }
        }
    }

    protected void submitValidator(AbstractPmasValidator abstractValidator, ExtendedDataEntity dataEntity) {
        DynamicObject group;
        String controlAmt;
        DynamicObject entity = dataEntity.getDataEntity();
        BigDecimal totalAmount = entity.getBigDecimal("totalamount");
        BigDecimal annualAmount = entity.getBigDecimal("annualamount");
        if (annualAmount.compareTo(totalAmount) > 0) {
            abstractValidator.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u7684\u9879\u76ee\u7acb\u9879\u7533\u8bf7\u4e2d\uff0c\u5e74\u5ea6\u91d1\u989d\u4e0d\u5f97\u8d85\u8fc7\u9879\u76ee\u7acb\u9879\u7533\u8bf7\u603b\u91d1\u989d\u3002", (String)"ProApprovalApplyOp_3", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), dataEntity.getBillNo()));
        }
        if (StringUtils.equals((CharSequence)(controlAmt = this.getSettingControlAmt((group = entity.getDynamicObject("group")).getPkValue())), (CharSequence)InvestBudgetEnum.STRICT_CONTROL.getValue()) || StringUtils.equals((CharSequence)controlAmt, (CharSequence)InvestBudgetEnum.REMINDER_CONTROL.getValue())) {
            this.amountTips(dataEntity, abstractValidator, controlAmt);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operateKey;
        switch (operateKey = e.getOperationKey()) {
            default: 
        }
    }

    public void amountTips(ExtendedDataEntity dataEntity, AbstractPmasValidator AbstractPmasValidator2, String controlAmt) {
        DynamicObject object = dataEntity.getDataEntity();
        DynamicObject proposal = object.getDynamicObject("proproposal");
        boolean isConfirm = false;
        if (proposal != null) {
            proposal = BusinessDataServiceHelper.loadSingle((Object)proposal.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmim_projectproposal"));
            BigDecimal totalAmount = object.getBigDecimal("totalamount");
            BigDecimal annualAmount = object.getBigDecimal("annualamount");
            BigDecimal proposalAmount = proposal.getBigDecimal("proinvestbudappamt");
            BigDecimal proposalYearAmount = proposal.getBigDecimal("yearbugapprovalamt");
            DynamicObject group = object.getDynamicObject("group");
            if (group != null) {
                String tips;
                if (controlAmt == null) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (totalAmount.compareTo(proposalAmount) > 0) {
                    tips = StringUtils.equals((CharSequence)controlAmt, (CharSequence)InvestBudgetEnum.REMINDER_CONTROL.getValue()) ? ResManager.loadKDString((String)"\u201c\u9879\u76ee\u7acb\u9879\u7533\u8bf7\u603b\u91d1\u989d\u201d\u8d85\u8fc7\u9879\u76ee\u5efa\u8bae\u4e66\u7684\u201c\u9879\u76ee\u6295\u8d44\u9884\u7b97\u6279\u590d\u603b\u989d\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProApprovalApplyOp_4", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u9879\u76ee\u7acb\u9879\u7533\u8bf7\u603b\u91d1\u989d\u201d\u8d85\u8fc7\u9879\u76ee\u5efa\u8bae\u4e66\u4e2d\u7684\u201c\u9879\u76ee\u6295\u8d44\u9884\u7b97\u6279\u590d\u603b\u989d\u201d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"ProApprovalApplyOp_5", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]);
                    stringBuilder.append(tips);
                    isConfirm = true;
                }
                if (annualAmount.compareTo(proposalYearAmount) > 0) {
                    String string = tips = StringUtils.equals((CharSequence)controlAmt, (CharSequence)InvestBudgetEnum.REMINDER_CONTROL.getValue()) ? ResManager.loadKDString((String)"\u201c\u9879\u76ee\u7acb\u9879\u7533\u8bf7\u603b\u91d1\u989d\u201d\u8d85\u8fc7\u9879\u76ee\u5efa\u8bae\u4e66\u4e2d\u7684\u201c\u9879\u76ee\u6295\u8d44\u9884\u7b97\u6279\u590d\u603b\u989d\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProApprovalApplyOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u9879\u76ee\u7acb\u9879\u7533\u8bf7\u5e74\u5ea6\u91d1\u989d\u201d\u8d85\u8fc7\u9879\u76ee\u5efa\u8bae\u4e66\u7684\u201c\u5e74\u5ea6\u6295\u8d44\u9884\u7b97\u6279\u590d\u603b\u989d\u201d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"ProApprovalApplyOp_7", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(tips);
                    isConfirm = true;
                }
                if (stringBuilder.length() > 0) {
                    if (isConfirm && StringUtils.equals((CharSequence)controlAmt, (CharSequence)InvestBudgetEnum.REMINDER_CONTROL.getValue())) {
                        AbstractPmasValidator2.addWarningMessage(dataEntity, stringBuilder.toString());
                    } else {
                        AbstractPmasValidator2.addErrorMessage(dataEntity, stringBuilder.toString());
                    }
                }
            }
        }
    }

    public String getSettingControlAmt(Object groupId) {
        DynamicObject projectKindSetting;
        QFilter proKindFilter = new QFilter("projectkind", "=", groupId);
        DynamicObject setting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)"id", (QFilter[])new QFilter[]{proKindFilter});
        if (setting != null && (projectKindSetting = BusinessDataServiceHelper.loadSingle((Object)setting.getPkValue(), (String)"pmbs_prokindctrlsetting", (String)"proposalctrlapplyamt")) != null) {
            return projectKindSetting.getString("proposalctrlapplyamt");
        }
        return null;
    }
}

