/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.project;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ProjectApprovalNumberOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String OPERATION_APPROVAL_SUBMIT = "approvalsubmit";
    private static final String OPERATION_REPORT_SUBMIT = "reportsubmit";

    public void onAddValidators(AddValidatorsEventArgs e) {
        List validators = e.getValidators();
        boolean isAddValid = false;
        for (AbstractValidator val : validators) {
            String key = val.getOperateKey();
            if (!"submit".equals(key) && !OPERATION_APPROVAL_SUBMIT.equals(key) && !OPERATION_REPORT_SUBMIT.equals(key)) continue;
            isAddValid = true;
            break;
        }
        if (isAddValid) {
            e.getValidators().add(new AbstractValidator(){

                public void validate() {
                    String operateKey = this.getOperateKey();
                    ExtendedDataEntity[] dataEntities = this.getDataEntities();
                    switch (operateKey) {
                        case "submit": 
                        case "approvalsubmit": 
                        case "reportsubmit": {
                            for (ExtendedDataEntity dataEntity : dataEntities) {
                                DynamicObject[] projectObjs;
                                DynamicObject project = (DynamicObject)dataEntity.getValue("pro");
                                if (project != null) continue;
                                String billNo = (String)dataEntity.getValue("billno");
                                DynamicObject parentPro = (DynamicObject)dataEntity.getValue("parentpro");
                                QFilter parentFilter = new QFilter("parent", "=", (Object)0);
                                QFilter numberFilter = new QFilter("number", "=", (Object)billNo);
                                if (parentPro != null) {
                                    parentFilter = new QFilter("parent", "=", parentPro.getPkValue());
                                }
                                if ((projectObjs = BusinessDataServiceHelper.load((String)"bd_project", (String)"", (QFilter[])new QFilter[]{numberFilter, parentFilter})).length <= 0) {
                                    return;
                                }
                                if (parentPro == null) {
                                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u9879\u76ee\u4e3b\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u7acb\u9879\u7f16\u53f7\u3002", (String)"ProjectApprovalNumberOpPlugin_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                                    continue;
                                }
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u7acb\u9879\u7f16\u53f7\uff0c\u56e0\u4e3a\u4e0a\u7ea7\u9879\u76ee\u4e3b\u6570\u636e\u201c%s\u201d\u4e0b\u5df2\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u9879\u76ee\u3002", (String)"ProjectApprovalNumberOpPlugin_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), parentPro.getString("name")));
                            }
                            break;
                        }
                    }
                }
            });
        }
    }
}

