/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.project;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.approval.ReportStatusEnum;

public class ProjectApproveReportOp
extends AbstractOperationServicePlugIn {
    protected static final String REPORT = "report";
    protected static final String REPORT_SUBMIT = "reportsubmit";
    protected static final String ISREPORT = "isreport";
    private static final String BOS_ATTACHMENT_FINTERID = "finterid";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("repaudstatus");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("prostatus");
        e.getFieldKeys().add("isrejectmodifystatus");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("kind");
        e.getFieldKeys().add("reportorg");
        e.getFieldKeys().add("attachtypeentry");
        e.getFieldKeys().add("attachtype");
        e.getFieldKeys().add("upfile");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String key = this.getOperateKey();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                switch (key) {
                    case "report": {
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            DynamicObject projectObj = dataEntity.getDataEntity();
                            String repaudStatus = projectObj.getString("repaudstatus");
                            if (!"C".equals(projectObj.getString("billstatus"))) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5ba1\u6838\uff0c\u518d\u4e0a\u62a5\u3002", (String)"ProjectApproveReportOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            if (StringUtils.isNotEmpty((CharSequence)repaudStatus) && !StringUtils.equals((CharSequence)repaudStatus, (CharSequence)ReportStatusEnum.REJECT.getValue())) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u4e0a\u62a5\uff0c\u65e0\u6cd5\u518d\u6b21\u4e0a\u62a5\u3002", (String)"ProjectApproveReportOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            if (projectObj.getDynamicObject("prostatus") == null || !ProjectStatusEnum.APPROVAL_FAIL.getId().equals(String.valueOf(projectObj.getDynamicObject("prostatus").getPkValue()))) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\u672a\u901a\u8fc7\uff0c\u65e0\u6cd5\u4e0a\u62a5\u3002", (String)"ProjectApproveReportOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                        break;
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        if (REPORT.equals(operateKey) || REPORT_SUBMIT.equals(operateKey)) {
            this.report(e);
        }
    }

    private void report(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dynamicObject : dynamicObjects = e.getDataEntities()) {
            String repaudStatus = dynamicObject.getString("repaudstatus");
            Boolean isRejectModifyStatus = dynamicObject.getBoolean("isrejectmodifystatus");
            if (StringUtils.equals((CharSequence)repaudStatus, (CharSequence)ReportStatusEnum.REJECT.getValue()) && isRejectModifyStatus.booleanValue()) continue;
            DynamicObject proAudit = ProjectApprovalHelper.proAppReport((DynamicObject)dynamicObject);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proAudit});
            proAudit = BusinessDataServiceHelper.loadSingle((Object)proAudit.getPkValue(), (String)"pmas_proj_audit");
            List enabledProcessInfoList = WorkflowServiceHelper.getEnabledProcesses((DynamicObject)proAudit, (String)"submit");
            if (enabledProcessInfoList != null && enabledProcessInfoList.size() > 0) {
                OperationServiceHelper.executeOperate((String)"submit", (String)"pmas_proj_audit", (DynamicObject[])new DynamicObject[]{proAudit}, (OperateOption)OperateOption.create());
            }
            dynamicObject.set("repaudstatus", (Object)ReportStatusEnum.IS_REPORT.getValue());
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }
}

