/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.project;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pmgt.pmas.business.helper.ApproveContext;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmas.business.helper.ProjectAuditHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetCtrlEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.approval.ReportStatusEnum;
import kd.pmgt.pmbs.servicehelper.BudgetCtrlHelper;

public class ProjectAuditAuditOp
extends AbstractOperationServicePlugIn {
    protected static final String AUDIT = "audit";
    protected static final String UNAUDIT = "unaudit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("reportstatus");
        e.getFieldKeys().add("canreport");
        e.getFieldKeys().add("lastproauditid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                switch (operateKey) {
                    case "unaudit": {
                        for (ExtendedDataEntity dataEntity : dataEntities) {
                            this.validateAudit(dataEntity);
                        }
                        break;
                    }
                }
            }

            private void validateAudit(ExtendedDataEntity dataEntity) {
                String proAppId;
                DynamicObject proApp;
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                if (!StringUtils.isEmpty((CharSequence)dynamicObject.getString("reportstatus"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u6709\u5173\u8054\u7684\u4e0a\u7ea7\u5ba1\u6279\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ProjectAuditAuditOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                }
                List enabledProcessInfoList = WorkflowServiceHelper.getEnabledProcesses((DynamicObject)dynamicObject, null);
                if (StringUtils.equals((CharSequence)dynamicObject.getString("billstatus"), (CharSequence)StatusEnum.CHECKED.getValue()) && enabledProcessInfoList != null && enabledProcessInfoList.size() > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\uff0c\u4e0d\u53ef\u53cd\u5ba1\u6838\u3002", (String)"ProjectAuditAuditOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.equals((CharSequence)(proApp = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(proAppId = dynamicObject.getString("project")), (String)"pmas_pro_approval")).getString("repaudstatus"), (CharSequence)ReportStatusEnum.REJECT.getValue())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5ba1\u6279\u7ed3\u8bba\u4e3a\u201c\u9a73\u56de\u201d\u7684\u5355\u636e\uff0c\u4e0d\u53ef\u53cd\u5ba1\u6838\u3002", (String)"ProjectAuditAuditOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.equals((CharSequence)proApp.getString("repaudstatus"), (CharSequence)ReportStatusEnum.FAIL.getValue())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5ba1\u6279\u7ed3\u8bba\u4e3a\u201c\u4e0d\u901a\u8fc7\u201d\u7684\u5355\u636e\uff0c\u4e0d\u53ef\u53cd\u5ba1\u6838\u3002", (String)"ProjectAuditAuditOp_3", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.equals((CharSequence)proApp.getString("repaudstatus"), (CharSequence)ReportStatusEnum.IS_REPORT.getValue())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5ba1\u6279\u7ed3\u8bba\u4e3a\u201c\u5ba1\u6279\u4e2d\u201d\u7684\u5355\u636e\uff0c\u4e0d\u53ef\u53cd\u5ba1\u6838\u3002", (String)"ProjectAuditAuditOp_4", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isNotEmpty((CharSequence)proApp.getString("approvalstatus"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\u5355\u5df2\u8fdb\u5165\u6838\u51c6\u6d41\u7a0b\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ProjectAuditAuditOp_5", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block3: {
            DynamicObject[] dynamicObjects;
            String operateKey;
            block2: {
                DynamicObject[] dynamicObjects2;
                super.beginOperationTransaction(e);
                operateKey = e.getOperationKey();
                if (!AUDIT.equals(operateKey)) break block2;
                for (DynamicObject dynamicObject : dynamicObjects2 = e.getDataEntities()) {
                    this.beginAudit(dynamicObject);
                }
                break block3;
            }
            if (!UNAUDIT.equals(operateKey)) break block3;
            for (DynamicObject dynamicObject : dynamicObjects = e.getDataEntities()) {
                this.beginUnAudit(dynamicObject);
            }
        }
    }

    private void beginUnAudit(DynamicObject dynamicObject) {
        String appProPk = dynamicObject.getString("project");
        DynamicObject appPro = BusinessDataServiceHelper.loadSingle((Object)appProPk, (String)"pmas_pro_approval");
        if (!appPro.getBoolean("needapproval") && StringUtils.equals((CharSequence)ReportStatusEnum.PASS.getValue(), (CharSequence)appPro.getString("repaudstatus"))) {
            ProjectApprovalHelper.deleteProjectProposalAndBudgetDataBase((DynamicObject)appPro);
        }
        ProjectAuditHelper.setLastProAuditReportStatus((DynamicObject)dynamicObject, (String)ReportStatusEnum.IS_REPORT.getValue());
        ProjectAuditHelper.setProAppReportStatus((DynamicObject)dynamicObject, (String)ReportStatusEnum.IS_REPORT.getValue());
    }

    private void beginAudit(DynamicObject dynamicObject) {
        String appProPk = dynamicObject.getString("project");
        DynamicObject appPro = BusinessDataServiceHelper.loadSingle((Object)appProPk, (String)"pmas_pro_approval");
        if (!dynamicObject.getBoolean("canreport")) {
            ProjectAuditHelper.setProAppReportStatus((DynamicObject)dynamicObject, (String)ReportStatusEnum.PASS.getValue());
            ApproveContext context = new ApproveContext();
            context.setApprovePro(appPro);
            DynamicObject project = appPro.getDynamicObject("pro");
            if (project != null) {
                DynamicObject sysPro = BusinessDataServiceHelper.loadSingle((Object)appPro.getDynamicObject("pro").getPkValue(), (String)"bd_project");
                context.setSysPro(sysPro);
            }
            if (!appPro.getBoolean("needapproval")) {
                ProjectApprovalHelper.syncProjectProposalAndBudgetDataBase((DynamicObject)appPro);
                ProjectApprovalHelper.synProjLeader((DynamicObject)context.getApprovePro());
                ProjectApprovalHelper.updateDownFlowBill((ApproveContext)context);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{context.getApprovePro()});
        }
        ProjectAuditHelper.setLastProAuditReportStatus((DynamicObject)dynamicObject, (String)ReportStatusEnum.PASS.getValue());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                for (DynamicObject dynamicObject : dataEntities) {
                    String appProPk;
                    DynamicObject appPro;
                    if (dynamicObject.getBoolean("canreport") || (appPro = BusinessDataServiceHelper.loadSingle((Object)(appProPk = dynamicObject.getString("project")), (String)"pmas_pro_approval")).getBoolean("needapproval")) continue;
                    DynamicObject proStatus = BusinessDataServiceHelper.loadSingle((Object)ProjectStatusEnum.APPROVAL_IN.getId(), (String)"bd_projectstatus");
                    appPro.set("prostatus", (Object)proStatus);
                    ProjectApprovalHelper.setProStatus((DynamicObject)appPro);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{appPro});
                }
                break;
            }
            case "unaudit": {
                for (DynamicObject dynamicObject : dataEntities) {
                    DynamicObject proApp = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("project"), (String)"pmas_pro_approval");
                    DynamicObject pro = proApp.getDynamicObject("pro");
                    ProjectApprovalHelper.checkOccurUnSysBiz((DynamicObject)pro);
                    if (proApp.getBoolean("needapproval")) {
                        return;
                    }
                    ProjectApprovalHelper.deleteRelateBizExclude((DynamicObject)proApp, (DynamicObject)pro);
                    proApp = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("project"), (String)"pmas_pro_approval");
                    DeleteServiceHelper.delete((String)"pmas_prostatus", (QFilter[])new QFilter[]{new QFilter("proapproval", "=", proApp.getPkValue())});
                    if (StringUtils.equals((CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue(), (CharSequence)proApp.getString("budgetcontrolmode"))) {
                        try {
                            BudgetCtrlHelper.invokeAdjustInterface((DynamicObject)proApp, (BudgetCtrlEnum)BudgetCtrlEnum.UNAUDIT);
                        }
                        catch (Exception exception) {
                            throw new KDBizException(exception.getMessage());
                        }
                        ProjectApprovalHelper.occupyAmount((DynamicObject)proApp, (String)UNAUDIT);
                    }
                    ProjectApprovalHelper.updateBudgetRecordField(null, (DynamicObject)proApp, (String)"submit");
                }
                break;
            }
        }
    }
}

