/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.project;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.pmgt.pmbs.common.enums.approval.ReportStatusEnum;

public class ProjectAuditReportOp
extends AbstractOperationServicePlugIn {
    protected static final String REPORT = "report";
    private static final String AUDIT_BILLNO_SDF = "yyyyMMddHHmmss";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = e.getOperationKey();
        if (REPORT.equals(operateKey)) {
            this.beginReport(e);
        }
    }

    private void beginReport(BeginOperationTransactionArgs e) {
        DynamicObject[] dynamicObjects;
        for (DynamicObject dynamicObject : dynamicObjects = e.getDataEntities()) {
            DynamicObject reportAudit = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_proj_audit"));
            CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"pmas_proj_audit", (DynamicObject)reportAudit, (String)String.valueOf(RequestContext.get().getOrgId()));
            Date now = new Date();
            if (null != codeRuleInfo) {
                reportAudit.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)reportAudit));
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat(AUDIT_BILLNO_SDF);
                reportAudit.set("billno", (Object)String.join((CharSequence)"", dynamicObject.getDynamicObject("prono").getString("billno"), sdf.format(now)));
            }
            reportAudit.set("billname", (Object)dynamicObject.getString("billname"));
            reportAudit.set("org", (Object)dynamicObject.getDynamicObject("reportingorg"));
            reportAudit.set("proorg", (Object)dynamicObject.getDynamicObject("org"));
            reportAudit.set("billstatus", (Object)dynamicObject.getString("billstatus"));
            reportAudit.set("lastproauditid", (Object)String.valueOf(dynamicObject.getPkValue()));
            reportAudit.set("project", (Object)dynamicObject.getString("project"));
            reportAudit.set("prono", (Object)dynamicObject.getDynamicObject("prono"));
            reportAudit.set("proname", (Object)dynamicObject.getString("proname"));
            reportAudit.set("kind", (Object)dynamicObject.getDynamicObject("kind"));
            reportAudit.set("proapp", (Object)dynamicObject.getDynamicObject("proapp"));
            reportAudit.set("creator", (Object)RequestContext.get().getUserId());
            reportAudit.set("modifier", (Object)RequestContext.get().getUserId());
            reportAudit.set("createtime", (Object)now);
            reportAudit.set("modifytime", (Object)now);
            reportAudit.set("billstatus", (Object)"A");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportAudit});
            reportAudit = BusinessDataServiceHelper.loadSingle((Object)reportAudit.getPkValue(), (String)"pmas_proj_audit");
            List enabledProcessInfoList = WorkflowServiceHelper.getEnabledProcesses((DynamicObject)reportAudit, (String)"submit");
            if (enabledProcessInfoList != null && enabledProcessInfoList.size() > 0) {
                OperationServiceHelper.executeOperate((String)"submit", (String)"pmas_proj_audit", (DynamicObject[])new DynamicObject[]{reportAudit}, (OperateOption)OperateOption.create());
            }
            dynamicObject.set("reportstatus", (Object)ReportStatusEnum.IS_REPORT.getValue());
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }
}

