/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.supervision;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.utils.ProjectSupervisionHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class ProjectSupervisionOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("supervisionentry");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("version");
        e.getFieldKeys().add("latestversion");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("billno, billstatus, creator, auditor, org, auditdate, createtime, modifytime, modifier, project, projectkind, version, latestversion, adjustexplain");
        e.getFieldKeys().add("projectstage");
        e.getFieldKeys().add("supervisionid");
        e.getFieldKeys().add("sysbill");
        e.getFieldKeys().add("workitem");
        e.getFieldKeys().add("keyitem");
        e.getFieldKeys().add("keypropertyid");
        e.getFieldKeys().add("estimateendtime");
        e.getFieldKeys().add("createorg");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                this.doAudit(dataEntities);
                break;
            }
        }
    }

    protected void doAudit(DynamicObject[] dataEntities) {
        for (DynamicObject superAdjust : dataEntities) {
            superAdjust = BusinessDataServiceHelper.loadSingle((Object)superAdjust.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_projectsupervision"));
            DynamicObjectCollection superAdjustEntry = superAdjust.getDynamicObjectCollection("supervisionentry");
            DynamicObject project = superAdjust.getDynamicObject("project");
            if (project != null) {
                QFilter projectFilter = new QFilter("billproject", "=", project.getPkValue());
                DynamicObject supervisionPerform = BusinessDataServiceHelper.loadSingle((String)"pmfs_supervisperform", (String)"", (QFilter[])new QFilter[]{projectFilter});
                if (supervisionPerform != null) {
                    supervisionPerform = BusinessDataServiceHelper.loadSingle((Object)supervisionPerform.getPkValue(), (String)"pmfs_supervisperform");
                }
                DynamicObjectCollection spvPerformEntry = null;
                if (superAdjustEntry != null && superAdjustEntry.size() > 0) {
                    if (supervisionPerform != null) {
                        spvPerformEntry = supervisionPerform.getDynamicObjectCollection("superentryentity");
                        if (spvPerformEntry.size() > 0) {
                            Map<String, DynamicObject> superidToAdjustMap = superAdjustEntry.stream().filter(entry -> StringUtils.isNotEmpty((CharSequence)entry.getString("supervisionid"))).collect(Collectors.toMap(o -> o.getString("supervisionid"), o -> o));
                            Set newSuperAdjustEntrySet = superAdjustEntry.stream().filter(entry -> StringUtils.isEmpty((CharSequence)entry.getString("supervisionid"))).collect(Collectors.toSet());
                            for (DynamicObject spvPerformEntryObj : spvPerformEntry) {
                                boolean isHiddenData = spvPerformEntryObj.getBoolean("hiddendata");
                                boolean isDeleted = spvPerformEntryObj.getBoolean("deleted");
                                if (isHiddenData || isDeleted) continue;
                                DynamicObject superAdjustEntryObj = (DynamicObject)superidToAdjustMap.get(spvPerformEntryObj.getPkValue().toString());
                                if (superAdjustEntryObj == null) {
                                    spvPerformEntryObj.set("deleted", (Object)Boolean.TRUE);
                                    continue;
                                }
                                this.updateWorkItem(superAdjustEntryObj, spvPerformEntryObj);
                            }
                            for (DynamicObject newSuperAdjustEntryObj : newSuperAdjustEntrySet) {
                                DynamicObjectType dt = spvPerformEntry.getDynamicObjectType();
                                DynamicObject workObject = this.generateWorkItemObj(newSuperAdjustEntryObj, dt, project);
                                spvPerformEntry.add((Object)workObject);
                            }
                        } else {
                            for (DynamicObject superAdjustEntryObj : superAdjustEntry) {
                                DynamicObjectType dt = spvPerformEntry.getDynamicObjectType();
                                DynamicObject workObject = this.generateWorkItemObj(superAdjustEntryObj, dt, project);
                                spvPerformEntry.add((Object)workObject);
                            }
                        }
                    } else {
                        supervisionPerform = this.generateSpvPerformBill(superAdjust, superAdjustEntry);
                    }
                } else if (supervisionPerform != null) {
                    spvPerformEntry = supervisionPerform.getDynamicObjectCollection("superentryentity");
                    for (DynamicObject spvPerformEntryObj : spvPerformEntry) {
                        boolean isHiddenData = spvPerformEntryObj.getBoolean("hiddendata");
                        boolean isDeleted = spvPerformEntryObj.getBoolean("deleted");
                        if (isHiddenData || isDeleted) continue;
                        spvPerformEntryObj.set("deleted", (Object)Boolean.TRUE);
                    }
                } else {
                    supervisionPerform = this.generateSpvPerformBill(superAdjust, superAdjustEntry);
                }
                String projectWarnLightValue = ProjectSupervisionHelper.getProjectWarnLight((DynamicObjectCollection)spvPerformEntry);
                supervisionPerform.set("prowarninglight", (Object)projectWarnLightValue);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supervisionPerform});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{superAdjust});
                QFilter proFilter = new QFilter("project", "=", project.getPkValue());
                QFilter latestFilter = new QFilter("latestversion", "=", (Object)Boolean.TRUE);
                QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                QFilter idFilter = new QFilter("id", "not in", superAdjust.getPkValue());
                DynamicObject supervision = BusinessDataServiceHelper.loadSingle((String)"pmas_projectsupervision", (String)"latestversion", (QFilter[])new QFilter[]{proFilter, latestFilter, statusFilter, idFilter});
                if (supervision != null) {
                    supervision.set("latestversion", (Object)Boolean.FALSE);
                    SaveServiceHelper.update((DynamicObject)supervision);
                }
            }
            superAdjust.set("latestversion", (Object)Boolean.TRUE);
        }
    }

    protected DynamicObject generateSpvPerformBill(DynamicObject superAdjust, DynamicObjectCollection superAdjustEntry) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmfs_supervisperform");
        DynamicObject spvPerformObj = new DynamicObject((DynamicObjectType)dt);
        String billNo = superAdjust.getString("billno");
        String[] s = billNo.split("_");
        DynamicObject project = superAdjust.getDynamicObject("project");
        spvPerformObj.set("billproject", (Object)project);
        spvPerformObj.set("billno", (Object)(s[0] + "_supervisperform"));
        spvPerformObj.set("creator", (Object)superAdjust.getDynamicObject("creator"));
        spvPerformObj.set("modifier", (Object)superAdjust.getDynamicObject("modifier"));
        spvPerformObj.set("auditor", (Object)superAdjust.getDynamicObject("modifier"));
        spvPerformObj.set("createtime", (Object)superAdjust.getDate("createtime"));
        spvPerformObj.set("modifytime", (Object)superAdjust.getDate("modifytime"));
        spvPerformObj.set("auditdate", (Object)superAdjust.getDate("modifytime"));
        spvPerformObj.set("billstatus", (Object)StatusEnum.CHECKED.getValue());
        DynamicObjectCollection performEntryCol = spvPerformObj.getDynamicObjectCollection("superentryentity");
        DynamicObjectType superEntryDT = performEntryCol.getDynamicObjectType();
        for (DynamicObject superAdjustEntryObj : superAdjustEntry) {
            DynamicObject workObject = this.generateWorkItemObj(superAdjustEntryObj, superEntryDT, project);
            performEntryCol.add((Object)workObject);
        }
        return spvPerformObj;
    }

    protected DynamicObject generateWorkItemObj(DynamicObject newSuperAdjustEntryObj, DynamicObjectType dt, DynamicObject project) {
        DynamicObject workObject = new DynamicObject(dt);
        ORM orm = ORM.create();
        long id = orm.genLongId((IDataEntityType)dt);
        workObject.set("id", (Object)id);
        workObject.set("seq", (Object)newSuperAdjustEntryObj.getString("seq"));
        workObject.set("projectstage", (Object)newSuperAdjustEntryObj.getDynamicObject("projectstage"));
        workObject.set("sysbill", (Object)newSuperAdjustEntryObj.getDynamicObject("sysbill"));
        workObject.set("workitem", (Object)newSuperAdjustEntryObj.getString("workitem"));
        workObject.set("keyitem", (Object)newSuperAdjustEntryObj.getBoolean("keyitem"));
        workObject.set("hiddendata", (Object)newSuperAdjustEntryObj.getBoolean("hiddendata"));
        workObject.set("keypropconfigid", (Object)newSuperAdjustEntryObj.getString("keypropertyid"));
        Date estimateDate = newSuperAdjustEntryObj.getDate("estimateendtime");
        workObject.set("estimateendtime", (Object)estimateDate);
        workObject.set("supervisionid", newSuperAdjustEntryObj.getPkValue());
        workObject.set("project", (Object)project);
        workObject.set("deleted", (Object)Boolean.FALSE);
        Date actualEndTime = workObject.getDate("actualendtime");
        String itemWarnLightValue = ProjectSupervisionHelper.getItemWarnLight((Date)estimateDate, (Date)actualEndTime);
        workObject.set("itemwarninglight", (Object)itemWarnLightValue);
        newSuperAdjustEntryObj.set("supervisionid", (Object)Long.toString(id));
        return workObject;
    }

    public void updateWorkItem(DynamicObject superAdjustEntryObj, DynamicObject workObject) {
        workObject.set("seq", (Object)superAdjustEntryObj.getString("seq"));
        workObject.set("projectstage", (Object)superAdjustEntryObj.getDynamicObject("projectstage"));
        workObject.set("sysbill", (Object)superAdjustEntryObj.getDynamicObject("sysbill"));
        workObject.set("workitem", (Object)superAdjustEntryObj.getString("workitem"));
        workObject.set("keyitem", (Object)superAdjustEntryObj.getBoolean("keyitem"));
        workObject.set("hiddendata", (Object)Boolean.FALSE);
        workObject.set("keypropconfigid", (Object)superAdjustEntryObj.getString("keypropertyid"));
        workObject.set("supervisionid", (Object)superAdjustEntryObj.getPkValue().toString());
        Date estimateDate = superAdjustEntryObj.getDate("estimateendtime");
        workObject.set("estimateendtime", (Object)estimateDate);
        Date actualEndTime = workObject.getDate("actualendtime");
        String itemWarnLightValue = ProjectSupervisionHelper.getItemWarnLight((Date)estimateDate, (Date)actualEndTime);
        workObject.set("itemwarninglight", (Object)itemWarnLightValue);
    }
}

