/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.team;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmas.business.helper.ProjectBudgetGenerateHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetStageEnum;
import kd.pmgt.pmbs.common.enums.MajorTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.StageStatusHelper;

public class InBudgetOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("sourcetype");
        e.getFieldKeys().add("version");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("isvalid");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("totalyearamt");
        e.getFieldKeys().add("totalamount");
        e.getFieldKeys().add("budgetstage");
        e.getFieldKeys().add("schangeamount");
        e.getFieldKeys().add("vchangeamount");
        e.getFieldKeys().add("year");
        e.getFieldKeys().add("treeentryentity");
        e.getFieldKeys().add("treeentryentity.budgetamount");
        e.getFieldKeys().add("treeentryentity.budgetitem");
        e.getFieldKeys().add("treeentryentity.budgetitemname");
        e.getFieldKeys().add("treeentryentity.budgetitemnum");
        e.getFieldKeys().add("treeentryentity.descriptionentry");
        e.getFieldKeys().add("treeentryentity.isGroupNode");
        e.getFieldKeys().add("treeentryentity.pid");
        e.getFieldKeys().add("treeentryentity.projectbudgetitem");
        e.getFieldKeys().add("treeentryentity.siamount");
        e.getFieldKeys().add("treeentryentity.viamount");
        e.getFieldKeys().add("treeentryentity.vichangeamount");
        e.getFieldKeys().add("treeentryentity.seq");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                ArrayList<DynamicObject> updateObjs = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> auditObjs = new ArrayList<DynamicObject>();
                ArrayList updateProjectItems = new ArrayList();
                ArrayList addProjectItems = new ArrayList();
                for (DynamicObject obj : dataEntities) {
                    boolean isNew;
                    DynamicObject project;
                    QFilter yearValid;
                    QFilter sourceTypeFilter;
                    QFilter isValid;
                    QFilter projFilter = new QFilter("project", "=", obj.getDynamicObject("project").getPkValue());
                    DynamicObject[] validObjs = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id,billno,isvalid", (QFilter[])new QFilter[]{projFilter, isValid = new QFilter("isvalid", "=", (Object)"1"), sourceTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.IN.getValue()), yearValid = new QFilter("year", "=", (Object)obj.getDate("year"))});
                    if (validObjs.length > 0) {
                        for (DynamicObject budget : validObjs) {
                            budget.set("isvalid", (Object)"0");
                            updateObjs.add(budget);
                        }
                    }
                    obj.set("isvalid", (Object)"1");
                    auditObjs.add(obj);
                    ProjectBudgetGenerateHelper.generateProjectBudget((DynamicObject)obj, updateProjectItems, addProjectItems, (String)BudgetSourceTypeEnum.IN.getValue());
                    if (auditObjs.size() > 0) {
                        SaveServiceHelper.update((DynamicObject[])auditObjs.toArray(new DynamicObject[0]));
                    }
                    if (updateProjectItems.size() > 0) {
                        SaveServiceHelper.save((IDataEntityType)((DynamicObject)updateProjectItems.get(0)).getDataEntityType(), (Object[])updateProjectItems.toArray(new DynamicObject[0]));
                    }
                    if (addProjectItems.size() > 0) {
                        SaveServiceHelper.save((IDataEntityType)((DynamicObject)addProjectItems.get(0)).getDataEntityType(), (Object[])addProjectItems.toArray(new DynamicObject[0]));
                    }
                    if ((project = obj.getDynamicObject("project")) != null && (isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(project.getPkValue().toString())))) {
                        ProBudgetControlHelper.updateYearBudgetCtrlData((DynamicObject)obj);
                        ProBudgetControlHelper.updateTotalBudgetCtrlByYearBudget((DynamicObject)obj);
                    }
                    if (updateObjs.size() <= 0) continue;
                    SaveServiceHelper.update((DynamicObject[])updateObjs.toArray(new DynamicObject[0]));
                }
                break;
            }
            case "submit": {
                for (DynamicObject obj : dataEntities) {
                    BigDecimal version = obj.getBigDecimal("version");
                    DynamicObject budgetStage = obj.getDynamicObject("budgetstage");
                    DynamicObject project = obj.getDynamicObject("project");
                    if (budgetStage == null || BigDecimal.valueOf(1.0).compareTo(version) != 0 || !StringUtils.equals((CharSequence)budgetStage.getString("number"), (CharSequence)BudgetStageEnum.PREINSTALL_2.getValue())) continue;
                    StageStatusHelper.changeStatus((DynamicObject)project, (ProjectStageEnum)ProjectStageEnum.FEASIBILITYSTUDYSTAGE_S, (ProjectStatusEnum)ProjectStatusEnum.APPROVAL_IN);
                }
                break;
            }
            case "unsubmit": {
                for (DynamicObject obj : dataEntities) {
                    BigDecimal version = obj.getBigDecimal("version");
                    DynamicObject budgetStage = obj.getDynamicObject("budgetstage");
                    DynamicObject project = obj.getDynamicObject("project");
                    if (budgetStage == null || BigDecimal.valueOf(1.0).compareTo(version) != 0 || !StringUtils.equals((CharSequence)budgetStage.getString("number"), (CharSequence)BudgetStageEnum.PREINSTALL_2.getValue())) continue;
                    boolean exist = false;
                    QFilter filter1 = new QFilter("project", "=", project.getPkValue());
                    DynamicObject[] proTask = BusinessDataServiceHelper.load((String)"pmpm_task", (String)"assigner,projectstatus,number,name,status,creator,modifier,enable,createtime,modifytime,masterid,longnumber,level,fullname,isleaf, parent, controllevel, majortype, tasktype, achievementnode, pretask, logical, relativeduration, absoluteduration, planstarttime, planendtime, aimfinishtime, comptimedeviation, responsibleperson, responsibledept, cooperationperson, cooperationdept, comment, realendtime, resultdoc, prechangetask, version, realtimedeviation, belongplantype, sourcetask, completionstatus, percent, sharer, project, relationtask, islatest, taskseq, planid, riskcolor, responsiblepost, associatepost, templatetask, tasksource, expecttime, multicooperationperson, multicooperationdept, completedescription,taskresultdocentry,billstatus,meettask", (QFilter[])new QFilter[]{filter1});
                    if (proTask != null && proTask.length > 0) {
                        for (DynamicObject task : proTask) {
                            DynamicObject majorType = task.getDynamicObject("majortype");
                            if (!StringUtils.equals((CharSequence)majorType.getString("number"), (CharSequence)MajorTypeEnum.FEASIBILITYSTUDY_S.getValue())) continue;
                            QFilter filter3 = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
                            filter3.or(new QFilter("billstatus", "=", (Object)StatusEnum.UNCHECKED.getValue()));
                            QFilter filter4 = new QFilter("task", "=", task.getPkValue());
                            DynamicObject[] taskReport = BusinessDataServiceHelper.load((String)"pmpm_taskreport", (String)"id,billno,billstatus,persontype,creator,modifier,auditor,auditdate,modifytime,createtime,chengguoentity.id,chengguoentity.attachmentfield,chengguoentity.resultname,chengguoentity.desc,chengguoentity.force,chengguoentity.resultid,chengguoentity.frequency,iscomplete,completetime,tips,reportdesc,huibaojlentity.id,huibaojlentity.completeprocess,huibaojlentity.resultdate,huibaojlentity.reportperson,huibaojlentity.completedesc,huibaojlentity.taskreport,huibaojlentity.historytask,huibaojlentity.resultstatus,task,percent,huibaoperson", (QFilter[])new QFilter[]{filter3, filter4});
                            if (taskReport == null || taskReport.length <= 0) continue;
                            exist = true;
                            break;
                        }
                    }
                    if (exist) continue;
                    StageStatusHelper.changeStatus((DynamicObject)project, (ProjectStageEnum)ProjectStageEnum.FEASIBILITYSTUDYSTAGE_S, null);
                }
                break;
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity extendDataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject dataEntity = extendDataEntity.getDataEntity();
                    DynamicObject project = dataEntity.getDynamicObject("project");
                    if (project != null) continue;
                    this.addErrorMessage(extendDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"InBudgetOp_0", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }
}

