/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.opplugin.team;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmas.business.helper.BudgetBillHelper;
import kd.pmgt.pmas.business.helper.OutBudgetOpHelper;
import kd.pmgt.pmas.business.helper.ProjectBudgetGenerateHelper;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.BudgetCtrlEnum;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.BudgetStageEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.StageStatusHelper;
import kd.pmgt.pmbs.servicehelper.BudgetCtrlHelper;

public class OutBudgetOp
extends AbstractOperationServicePlugIn {
    private static final String BUDGETCTRL = "budgetctrl";
    private static final String BUDGETPRONAME = "budgetproname";
    private static final String BUDGETPRONUMBER = "budgetpronumber";
    private static final String BUDGETPRO = "budgetpro";
    public static final String BUDGET_CONTROL_MODE = "budgetcontrolmode";
    public static final String PROJECT_COST_CONTROL = "projectcostcontrol";
    public static final String REALBUDGETENTRY = "realbudgetentry";
    public static final String OUTBUDGET_FORMID = "pmas_outbudget";
    private static final Log logger = LogFactory.getLog(OutBudgetOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("sourcetype");
        fieldKeys.add("version");
        fieldKeys.add("project");
        fieldKeys.add("isvalid");
        fieldKeys.add("currency");
        fieldKeys.add("budgetstage");
        fieldKeys.add("type");
        fieldKeys.add("totalamount");
        fieldKeys.add("year");
        fieldKeys.add("billstatus");
        fieldKeys.add("totalyearamt");
        fieldKeys.add("schangeamount");
        fieldKeys.add("vchangeamount");
        fieldKeys.add("treeentryentity");
        fieldKeys.add("budgetamount");
        fieldKeys.add("budgetitem");
        fieldKeys.add("budgetitemname");
        fieldKeys.add("budgetitemnum");
        fieldKeys.add("descriptionentry");
        fieldKeys.add("isGroupNode");
        fieldKeys.add("pid");
        fieldKeys.add("projectbudgetitem");
        fieldKeys.add("siamount");
        fieldKeys.add("viamount");
        fieldKeys.add("vichangeamount");
        fieldKeys.add("sichangeamount");
        fieldKeys.add("istotal");
        fieldKeys.add("itemtotalamount");
        fieldKeys.add(BUDGETCTRL);
        fieldKeys.add(BUDGET_CONTROL_MODE);
        fieldKeys.add(PROJECT_COST_CONTROL);
        fieldKeys.add(BUDGETPRONAME);
        fieldKeys.add(BUDGETPRONUMBER);
        fieldKeys.add(BUDGETPRO);
        fieldKeys.add("budgetperiod");
        fieldKeys.add("treeentryentity.seq");
        fieldKeys.add(REALBUDGETENTRY);
        fieldKeys.add("projectapplydate");
        fieldKeys.add("group");
        fieldKeys.add("splittype");
        fieldKeys.add("realbudgetentry.seq");
        fieldKeys.add("realbudgetentry.realprobudgetname");
        fieldKeys.add("realbudgetentry.realbudgetitem");
        fieldKeys.add("realbudgetentry.realundertakeorg");
        fieldKeys.add("realbudgetentry.realundertakeperiod");
        fieldKeys.add("realbudgetentry.realproname");
        fieldKeys.add("realbudgetentry.realpronumber");
        fieldKeys.add("realbudgetentry.realproid");
        fieldKeys.add("realbudgetentry.realbeforeamt");
        fieldKeys.add("realbudgetentry.realundertakeamt");
        fieldKeys.add("realbudgetentry.realdifferenceamt");
        fieldKeys.add("treeentryentity.seq");
        fieldKeys.add("controlinfoentry.entryproid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                String operationKey = this.getOperateKey();
                if ("submit".equals(operationKey)) {
                    for (ExtendedDataEntity dataEntry : dataEntities) {
                        boolean result;
                        DynamicObject dataEntity = dataEntry.getDataEntity();
                        String billStatus = dataEntity.getString("billstatus");
                        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)StatusEnum.CHECKED.getValue())) continue;
                        String tip = this.checkBudgetAmtCompareTotalAmt(dataEntity);
                        if (StringUtils.isNotEmpty((CharSequence)tip)) {
                            this.addErrorMessage(dataEntry, tip);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)(tip = this.checkSumBudgetAmtCompareTotalAmt(dataEntity)))) {
                            this.addErrorMessage(dataEntry, tip);
                        }
                        if (result = this.checkItemTotalAmt(dataEntity)) {
                            this.addErrorMessage(dataEntry, ResManager.loadKDString((String)"\u4e0b\u7ea7\u9884\u7b97\u9879\u201c\u603b\u91d1\u989d\u201d\u6c47\u603b\u503c\u5fc5\u987b\u7b49\u4e8e\u7236\u7ea7\u9884\u7b97\u9879\u201c\u603b\u91d1\u989d\u201d\u3002", (String)"OutBudgetOp_8", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                        }
                        this.checkBudgetAmt(dataEntry);
                    }
                }
            }

            private String checkSumBudgetAmtCompareTotalAmt(DynamicObject dataEntity) {
                StringBuffer result = new StringBuffer();
                DynamicObject currency = dataEntity.getDynamicObject("currency");
                int precision = currency == null ? 4 : currency.getInt("amtprecision");
                String type = dataEntity.getString("type");
                DynamicObject project = dataEntity.getDynamicObject("project");
                if (project != null) {
                    QFilter qFilter = new QFilter("tproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                    qFilter.and("tbudgettype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
                    DynamicObject totalBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudgetctrl", (QFilter[])new QFilter[]{qFilter});
                    if (totalBudgetCtrl == null) {
                        return result.toString();
                    }
                    BigDecimal budgetAmt = totalBudgetCtrl.getBigDecimal("tbudgetamt");
                    BigDecimal sumBudgetAmt = BigDecimal.ZERO;
                    DynamicObject exist = ProBudgetControlHelper.checkExistValidYearBudget((Long)Long.parseLong(project.getPkValue().toString()), (String)"OUT", null);
                    if (exist != null) {
                        sumBudgetAmt = totalBudgetCtrl.getBigDecimal("tsumbudamt");
                    }
                    sumBudgetAmt = sumBudgetAmt.compareTo(BigDecimal.ZERO) == 0 ? dataEntity.getBigDecimal("totalamount") : ("NEW".equals(type) ? sumBudgetAmt.add(dataEntity.getBigDecimal("schangeamount")) : sumBudgetAmt.add(dataEntity.getBigDecimal("vchangeamount")));
                    if (budgetAmt.compareTo(BigDecimal.ZERO) > 0 && budgetAmt.compareTo(sumBudgetAmt) < 0) {
                        result.append(String.format(ResManager.loadKDString((String)"\u5e74\u5ea6\u9884\u7b97\u7d2f\u8ba1\u91d1\u989d%1$s\u8d85\u9884\u7b97\u603b\u91d1\u989d%2$s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"OutBudgetOp_1", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), sumBudgetAmt.setScale(precision, RoundingMode.HALF_UP), budgetAmt.setScale(precision, RoundingMode.HALF_UP)));
                    }
                    if (StringUtils.isEmpty((CharSequence)result)) {
                        DynamicObjectCollection details = totalBudgetCtrl.getDynamicObjectCollection("tbudgetctrldetail");
                        if (details.isEmpty()) {
                            return result.toString();
                        }
                        DynamicObjectCollection entryEntries = dataEntity.getDynamicObjectCollection("treeentryentity");
                        for (int i = 0; i < entryEntries.size(); ++i) {
                            DynamicObject item = (DynamicObject)entryEntries.get(i);
                            DynamicObject proBudgetItem = item.getDynamicObject("projectbudgetitem");
                            if (proBudgetItem == null) continue;
                            long proBudgetId = Long.parseLong(proBudgetItem.getPkValue().toString());
                            Optional<DynamicObject> first = details.stream().filter(o -> o.getDynamicObject("budget") != null).filter(o -> proBudgetId == Long.parseLong(o.getDynamicObject("budget").getPkValue().toString())).findFirst();
                            if (!first.isPresent()) continue;
                            DynamicObject detail = first.get();
                            budgetAmt = detail.getBigDecimal("budgetamt");
                            sumBudgetAmt = BigDecimal.ZERO;
                            if (exist != null) {
                                sumBudgetAmt = detail.getBigDecimal("sumbudamt");
                            }
                            sumBudgetAmt = sumBudgetAmt.compareTo(BigDecimal.ZERO) == 0 ? item.getBigDecimal("budgetamount") : ("NEW".equals(type) ? sumBudgetAmt.add(item.getBigDecimal("sichangeamount")) : sumBudgetAmt.add(item.getBigDecimal("vichangeamount")));
                            if (budgetAmt.compareTo(BigDecimal.ZERO) <= 0 || budgetAmt.compareTo(sumBudgetAmt) >= 0) continue;
                            if (StringUtils.isNotEmpty((CharSequence)result.toString())) {
                                result.append("\r\n");
                            }
                            result.append(String.format(ResManager.loadKDString((String)"\u9884\u7b97\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u9884\u7b97\u9879\u5e74\u5ea6\u9884\u7b97\u7d2f\u8ba1\u91d1\u989d%2$s\u8d85\u9884\u7b97\u603b\u91d1\u989d%3$s\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"OutBudgetOp_2", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), i + 1, sumBudgetAmt.setScale(precision, RoundingMode.HALF_UP), budgetAmt.setScale(precision, RoundingMode.HALF_UP)));
                        }
                    }
                }
                return result.toString();
            }

            private String checkBudgetAmtCompareTotalAmt(DynamicObject dataEntity) {
                String result = "";
                DynamicObjectCollection itemEntities = dataEntity.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject itemEntity : itemEntities) {
                    BigDecimal budgetAmt = itemEntity.getBigDecimal("budgetamount");
                    BigDecimal totalAmt = itemEntity.getBigDecimal("itemtotalamount");
                    if (totalAmt.compareTo(BigDecimal.ZERO) <= 0 || totalAmt.compareTo(budgetAmt) >= 0) continue;
                    result = ResManager.loadKDString((String)"\u201c\u672c\u9636\u6bb5\u91d1\u989d\u201d\u5fc5\u987b\u4e0d\u5927\u4e8e\u201c\u603b\u91d1\u989d\u201d\u3002", (String)"OutBudgetOp_3", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]);
                    break;
                }
                return result;
            }

            private void checkBudgetAmt(ExtendedDataEntity dataEntry) {
                DynamicObject dataEntity = dataEntry.getDataEntity();
                DynamicObject currency = dataEntity.getDynamicObject("currency");
                int precision = currency == null ? 4 : currency.getInt("amtprecision");
                DynamicObject project = dataEntity.getDynamicObject("project");
                if (project != null) {
                    DynamicObjectCollection details = null;
                    QFilter qFilter = new QFilter("yproject", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                    qFilter.and("ybudgettype", "=", (Object)"OUT");
                    qFilter.and("yyear", "=", (Object)dataEntity.getDate("year"));
                    DynamicObject yearBudgetCtrl = BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrl", (QFilter[])new QFilter[]{qFilter});
                    if (yearBudgetCtrl != null) {
                        details = yearBudgetCtrl.getDynamicObjectCollection("ybudgetctrldetail");
                    }
                    if (details == null) {
                        return;
                    }
                    DynamicObjectCollection itemEntities = dataEntity.getDynamicObjectCollection("treeentryentity");
                    for (int i = 0; i < itemEntities.size(); ++i) {
                        DynamicObject itemEntity = (DynamicObject)itemEntities.get(i);
                        DynamicObject projectBudget = itemEntity.getDynamicObject("projectbudgetitem");
                        if (projectBudget == null) continue;
                        long projectBudgetId = Long.parseLong(projectBudget.getPkValue().toString());
                        Optional<DynamicObject> first = details.stream().filter(o -> o.getDynamicObject("budget") != null).filter(o -> Long.parseLong(o.getDynamicObject("budget").getPkValue().toString()) == projectBudgetId).findFirst();
                        if (!first.isPresent()) continue;
                        BigDecimal budgetAmt = itemEntity.getBigDecimal("budgetamount");
                        BigDecimal usageAmt = first.get().getBigDecimal("usageamt");
                        BigDecimal preUsageAmt = first.get().getBigDecimal("preoccupyusageamt");
                        if (budgetAmt.compareTo(usageAmt = usageAmt.add(preUsageAmt)) >= 0) continue;
                        String errorTip = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c\u9884\u7b97\u91d1\u989d\u201d\u5e94\u5927\u4e8e\u201c\u5df2\u4f7f\u7528\u91d1\u989d\u201d\uff08%2$s\uff09", (String)"OutBudgetOp_4", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), i + 1, usageAmt.setScale(precision, RoundingMode.HALF_UP));
                        this.addErrorMessage(dataEntry, errorTip);
                    }
                }
            }

            private boolean checkItemTotalAmt(DynamicObject dataEntity) {
                boolean result = false;
                HashMap<Long, BigDecimal> itemTotalMap = new HashMap<Long, BigDecimal>();
                HashMap<Long, BigDecimal> parentTotalAmtMap = new HashMap<Long, BigDecimal>();
                DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject entry : entryEntities) {
                    boolean isTotal = entry.getBoolean("istotal");
                    BigDecimal totalAmt = entry.getBigDecimal("itemtotalamount");
                    if (isTotal) {
                        itemTotalMap.put(Long.parseLong(entry.getPkValue().toString()), totalAmt);
                    }
                    long pid = entry.getLong("pid");
                    if (isTotal || pid == 0L) continue;
                    BigDecimal parentTotalAmt = (BigDecimal)parentTotalAmtMap.get(pid);
                    if (parentTotalAmt == null) {
                        parentTotalAmtMap.put(pid, totalAmt);
                        continue;
                    }
                    parentTotalAmtMap.put(pid, totalAmt.add(parentTotalAmt));
                }
                if (!itemTotalMap.isEmpty() && !parentTotalAmtMap.isEmpty()) {
                    Set parentTotalAmtSet = parentTotalAmtMap.entrySet();
                    for (Map.Entry parentTotalAmt : parentTotalAmtSet) {
                        Long parentId = (Long)parentTotalAmt.getKey();
                        BigDecimal parentAmt = (BigDecimal)parentTotalAmt.getValue();
                        BigDecimal isTotalAmt = (BigDecimal)itemTotalMap.get(parentId);
                        if (isTotalAmt == null || isTotalAmt.compareTo(parentAmt) == 0) continue;
                        result = true;
                        break;
                    }
                }
                return result;
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "save": {
                for (DynamicObject dataEntity : dataEntities) {
                    QFilter qFilter;
                    DynamicObject curBudgetRecord;
                    Long pk = (Long)dataEntity.getPkValue();
                    if (pk == 0L || (curBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno", (QFilter[])new QFilter[]{qFilter = new QFilter("relatebillid", "=", (Object)pk.toString())})) == null) continue;
                    curBudgetRecord.set("billno", dataEntity.get("billno"));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curBudgetRecord});
                }
                break;
            }
            case "submit": {
                this.doSubmit(dataEntities);
                break;
            }
            case "unsubmit": {
                OutBudgetOpHelper.doUnsubmit((DynamicObject[])dataEntities);
                break;
            }
            case "audit": {
                for (DynamicObject dataEntity : dataEntities) {
                    String budgetControlMode = dataEntity.getString(BUDGET_CONTROL_MODE);
                    String splitType = dataEntity.getString("splittype");
                    if (SplitTypeEnum.TOTALAMTSPLIT.getValue().equals(splitType) || !StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) continue;
                    OutBudgetOpHelper.returnOccupyChangeAmount((DynamicObject)dataEntity, (String)"audit");
                }
                this.doAudit(dataEntities);
                break;
            }
            case "delete": {
                for (DynamicObject obj : dataEntities) {
                    this.deleteBudgetRecord(obj);
                }
                break;
            }
        }
    }

    protected void doSubmit(DynamicObject[] dataEntities) {
        for (DynamicObject obj : dataEntities) {
            BigDecimal version = obj.getBigDecimal("version");
            DynamicObject budgetStage = obj.getDynamicObject("budgetstage");
            DynamicObject project = obj.getDynamicObject("project");
            if (budgetStage != null && BigDecimal.valueOf(1.0).compareTo(version) == 0 && StringUtils.equals((CharSequence)budgetStage.getString("number"), (CharSequence)BudgetStageEnum.PREINSTALL_2.getValue())) {
                StageStatusHelper.changeStatus((DynamicObject)project, (ProjectStageEnum)ProjectStageEnum.FEASIBILITYSTUDYSTAGE_S, (ProjectStatusEnum)ProjectStatusEnum.APPROVAL_IN);
            }
            String budgetControlMode = obj.getString(BUDGET_CONTROL_MODE);
            String splitType = obj.getString("splittype");
            if (SplitTypeEnum.TOTALAMTSPLIT.getValue().equals(splitType)) continue;
            if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue())) {
                QFilter outFilter;
                QFilter validFilter;
                QFilter proFilter = new QFilter("project", "=", project.getPkValue());
                DynamicObject[] lastBillObjs = BusinessDataServiceHelper.load((String)OUTBUDGET_FORMID, (String)"id,year", (QFilter[])new QFilter[]{proFilter, validFilter = new QFilter("isvalid", "=", (Object)"1"), outFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue())}, (String)"year desc", (int)1);
                if (lastBillObjs.length <= 0) continue;
                DynamicObject lastBillObj = lastBillObjs[0];
                Date preBudgetDate = lastBillObj.getDate("year");
                Date budgetDate = obj.getDate("year");
                int curYear = budgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                int preYear = preBudgetDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                if (preYear != curYear) {
                    this.occupyChangeAmount(obj, "submit");
                    continue;
                }
                lastBillObj = OutBudgetOpHelper.getLastBillObj((DynamicObject)project, (String)"submit");
                this.occupyAmount(obj, lastBillObj, "submit");
                continue;
            }
            if (!StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) continue;
            this.occupyChangeAmount(obj, "submit");
        }
    }

    protected void saveBudgetRecord(DynamicObject dataEntity) {
        String billNo = dataEntity.getString("billno");
        Long pk = (Long)dataEntity.getPkValue();
        QFilter qFilter = pk == 0L ? new QFilter("billno", "=", (Object)billNo) : new QFilter("relatebillid", "=", (Object)pk.toString());
        DynamicObject budgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"billno, billstatus, creator, auditor, org, auditdate, createtime, modifytime, modifier, project, relatebillid, billsource, budgetstage, totalamount, group, currency, projectapplydate, budgetcontrolmode, projectcostcontrol, isvalid, description,year,realbudgetentry.id, realbudgetentry.seq, realbudgetentry.realprobudgetname, realbudgetentry.realbudgetitem, realbudgetentry.realundertakeorg, realbudgetentry.realundertakeperiod, realbudgetentry.realproname, realbudgetentry.realpronumber, realbudgetentry.realproid, realbudgetentry.realbeforeamt, realbudgetentry.realundertakeamt, realbudgetentry.realdifferenceamt", (QFilter[])new QFilter[]{qFilter});
        if (budgetRecord != null) {
            String billSource = budgetRecord.getString("billsource");
            if (StringUtils.equals((CharSequence)OUTBUDGET_FORMID, (CharSequence)billSource)) {
                OutBudgetOpHelper.setBudgetRecordFieldValue((DynamicObject)dataEntity, (DynamicObject)budgetRecord, (boolean)true);
            } else {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmco_budgetrecord");
                budgetRecord = new DynamicObject((DynamicObjectType)dt);
                budgetRecord.set("id", (Object)ORM.create().genLongId("pmco_budgetrecord"));
                OutBudgetOpHelper.setBudgetRecordFieldValue((DynamicObject)dataEntity, (DynamicObject)budgetRecord, (boolean)false);
            }
        } else {
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmco_budgetrecord");
            budgetRecord = new DynamicObject((DynamicObjectType)dt);
            budgetRecord.set("id", (Object)ORM.create().genLongId("pmco_budgetrecord"));
            OutBudgetOpHelper.setBudgetRecordFieldValue((DynamicObject)dataEntity, (DynamicObject)budgetRecord, (boolean)false);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{budgetRecord});
    }

    protected void occupyAmount(DynamicObject curObj, DynamicObject lastObj, String curOperate) {
        DynamicObject newBudgetRecord;
        DynamicObject lastBudgetRecord = null;
        String billNo = curObj.getString("billno");
        try {
            QFilter qFilter = new QFilter("relatebillid", "=", (Object)lastObj.getPkValue().toString());
            lastBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
            if (lastBudgetRecord != null) {
                String lastBillNo = lastBudgetRecord.getString("billno");
                String msg1 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u5bf9\u4e0a\u4e00\u5f20\u5355\u201c%3$s\u201d\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u8fd4\u8fd8\u64cd\u4f5c%4$s\uff1a", (String)"OutBudgetOp_15", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo, curOperate, lastBillNo, "unsubmitoccupy");
                BudgetCtrlHelper.returnBudget((DynamicObject)lastBudgetRecord, (String)"pmco_budgetrecord", (String)"unsubmitoccupy", (String)msg1);
            }
            String msg2 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%3$s\uff1a", (String)"OutBudgetOp_16", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo, curOperate, "submitoccupy");
            qFilter = new QFilter("relatebillid", "=", (Object)curObj.getPkValue().toString());
            newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno, relatebillid", (QFilter[])new QFilter[]{qFilter});
            if (newBudgetRecord == null) {
                qFilter = new QFilter("billno", "=", (Object)billNo);
                QFilter billSourceFilter = new QFilter("billsource", "=", (Object)OUTBUDGET_FORMID);
                newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno, relatebillid", (QFilter[])new QFilter[]{qFilter, billSourceFilter});
            }
            if (newBudgetRecord != null) {
                newBudgetRecord.set("relatebillid", (Object)curObj.getPkValue().toString());
                BudgetCtrlHelper.requestBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"submitoccupy", (boolean)true, (String)msg2);
            }
        }
        catch (Exception e) {
            if (lastBudgetRecord != null) {
                String lastBillNo = lastBudgetRecord.getString("billno");
                String msg3 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%3$s\uff1a\u53d1\u751f\u5f02\u5e38\uff0c\u5bf9\u4e0a\u4e00\u5f20\u5355\u201c%4$s\u201d\u91cd\u65b0\u5360\u7528\u3002", (String)"OutBudgetOp_17", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo, curOperate, "submitoccupy", lastBillNo);
                BudgetCtrlHelper.requestBudget((DynamicObject)lastBudgetRecord, (String)"pmco_budgetrecord", (String)"submitoccupy", (boolean)true, (String)msg3);
            }
            logger.error((Throwable)e);
            throw new KDBizException(e.toString());
        }
        if (newBudgetRecord != null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newBudgetRecord});
        }
    }

    protected void returnOccupyAmount(DynamicObject curObj, DynamicObject lastObj, String curOperate) {
        String billNo = curObj.getString("billno");
        DynamicObject lastBudgetRecord = null;
        try {
            String msg1 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u8fd4\u8fd8\u63a5\u53e3\u201cBgControlService.returnBudget\u201d\uff0c\u8fd4\u8fd8\u64cd\u4f5c%3$s\uff1a", (String)"OutBudgetOp_20", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo, curOperate, "unsubmitoccupy");
            QFilter qFilter = new QFilter("relatebillid", "=", (Object)curObj.getPkValue().toString());
            DynamicObject newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
            BudgetCtrlHelper.returnBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"unsubmitoccupy", (String)msg1);
            qFilter = new QFilter("relatebillid", "=", (Object)lastObj.getPkValue().toString());
            lastBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
            if (lastBudgetRecord != null) {
                String lastBillNo = lastBudgetRecord.getString("billno");
                String msg2 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u5bf9\u4e0a\u4e00\u5f20\u5355\u201c%3$s\u201d\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%4$s\uff1a", (String)"OutBudgetOp_18", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo, curOperate, lastBillNo, "submitoccupy");
                BudgetCtrlHelper.requestBudget((DynamicObject)lastBudgetRecord, (String)"pmco_budgetrecord", (String)"submitoccupy", (boolean)true, (String)msg2);
            }
        }
        catch (Exception e) {
            if (lastBudgetRecord != null) {
                String lastBillNo = lastBudgetRecord.getString("billno");
                String msg3 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u5bf9\u4e0a\u4e00\u5f20\u5355\u201c%3$s\u201d\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%4$s\uff1a\u53d1\u751f\u5f02\u5e38\u3002", (String)"OutBudgetOp_19", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo, curOperate, lastBillNo, "submitoccupy");
                logger.error(msg3);
            }
            logger.error((Throwable)e);
            throw new KDBizException(e.toString());
        }
    }

    protected void occupyChangeAmount(DynamicObject curObj, String curOperate) {
        DynamicObject newBudgetRecord;
        String billNo = curObj.getString("billno");
        try {
            String msg1 = String.format(ResManager.loadKDString((String)"\u652f\u51fa\u9884\u7b97\u5355\u201c%1$s\u201d%2$s\u64cd\u4f5c\uff0c\u8c03\u7528\u4f01\u4e1a\u7ee9\u6548\u4e91\u201c\u9884\u7b97\u6263\u51cf\u63a5\u53e3\u201cBgControlService.requestBudget\u201d\u505a\u5360\u7528\uff0c\u5360\u7528\u64cd\u4f5c%3$s\uff1a", (String)"OutBudgetOp_16", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]), billNo, curOperate, "submitoccupy");
            QFilter qFilter = new QFilter("relatebillid", "=", (Object)curObj.getPkValue().toString());
            newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno, relatebillid", (QFilter[])new QFilter[]{qFilter});
            if (newBudgetRecord == null) {
                qFilter = new QFilter("billno", "=", (Object)billNo);
                QFilter billSourceFilter = new QFilter("billsource", "=", (Object)OUTBUDGET_FORMID);
                newBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno, relatebillid", (QFilter[])new QFilter[]{qFilter, billSourceFilter});
            }
            if (newBudgetRecord != null) {
                newBudgetRecord.set("relatebillid", (Object)curObj.getPkValue().toString());
                BudgetCtrlHelper.requestBudget((DynamicObject)newBudgetRecord, (String)"pmco_budgetrecord", (String)"submitoccupy", (boolean)true, (String)msg1);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.toString());
        }
        if (newBudgetRecord != null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newBudgetRecord});
        }
    }

    protected void doAudit(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> updateObjs = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> auditObjs = new ArrayList<DynamicObject>(10);
        ArrayList updateProjectItems = new ArrayList();
        ArrayList addProjectItems = new ArrayList();
        for (DynamicObject obj : dataEntities) {
            DynamicObjectCollection treeEntryEntity;
            DynamicObject project = obj.getDynamicObject("project");
            QFilter proFilter = new QFilter("project", "=", project.getPkValue());
            QFilter isValid = new QFilter("isvalid", "=", (Object)"1");
            QFilter yearValid = new QFilter("year", "=", (Object)obj.getDate("year"));
            QFilter sourceTypeFilter = new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            DynamicObject[] validObjs = BusinessDataServiceHelper.load((String)"pmas_budget", (String)"id,billno,isvalid", (QFilter[])new QFilter[]{proFilter, isValid, sourceTypeFilter, yearValid});
            if (validObjs.length > 0) {
                for (DynamicObject budget : validObjs) {
                    budget.set("isvalid", (Object)DefaultEnum.NO.getValue());
                    updateObjs.add(budget);
                }
            }
            obj.set("isvalid", (Object)DefaultEnum.YES.getValue());
            String budgetControlMode = obj.getString(BUDGET_CONTROL_MODE);
            String splitType = obj.getString("splittype");
            if (!SplitTypeEnum.TOTALAMTSPLIT.getValue().equals(splitType) && StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue()) && !(treeEntryEntity = obj.getDynamicObjectCollection("treeentryentity")).isEmpty()) {
                OutBudgetOpHelper.generateAdjustForm((DynamicObject)obj, (BudgetCtrlEnum)BudgetCtrlEnum.AUDIT);
            }
            auditObjs.add(obj);
            boolean isNew = ProBudgetControlHelper.checkIsNewProBudgetCtrl((Long)Long.parseLong(project.getPkValue().toString()));
            if (isNew) {
                ProjectBudgetGenerateHelper.generateProjectBudget((DynamicObject)obj, updateProjectItems, addProjectItems, (String)BudgetSourceTypeEnum.OUT.getValue());
            } else {
                DynamicObject projectApproval = new BudgetBillHelper().getProApprovalInfo(Long.valueOf(Long.parseLong(project.getPkValue().toString())));
                if (projectApproval != null) {
                    if (ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue().equals(projectApproval.getString("probudgetctrl"))) {
                        ProjectBudgetGenerateHelper.generateProjectBudget((DynamicObject)obj, updateProjectItems, addProjectItems, (String)BudgetSourceTypeEnum.OUT.getValue());
                    }
                } else {
                    ProjectBudgetGenerateHelper.generateProjectBudget((DynamicObject)obj, updateProjectItems, addProjectItems, (String)BudgetSourceTypeEnum.OUT.getValue());
                }
            }
            DynamicObject lastBillObj = OutBudgetOpHelper.getLastBillObj((DynamicObject)project, (String)"audit");
            if (!SplitTypeEnum.TOTALAMTSPLIT.getValue().equals(splitType)) {
                OutBudgetOpHelper.updateBudgetRecordField((DynamicObject)obj, (DynamicObject)lastBillObj, (String)"audit");
            }
            if (!updateProjectItems.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)updateProjectItems.get(0)).getDataEntityType(), (Object[])updateProjectItems.toArray(new DynamicObject[0]));
            }
            if (!addProjectItems.isEmpty()) {
                SaveServiceHelper.save((IDataEntityType)((DynamicObject)addProjectItems.get(0)).getDataEntityType(), (Object[])addProjectItems.toArray(new DynamicObject[0]));
            }
            if (!auditObjs.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])auditObjs.toArray(new DynamicObject[0]));
            }
            if (isNew) {
                ProBudgetControlHelper.updateYearBudgetCtrlData((DynamicObject)obj);
                ProBudgetControlHelper.updateTotalBudgetCtrlByYearBudget((DynamicObject)obj);
            }
            if (updateObjs.isEmpty()) continue;
            SaveServiceHelper.update((DynamicObject[])updateObjs.toArray(new DynamicObject[0]));
        }
    }

    protected void deleteBudgetRecord(DynamicObject dataEntity) {
        String budgetControlMode = dataEntity.getString(BUDGET_CONTROL_MODE);
        if (!StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue()) && !StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
            return;
        }
        QFilter qFilter = new QFilter("relatebillid", "=", (Object)dataEntity.getPkValue().toString());
        DynamicObject curBudgetRecord = BusinessDataServiceHelper.loadSingle((String)"pmco_budgetrecord", (String)"id, billno", (QFilter[])new QFilter[]{qFilter});
        if (curBudgetRecord != null) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmco_budgetrecord"), (Object[])new Object[]{curBudgetRecord.getPkValue()});
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "submit": {
                for (DynamicObject dataEntity : dataEntities) {
                    BigDecimal totalamount = dataEntity.getBigDecimal("totalamount");
                    String budgetControlMode = dataEntity.getString(BUDGET_CONTROL_MODE);
                    String splitType = dataEntity.getString("splittype");
                    if (SplitTypeEnum.TOTALAMTSPLIT.getValue().equals(splitType)) continue;
                    if (StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue())) {
                        if (totalamount.compareTo(BigDecimal.ZERO) <= 0) continue;
                        DynamicObjectCollection treeEntryEntity = dataEntity.getDynamicObjectCollection("treeentryentity");
                        if (treeEntryEntity.isEmpty()) {
                            e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u4f01\u4e1a\u9884\u7b97\u63a7\u5236\u65b9\u5f0f\u4e3a\u201c\u53d7\u63a7\uff0c\u7acb\u9879\u65f6\u8c03\u5242\u201d\uff0c\u8bf7\u5148\u586b\u5199\u660e\u7ec6\u652f\u51fa\u9884\u7b97\u9879\u91d1\u989d\uff0c\u518d\u63d0\u4ea4\u3002", (String)"OutBudgetOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                            e.setCancel(true);
                            continue;
                        }
                        OutBudgetOpHelper.validateBudgetBalance((DynamicObject)dataEntity, (String)DefaultEnum.YES.getValue());
                        this.saveBudgetRecord(dataEntity);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDOCCUPY.getValue()) || totalamount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    DynamicObjectCollection realBudgetEntry = dataEntity.getDynamicObjectCollection(REALBUDGETENTRY);
                    if (realBudgetEntry.isEmpty()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u4f01\u4e1a\u9884\u7b97\u63a7\u5236\u65b9\u5f0f\u4e3a\u201c\u53d7\u63a7\uff0c\u7acb\u9879\u65f6\u5360\u7528\u201d\uff0c\u8bf7\u5148\u586b\u5199\u660e\u7ec6\u652f\u51fa\u9884\u7b97\u9879\u91d1\u989d\uff0c\u518d\u63d0\u4ea4\u3002", (String)"OutBudgetOp_7", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    }
                    this.saveBudgetRecord(dataEntity);
                }
                break;
            }
            case "audit": {
                for (DynamicObject obj : dataEntities) {
                    DynamicObjectCollection treeEntryEntity;
                    BigDecimal totalamount = obj.getBigDecimal("totalamount");
                    String budgetControlMode = obj.getString(BUDGET_CONTROL_MODE);
                    String splitType = obj.getString("splittype");
                    if (SplitTypeEnum.TOTALAMTSPLIT.getValue().equals(splitType) || !StringUtils.equals((CharSequence)budgetControlMode, (CharSequence)BudgetCtlModeEnum.CONTROLANDADJUST.getValue()) || totalamount.compareTo(BigDecimal.ZERO) <= 0 || !(treeEntryEntity = obj.getDynamicObjectCollection("treeentryentity")).isEmpty()) continue;
                    e.setCancelMessage(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u4f01\u4e1a\u9884\u7b97\u63a7\u5236\u65b9\u5f0f\u4e3a\u201c\u53d7\u63a7\uff0c\u7acb\u9879\u65f6\u8c03\u5242\u201d\uff0c\u8bf7\u5148\u586b\u5199\u660e\u7ec6\u652f\u51fa\u9884\u7b97\u9879\u91d1\u989d\uff0c\u518d\u63d0\u4ea4\u3002", (String)"OutBudgetOp_6", (String)"pmgt-pmas-opplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                break;
            }
        }
    }
}

