/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.base;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.org.model.EnableEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmbs.formplugin.base.AbstractPmgtTreeListPlugin;

public abstract class AbstractGroupTreeListPlugin
extends AbstractPmgtTreeListPlugin {
    protected static final String SELECTED_TAG_KEY = "selected_tag_key";
    protected static final String KEY_SEARCHAP = "searchap";
    protected static final String all_id = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    protected static final String KEY_TREEVIEWAP = "treeview";
    protected static final String FOCUSNODE_KEY = "focusnode_key";

    public void refreshNode(RefreshNodeEvent e) {
        List<TreeNode> treeNodes = this.getDirectChildrenNodes(e.getNodeId().toString());
        e.setChildNodes(treeNodes);
    }

    public abstract String getGroupName();

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
        }
    }

    public void setFilter(SetFilterEvent e) {
        IPageCache pageCache = this.getPageCache();
        String nodeid = pageCache.get(FOCUSNODE_KEY);
        TreeNode focusNode = new TreeNode();
        if (nodeid == null) {
            nodeid = all_id;
        }
        focusNode.setId(nodeid);
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEWAP);
        if (treeView != null) {
            treeView.focusNode(focusNode);
        }
    }

    public void expendTreeNode(TreeNodeEvent e) {
        String nodeId = (String)e.getNodeId();
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        if (node != null) {
            node.setIsOpened(true);
            e.setExpandedNode(node);
        }
    }

    protected List<TreeNode> getDirectChildrenNodes(Object id) {
        this.getPageCache().get("");
        if (all_id.equals(id)) {
            id = "0";
        }
        DynamicObject[] nodes = this.getGroupNodesByParent(id, this.getGroupName());
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(nodes.length);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.Enable);
        Set parentIdSet = Arrays.stream(nodes).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection childCol = QueryServiceHelper.query((String)this.getGroupName(), (String)"id,name,parent", (QFilter[])new QFilter[]{new QFilter("parent", "in", parentIdSet), enableFilter});
        Set childRenIsParentSet = childCol.stream().map(obj -> obj.getLong("parent")).collect(Collectors.toSet());
        for (DynamicObject node : nodes) {
            TreeNode treeNode = new TreeNode();
            treeNode.setId(node.getString("id"));
            treeNode.setParentid(node.getDynamicObject("parent") != null ? String.valueOf(node.getDynamicObject("parent").getPkValue()) : "");
            treeNode.setText(node.getString("name"));
            if (childRenIsParentSet.contains(node.getLong("id"))) {
                treeNode.addChildren(new ArrayList());
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    public DynamicObject[] getGroupNodesByParent(Object id, String entityName) {
        long longID = StringUtils.isNotBlank((Object)id) ? Long.parseLong(String.valueOf(id)) : 0L;
        QFilter parentFilter = new QFilter("parent", "=", (Object)longID);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.Enable);
        QFilter[] filters = new QFilter[]{parentFilter, enableFilter, this.getCustomQFilter()};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)"id,name,parent", (QFilter[])filters);
        Arrays.sort(dynamicObjects, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Collator instance = Collator.getInstance();
                String source = o1.getLocaleString("name").getLocaleValue() != null ? o1.getLocaleString("name").getLocaleValue() : "";
                String target = o2.getLocaleString("name").getLocaleValue() != null ? o2.getLocaleString("name").getLocaleValue() : "";
                return instance.compare(source, target);
            }
        });
        return dynamicObjects;
    }

    public abstract QFilter getCustomQFilter();

    protected List<TreeNode> getSearchGroup(String searchText) {
        QFilter qFilter2 = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection datas = QueryServiceHelper.query((String)this.getGroupName(), (String)"id,number,name,parent,isleaf", (QFilter[])new QFilter[]{qFilter2, qFilter3}, (String)"number");
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(datas.size());
        for (DynamicObject group : datas) {
            if (group.getLong("id") == 0L) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getString("id"));
            long parent = group.getLong("parent");
            treeNode.setText(group.getString("name"));
            treeNode.setParentid(parent == 0L ? all_id : group.getString("parent"));
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    private List<String> getParentGroupId(String groupId, List<String> parentIds) {
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(groupId), (String)this.getGroupName(), (String)"parent");
        DynamicObject parent = group.getDynamicObject("parent");
        if (parent != null) {
            if (parent.getString("id").equals(groupId)) {
                return parentIds;
            }
            parentIds.add(parent.getString("id"));
            parentIds = this.getParentGroupId(parent.getString("id"), parentIds);
        }
        return parentIds;
    }

    public void search(SearchEnterEvent arg0) {
        Search search = (Search)arg0.getSource();
        String searchText = arg0.getText();
        if (KEY_SEARCHAP.equals(search.getKey())) {
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                this.doSearch(arg0);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u7d22\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractGroupTreeListPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
    }

    public void doSearch(SearchEnterEvent evt) {
        List<Object> treeNodes;
        String searchText = evt.getText();
        IPageCache pageCache = this.getPageCache();
        String searchNodesCacheKey = this.getView().getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if ((oldSearchText == null || oldSearchText.equals(searchText)) && !StringUtils.isBlank((CharSequence)matchNodesCache)) {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        } else {
            treeNodes = this.getSearchGroup(searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        }
        if (treeNodes.isEmpty()) {
            treeNodes = this.getSearchGroup(searchText);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u641c\u7d22\u5df2\u5b8c\u6210\uff0c\u672a\u627e\u5230\u5339\u914d\u9879\u3002", (String)"AbstractGroupTreeListPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
        } else {
            TreeView treeView = this.getTreeListView().getTreeView();
            if (!StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                treeView.showNode(treeNodes.get(0).getParentid());
                treeView.focusNode(treeNodes.get(0));
                treeView.treeNodeClick(treeNodes.get(0).getParentid(), treeNodes.get(0).getId());
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            } else {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache >= treeNodes.size()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"AbstractGroupTreeListPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                } else {
                    TreeNode treeNode = treeNodes.get(indexCache);
                    String parentId = treeNode.getParentid();
                    List<String> parentIds = new ArrayList<String>();
                    if (all_id.equals(parentId)) {
                        parentIds.add("0");
                    } else {
                        parentIds = this.getParentGroupId(parentId, parentIds);
                    }
                    if (parentIds.size() <= 1) {
                        treeView.showNode(treeNodes.get(indexCache).getParentid());
                        treeView.focusNode(treeNodes.get(indexCache));
                        treeView.treeNodeClick(treeNodes.get(indexCache).getParentid(), treeNodes.get(indexCache).getId());
                        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                    } else {
                        for (int i = parentIds.size(); i >= 1; --i) {
                            if (i == 1) {
                                treeView.showNode(parentIds.get(i - 1));
                                treeView.focusNode(treeNodes.get(indexCache));
                                treeView.treeNodeClick(treeNodes.get(indexCache).getParentid(), treeNodes.get(indexCache).getId());
                                break;
                            }
                            treeView.showNode(parentIds.get(i - 1));
                            treeView.treeNodeClick(parentIds.get(i - 1), parentIds.get(i - 2));
                        }
                        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                    }
                }
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    protected Set<Object> getChildrenNodes(Object id) {
        Long nodeID = Long.valueOf(id.toString());
        HashSet<Object> childrenids = new HashSet<Object>(16);
        childrenids.add(nodeID);
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableEnum.Enable);
        DynamicObject[] ecbdResources = BusinessDataServiceHelper.load((String)this.getGroupName(), (String)"id,parent", (QFilter[])new QFilter[]{enableFilter});
        HashMap<Long, Set> parentChildrenMap = new HashMap<Long, Set>(16);
        for (DynamicObject ecbdResource : ecbdResources) {
            long resourceId = ecbdResource.getLong("id");
            long parentId = ecbdResource.getLong("parent_id");
            Set childRenSet = parentChildrenMap.getOrDefault(parentId, new HashSet());
            childRenSet.add(resourceId);
            parentChildrenMap.put(parentId, childRenSet);
        }
        LinkedList<Long> parentQueue = new LinkedList<Long>();
        parentQueue.offer(nodeID);
        while (!parentQueue.isEmpty()) {
            Long parentId = (Long)parentQueue.poll();
            Set childRenSet = (Set)parentChildrenMap.get(parentId);
            if (childRenSet == null) continue;
            parentQueue.addAll(childRenSet);
            childrenids.addAll(childRenSet);
        }
        return childrenids;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (KEY_TREEVIEWAP.equals(key)) {
            Object nodeId = evt.getNodeId();
            DynamicObject node = null;
            if (!all_id.equals(nodeId)) {
                node = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)this.getGroupName());
            }
            String nodeIdStr = evt.getNodeId().toString();
            if (!"1".equals(nodeId)) {
                this.treeListView.getTreeView().queryTreeNodeChildren(evt.getParentNodeId().toString(), nodeIdStr);
            }
            if (node != null) {
                IPageCache pageCache = this.getPageCache();
                pageCache.put(FOCUSNODE_KEY, nodeId.toString());
            } else if (all_id.equals(nodeId)) {
                IPageCache pageCache = this.getPageCache();
                pageCache.put(FOCUSNODE_KEY, null);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u5df2\u4e0d\u5b58\u5728\u3002", (String)"AbstractGroupTreeListPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

