/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.budget;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasFormPlugin;
import kd.pmgt.pmbs.business.helper.ProBudgetControlHelper;
import kd.pmgt.pmbs.common.enums.ProBudgetCtrlEnums;

public class BudgetDetailFormPlugin
extends AbstractPmasFormPlugin
implements HyperLinkClickListener {
    private static final String ENTRY_PERFORMENTRY = "performentry";
    private static final String PARAM_BUGETID = "budgetId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_PERFORMENTRY);
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long budgetId = (Long)this.getView().getFormShowParameter().getCustomParam(PARAM_BUGETID);
        if (budgetId == null || budgetId == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u9884\u7b97\u9879\u4f20\u5165ID\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BudgetDetailFormPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject proBudget = BusinessDataServiceHelper.loadSingle((Object)budgetId, (String)"pmas_projectbudget");
        if (proBudget != null) {
            this.getModel().setValue("number", proBudget.get("number"));
            this.getModel().setValue("name", proBudget.get("name"));
            this.getModel().setValue("sourcetype", proBudget.get("sourcetype"));
            DynamicObject project = proBudget.getDynamicObject("project");
            this.getModel().setValue("project", (Object)project);
            if (project != null) {
                DynamicObject tBudgetControl = this.getTotalBudgetControl(project.getPkValue(), budgetId);
                DynamicObject yBudgetControl = this.getYearBudgetControl(project.getPkValue(), budgetId);
                this.loadBaseInfo(budgetId, project.getPkValue(), tBudgetControl);
                this.loadMonitorData(tBudgetControl, yBudgetControl);
                this.loadPerformData(budgetId);
            }
        }
    }

    protected void loadBaseInfo(Long budgetId, Object projectId, DynamicObject tBudgetControl) {
        QFilter qFilter = new QFilter("project", "=", projectId);
        qFilter.and(new QFilter("isvalid", "=", (Object)true));
        DynamicObject totalBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_totalbudget", (QFilter[])new QFilter[]{qFilter});
        if (totalBudget != null) {
            this.getModel().setValue("budgetstage", totalBudget.get("budgetstage"));
            this.getModel().setValue("currency", totalBudget.get("currency"));
            DynamicObjectCollection budgetEntries = totalBudget.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject budgetEntry : budgetEntries) {
                DynamicObject proBudget = budgetEntry.getDynamicObject("projectbudgetitem");
                if (proBudget == null || !budgetId.equals(proBudget.getPkValue())) continue;
                this.getModel().setValue("viamount", budgetEntry.get("viamount"));
                this.getModel().setValue("budgetamount", budgetEntry.get("budgetamount"));
                this.getModel().setValue("vichangeamount", budgetEntry.get("vichangeamount"));
                this.getModel().setValue("budgetitem", budgetEntry.get("budgetitem"));
                this.getModel().setValue("description", budgetEntry.get("descriptionentry"));
            }
        }
        if (tBudgetControl != null) {
            this.getModel().setValue("occupyamt", (Object)tBudgetControl.getBigDecimal("occupyamt"));
            this.getModel().setValue("performamt", (Object)tBudgetControl.getBigDecimal("usageamt"));
            this.getModel().setValue("siamount", (Object)tBudgetControl.getBigDecimal("sumbudamt"));
            BigDecimal budgetAmount = (BigDecimal)this.getModel().getValue("budgetamount");
            BigDecimal remainAmt = budgetAmount.subtract(tBudgetControl.getBigDecimal("usageamt"));
            this.getModel().setValue("remainamt", (Object)remainAmt);
            if (budgetAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.getModel().setValue("remainrate", (Object)remainAmt.divide(budgetAmount, 10, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)));
            }
        }
    }

    protected void loadMonitorData(DynamicObject tBudgetControl, DynamicObject yBudgetControl) {
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if (project != null) {
            ProBudgetCtrlEnums budgetControlType = ProBudgetControlHelper.getProjectBudgetControlType((DynamicObject)project);
            this.getModel().setValue("probudgetctrl", (Object)budgetControlType.getValue());
            if (yBudgetControl != null) {
                this.getModel().setValue("budgetamt", (Object)yBudgetControl.getBigDecimal("budgetamt"));
                this.getModel().setValue("yearperformamt", (Object)yBudgetControl.getBigDecimal("usageamt"));
            }
            if (ProBudgetCtrlEnums.CTRL_YEARBUDGET.getValue().equals(budgetControlType.getValue())) {
                if (yBudgetControl != null) {
                    BigDecimal budgetAmt = (BigDecimal)this.getModel().getValue("budgetamt");
                    BigDecimal remindRate = yBudgetControl.getBigDecimal("remindrate");
                    BigDecimal controlRate = yBudgetControl.getBigDecimal("controlrate");
                    this.getModel().setValue("remindrate", (Object)yBudgetControl.getBigDecimal("remindrate"));
                    this.getModel().setValue("controlrate", (Object)yBudgetControl.getBigDecimal("controlrate"));
                    this.getModel().setValue("remindamt", (Object)(remindRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(remindRate.divide(BigDecimal.valueOf(100L))) : BigDecimal.ZERO));
                    this.getModel().setValue("controlamt", (Object)(controlRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(controlRate.divide(BigDecimal.valueOf(100L))) : BigDecimal.ZERO));
                }
            } else if (ProBudgetCtrlEnums.CTRL_OVERALLBUDGET.getValue().equals(budgetControlType.getValue())) {
                if (tBudgetControl != null) {
                    BigDecimal budgetAmt = (BigDecimal)this.getModel().getValue("siamount");
                    BigDecimal remindRate = tBudgetControl.getBigDecimal("remindrate");
                    BigDecimal controlRate = tBudgetControl.getBigDecimal("controlrate");
                    this.getModel().setValue("remindrate", (Object)remindRate);
                    this.getModel().setValue("controlrate", (Object)controlRate);
                    this.getModel().setValue("remindamt", (Object)(remindRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(remindRate.divide(BigDecimal.valueOf(100L))) : BigDecimal.ZERO));
                    this.getModel().setValue("controlamt", (Object)(controlRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(controlRate.divide(BigDecimal.valueOf(100L))) : BigDecimal.ZERO));
                }
            } else if (ProBudgetCtrlEnums.CTRL_SUMYEARBUDGET.getValue().equals(budgetControlType.getValue()) && tBudgetControl != null) {
                BigDecimal budgetAmt = (BigDecimal)this.getModel().getValue("budgetamount");
                BigDecimal remindRate = tBudgetControl.getBigDecimal("remindrate");
                BigDecimal controlRate = tBudgetControl.getBigDecimal("controlrate");
                this.getModel().setValue("remindrate", (Object)remindRate);
                this.getModel().setValue("controlrate", (Object)controlRate);
                this.getModel().setValue("remindamt", (Object)(remindRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(remindRate.divide(BigDecimal.valueOf(100L))) : BigDecimal.ZERO));
                this.getModel().setValue("controlamt", (Object)(controlRate.compareTo(BigDecimal.ZERO) > 0 ? budgetAmt.multiply(controlRate.divide(BigDecimal.valueOf(100L))) : BigDecimal.ZERO));
            }
        }
    }

    protected void loadPerformData(Object budgetId) {
        DynamicObject[] performRecords;
        this.getModel().deleteEntryData(ENTRY_PERFORMENTRY);
        DynamicObjectCollection performEntry = this.getModel().getEntryEntity(ENTRY_PERFORMENTRY);
        QFilter qFilter = new QFilter("probudget", "=", budgetId);
        qFilter.and(new QFilter("iseffect", "=", (Object)true));
        String selectProperties = String.join((CharSequence)",", "optype", "opaction", "bizbillname", "bizbillmark", "billno", "billname", "oriamount", "oricurrency", "currency", "amount", "bizuser", "optime", "billid");
        for (DynamicObject performRecord : performRecords = BusinessDataServiceHelper.load((String)"pmas_budgetexerecord", (String)selectProperties, (QFilter[])new QFilter[]{qFilter}, (String)"optime desc")) {
            DynamicObject newEntry = new DynamicObject(performEntry.getDynamicObjectType());
            newEntry.set("optype", (Object)performRecord.getString("optype"));
            newEntry.set("opaction", (Object)performRecord.getString("opaction"));
            newEntry.set("entrybilltype", (Object)performRecord.getString("bizbillmark"));
            newEntry.set("entrybilltypename", (Object)performRecord.getString("bizbillname"));
            newEntry.set("entrybillno", (Object)performRecord.getString("billno"));
            newEntry.set("entrybillname", (Object)performRecord.getString("billname"));
            newEntry.set("oricurrency", (Object)performRecord.getDynamicObject("oricurrency"));
            newEntry.set("oriamount", (Object)performRecord.getBigDecimal("oriamount"));
            newEntry.set("entrycurrency", (Object)performRecord.getDynamicObject("currency"));
            newEntry.set("entryamount", (Object)performRecord.getBigDecimal("amount"));
            newEntry.set("billoperator", (Object)performRecord.getDynamicObject("bizuser"));
            newEntry.set("billoperadate", (Object)performRecord.getDate("optime"));
            newEntry.set("entrybillid", (Object)performRecord.getLong("billid"));
            performEntry.add((Object)newEntry);
        }
        this.getModel().updateEntryCache(performEntry);
        this.getView().updateView(ENTRY_PERFORMENTRY);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"refresh", (CharSequence)operateKey)) {
            this.getView().updateView();
        } else if (StringUtils.equals((CharSequence)"close", (CharSequence)operateKey)) {
            this.getView().getParentView().invokeOperation("close");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_PERFORMENTRY);
        int rowIndex = event.getRowIndex();
        if ("entrybillno".equals(fieldName)) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId(((DynamicObject)entryEntity.get(rowIndex)).get("entrybillid"));
            showParameter.setFormId(((DynamicObject)entryEntity.get(rowIndex)).getString("entrybilltype"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private DynamicObject getTotalBudgetControl(Object projectId, Long budgetId) {
        QFilter qFilter = new QFilter("budget", "=", (Object)budgetId);
        qFilter.and("project", "=", projectId);
        return BusinessDataServiceHelper.loadSingle((String)"pmas_tbudgetctrldetail", (QFilter[])new QFilter[]{qFilter});
    }

    private DynamicObject getYearBudgetControl(Object projectId, Long budgetId) {
        QFilter qFilter = new QFilter("budget", "=", (Object)budgetId);
        qFilter.and("project", "=", projectId);
        return BusinessDataServiceHelper.loadSingle((String)"pmas_ybudgetctrldetail", (QFilter[])new QFilter[]{qFilter});
    }
}

