/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.budget;

import java.util.HashMap;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasListPlugin;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;

public class BudgetListPlugin
extends AbstractPmasListPlugin {
    private static final String ADJUST_OP = "adjust";
    private static final String PROJECTCACHE = "ProjectPermListPlugin_projectId";

    public void setFilter(SetFilterEvent e) {
        QFilter sourceTypeFilter = this.getSourceTypeFilter();
        if (sourceTypeFilter != null) {
            e.getQFilters().add(sourceTypeFilter);
        }
        if (this.getControlFilters().getFilter("org.id").size() == 0) {
            e.setMainOrgQFilter(null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate opertate = (FormOperate)args.getSource();
        String operateKey = opertate.getOperateKey();
        String projectId = this.getPageCache().get(PROJECTCACHE);
        switch (operateKey) {
            case "new": {
                DynamicObjectCollection budgets;
                if (!StringUtils.isNotEmpty((CharSequence)projectId)) break;
                QFilter filter = new QFilter("project", "=", (Object)Long.valueOf(projectId));
                QFilter sourceTypeFilter = this.getSourceTypeFilter();
                if (sourceTypeFilter != null) {
                    filter.and(sourceTypeFilter);
                }
                if ((budgets = QueryServiceHelper.query((String)"pmas_budget", (String)"id,name,billno,billstatus", (QFilter[])new QFilter[]{filter})).isEmpty()) break;
                this.getPageCache().remove(PROJECTCACHE);
                break;
            }
            case "adjust": {
                QFilter sourceFilter;
                String billStatus;
                IListView view = (IListView)this.getView();
                ListSelectedRowCollection selectedRows = view.getSelectedRows().getBillListSelectedRowCollection();
                if (selectedRows != null && selectedRows.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u8c03\u6574\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"BudgetListPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String string = billStatus = selectedRows != null ? selectedRows.get(0).getBillStatus() : null;
                if (!"C".equals(billStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5df2\u5ba1\u6279\u7684\u6570\u636e\u3002", (String)"BudgetListPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
                DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"pmas_budget");
                DynamicObject project = budget.getDynamicObject("project");
                Object projectid = project.getPkValue();
                boolean isValid = budget.getBoolean("isvalid");
                Object orgId = budget.getDynamicObject("org").getPkValue();
                QFilter projFilter = new QFilter("project", "=", projectid);
                QFilter unauditFilter = new QFilter("billstatus", "!=", (Object)BillStatus.C.name());
                DynamicObjectCollection unAudit = QueryServiceHelper.query((String)"pmas_budget", (String)"id,name,billno,billstatus", (QFilter[])new QFilter[]{projFilter, unauditFilter, sourceFilter = this.getSourceTypeFilter()});
                if (unAudit.size() > 0 || !isValid) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7248\u672c\u4e0d\u662f\u751f\u6548\u7248\u672c\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574\u3002", (String)"BudgetListPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                DynamicObject proStatus = project.getDynamicObject("prostatus");
                String proStatusNumber = "";
                if (proStatus != null) {
                    proStatusNumber = proStatus.getString("number");
                }
                if (proStatusNumber.equals(ProjectStatusEnum.BUSSINESS_CLOSE.getValue()) || proStatusNumber.equals(ProjectStatusEnum.FINANCIAL_CLOSE.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u201c\u4e1a\u52a1\u5173\u95ed\u201d\u6216\u201c\u8d22\u52a1\u5173\u95ed\u201d\uff0c\u65e0\u6cd5\u8fdb\u884c\u8c03\u6574\u3002", (String)"BudgetListPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
                String billFormId = listShowParameter.getBillFormId();
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("formId", billFormId);
                param.put("adjustId", primaryKeyValue);
                param.put("projectId", projectid);
                param.put("orgId", orgId);
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String projectId = this.getPageCache().get(PROJECTCACHE);
        if (StringUtils.isNotEmpty((CharSequence)projectId)) {
            e.getParameter().getCustomParams().put("projectId", projectId);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object budgetId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        String billFormId = billList.getBillFormId();
        String fieldName = args.getFieldName();
        if ("project_name".equals(fieldName)) {
            args.setCancel(true);
            DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)budgetId, (String)billFormId);
            QFilter qFilter = new QFilter("pro", "=", budget.getDynamicObject("project").getPkValue());
            qFilter.and(new QFilter("billstatus", "!=", (Object)"A"));
            DynamicObject[] projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (projectApprovals != null && projectApprovals.length > 0) {
                HashMap<String, Object> custormMap = new HashMap<String, Object>();
                custormMap.put("proAppId", projectApprovals[0].getPkValue());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("formId", "pmba_projectkanban");
                map.put("customParams", custormMap);
                FormShowParameter showParameter = BillShowParameter.createFormShowParameter(map);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
            }
        }
    }

    private QFilter getSourceTypeFilter() {
        String billFormId;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        switch (billFormId = listShowParameter.getBillFormId()) {
            case "pmas_inbudget": {
                return new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.IN.getValue());
            }
            case "pmas_outbudget": {
                return new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.OUT.getValue());
            }
            case "pmas_totalbudget": {
                return new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.TOTAL.getValue());
            }
        }
        return null;
    }
}

