/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.budget;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasFormPlugin;

public class SelectBudgetEntryPlugin
extends AbstractPmasFormPlugin {
    protected static final String KEY_FORMID = "key_formId";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        IDataModel parentViewModel = parentView.getModel();
        String parentViewEntityId = (String)this.getView().getFormShowParameter().getCustomParams().get(KEY_FORMID);
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
        DynamicObjectType dynamicObjectType = entryCol.getDynamicObjectType();
        if (StringUtils.equals((CharSequence)"pmas_pro_approval", (CharSequence)parentViewEntityId)) {
            DynamicObjectCollection budgetOutEntryCol = parentViewModel.getEntryEntity("budgetout");
            for (DynamicObject entry : budgetOutEntryCol) {
                long pid = entry.getLong("pid");
                if (pid != 0L) continue;
                DynamicObject newEntry = new DynamicObject(dynamicObjectType);
                newEntry.set("probudgetitemname", entry.get("outitemname"));
                newEntry.set("budgetitem", entry.get("outitem"));
                entryCol.add((Object)newEntry);
            }
        } else if (StringUtils.equals((CharSequence)"pmas_approval_amtmodify", (CharSequence)parentViewEntityId)) {
            DynamicObject project = (DynamicObject)parentViewModel.getValue("project");
            QFilter qFilter = new QFilter("pro", "=", project.getPkValue());
            DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((String)"pmas_pro_approval", (QFilter[])new QFilter[]{qFilter});
            if (projectApproval != null) {
                DynamicObjectCollection budgetOutEntryCol = projectApproval.getDynamicObjectCollection("budgetout");
                for (DynamicObject entry : budgetOutEntryCol) {
                    long pid = entry.getLong("pid");
                    if (pid != 0L) continue;
                    DynamicObject newEntry = new DynamicObject(dynamicObjectType);
                    newEntry.set("probudgetitemname", entry.get("outitemname"));
                    newEntry.set("budgetitem", entry.get("outitem"));
                    entryCol.add((Object)newEntry);
                }
            }
        } else {
            DynamicObjectCollection treeentryentity = parentViewModel.getEntryEntity("treeentryentity");
            for (DynamicObject entry : treeentryentity) {
                long pid = entry.getLong("pid");
                if (pid != 0L) continue;
                DynamicObject newEntry = new DynamicObject(dynamicObjectType);
                newEntry.set("probudgetitemname", entry.get("budgetitemname"));
                newEntry.set("budgetitem", entry.get("budgetitem"));
                newEntry.set("probudgetitem", entry.get("projectbudgetitem"));
                entryCol.add((Object)newEntry);
            }
        }
        this.getModel().updateEntryCache(entryCol);
        this.getView().updateView("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid;
        int[] selectRows;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)operateKey) && (selectRows = (entryGrid = (EntryGrid)this.getControl("entryentity")).getSelectRows()).length != 0) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", selectRows[0]);
            this.getView().returnDataToParent((Object)entryRowEntity);
            this.getView().close();
        }
    }
}

