/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.fund;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasBillPlugin;
import kd.pmgt.pmbs.business.helper.FileAttachmentHelper;
import kd.pmgt.pmbs.common.enums.BillTypeEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.ProjectPermissionHelper;

public class FundSourceBillPlugin
extends AbstractPmasBillPlugin
implements BeforeF7SelectListener {
    private static final String DELETEENTRY = "deleteentry";
    private static final String MAXIMUM = "10000000000000.00";
    private static final String ATTACHMENTPANEL = "attachmentpanel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("id", (Object)ORM.create().genLongId((IDataEntityType)this.getModel().getDataEntityType()));
        Object adjustId = this.getView().getFormShowParameter().getCustomParam("adjustId");
        if (adjustId != null) {
            DynamicObject adjust = BusinessDataServiceHelper.loadSingle((Object)adjustId, (String)"pmas_projfundsource");
            String sourceBillFormId = adjust.getDynamicObjectType().toString();
            Object sourceBillId = adjust.getPkValue();
            String destinationFormId = this.getView().getFormShowParameter().getFormId();
            Object destinationBillId = this.getModel().getDataEntity().getPkValue();
            FileAttachmentHelper.copyFileFromAToB((String)sourceBillFormId, (Object)sourceBillId, (String)ATTACHMENTPANEL, (String)destinationFormId, (Object)destinationBillId, (String)ATTACHMENTPANEL);
        }
    }

    public void afterBindData(EventObject e) {
        int entryRowCount;
        Object orgId;
        super.afterBindData(e);
        Object adjustId = this.getView().getFormShowParameter().getCustomParam("adjustId");
        DynamicObject projectObj = (DynamicObject)this.getModel().getValue("project");
        if (projectObj != null) {
            this.getModel().setValue("projkind", projectObj.get("group"));
        }
        if (adjustId != null) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)adjustId, (String)"pmas_projfundsource");
            DynamicObject project = obj.getDynamicObject("project");
            this.getModel().setValue("project", (Object)project);
            this.getModel().setValue("projkind", (Object)project.getDynamicObject("group"));
            this.getModel().setValue("type", (Object)BillTypeEnum.ADJUST.getValue());
            BigDecimal totalAmount = obj.getBigDecimal("totalamount");
            this.getModel().setValue("totaloldamount", (Object)totalAmount);
            this.getModel().setValue("totalamount", (Object)totalAmount);
            this.getModel().setValue("yearbudgetapproveamt", (Object)obj.getBigDecimal("yearbudgetapproveamt"));
            this.getModel().setValue("budgetperiod", obj.get("budgetperiod"));
            this.getModel().setValue("budgetproname", obj.get("budgetproname"));
            this.getModel().setValue("budgetpronumber", obj.get("budgetpronumber"));
            this.getModel().setValue("org", (Object)obj.getDynamicObject("org"));
            this.getModel().setValue("year", obj.get("year"));
            BigDecimal newVersion = obj.getBigDecimal("version").add(BigDecimal.ONE).setScale(1);
            this.getModel().setValue("version", (Object)newVersion);
            this.getModel().setValue("billname", (Object)String.format(ResManager.loadKDString((String)"%1$s-\u8d44\u91d1\u6765\u6e90%2$s", (String)"FundSourceBillPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), project.getString("name"), newVersion.toPlainString()));
            this.getModel().setValue("createorg", obj.get("createorg"));
            this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("fundentry");
            this.getModel().beginInit();
            for (DynamicObject entry : entries) {
                int rowIndex = this.getModel().createNewEntryRow("fundentry");
                this.getModel().setValue("sourcetype", entry.get("sourcetype"), rowIndex);
                this.getModel().setValue("amount", entry.get("amount"), rowIndex);
                this.getModel().setValue("oldamount", entry.get("currententryamt"), rowIndex);
                this.getModel().setValue("note", entry.get("note"), rowIndex);
                this.getModel().setValue("formofinvest", entry.get("formofinvest"), rowIndex);
                this.getModel().setValue("investcurrency", entry.get("investcurrency"), rowIndex);
                this.getModel().setValue("scale", entry.get("scale"), rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"sourcetype", "amount"});
            }
            this.getModel().endInit();
            this.getView().updateView("fundentry");
            orgId = obj.getDynamicObject("org").getPkValue();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unaudit"});
            orgId = ((DynamicObject)this.getModel().getValue("org")).getPkValue();
        }
        BigDecimal newVersion = this.getModel().getDataEntity().getBigDecimal("version");
        if (newVersion.compareTo(BigDecimal.ONE) > 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"createorg"});
        }
        if ((entryRowCount = this.getModel().getEntryRowCount("fundentry")) < 1) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"totalamount"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"totalamount"});
        }
        Boolean result = (Boolean)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"isControl", (Object[])new Object[]{"pmas_projfundsource", orgId});
        if (result != null && result.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap2"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap2"});
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "deleteentry": {
                BigDecimal value = (BigDecimal)this.getModel().getValue("version");
                if (value.compareTo(new BigDecimal("1.0")) <= 0) break;
                EntryGrid grid = (EntryGrid)this.getControl("fundentry");
                int[] selectRows = grid.getSelectRows();
                boolean valid = true;
                DynamicObject lastVersionFundSource = this.getLastVersionFundSource();
                DynamicObjectCollection entries = lastVersionFundSource.getDynamicObjectCollection("fundentry");
                int len = entries.size();
                if (len > 0) {
                    for (int row : selectRows) {
                        if (row > len - 1) continue;
                        valid = false;
                        break;
                    }
                }
                if (valid) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u7248\u672c\u7684\u8d44\u91d1\u6765\u6e90\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u5c06\u91d1\u989d\u8bbe\u4e3a0\u3002", (String)"FundSourceBillPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private DynamicObject getLastVersionFundSource() {
        BigDecimal version = (BigDecimal)this.getModel().getValue("version");
        DynamicObject pro = (DynamicObject)this.getModel().getValue("project");
        QFilter qFilter = new QFilter("version", "=", (Object)version.subtract(new BigDecimal("1.0").setScale(1)));
        qFilter.and(new QFilter("project", "=", pro.getPkValue()));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"id,billno,fundentry", (QFilter[])new QFilter[]{qFilter});
        return load[0];
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "deleteentry": {
                this.setTotalAmoutAndTotaldiffAmout();
                int entryRowCount = this.getModel().getEntryRowCount("fundentry");
                if (entryRowCount < 1) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"totalamount"});
                }
                this.setEntryScale();
                break;
            }
            case "newentry": {
                this.getView().setEnable(Boolean.FALSE, new String[]{"totalamount"});
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        switch (key) {
            case "amount": {
                EntryGrid grid = (EntryGrid)this.getControl("fundentry");
                BigDecimal sumOfNotConsiderCur = grid.getSum("amount");
                BigDecimal maximum = new BigDecimal(MAXIMUM);
                if (maximum.compareTo(sumOfNotConsiderCur) <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u603b\u8d44\u91d1\u8d85\u8fc7\u9650\u989d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"FundSourceBillPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    this.getModel().setValue("amount", (Object)0, rowIndex);
                    break;
                }
                this.setTotalAmoutAndTotaldiffAmout();
                this.setEntryScale();
                break;
            }
            case "investcurrency": {
                this.setTotalAmoutAndTotaldiffAmout();
                break;
            }
            case "project": {
                DynamicObject projectObj = (DynamicObject)changeData.getNewValue();
                if (projectObj == null) break;
                this.getModel().setValue("projkind", projectObj.get("group"));
                break;
            }
            case "totalamount": {
                String type = (String)this.getModel().getValue("type");
                if (!StringUtils.equals((CharSequence)BillTypeEnum.ADJUST.getValue(), (CharSequence)type)) break;
                BigDecimal newAmount = NumberHelper.toBigDecimal((Object)changeData.getNewValue());
                BigDecimal oldAmount = NumberHelper.toBigDecimal((Object)this.getModel().getValue("totaloldamount", rowIndex));
                this.getModel().setValue("totaldiffamount", (Object)newAmount.subtract(oldAmount), rowIndex);
                break;
            }
            case "year": {
                DynamicObject project = (DynamicObject)this.getModel().getValue("project");
                Object adjustId = this.getView().getFormShowParameter().getCustomParam("adjustId");
                if (project == null || adjustId != null) {
                    return;
                }
                QFilter filter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                Date year = (Date)this.getModel().getValue("year");
                LocalDate localDate = year.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                filter.and("YEAR(year)", "=", (Object)localDate.getYear());
                DynamicObject[] fundBills = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"id", (QFilter[])new QFilter[]{filter});
                if (fundBills.length == 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u8be5\u5e74\u5ea6\u7684\u8d44\u91d1\u6765\u6e90\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5e74\u5ea6\u3002", (String)"FundSourceBillPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("year", changeData.getOldValue());
                return;
            }
            case "currententryamt": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fundentry");
                BigDecimal sum = BigDecimal.ZERO;
                if (entryEntity.size() > 0) {
                    sum = entryEntity.stream().map(obj -> obj.getBigDecimal("currententryamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                }
                this.getModel().setValue("curinvestamt", (Object)sum);
                BigDecimal newAmount = NumberHelper.toBigDecimal((Object)changeData.getNewValue());
                if (newAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal oldAmount = NumberHelper.toBigDecimal((Object)this.getModel().getValue("oldamount", rowIndex));
                this.getModel().setValue("diffamount", (Object)newAmount.subtract(oldAmount), rowIndex);
                break;
            }
        }
    }

    protected void setEntryScale() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fundentry");
        if (entryEntity.size() > 0) {
            BigDecimal sum = entryEntity.stream().map(obj -> obj.getBigDecimal("amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            for (DynamicObject entry : entryEntity) {
                BigDecimal totalAmount = entry.getBigDecimal("amount");
                if (sum.compareTo(BigDecimal.ZERO) > 0) {
                    entry.set("scale", (Object)totalAmount.divide(sum, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
                    continue;
                }
                entry.set("scale", (Object)BigDecimal.ZERO);
            }
        }
        this.getModel().updateEntryCache(entryEntity);
        this.getView().updateView("fundentry");
    }

    protected void setTotalAmoutAndTotaldiffAmout() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fundentry");
        BigDecimal sum = new BigDecimal(0);
        if (!entryEntity.isEmpty()) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject exRateTable = null;
            if (org != null) {
                exRateTable = CurrencyHelper.getExRateTable((Long)((Long)org.getPkValue()));
            }
            if (org == null || currency == null || exRateTable == null) {
                EntryGrid grid = (EntryGrid)this.getControl("fundentry");
                BigDecimal sumOfNotConsiderCur = grid.getSum("amount");
                this.getModel().setValue("totalamount", (Object)sumOfNotConsiderCur);
                return;
            }
            Long targCurId = (Long)currency.getPkValue();
            Long exRateTableId = (Long)exRateTable.getPkValue();
            for (DynamicObject row : entryEntity) {
                DynamicObject currentCur = row.getDynamicObject("investcurrency");
                BigDecimal currentAmount = row.getBigDecimal("amount");
                if (currentCur == null || currentAmount == null || currentAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                Long srcCurId = (Long)currentCur.getPkValue();
                BigDecimal exchangeRate = CurrencyHelper.getExChangeRate((Long)srcCurId, (Long)targCurId, (Long)exRateTableId, (Date)new Date());
                if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                    exchangeRate = BigDecimal.ONE;
                }
                BigDecimal convertedAmount = currentAmount.multiply(exchangeRate);
                sum = sum.add(convertedAmount);
            }
        }
        this.getModel().setValue("totalamount", (Object)sum);
        this.getView().updateView("totalamount");
        BigDecimal totalAmout = NumberHelper.toBigDecimal((Object)this.getModel().getValue("totalamount"));
        BigDecimal totalOldAmout = NumberHelper.toBigDecimal((Object)this.getModel().getValue("totaloldamount"));
        this.getModel().setValue("totaldiffamount", (Object)totalAmout.subtract(totalOldAmout));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        super.beforeF7Select(e);
        switch (key = e.getProperty().getName()) {
            case "project": {
                DynamicObject[] fundBills;
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                ArrayList<Long> orgList = new ArrayList<Long>();
                orgList.add((Long)org.getPkValue());
                Map projects = ProjectPermissionHelper.getEntityPermProjByOrgList(orgList, (boolean)true, (String)"pmas_projfundsource", (String)"new");
                Set projectIds = projects.keySet();
                QFilter filter = new QFilter("project", "in", projectIds);
                if (this.getModel().getValue("year") != null) {
                    Date year = (Date)this.getModel().getValue("year");
                    DynamicObject[] localDate = year.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                    filter.and("YEAR(year)", "=", (Object)localDate.getYear());
                }
                if ((fundBills = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"project", (QFilter[])new QFilter[]{filter})).length != 0) {
                    for (DynamicObject bill : fundBills) {
                        projectIds.remove(bill.getDynamicObject("project").getPkValue());
                    }
                }
                if (projectIds.size() <= 0) break;
                ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
                param.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)projectIds.toArray(new Object[projectIds.size()])));
                break;
            }
        }
    }
}

