/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.fund;

import java.time.ZoneId;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasListPlugin;

public class FundSourceListPlugin
extends AbstractPmasListPlugin {
    private static final String ADJUST_OP = "adjust";
    private static final String NEW = "NEW";
    private static final String ORGCACHE = "ORGCACHE";
    private static final String PROJECTCACHE = "PROJECTCACHE";
    private static final String OPERATE_REFRESH = "refresh";
    private static final String CALLBACKKEY_ADDNEW = "project_addnew";

    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void listRowClick(ListRowClickEvent evt) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate opertate = (FormOperate)args.getSource();
        String operateKey = opertate.getOperateKey();
        String orgId = this.getPageCache().get(ORGCACHE);
        ListView listView = (ListView)this.getView();
        ListSelectedRowCollection listSelectedData = listView.getSelectedRows().getBillListSelectedRowCollection();
        switch (operateKey) {
            case "adjust": {
                if (listSelectedData == null || listSelectedData.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u5217\u8868\u4e2d\u7684\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u8c03\u6574\u3002", (String)"FundSourceListPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListSelectedRow curRow = listSelectedData.get(0);
                Object pkValue = curRow.getPrimaryKeyValue();
                DynamicObject fundSourceObj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmas_projfundsource");
                DynamicObject project = fundSourceObj.getDynamicObject("project");
                if (project == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u6570\u636e\u672a\u8bbe\u7f6e\u9879\u76ee\u3002", (String)"FundSourceListPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                Date billYear = fundSourceObj.getDate("year");
                int year = billYear.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getYear();
                QFilter projFilter = new QFilter("project", "=", (Object)Long.parseLong(project.getPkValue().toString()));
                QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatus.C.name());
                QFilter yearFilter = new QFilter("YEAR(year)", "=", (Object)year);
                boolean isValid = fundSourceObj.getBoolean("isvalid");
                if (isValid) {
                    DynamicObjectCollection unAuditFunds = QueryServiceHelper.query((String)"pmas_projfundsource", (String)"id,billname,billno,billstatus", (QFilter[])new QFilter[]{projFilter, statusFilter, yearFilter});
                    if (unAuditFunds.size() > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5b58\u5728\u672a\u5ba1\u6838\u7684\u8d44\u91d1\u6765\u6e90\u5355\u636e\u3002", (String)"FundSourceListPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6700\u65b0\u7248\u672c\u7684\u6570\u636e\u8fdb\u884c\u8c03\u6574\u3002", (String)"FundSourceListPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                statusFilter = new QFilter("billstatus", "=", (Object)BillStatus.C.name());
                QFilter validQFilter = new QFilter("isvalid", "=", (Object)Boolean.TRUE);
                DynamicObject[] aduitfundsoures = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"id,billname,billno,billstatus", (QFilter[])new QFilter[]{projFilter, statusFilter, yearFilter, validQFilter}, (String)"version desc");
                Object pk = aduitfundsoures[0].getPkValue();
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("formId", "pmas_projfundsource");
                param.put("adjustId", pk);
                param.put("projectId", project.getPkValue().toString());
                param.put("orgId", orgId);
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(showParameter);
                break;
            }
            case "new": {
                List projectIds;
                String clickProjectList = this.getPageCache().get("click_project_cache");
                if (!StringUtils.isNotEmpty((CharSequence)clickProjectList) || (projectIds = SerializationUtils.fromJsonStringToList((String)clickProjectList, Long.class)).size() <= 0) break;
                QFilter projectFilter = new QFilter("project", "in", (Object)projectIds);
                DynamicObject[] fundBill = BusinessDataServiceHelper.load((String)"pmas_projfundsource", (String)"", (QFilter[])new QFilter[]{projectFilter});
                if (fundBill.length == 0) {
                    return;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u5df2\u5b58\u5728\u8d44\u91d1\u6765\u6e90\u5355\u636e\uff0c\u8bf7\u67e5\u770b\u8d44\u91d1\u6765\u6e90\u5217\u8868\u3002", (String)"FundSourceListPlugin_4", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "unaudit": {
                if (listSelectedData == null || listSelectedData.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u5217\u8868\u4e2d\u7684\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u8c03\u6574\u3002", (String)"FundSourceListPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListSelectedRow curRow = listSelectedData.get(0);
                Object pkValue = curRow.getPrimaryKeyValue();
                DynamicObject fundSourceObj = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmas_projfundsource");
                if (!fundSourceObj.getBoolean("issys")) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u7684\u8d44\u91d1\u6765\u6e90\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FundSourceListPlugin_5", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object budgetId = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        String billFormId = billList.getBillFormId();
        String fieldName = args.getFieldName();
        if ("project_name".equals(fieldName)) {
            args.setCancel(true);
            DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)budgetId, (String)billFormId);
            QFilter qFilter = new QFilter("pro", "=", budget.getDynamicObject("project").getPkValue());
            qFilter.and(new QFilter("billstatus", "!=", (Object)"A"));
            DynamicObject[] projectApprovals = BusinessDataServiceHelper.load((String)"pmas_pro_approval", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (projectApprovals != null && projectApprovals.length > 0) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setPkId(projectApprovals[0].getPkValue());
                showParameter.setFormId("pmas_pro_approval");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)CALLBACKKEY_ADDNEW, (CharSequence)key)) {
            this.getView().invokeOperation(OPERATE_REFRESH);
        }
    }
}

