/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.pro;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmas.formplugin.base.AbstractPmasBillPlugin;
import kd.pmgt.pmbs.common.enums.BudgetCtlModeEnum;
import kd.pmgt.pmbs.common.enums.DimShareType;
import kd.pmgt.pmbs.common.enums.SplitTypeEnum;
import kd.pmgt.pmbs.common.utils.TimeUtils;

public class ApprovalAmtModifyBudgetEditPlugin
extends AbstractPmasBillPlugin {
    private static final Log logger = LogFactory.getLog(ApprovalAmtModifyBudgetEditPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit ctrlOutItem;
        TextEdit entryProName;
        TextEdit ctrlOutItemName = (TextEdit)this.getView().getControl("ctrloutitemname");
        if (ctrlOutItemName != null) {
            ctrlOutItemName.addButtonClickListener((ClickListener)this);
        }
        if ((entryProName = (TextEdit)this.getView().getControl("entryproname")) != null) {
            entryProName.addButtonClickListener((ClickListener)this);
        }
        if ((ctrlOutItem = (BasedataEdit)this.getControl("ctrloutitem")) != null) {
            ctrlOutItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey)) {
            DynamicObject dataEntity = model.getDataEntity();
            String budgetControlMode = dataEntity.getString("budgetcontrolmode");
            if (StringUtils.equals((CharSequence)BudgetCtlModeEnum.NOTCONTROL.getValue(), (CharSequence)budgetControlMode)) {
                return;
            }
            if (this.validateBudgetEntry(model, dataEntity)) {
                this.setRealBudgetEntry(model, dataEntity);
                this.getView().updateView("realbudgetentry");
            } else {
                args.setCancel(true);
            }
        }
    }

    protected boolean validateBudgetEntry(IDataModel model, DynamicObject dataEntity) {
        DynamicObjectCollection controlInfoEntryCol = model.getEntryEntity("controlinfoentry");
        String splitType = dataEntity.getString("splittype");
        if (StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
            int controlInfoSize = controlInfoEntryCol.size();
            if (controlInfoSize == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9884\u7b97\u5206\u644a\u660e\u7ec6\u3002", (String)"ApprovalAmtModifyBudgetEditPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                return false;
            }
            BigDecimal outAmount = dataEntity.getBigDecimal("proyearbudgetamt");
            if (outAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u7acb\u9879\u5e74\u5ea6\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002", (String)"ApprovalAmtModifyBudgetEditPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected void setRealBudgetEntry(IDataModel model, DynamicObject dataEntity) {
        model.deleteEntryData("realbudgetentry");
        String splitType = dataEntity.getString("splittype");
        DynamicObjectCollection controlInfoEntryCol = model.getEntryEntity("controlinfoentry");
        DynamicObjectCollection realBudgetEntry = this.getModel().getEntryEntity("realbudgetentry");
        for (DynamicObject controlInfo : controlInfoEntryCol) {
            DynamicObject budgetitem = controlInfo.getDynamicObject("ctrloutitem");
            String ctrloutItemName = controlInfo.getString("ctrloutitemname");
            DynamicObject undertakeOrg = controlInfo.getDynamicObject("undertakeorg");
            Date undertakePeriod = controlInfo.getDate("undertakeperiod");
            ComboProp prop = (ComboProp)this.getModel().getProperty("defmonth");
            Object month = prop.getDefValue();
            if (StringUtils.equals((CharSequence)SplitTypeEnum.TOTALAMTSPLIT.getValue(), (CharSequence)splitType)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(undertakePeriod);
                if (month != null) {
                    calendar.set(2, Integer.parseInt(month.toString()) - 1);
                } else {
                    calendar.set(2, 0);
                }
                undertakePeriod = calendar.getTime();
            }
            long entryproid = controlInfo.getLong("entryproid");
            BigDecimal realundertakeamt = controlInfo.getBigDecimal("afterundertakeamt");
            if (this.checkIsRepeat(controlInfo, budgetitem, realundertakeamt)) continue;
            DynamicObject newEntry = new DynamicObject(realBudgetEntry.getDynamicObjectType());
            newEntry.set("realbudgetitem", (Object)budgetitem);
            newEntry.set("realprobudgetname", (Object)ctrloutItemName);
            newEntry.set("realundertakeorg", (Object)undertakeOrg);
            newEntry.set("realundertakeperiod", (Object)undertakePeriod);
            newEntry.set("realproname", controlInfo.get("entryproname"));
            newEntry.set("realpronumber", controlInfo.get("entrypronumber"));
            newEntry.set("realproid", (Object)entryproid);
            newEntry.set("realundertakeamt", (Object)realundertakeamt);
            newEntry.set("realbeforeamt", controlInfo.get("undertakeamt"));
            newEntry.set("realdifferenceamt", controlInfo.get("differundertakeamt"));
            realBudgetEntry.add((Object)newEntry);
        }
        this.getModel().updateEntryCache(realBudgetEntry);
    }

    protected boolean checkIsRepeat(DynamicObject controlInfo, DynamicObject budgetitem, BigDecimal realUndertakeAmt) {
        boolean isContinue = false;
        int rowCount = this.getModel().getEntryRowCount("realbudgetentry");
        for (int i = 0; i < rowCount; ++i) {
            Integer realundertakeorgPK;
            Object budgetitemPK = budgetitem == null ? Integer.valueOf(0) : budgetitem.getPkValue();
            Integer undertakeOrgPK = controlInfo.getDynamicObject("undertakeorg") == null ? Integer.valueOf(0) : controlInfo.getDynamicObject("undertakeorg").getPkValue();
            Date undertakePeriod = controlInfo.getDate("undertakeperiod");
            Long entryproid = controlInfo.getLong("entryproid");
            Integer realbudgetitemPK = this.getModel().getValue("realbudgetitem", i) == null ? Integer.valueOf(0) : ((DynamicObject)this.getModel().getValue("realbudgetitem", i)).getPkValue();
            Integer n = realundertakeorgPK = this.getModel().getValue("realundertakeorg", i) == null ? Integer.valueOf(0) : ((DynamicObject)this.getModel().getValue("realundertakeorg", i)).getPkValue();
            if (budgetitemPK != realbudgetitemPK || undertakeOrgPK != realundertakeorgPK || !TimeUtils.isSameMonth((Date)undertakePeriod, (Date)((Date)this.getModel().getValue("realundertakeperiod", i))) || !entryproid.equals(this.getModel().getValue("realproid", i))) continue;
            this.getModel().setValue("realundertakeamt", (Object)((BigDecimal)this.getModel().getValue("realundertakeamt", i)).add(realUndertakeAmt), i);
            isContinue = true;
        }
        return isContinue;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey().toLowerCase();
        int selectRow = control.getModel().getEntryCurrentRowIndex("controlinfoentry");
        if (StringUtils.equals((CharSequence)"ctrloutitemname", (CharSequence)key)) {
            if (this.getModel().getValue("project") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u3002", (String)"ApprovalAmtModifyBudgetEditPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pmas_selectbudgetentry");
            showParameter.setCustomParam("key_formId", (Object)"pmas_approval_amtmodify");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ctrloutitemname"));
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)"entryproname", (CharSequence)key)) {
            DynamicObject undertakeOrg = (DynamicObject)this.getModel().getValue("undertakeorg", selectRow);
            if (undertakeOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u627f\u62c5\u7ec4\u7ec7\u3002", (String)"ApprovalAmtModifyBudgetEditPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("formId", "eb_sharedimensiontreef7");
            DynamicObject obj = this.getModel().getDataEntity(true);
            String formId = obj.getDynamicObjectType().getName();
            DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(obj.getDynamicObjectType());
            DcJsonSerializer dcJsonSerializer = new DcJsonSerializer((DcBinder)binder);
            dcJsonSerializer.setIsLocaleValueFull(true);
            binder.setOnlyDbProperty(false);
            String serializeObjStr = dcJsonSerializer.serializeToString((Object)obj, null);
            map.put("dynamicObject", serializeObjStr);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
            showParameter.setCustomParam("billNumber", (Object)formId);
            showParameter.setCustomParam("fieldNumber", (Object)"controlinfoentry.entryproname");
            showParameter.setCustomParam("ischeckData", (Object)Boolean.TRUE);
            showParameter.setCustomParam("isMul", (Object)Boolean.FALSE);
            logger.info("click entryproname  billNumber\uff1a{}\uff0cdynamicObject\uff1a{}\uff0cserializeObjStr\uff1a{}", new Object[]{formId, obj, serializeObjStr});
            ArrayList budgetMapList = new ArrayList(10);
            HashMap<String, String> budgetFilterMap = new HashMap<String, String>(16);
            budgetFilterMap.put("key", "controlinfoentry.undertakeorg");
            budgetFilterMap.put("value", undertakeOrg.getString("number"));
            budgetFilterMap.put("type", DimShareType.BASEDATA.getIndex());
            budgetFilterMap.put("dimtype", DimShareType.BUDGETDIM.getIndex());
            budgetMapList.add(budgetFilterMap);
            String budgetFilterJson = SerializationUtils.toJsonString(budgetMapList);
            showParameter.setCustomParam("budgetfilter", (Object)budgetFilterJson);
            logger.info("click entryproname budgetMapList\uff1a{}\uff0cserializeObjStr\uff1a{}", budgetMapList, (Object)budgetFilterJson);
            ArrayList powerMapList = new ArrayList(16);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org", selectRow);
            if (org != null) {
                HashMap<String, String> powerFilterMap = new HashMap<String, String>(16);
                powerFilterMap.put("key", "org");
                powerFilterMap.put("value", org.getString("number"));
                powerFilterMap.put("type", DimShareType.BASEDATA.getIndex());
                powerFilterMap.put("dimtype", DimShareType.BUDGETDIM.getIndex());
                powerMapList.add(powerFilterMap);
            }
            if (budgetMapList.size() > 0) {
                String powerFilterJson = SerializationUtils.toJsonString(powerMapList);
                showParameter.setCustomParam("relation", (Object)powerFilterJson);
                logger.info("click entryproname powerMapList\uff1a{}\uff0cserializeObjStr\uff1a{}", powerMapList, (Object)powerFilterJson);
            }
            CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, "selectProject");
            showParameter.setCloseCallBack(ccb);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            showParameter.getOpenStyle().setInlineStyleCss(css);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)"ctrloutitemname", (CharSequence)actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("controlinfoentry");
                DynamicObject entryEntity = (DynamicObject)returnData;
                this.getModel().setValue("ctrloutitem", entryEntity.get("budgetitem"), entryCurrentRowIndex);
                this.getModel().setValue("ctrloutitemname", entryEntity.get("probudgetitemname"), entryCurrentRowIndex);
            }
        } else if (StringUtils.equals((CharSequence)"selectProject", (CharSequence)actionId)) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (returnData == null || returnData.isEmpty()) {
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("controlinfoentry");
            ListSelectedRow row = returnData.get(0);
            this.getModel().setValue("entrypronumber", (Object)row.getNumber(), entryCurrentRowIndex);
            this.getModel().setValue("entryproname", (Object)row.getName(), entryCurrentRowIndex);
            this.getModel().setValue("entryproid", row.getPrimaryKeyValue(), entryCurrentRowIndex);
        }
    }
}

