/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.pro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasListPlugin;
import kd.pmgt.pmbs.common.utils.BuildCommonFilterList;

public class ApproveAuditBillListPlugin
extends AbstractPmasListPlugin
implements BeforeFilterF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn orgFilterColumn;
        String fieldName;
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumnList) {
            fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"org.name", (CharSequence)fieldName)) continue;
            orgFilterColumn = (CommonFilterColumn)filterColumn;
            List comboItems = orgFilterColumn.getComboItems();
            if (comboItems.size() <= 0) break;
            List auditOrgs = comboItems.stream().map(o -> Long.parseLong(o.getValue())).collect(Collectors.toList());
            String auditOrgsCache = SerializationUtils.toJsonString(auditOrgs);
            this.getPageCache().put("auditOrgsCache", auditOrgsCache);
            break;
        }
        for (FilterColumn filterColumn : filterColumnList) {
            fieldName = filterColumn.getFieldName();
            if (!StringUtils.equals((CharSequence)"lastreportorg.name", (CharSequence)fieldName)) continue;
            orgFilterColumn = (CommonFilterColumn)filterColumn;
            this.setOrgComboItems(orgFilterColumn);
            break;
        }
    }

    protected void setOrgComboItems(CommonFilterColumn orgFilterColumn) {
        List combos = new ArrayList(16);
        String orgsCombosCache = this.getPageCache().get("declareOrgCache");
        if (StringUtils.isNotBlank((CharSequence)orgsCombosCache)) {
            combos = SerializationUtils.fromJsonStringToList((String)orgsCombosCache, ComboItem.class);
            orgFilterColumn.setComboItems(combos);
            return;
        }
        String auditOrgsCache = this.getPageCache().get("auditOrgsCache");
        if (StringUtils.isNotBlank((CharSequence)auditOrgsCache)) {
            List auditOrgs = SerializationUtils.fromJsonStringToList((String)auditOrgsCache, Long.class);
            QFilter qFilter = new QFilter("org", "in", (Object)auditOrgs);
            DynamicObject[] lastReportOrg = BusinessDataServiceHelper.load((String)"pmas_pro_app_audit", (String)"lastreportorg,lastreportorg.id", (QFilter[])new QFilter[]{qFilter});
            if (lastReportOrg != null) {
                List proOrgIds = Arrays.stream(lastReportOrg).map(o -> Long.parseLong(o.getDynamicObject("lastreportorg").getPkValue().toString())).collect(Collectors.toList());
                qFilter = new QFilter("id", "in", proOrgIds);
                combos = BuildCommonFilterList.buildComboItem((String)"bos_org", (QFilter)qFilter);
            }
        }
        if (combos.size() > 0) {
            orgFilterColumn.setComboItems(combos);
            orgsCombosCache = SerializationUtils.toJsonString(combos);
            this.getPageCache().put("declareOrgCache", orgsCombosCache);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
    }
}

