/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.pro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.business.projectkind.ProjectKindService;
import kd.pmgt.pmbs.business.utils.ReportConfigUtils;
import kd.pmgt.pmbs.common.enums.FieldTypeEnum;
import kd.pmgt.pmbs.common.enums.ProjectStageEnum;
import kd.pmgt.pmbs.common.enums.ProjectStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.approval.ApprovalStatusEnum;
import kd.pmgt.pmbs.formplugin.base.AbstractPmgtTreeListPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class ProjectApprovalListPlugin
extends AbstractPmgtTreeListPlugin
implements TreeNodeClickListener,
SearchEnterListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(ProjectApprovalListPlugin.class);
    private static final String OPERATE_NEW = "new";
    private static final String OPERATE_REFRESH = "refresh";
    private static final String[] GROUP_OPERATE_FLAG = new String[]{"btnnew", "btndel", "btnedit"};
    private static final String OPERATE_PROJECT_KANBAN = "prokanban";
    private static final String OPERATE_PROADJUST = "appadjust";
    private static final String OPERATE_CHECKADJUST = "adjustrecord";
    private static final String OPERATE_APPROVAL = "approval";
    private static final String OPERATE_CALL_CHANGELEADER = "callchangeleader";
    private static final String SEARCH_USER_ORG_ID = "org";
    private static final String ADJUSTSUPERVISION = "adjustsupervision";
    private static final String VIEWADJUSTSUPERVISION = "viewadjustsupervision";
    private static final String changeApprovalAmt = "changeapprovalamt";
    private static final String CLICK_ORG = "CLICK_ORG";
    private ProjectKindService projectKindService = new ProjectKindService();
    private static final String GROUPID_SUBFIX_KEY = "_groupId";
    private static final String FIRST_BUILD_LEFT_TREE = "first_build_lift_tree";
    private static final String CLICK_LEFT_TREE_NODE = "click_left_tree_node";

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, GROUP_OPERATE_FLAG);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null) {
            if (args.getFastFilterValues().size() > 0) {
                return;
            }
            String fieldName = ((List)currentCommonFilter.get("FieldName")).get(0).toString();
            if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)SEARCH_USER_ORG_ID)) {
                long userOrgId;
                List commonFilterValue = (List)currentCommonFilter.get("Value");
                if (CollectionUtils.isEmpty((Collection)commonFilterValue) || StringUtils.isBlank((CharSequence)commonFilterValue.get(0).toString())) {
                    userOrgId = RequestContext.get().getOrgId();
                    this.getView().getPageCache().put("unuseorg", "true");
                } else {
                    this.getView().getPageCache().remove("unuseorg");
                    userOrgId = Long.parseLong(commonFilterValue.get(0).toString());
                }
                this.getPageCache().put(CLICK_ORG, String.valueOf(userOrgId));
                this.constructLeftTree();
            }
        }
        super.filterContainerSearchClick(args);
    }

    public void search(SearchEnterEvent evt) {
        super.search(evt);
        this.constructLeftTree();
    }

    private void constructLeftTree() {
        String clickLeftTreeNodeId;
        Long orgId = this.getPageCache().get(CLICK_ORG) == null ? RequestContext.get().getOrgId() : Long.parseLong(this.getPageCache().get(CLICK_ORG));
        DynamicObject[] proKinds = this.projectKindService.getAuthorizedProjectKindList(null, orgId);
        List treeNodeList = this.projectKindService.getNodes(proKinds);
        TreeNode root = this.getTreeModel().getRoot();
        root.setChildren(treeNodeList);
        this.getTreeModel().getRoot().setChildren(treeNodeList);
        TreeView treeView = (TreeView)this.getControl("treeview");
        treeView.deleteAllNodes();
        treeView.addNode(root);
        List nodeIdList = Arrays.stream(proKinds).map(dynamicObject -> String.valueOf(dynamicObject.getPkValue())).collect(Collectors.toList());
        String string = clickLeftTreeNodeId = this.getPageCache().get(CLICK_LEFT_TREE_NODE) == null ? root.getId() : this.getPageCache().get(CLICK_LEFT_TREE_NODE);
        if (!StringUtils.equals((CharSequence)clickLeftTreeNodeId, (CharSequence)root.getId()) && !nodeIdList.contains(clickLeftTreeNodeId)) {
            treeView.focusNode(root);
            treeView.treeNodeClick(null, root.getId());
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        this.getPageCache().put(CLICK_LEFT_TREE_NODE, String.valueOf(e.getNodeId()));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getPageCache().get(FIRST_BUILD_LEFT_TREE) == null) {
            this.constructLeftTree();
            this.getPageCache().put(FIRST_BUILD_LEFT_TREE, String.valueOf(Boolean.FALSE));
        }
    }

    public void setFilter(SetFilterEvent e) {
        boolean superUser;
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        List qFilters = e.getQFilters();
        if (mainOrgQFilter != null) {
            DynamicObject[] projectKindsArr = this.projectKindService.getAuthorizedProjectKindList(null, (Long)((ArrayList)mainOrgQFilter.getValue()).get(0));
            List projectKindIds = Arrays.stream(projectKindsArr).map(projectKind -> Long.valueOf(projectKind.getPkValue().toString())).collect(Collectors.toList());
            QFilter projectKindFilter = new QFilter("kind", "in", projectKindIds);
            qFilters.add(projectKindFilter);
        }
        if (superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) {
            return;
        }
        boolean adminUser = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
        if (adminUser) {
            return;
        }
        Map hasPermOrgMap = ProjectPermFilterHelper.getHasPermOrgMap((IListView)((IListView)this.getView()), (String)this.getOrgKey(), (String)this.getOrgFilterKey());
        HashSet orgList = new HashSet(2000);
        for (Map.Entry item : hasPermOrgMap.entrySet()) {
            orgList.addAll((Collection)item.getValue());
        }
        QFilter orgQFilter = new QFilter(this.getOrgKey(), "in", orgList);
        ArrayList projectIds = new ArrayList(ProjectPermFilterHelper.getHasPermProjectList((IListView)((IListView)this.getView()), (Map)hasPermOrgMap, (String)this.getOrgKey(), (String)this.getProjectKey()));
        QFilter projectQFilter = new QFilter(this.getProjectKey(), "in", projectIds);
        projectQFilter.or(orgQFilter);
        qFilters.add(projectQFilter);
        boolean orgNoLimit = ProjectPermFilterHelper.isFilterFieldSelectedNoLimit((IListView)((IListView)this.getView()), (String)this.getOrgFilterKey());
        if (orgNoLimit) {
            e.setMainOrgQFilter(null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        String operateName = operate.getOperateName().getLocaleValue();
        if (OPERATE_NEW.equals(operateKey)) {
            if (currentNodeId != null) {
                if (!StringUtils.isNumeric((CharSequence)((String)currentNodeId))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u5206\u7c7b\u660e\u7ec6\u8282\u70b9\u3002", (String)"ProjectApprovalListPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else {
                    DynamicObject projectKind;
                    TreeNode node = this.getTreeModel().getRoot().getTreeNode(currentNodeId.toString(), 20);
                    if (node != null && (projectKind = BusinessDataServiceHelper.loadSingle((Object)currentNodeId, (String)"bd_projectkind")) != null && !projectKind.getBoolean("isleaf")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u5206\u7c7b\u660e\u7ec6\u8282\u70b9\u3002", (String)"ProjectApprovalListPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                    QFilter proKindFilter = new QFilter("projectkind", "=", (Object)Long.parseLong(String.valueOf(currentNodeId)));
                    String selectProperties = String.join((CharSequence)",", "enable", "probilltype");
                    DynamicObject projectKindControlSetting = BusinessDataServiceHelper.loadSingle((String)"pmbs_prokindctrlsetting", (String)selectProperties, (QFilter[])new QFilter[]{proKindFilter});
                    if (projectKindControlSetting == null && node != null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5bf9%s\u8fdb\u884c\u9879\u76ee\u5206\u7c7b\u7ba1\u63a7\u8bbe\u7f6e\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ProjectApprovalListPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), node.getText()));
                        args.setCancel(true);
                        return;
                    }
                    if (projectKindControlSetting != null && node != null && !projectKindControlSetting.getBoolean("enable")) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u542f\u7528\u201c%s\u201d\u7684\u201c\u5206\u7c7b\u7ba1\u63a7\u8bbe\u7f6e\u201d\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ProjectApprovalListPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), node.getText()));
                        args.setCancel(true);
                    }
                    if (projectKindControlSetting != null) {
                        this.getPageCache().put("projectKindSetting", projectKindControlSetting.getPkValue().toString());
                    }
                }
            }
        } else if ("submit".equals(operateKey)) {
            DynamicObject[] proApps;
            ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().getBillListSelectedRowCollection();
            for (DynamicObject proApp : proApps = BusinessDataServiceHelper.load((Object[])listSelectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_pro_approval"))) {
                this.replenishReportOrg(proApp);
                boolean isValid = this.validateDynamicField(proApp);
                if (isValid) continue;
                args.setCancel(true);
                return;
            }
        } else if (OPERATE_PROJECT_KANBAN.equals(operateKey)) {
            if (((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().isEmpty()) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"ProjectApprovalListPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                return;
            }
            if (((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().size() > 1) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u9879\u76ee\u8fdb\u884c\u64cd\u4f5c\uff0c\u4e0d\u652f\u6301\u591a\u4e2a\u9879\u76ee\u67e5\u770b\u201c\u9879\u76ee\u770b\u677f\u201d\u3002", (String)"ProjectApprovalListPlugin_4", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                return;
            }
            String billStatus = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0).getBillStatus();
            if (!"C".equals(billStatus)) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u5355\u636e\u672a\u5ba1\u6838\uff0c\u65e0\u6cd5\u67e5\u770b\u9879\u76ee\u770b\u677f\u3002", (String)"ProjectApprovalListPlugin_5", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object pkValue = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0).getPrimaryKeyValue();
            DynamicObject proApp = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmas_pro_approval");
            boolean needApproval = proApp.getBoolean("needapproval");
            String approvalStatus = proApp.getString("approvalstatus");
            if (needApproval && !StringUtils.equals((CharSequence)approvalStatus, (CharSequence)ApprovalStatusEnum.PASS.getValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u6838\u51c6\u901a\u8fc7\u624d\u80fd\u67e5\u770b\u9879\u76ee\u770b\u677f\u3002", (String)"ProjectApprovalListPlugin_6", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject proStatus = ProjectApprovalHelper.getProStatus((Object)pkValue, (String)ProjectStageEnum.PROPOSALSTAGE_S.getValue(), (String)ProjectStatusEnum.APPROVAL_SUCC.getValue());
            if (proStatus == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u6682\u672a\u7acb\u9879\uff0c\u65e0\u9879\u76ee\u770b\u677f\u3002", (String)"ProjectApprovalListPlugin_7", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object pk = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0).getPrimaryKeyValue();
            HashMap<String, String> customMap = new HashMap<String, String>();
            customMap.put("proAppId", pk.toString());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("formId", "pmba_projectkanban");
            map.put("customParams", customMap);
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
        } else if ("biz_travel_apply".equals(operateKey) || "biz_travel_apply_loan".equals(operateKey) || "biz_travel_reimburse".equals(operateKey) || "cost_apply".equals(operateKey) || "loan".equals(operateKey) || "cost_reimburse".equals(operateKey) || "corporate_reimburse".equals(operateKey)) {
            ListSelectedRowCollection rows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().getBillListSelectedRowCollection();
            if (rows.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"ProjectApprovalListPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            }
            if (rows.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u540c\u65f6\u9009\u62e9\u591a\u884c\u6570\u636e\u3002", (String)"ProjectApprovalListPlugin_8", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            }
            ListSelectedRow row = rows.get(0);
            if (!StatusEnum.CHECKED.getValue().equals(row.getBillStatus())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u7684\u6570\u636e\u3002", (String)"ProjectApprovalListPlugin_9", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            }
            DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"pmas_pro_approval");
            DynamicObject project = null;
            if (projectApproval != null && projectApproval.getDynamicObject("pro") != null) {
                project = BusinessDataServiceHelper.loadSingle((Object)projectApproval.getDynamicObject("pro").getPkValue(), (String)"bd_project");
            }
            HashMap<String, Object> data = null;
            if (project != null) {
                DynamicObject proStatus = project.getDynamicObject("prostatus");
                if (ProjectStatusEnum.FINANCIAL_CLOSE.getId().equals(proStatus.getPkValue().toString())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%1$s\u201d\u7684\u72b6\u6001\u5df2\u4e3a%2$s\uff0c\u65e0\u6cd5%3$s\u3002", (String)"ProjectApprovalListPlugin_10", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), project.get("name"), ProjectStatusEnum.FINANCIAL_CLOSE.getName(), operateName));
                }
                data = new HashMap<String, Object>();
                data.put("project", project.getPkValue());
            }
            this.quickStart(operateKey, data);
        } else if (OPERATE_PROADJUST.equals(operateKey)) {
            QFilter filter1;
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().getBillListSelectedRowCollection();
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u8c03\u6574\u4e00\u6761\u6570\u636e\u3002", (String)"ProjectApprovalListPlugin_11", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            DynamicObject projApproval = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"pmas_pro_approval");
            DynamicObject proStatus = ProjectApprovalHelper.getProStatus((Object)selectedRow.getPrimaryKeyValue(), (String)ProjectStageEnum.PROPOSALSTAGE_S.getValue(), (String)ProjectStatusEnum.APPROVAL_SUCC.getValue());
            if (projApproval == null || !StringUtils.equals((CharSequence)projApproval.getString("billstatus"), (CharSequence)"C") || proStatus == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u6682\u672a\u7acb\u9879\u901a\u8fc7\uff0c\u65e0\u6cd5\u8fdb\u884c\u8c03\u6574\u3002", (String)"ProjectApprovalListPlugin_12", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject project = projApproval.getDynamicObject("pro");
            QFilter filter = new QFilter("pro", "=", project.getPkValue());
            DynamicObject[] proAdjust = BusinessDataServiceHelper.load((String)"pmas_pro_approvaladjust", (String)"id", (QFilter[])new QFilter[]{filter, filter1 = new QFilter("billstatus", "!=", (Object)"C")});
            if (proAdjust.length > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u5b58\u5728\u672a\u5ba1\u6279\u7684\u8c03\u6574\u8bb0\u5f55\uff0c\u8bf7\u52ff\u91cd\u590d\u8c03\u6574\u3002", (String)"ProjectApprovalListPlugin_13", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter filter2 = new QFilter("billstatus", "=", (Object)"C");
            DynamicObject[] proAdjustAud = BusinessDataServiceHelper.load((String)"pmas_pro_approvaladjust", (String)"id", (QFilter[])new QFilter[]{filter, filter2}, (String)"version desc");
            HashMap<String, Object> customMap = new HashMap<String, Object>();
            if (proAdjustAud.length > 0) {
                customMap.put("proAdjustId", proAdjustAud[0].getPkValue());
            }
            customMap.put("projApprovalId", projApproval.getPkValue());
            this.showForm(customMap, ShowType.MainNewTabPage, "pmas_pro_approvaladjust");
        } else if (OPERATE_CHECKADJUST.equals(operateKey)) {
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().getBillListSelectedRowCollection();
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u67e5\u770b\u4e00\u4e2a\u9879\u76ee\u7684\u8c03\u6574\u8bb0\u5f55\u3002", (String)"ProjectApprovalListPlugin_14", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            DynamicObject projApproval = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"pmas_pro_approval");
            DynamicObject proStatus = ProjectApprovalHelper.getProStatus((Object)selectedRow.getPrimaryKeyValue(), (String)ProjectStageEnum.PROPOSALSTAGE_S.getValue(), (String)ProjectStatusEnum.APPROVAL_SUCC.getValue());
            if (projApproval == null || !StringUtils.equals((CharSequence)projApproval.getString("billstatus"), (CharSequence)"C") || proStatus == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u672a\u7acb\u9879\u901a\u8fc7\uff0c\u65e0\u8c03\u6574\u8bb0\u5f55\u3002", (String)"ProjectApprovalListPlugin_15", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject pro = projApproval.getDynamicObject("pro");
            HashMap<String, Object> customMap = new HashMap<String, Object>();
            customMap.put("projectId", pro.getPkValue());
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("pmas_pro_approvaladjust");
            parameter.setFormId("bos_list");
            parameter.getListFilterParameter().getQFilters().add(new QFilter("pro", "=", pro.getPkValue()));
            parameter.setCustomParams(customMap);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            this.getView().showForm((FormShowParameter)parameter);
        } else if (StringUtils.equals((CharSequence)OPERATE_CALL_CHANGELEADER, (CharSequence)operateKey)) {
            DynamicObject[] checkdTeams;
            if (((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().size() > 1) {
                this.getView().showMessage(ResManager.loadKDStringExt((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u9879\u76ee\u8fdb\u884c\u64cd\u4f5c\uff0c\u4e0d\u652f\u6301\u53d8\u66f4\u591a\u4e2a\u9879\u76ee\u7684\u8d23\u4efb\u4eba\u3002", (String)"ProjectApprovalListPlugin_16", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ListSelectedRow selRow = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0);
            if (!StatusEnum.CHECKED.getValue().equals(selRow.getBillStatus())) {
                this.getView().showMessage(String.format(ResManager.loadKDStringExt((String)"\u5355\u636e\u72b6\u6001\u4e3a\u201c%s\u201d\uff0c\u65e0\u6cd5\u66f4\u6539\u8d23\u4efb\u4eba\u3002", (String)"ProjectApprovalListPlugin_17", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), StatusEnum.getEnumByValue((Object)selRow.getBillStatus()).getName()));
                args.setCancel(true);
                return;
            }
            DynamicObject proStatus = ProjectApprovalHelper.getProStatus((Object)selRow.getPrimaryKeyValue(), (String)ProjectStageEnum.PROPOSALSTAGE_S.getValue(), (String)ProjectStatusEnum.APPROVAL_SUCC.getValue());
            if (proStatus == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u6682\u672a\u7acb\u9879\uff0c\u65e0\u6cd5\u66f4\u6539\u9879\u76ee\u8d1f\u8d23\u4eba\u3002", (String)"ProjectApprovalListPlugin_18", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject projApproval = BusinessDataServiceHelper.loadSingle((Object)selRow.getPrimaryKeyValue(), (String)"pmas_pro_approval");
            DynamicObject project = null;
            if (projApproval != null) {
                project = projApproval.getDynamicObject("pro");
            }
            if (project != null && (checkdTeams = BusinessDataServiceHelper.load((String)"pmas_team", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("project", "=", project.getPkValue()).and("billstatus", "<>", (Object)StatusEnum.CHECKED.getValue())})) != null && checkdTeams.length > 0) {
                this.getView().showMessage(String.format(ResManager.loadKDStringExt((String)"\u5b58\u5728\u9879\u76ee\u56e2\u961f\u7f16\u5236\u6216\u5ba1\u6838\u4e2d\u7684\u5355\u636e\u201c%s\u201d\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838\u901a\u8fc7\u540e\u518d\u53d8\u66f4\u9879\u76ee\u8d1f\u8d23\u4eba\u3002", (String)"ProjectApprovalListPlugin_19", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), checkdTeams[0].get("billno")));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)OPERATE_APPROVAL, (CharSequence)operateKey)) {
            if (((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u9879\u76ee\u8fdb\u884c\u6838\u51c6\u3002", (String)"ProjectApprovalListPlugin_20", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)changeApprovalAmt, (CharSequence)operateKey) && ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDStringExt((String)"\u53ea\u652f\u6301\u5bf9\u4e00\u4e2a\u9879\u76ee\u8fdb\u884c\u53d8\u66f4\u3002", (String)"ProjectApprovalListPlugin_21", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private boolean validateDynamicField(DynamicObject proApp) {
        boolean isValid = true;
        List<HashMap<String, Object>> allField = this.getAllField(proApp);
        if (!allField.isEmpty()) {
            for (HashMap<String, Object> map : allField) {
                Object fieldValue;
                Object fieldType;
                boolean isFillValue;
                if (!"true".equals(map.get("ismustinput")) || (isFillValue = this.isDynamicFieldFillValue(fieldType = map.get("fieldtype"), fieldValue = map.get("fieldvalue")))) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u53f7\u4e3a\u201c%1$s\u201d\u7684\u8868\u5355\u7684\u201c%2$s\u201d\u3002", (String)"ProjectApprovalListPlugin_22", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), proApp.getString("billno"), map.get("showname")));
                isValid = false;
                break;
            }
        }
        return isValid;
    }

    private List<HashMap<String, Object>> getAllField(DynamicObject proApp) {
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        Comparator dynamicObjectComparator = (d1, d2) -> {
            String fieldType2;
            String fieldType1 = d1.getString("fieldtype");
            if (!fieldType1.equals(fieldType2 = d2.getString("fieldtype"))) {
                if (FieldTypeEnum.LONGTEXTTYPE.getValue().equals(fieldType1)) {
                    return 1;
                }
                if (FieldTypeEnum.LONGTEXTTYPE.getValue().equals(fieldType2)) {
                    return -1;
                }
            }
            Integer seq1 = d1.getInt("seq");
            Integer seq2 = d2.getInt("seq");
            return seq1 - seq2;
        };
        DynamicObjectCollection proFieldObjects = proApp.getDynamicObjectCollection("entryentity_dynamic");
        if (!proFieldObjects.isEmpty()) {
            Collections.sort(proFieldObjects, dynamicObjectComparator);
            for (DynamicObject proField : proFieldObjects) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                String fieldKey = proField.getString("fieldkey");
                map.put("fieldkey", fieldKey);
                map.put("showname", proField.get("fieldname"));
                map.put("fieldtype", proField.get("fieldtype"));
                map.put("fieldvalue", proField.get("fieldvalue"));
                map.put("ismustinput", Boolean.toString((Boolean)proField.get("ismustinput")));
                if (FieldTypeEnum.ASSISTDATATYPE.getValue().equals(proField.get("fieldtype"))) {
                    map.put(fieldKey + GROUPID_SUBFIX_KEY, proField.get("group"));
                }
                result.add(map);
            }
        }
        return result;
    }

    protected boolean isDynamicFieldFillValue(Object fieldType, Object fieldValue) {
        boolean isFillValue = true;
        if (fieldValue == null) {
            return false;
        }
        if (fieldType instanceof String) {
            String fieldTypeStr;
            switch (fieldTypeStr = (String)fieldType) {
                case "02": {
                    double fieldValueDouble = Double.parseDouble((String)fieldValue);
                    if (fieldValueDouble != 0.0) break;
                    isFillValue = false;
                    break;
                }
                case "03": {
                    if (!StringUtils.isEmpty((CharSequence)((String)fieldValue))) break;
                    isFillValue = false;
                    break;
                }
            }
        }
        return isFillValue;
    }

    private void showForm(Map<String, Object> data, ShowType showType, String formId) {
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        data.put("formId", formId);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(data);
        parameter.getOpenStyle().setShowType(showType);
        this.getView().showForm(parameter);
    }

    private void quickStart(String operateKey, Map<String, Object> data) {
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        switch (operateKey) {
            case "biz_travel_apply": {
                data.put("app", "tra");
                this.showForm(data, ShowType.MainNewTabPage, "er_tripreqbill");
                break;
            }
            case "biz_travel_apply_loan": {
                data.put("isloan", Boolean.TRUE);
                data.put("app", "tra");
                this.showForm(data, ShowType.MainNewTabPage, "er_tripreqbill");
                break;
            }
            case "biz_travel_reimburse": {
                data.put("app", "tra");
                this.showForm(data, ShowType.MainNewTabPage, "er_tripreimbursebill");
                break;
            }
            case "cost_apply": {
                data.put("app", "exp");
                this.showForm(data, ShowType.MainNewTabPage, "er_dailyapplybill");
                break;
            }
            case "loan": {
                data.put("app", "exp");
                this.showForm(data, ShowType.MainNewTabPage, "er_dailyloanbill");
                break;
            }
            case "cost_reimburse": {
                data.put("app", "exp");
                this.showForm(data, ShowType.MainNewTabPage, "er_dailyreimbursebill");
                break;
            }
            case "corporate_reimburse": {
                data.put("app", "exp");
                this.showForm(data, ShowType.MainNewTabPage, "er_publicreimbursebill");
                break;
            }
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] queryValues;
        for (DynamicObject row : queryValues = e.getQueryValues()) {
            DynamicObjectCollection supervisionEntry = (row = BusinessDataServiceHelper.loadSingle((Object)row.getPkValue(), (String)"pmas_pro_approval")).getDynamicObjectCollection("workentity");
            if (supervisionEntry == null || supervisionEntry.size() <= 0) continue;
            DynamicObject projectApproval = BusinessDataServiceHelper.loadSingle((Object)row.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmas_pro_approval"));
            if (projectApproval == null) {
                return;
            }
            DynamicObjectCollection supervisionCollection = projectApproval.getDynamicObjectCollection("workentity");
            ArrayList<Object> supervisionList = new ArrayList<Object>(10);
            ArrayList<DynamicObject> workList = new ArrayList<DynamicObject>(10);
            if (supervisionCollection != null && supervisionCollection.size() > 0) {
                for (DynamicObject supervision : supervisionCollection) {
                    boolean hideFlag = supervision.getBoolean("hiddendata");
                    if (!hideFlag) continue;
                    supervisionList.add(supervision.getPkValue());
                }
            }
            for (DynamicObject supervision : supervisionEntry) {
                if (supervisionList.contains(supervision.getPkValue())) continue;
                workList.add(supervision);
            }
            supervisionEntry.clear();
            supervisionEntry.addAll(workList);
            row.set("workentity", (Object)supervisionEntry);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        ListSelectedRow selRow;
        DynamicObject proApproval;
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)OPERATE_CALL_CHANGELEADER, (CharSequence)operateKey) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
            ListSelectedRow selectedRow = selectedRows.get(0);
            DynamicObject projApproval = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"pmas_pro_approval");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("formId", "pmas_changeproleader");
            param.put("projApprovalID", projApproval.getPkValue());
            DynamicObject projObj = projApproval.getDynamicObject("pro");
            param.put("projectID", projObj.getPkValue());
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
            this.getView().getFormShowParameter().getOpenStyle().getShowType();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equals((CharSequence)ADJUSTSUPERVISION, (CharSequence)operateKey)) {
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
            DynamicObject proApproval2 = BusinessDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"pmas_pro_approval");
            String billStatus = proApproval2.getString("billstatus");
            DynamicObject proStatus = ProjectApprovalHelper.getProStatus((Object)proApproval2.getPkValue(), (String)ProjectStageEnum.PROPOSALSTAGE_S.getValue(), (String)ProjectStatusEnum.APPROVAL_SUCC.getValue());
            DynamicObject projectStatus = proApproval2.getDynamicObject("prostatus");
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u8c03\u6574\u4e00\u4e2a\u9879\u76ee\u7684\u201c\u5de5\u4f5c\u7763\u5bfc\u201d\u8bbe\u7f6e\u3002", (String)"ProjectApprovalListPlugin_23", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            } else if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ProjectApprovalListPlugin_24", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            } else if (!billStatus.equals("C") || proStatus == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u672a\u7acb\u9879\u901a\u8fc7\uff0c\u65e0\u6cd5\u8fdb\u884c\u201c\u5de5\u4f5c\u7763\u5bfc\u201d\u8c03\u6574\u3002", (String)"ProjectApprovalListPlugin_25", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            } else if (projectStatus.getString("number").equals("BUSINESSCLOSURE_S") || projectStatus.getString("number").equals("FINANCIALCLOSURE_S") || projectStatus.getString("number").equals("FAILED_S")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u201c%s\u201d\u65e0\u6cd5\u8fdb\u884c\u201c\u5de5\u4f5c\u7763\u5bfc\u201d\u8c03\u6574\u3002", (String)"ProjectApprovalListPlugin_26", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), projectStatus.getString("name")));
            } else {
                DynamicObject project = proApproval2.getDynamicObject("pro");
                if (project != null) {
                    QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"B");
                    QFilter proFilter = new QFilter("project.id", "=", project.getPkValue());
                    DynamicObject[] superVisions = BusinessDataServiceHelper.load((String)"pmas_projectsupervision", (String)"id", (QFilter[])new QFilter[]{billStatusFilter, proFilter});
                    if (superVisions.length > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u5b58\u5728\u672a\u5ba1\u6279\u7684\u8c03\u6574\u8bb0\u5f55\uff0c\u8bf7\u52ff\u91cd\u590d\u8c03\u6574\u3002", (String)"ProjectApprovalListPlugin_13", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    } else {
                        billStatusFilter = new QFilter("billstatus", "=", (Object)"A");
                        superVisions = BusinessDataServiceHelper.load((String)"pmas_projectsupervision", (String)"id", (QFilter[])new QFilter[]{billStatusFilter, proFilter});
                        if (superVisions.length > 0) {
                            DynamicObject superVision = superVisions[0];
                            BillShowParameter billShowParameter = new BillShowParameter();
                            billShowParameter.setPkId(superVision.getPkValue());
                            billShowParameter.setFormId("pmas_projectsupervision");
                            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                            this.getView().showForm((FormShowParameter)billShowParameter);
                        } else {
                            QFilter latestFilter = new QFilter("latestversion", "=", (Object)Boolean.TRUE);
                            billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
                            superVisions = BusinessDataServiceHelper.load((String)"pmas_projectsupervision", (String)String.join((CharSequence)",", "auditdate"), (QFilter[])new QFilter[]{billStatusFilter, proFilter, latestFilter});
                            HashMap<String, Object> map = new HashMap<String, Object>(16);
                            DynamicObject org = proApproval2.getDynamicObject(SEARCH_USER_ORG_ID);
                            if (superVisions.length > 0) {
                                DynamicObject superVision = superVisions[0];
                                map.put("formId", "pmas_projectsupervision");
                                map.put("id", superVision.getPkValue());
                                map.put("orgId", org.getPkValue());
                                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                                this.getView().showForm(parameter);
                            } else {
                                map.put("formId", "pmas_projectsupervision");
                                map.put("projectId", project.getPkValue());
                                map.put("orgId", org.getPkValue());
                                map.put("projectkind", proApproval2.getDynamicObject("kind").getPkValue());
                                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                                this.getView().showForm(parameter);
                            }
                        }
                    }
                }
            }
        } else if (StringUtils.equals((CharSequence)VIEWADJUSTSUPERVISION, (CharSequence)operateKey)) {
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u67e5\u770b\u4e00\u4e2a\u9879\u76ee\u7684\u201c\u5de5\u4f5c\u7763\u5bfc\u201d\u8c03\u6574\u8bb0\u5f55\u3002", (String)"ProjectApprovalListPlugin_27", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            } else if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"ProjectApprovalListPlugin_24", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            } else {
                ListSelectedRow selectedRow = selectedRows.get(0);
                DynamicObject proApproval3 = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"pmas_pro_approval");
                String billStatus = proApproval3.getString("billstatus");
                DynamicObject proStatus = ProjectApprovalHelper.getProStatus((Object)proApproval3.getPkValue(), (String)ProjectStageEnum.PROPOSALSTAGE_S.getValue(), (String)ProjectStatusEnum.APPROVAL_SUCC.getValue());
                if (!billStatus.equals("C") || proStatus == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u6682\u672a\u7acb\u9879\u901a\u8fc7\uff0c\u65e0\u6cd5\u67e5\u770b\u8c03\u6574\u8bb0\u5f55\u3002", (String)"ProjectApprovalListPlugin_28", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                } else {
                    DynamicObject project = proApproval3.getDynamicObject("pro");
                    DynamicObject projectKind = proApproval3.getDynamicObject("kind");
                    ListShowParameter listShowParameter = new ListShowParameter();
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("project", project.getPkValue().toString());
                    map.put("projectkind", projectKind.getPkValue().toString());
                    QFilter projectFilter = new QFilter("project.id", "=", project.getPkValue());
                    listShowParameter.setCustomParams(map);
                    listShowParameter.getListFilterParameter().setFilter(null);
                    listShowParameter.getListFilterParameter().setFilter(projectFilter);
                    listShowParameter.setBillFormId("pmas_projectsupervision");
                    listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)listShowParameter);
                }
            }
        } else if (StringUtils.equals((CharSequence)OPERATE_APPROVAL, (CharSequence)operateKey)) {
            boolean success = args.getOperationResult().getValidateResult().isSuccess();
            if (!success) {
                return;
            }
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
            ListSelectedRow selectedRow = selectedRows.get(0);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("operation", operateKey);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setPkId(selectedRow.getPrimaryKeyValue());
            billShowParameter.setFormId("pmas_pro_approval");
            billShowParameter.setCustomParams(param);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
        } else if (StringUtils.equals((CharSequence)OPERATE_REFRESH, (CharSequence)operateKey)) {
            this.constructLeftTree();
        } else if (StringUtils.equals((CharSequence)changeApprovalAmt, (CharSequence)operateKey) && (proApproval = BusinessDataServiceHelper.loadSingle((Object)(selRow = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection().get(0)).getPrimaryKeyValue(), (String)"pmas_pro_approval")) != null && proApproval.getDynamicObject("pro") != null) {
            DynamicObject pro = proApproval.getDynamicObject("pro");
            DynamicObject org = proApproval.getDynamicObject(SEARCH_USER_ORG_ID);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("formId", "pmas_approval_amtmodify");
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(param);
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setCustomParam("projectId", (Object)pro.getPkValue().toString());
            showParameter.setCustomParam("orgId", (Object)org.getPkValue().toString());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        DynamicObject projectKindSetting;
        DynamicObject billType;
        super.beforeShowBill(e);
        String projectKindSettingId = this.getView().getPageCache().get("projectKindSetting");
        this.getView().getPageCache().remove("projectKindSetting");
        if (StringUtils.isNotEmpty((CharSequence)projectKindSettingId) && (billType = (DynamicObject)(projectKindSetting = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(projectKindSettingId), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmbs_prokindctrlsetting"))).get("probilltype")) != null) {
            BillShowParameter parameter = e.getParameter();
            parameter.setBillTypeId(billType.getPkValue().toString());
        }
    }

    protected TreeNode rebuildProjectKindTreeRoot() {
        TreeNode root = new TreeNode();
        root.setId("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
        root.setText(this.getRootNodeName());
        return root;
    }

    public String getRootNodeName() {
        return ResManager.loadKDString((String)"\u5168\u90e8", (String)"ProjectApprovalListPlugin_29", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]);
    }

    protected void replenishReportOrg(DynamicObject proApp) {
        boolean needApproval = proApp.getBoolean("needapproval");
        if (needApproval) {
            String orgId;
            DynamicObject org = proApp.getDynamicObject(SEARCH_USER_ORG_ID);
            DynamicObject kind = proApp.getDynamicObject("kind");
            String kindId = kind != null ? kind.getPkValue().toString() : null;
            DynamicObject reportOrg = ReportConfigUtils.gainReportorg((String)kindId, (String)(orgId = org != null ? org.getPkValue().toString() : null), (String)"pmas_pro_approval");
            if (reportOrg != null) {
                proApp.set("reportorg", (Object)reportOrg);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{proApp});
            }
        }
    }

    protected String getOrgKey() {
        ListView view = (ListView)this.getView();
        String billFormId = view.getBillFormId();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billFormId);
        return mainType.getMainOrg() == null ? SEARCH_USER_ORG_ID : mainType.getMainOrg();
    }

    protected String getOrgFilterKey() {
        return this.getOrgKey().concat(".id");
    }

    protected String getProjectKey() {
        return "pro";
    }

    protected String getProjectFilterKey() {
        return this.getProjectKey().concat(".id");
    }
}

