/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.projteam;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmas.business.helper.ProjectTeamHelper;
import kd.pmgt.pmas.common.utils.ImportProjTeamUtils;
import kd.pmgt.pmas.formplugin.base.AbstractPmasBillPlugin;
import kd.pmgt.pmbs.business.helper.UserOrgRangeHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import org.apache.commons.collections4.CollectionUtils;

public class AddTmemberBillPlugin
extends AbstractPmasBillPlugin
implements BeforeF7SelectListener,
UploadListener {
    private static final String IMPORTENTRY_OP = "importentry";
    private static final String TEMPLATEEXPORT_OP = "templateexport";
    private static final String[] COLUMNKEY = new String[]{"member", "role", "telno", "empnum", "stafftype", "note"};
    private static final String[] FAIL_COLUMNKEY = new String[]{"member", "role", "telno", "empnum", "stafftype", "note", "failmsg"};
    private static String[] header = null;
    private static String[] failHeader = null;
    private static String[] FAIL_CHAR_COLUMNKEY = null;
    private static final String BACK_USERF7 = "back_userf7";
    private static final String SELECTED_MEMBER_CUREENT_ROW_INDEX = "rowindex";

    private List<String> getMustFillColumn() {
        List<String> mustFillColumn = Collections.singletonList(ResManager.loadKDString((String)"\u59d3\u540d", (String)"AddTmemberBillPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
        return mustFillColumn;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTeamOrg();
    }

    protected void initTeamOrg() {
        DynamicObjectCollection teamEntries = this.getView().getModel().getEntryEntity("tmemberentry");
        for (DynamicObject teamEntry : teamEntries) {
            DynamicObject mainOrg;
            DynamicObject member = teamEntry.getDynamicObject("member");
            if (member == null || (mainOrg = ProjectTeamHelper.getUserAdminOrgId((long)((Long)member.getPkValue()))) == null) continue;
            teamEntry.set("insideorg", (Object)mainOrg);
            teamEntry.set("insidecompany", (Object)OrgTreeUtils.getSuperCompanyOrg((long)((Long)mainOrg.getPkValue())));
        }
        this.getModel().updateEntryCache(teamEntries);
        this.getView().updateView("tmemberentry");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit teamRole = (BasedataEdit)this.getControl("role");
        teamRole.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit teamMember = (BasedataEdit)this.getControl("member");
        teamMember.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit outPartner = (BasedataEdit)this.getControl("outpartner");
        outPartner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "importPageClosed": {
                String url = (String)evt.getReturnData();
                if (url == null || "".equals(url.trim())) {
                    return;
                }
                String colhash = POIHelper.stringArrayToHash((String[])COLUMNKEY);
                JSONArray jsonArray = POIHelper.importProjTeamExcel((String)url, (String)colhash);
                ImportProjTeamUtils.finishImportAdd((JSONArray)jsonArray, (IDataModel)this.getModel(), (IFormView)this.getView(), (String[])failHeader, (String[])FAIL_COLUMNKEY);
                break;
            }
            case "back_userf7": {
                ListSelectedRowCollection returnData = (ListSelectedRowCollection)evt.getReturnData();
                if (returnData == null) break;
                DynamicObjectCollection teamEntry = this.getView().getModel().getEntryEntity("tmemberentry");
                String s = this.getPageCache().get(SELECTED_MEMBER_CUREENT_ROW_INDEX);
                int selectedRowIndex = Integer.parseInt(s);
                teamEntry.remove(selectedRowIndex);
                this.getView().getModel().beginInit();
                for (int i = 0; i < returnData.size(); ++i) {
                    DynamicObject rowObject = new DynamicObject(teamEntry.getDynamicObjectType());
                    ListSelectedRow selectedRow = returnData.get(i);
                    DynamicObject bos_user = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"bos_user", (String)"id,name,phone");
                    rowObject.set("member", (Object)bos_user);
                    rowObject.set("telno", bos_user.get("phone"));
                    DynamicObject mainOrg = ProjectTeamHelper.getUserAdminOrgId((long)((Long)bos_user.getPkValue()));
                    if (mainOrg != null) {
                        rowObject.set("insideorg", (Object)mainOrg);
                        rowObject.set("insidecompany", (Object)OrgTreeUtils.getSuperCompanyOrg((long)((Long)mainOrg.getPkValue())));
                    }
                    teamEntry.add(i + selectedRowIndex, rowObject);
                }
                this.getView().getModel().endInit();
                this.getModel().updateCache();
                this.getModel().updateEntryCache(teamEntry);
                this.getView().updateView();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "importentry": {
                Object project = this.getModel().getValue("project");
                if (project == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9879\u76ee\u518d\u5bfc\u5165Excel\u3002", (String)"AddTmemberBillPlugin_8", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection teamMamberEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("tmemberentry");
                DynamicObjectCollection outTeamMamberEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("outtmemberentry");
                if (CollectionUtils.isEmpty((Collection)teamMamberEntrys) && CollectionUtils.isEmpty((Collection)outTeamMamberEntrys)) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("fileName", ResManager.loadKDString((String)"\u7533\u8bf7\u9879\u76ee\u6210\u5458\u6a21\u677f", (String)"AddTmemberBillPlugin_9", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    params.put("sheetName", ResManager.loadKDString((String)"\u7533\u8bf7\u9879\u76ee\u6210\u5458\u6a21\u677f", (String)"AddTmemberBillPlugin_9", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    ImportProjTeamUtils.openImportExcelPage((AbstractBillPlugIn)this, (String)"pmbs_projteamimportexcel", params, (String)"importPageClosed");
                    break;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(IMPORTENTRY_OP, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5bfc\u5165\u64cd\u4f5c\u5c06\u6e05\u7a7a\u7533\u8bf7\u660e\u7ec6\u5206\u5f55\u5185\u5bb9\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"AddTmemberBillPlugin_10", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
                break;
            }
            case "templateexport": {
                String fileName = ResManager.loadKDString((String)"\u7533\u8bf7\u9879\u76ee\u6210\u5458\u6a21\u677f", (String)"AddTmemberBillPlugin_9", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]);
                String sheetName = ResManager.loadKDString((String)"\u7533\u8bf7\u9879\u76ee\u6210\u5458\u6a21\u677f", (String)"AddTmemberBillPlugin_9", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]);
                JSONArray data = new JSONArray();
                String url = POIHelper.exportExcel((String)fileName, (String)sheetName, (String[])header, (String[])COLUMNKEY, this.getMustFillColumn(), (JSONArray)data);
                this.getView().download(url);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u51fa\u6210\u529f\u3002", (String)"AddTmemberBillPlugin_11", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)IMPORTENTRY_OP, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("fileName", ResManager.loadKDString((String)"\u7533\u8bf7\u9879\u76ee\u6210\u5458\u6a21\u677f", (String)"AddTmemberBillPlugin_9", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            params.put("sheetName", ResManager.loadKDString((String)"\u7533\u8bf7\u9879\u76ee\u6210\u5458\u6a21\u677f", (String)"AddTmemberBillPlugin_9", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
            ImportProjTeamUtils.openImportExcelPage((AbstractBillPlugIn)this, (String)"pmbs_projteamimportexcel", params, (String)"importPageClosed");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
        int curRowIndex = this.getModel().getEntryCurrentRowIndex("tmemberentry");
        switch (key) {
            case "member": {
                param.setF7Style(3);
                List qFilterList = param.getListFilterParameter().getQFilters();
                long currUserId = RequestContext.get().getCurrUserId();
                QFilter qFilter = UserOrgRangeHelper.loadUserOrgRangesByPermOrg((String)String.valueOf(currUserId), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getEntityId());
                if (qFilter != null) {
                    qFilterList.add(qFilter);
                }
                this.getPageCache().put(SELECTED_MEMBER_CUREENT_ROW_INDEX, String.valueOf(curRowIndex));
                e.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, BACK_USERF7));
                break;
            }
            case "role": {
                DynamicObject member = (DynamicObject)this.getModel().getValue("member", curRowIndex);
                if (member != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4eba\u5458\u3002", (String)"AddTmemberBillPlugin_12", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "project": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u518d\u9009\u62e9\u9879\u76ee\u3002", (String)"AddTmemberBillPlugin_13", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "outpartner": {
                ProjectTeamHelper.beforeF7OutPartner((FormShowParameter)e.getFormShowParameter());
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        long userId = RequestContext.get().getCurrUserId();
        this.getModel().setValue("applicant", (Object)userId);
        boolean isApplyBill = (Boolean)this.getModel().getValue("isapplybill");
        if (!isApplyBill) {
            int row = this.getModel().createNewEntryRow("tmemberentry");
            DynamicObject bos_user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
            this.getModel().setValue("member", (Object)userId, row);
            this.getModel().setValue("telno", bos_user.get("phone"), row);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        int curIndex = changeData.getRowIndex();
        switch (name) {
            case "member": {
                this.getModel().setValue("role", null, curIndex);
                if (newValue == null) {
                    this.getModel().setValue("telno", null, curIndex);
                    this.getModel().setValue("insideorg", null, curIndex);
                    this.getModel().setValue("insidecompany", null, curIndex);
                    break;
                }
                DynamicObject member = (DynamicObject)newValue;
                this.getModel().setValue("telno", (Object)member.getString("phone"), curIndex);
                DynamicObject mainOrg = ProjectTeamHelper.getUserAdminOrgId((long)((Long)member.getPkValue()));
                if (mainOrg == null) break;
                this.getModel().setValue("insideorg", (Object)mainOrg, curIndex);
                this.getModel().setValue("insidecompany", (Object)OrgTreeUtils.getSuperCompanyOrg((long)((Long)mainOrg.getPkValue())), curIndex);
                break;
            }
            case "role": {
                HashMap<String, String> paraMap = new HashMap<String, String>();
                paraMap.put("member", "member");
                paraMap.put("role", "role");
                paraMap.put("entry", "tmemberentry");
                boolean isUnique = ImportProjTeamUtils.isUserRoleUnique((AbstractBillPlugIn)this, (int)curIndex, paraMap);
                if (isUnique) break;
                this.getModel().setValue("role", changeData.getOldValue(), curIndex);
                break;
            }
            case "project": {
                DynamicObject project;
                DynamicObject[] nowTeamObjs;
                if (newValue == null) break;
                DynamicObject applicant = (DynamicObject)this.getModel().getValue("applicant");
                boolean exists = this.isExists((DynamicObject)newValue, applicant, this.getModel().getDataEntity().getPkValue().toString());
                if (exists) {
                    this.getModel().setValue("project", null);
                }
                if ((nowTeamObjs = ProjectApprovalHelper.getNowTeamManager((Object)(project = (DynamicObject)newValue).getPkValue())).length > 0) {
                    DynamicObject nowTeamObj = nowTeamObjs[0];
                    this.getModel().setValue("proleader", (Object)nowTeamObj.getDynamicObject("member"));
                    break;
                }
                boolean isApplyBill = (Boolean)this.getModel().getValue("isapplybill");
                if (isApplyBill) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9879\u76ee\u65e0\u201c\u9879\u76ee\u8d1f\u8d23\u4eba\u201d\uff0c\u65e0\u6cd5\u63d0\u4ea4\u7533\u8bf7\u3002\u8bf7\u8054\u7cfb\u9879\u76ee\u7ecf\u7406\u914d\u7f6e\u201c\u9879\u76ee\u8d1f\u8d23\u4eba\u201d\u3002", (String)"AddTmemberBillPlugin_14", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                this.getModel().setValue("project", null);
                break;
            }
            case "applicant": {
                DynamicObject project;
                boolean exists;
                if (newValue == null || !(exists = this.isExists(project = (DynamicObject)this.getModel().getValue("project"), (DynamicObject)newValue, this.getModel().getDataEntity().getPkValue().toString()))) break;
                this.getModel().setValue("applicant", null);
                break;
            }
            case "outpartner": {
                DynamicObject partner = (DynamicObject)newValue;
                if (partner == null) break;
                this.getModel().setValue("outbizparter", (Object)ProjectTeamHelper.getBizPartner((Object)partner.getPkValue()), curIndex);
                break;
            }
        }
    }

    private boolean isExists(DynamicObject project, DynamicObject applicant, String billid) {
        String projectId;
        boolean isExists = false;
        String string = projectId = project == null ? null : project.getPkValue().toString();
        if (StringUtils.isEmpty((CharSequence)projectId)) {
            return false;
        }
        boolean isApplyBill = (Boolean)this.getModel().getValue("isapplybill");
        QFilter filter = new QFilter("project", "=", (Object)Long.valueOf(projectId));
        filter.and("applicant", "=", applicant.getPkValue());
        filter.and("billstatus", "!=", (Object)StatusEnum.CHECKED.getValue());
        filter.and("id", "!=", (Object)Long.valueOf(billid));
        filter.and("isapplybill", "=", (Object)isApplyBill);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"pmas_addtmemberbill", (String)"id,billname,billno,billstatus", (QFilter[])new QFilter[]{filter});
        if (load.length > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5b8c\u6210\u9879\u76ee\u7684%2$s\u5355\uff0c\u72b6\u6001\u4e3a\u5f85\u5ba1\u6838\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7\u3002", (String)"AddTmemberBillPlugin_15", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), applicant.getString("name"), this.getModel().getDataEntityType().getDisplayName()), Integer.valueOf(5000));
            isExists = true;
        }
        return isExists;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    static {
        header = new String[]{ResManager.loadKDString((String)"\u59d3\u540d", (String)"AddTmemberBillPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u89d2\u8272", (String)"AddTmemberBillPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8054\u7cfb\u7535\u8bdd", (String)"AddTmemberBillPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5de5\u53f7", (String)"AddTmemberBillPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578b", (String)"AddTmemberBillPlugin_4", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"AddTmemberBillPlugin_5", (String)"pmgt-pmas-formplugin", (Object[])new Object[0])};
        failHeader = new String[]{ResManager.loadKDString((String)"\u59d3\u540d", (String)"AddTmemberBillPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u89d2\u8272", (String)"AddTmemberBillPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8054\u7cfb\u7535\u8bdd", (String)"AddTmemberBillPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5de5\u53f7", (String)"AddTmemberBillPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578b", (String)"AddTmemberBillPlugin_4", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"AddTmemberBillPlugin_5", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\u63d0\u793a", (String)"AddTmemberBillPlugin_6", (String)"pmgt-pmas-formplugin", (Object[])new Object[0])};
        FAIL_CHAR_COLUMNKEY = new String[]{ResManager.loadKDString((String)"\u59d3\u540d*", (String)"AddTmemberBillPlugin_7", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u89d2\u8272", (String)"AddTmemberBillPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8054\u7cfb\u7535\u8bdd", (String)"AddTmemberBillPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5de5\u53f7", (String)"AddTmemberBillPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578b", (String)"AddTmemberBillPlugin_4", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5907\u6ce8", (String)"AddTmemberBillPlugin_5", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]), "failmsg"};
    }
}

