/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmas.formplugin.projteam;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.pmgt.pmas.business.helper.ProjectApprovalHelper;
import kd.pmgt.pmas.business.helper.ProjectTeamHelper;
import kd.pmgt.pmas.formplugin.base.AbstractPmasBillPlugin;
import kd.pmgt.pmbs.common.enums.AuditStatusEnum;
import kd.pmgt.pmbs.common.enums.BillTypeEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.enums.TeamAdjustTypeEnum;
import kd.pmgt.pmbs.common.utils.OrgTreeUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ProjTeamViewUIPlugin
extends AbstractPmasBillPlugin {
    private static final String NEWTEAM_OP = "newteam";
    private static final String ADJUSTTEAM_OP = "adjustteam";
    private static final String BAR_NEWTEAM = "bar_newteam";
    private static final String BAR_ADJUST = "bar_adjust";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object project = this.getView().getFormShowParameter().getCustomParam("projectId");
        Long projectPk = project != null ? Long.valueOf(project.toString()) : null;
        this.loadData(projectPk);
        this.loadOutData(projectPk);
        DynamicObjectCollection members = this.getModel().getDataEntity().getDynamicObjectCollection("nowteamentry");
        DynamicObjectCollection adjustEntries = this.getModel().getDataEntity().getDynamicObjectCollection("chteamentry");
        DynamicObjectCollection outMembers = this.getModel().getDataEntity().getDynamicObjectCollection("outnowteamentry");
        DynamicObjectCollection outAdjustEntries = this.getModel().getDataEntity().getDynamicObjectCollection("outchteamentry");
        if (members.size() < 1 && adjustEntries.size() < 1 && outMembers.size() < 1 && outAdjustEntries.size() < 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_ADJUST});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_NEWTEAM});
        }
    }

    private void loadOutData(Object project) {
        this.getModel().deleteEntryData("outnowteamentry");
        this.getModel().deleteEntryData("outchteamentry");
        QFilter filter = new QFilter("project", "=", project);
        DynamicObjectCollection outMembers = QueryServiceHelper.query((String)"pmas_outnowteam", (String)"project, seqno, member, role, telno, description,outpartner,roleobj,outbizparter", (QFilter[])new QFilter[]{filter}, (String)"seqno");
        for (DynamicObject member : outMembers) {
            int rowIndex = this.getModel().createNewEntryRow("outnowteamentry");
            this.getModel().setValue("outmember", member.get("member"), rowIndex);
            this.getModel().setValue("outrole", member.get("role"), rowIndex);
            this.getModel().setValue("outtelno", member.get("telno"), rowIndex);
            this.getModel().setValue("outnote", member.get("description"), rowIndex);
            this.getModel().setValue("outroleobj", member.get("roleobj"), rowIndex);
            this.getModel().setValue("outpartner", member.get("outpartner"), rowIndex);
            this.getModel().setValue("outbizpartner", member.get("outbizparter"), rowIndex);
        }
        List<HashMap<String, Object>> outAdjustEntries = this.getOutAdjustEntries(project);
        EntryGrid entryGrid = (EntryGrid)this.getControl("outchteamentry");
        for (HashMap<String, Object> entry : outAdjustEntries) {
            int rowIndex = this.getModel().createNewEntryRow("outchteamentry");
            String outAdjustMember = (String)entry.get("outchmember");
            this.getModel().setValue("outchmember", (Object)outAdjustMember, rowIndex);
            this.getModel().setValue("outchrole", entry.get("outchrole"), rowIndex);
            this.getModel().setValue("outchtelno", entry.get("outchtelno"), rowIndex);
            this.getModel().setValue("outchnote", entry.get("outchnote"), rowIndex);
            this.getModel().setValue("outchchangetype", entry.get("outchchangetype"), rowIndex);
            this.getModel().setValue("outdate", entry.get("outdate"), rowIndex);
            this.getModel().setValue("outprerole", entry.get("outprerole"), rowIndex);
            this.getModel().setValue("outchpartner", entry.get("outchpartner"), rowIndex);
            this.getModel().setValue("outchbizpartner", entry.get("outchbizpartner"), rowIndex);
            this.getModel().setValue("outchroleobj", entry.get("outchroleobj"), rowIndex);
            this.getModel().setValue("outpreroleobj", entry.get("outpreroleobj"), rowIndex);
            if (!this.checkIsLastAdjust(outMembers, entry, outAdjustEntries)) continue;
            entryGrid.setRowBackcolor("#00FFFF", new int[]{rowIndex});
        }
    }

    private boolean checkIsLastAdjust(DynamicObjectCollection outMembers, HashMap<String, Object> entryAdjust, List<HashMap<String, Object>> outAdjustEntries) {
        String outAdjustMember = (String)entryAdjust.get("outchmember");
        outAdjustEntries = outAdjustEntries.stream().filter(item -> StringUtils.equals((CharSequence)((String)item.get("outchmember")), (CharSequence)outAdjustMember)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty((Collection)outMembers)) {
            return false;
        }
        boolean exists = outMembers.stream().anyMatch(outManObj -> StringUtils.equals((CharSequence)outManObj.getString("member"), (CharSequence)outAdjustMember));
        if (!exists) {
            return false;
        }
        long maxOutdata = outAdjustEntries.stream().mapToLong(item -> {
            if (item.get("outdate") == null) {
                return 0L;
            }
            return ((Date)item.get("outdate")).getTime();
        }).max().getAsLong();
        long currentOutDate = entryAdjust.get("outdate") == null ? 0L : ((Date)entryAdjust.get("outdate")).getTime();
        return new BigDecimal(currentOutDate).compareTo(new BigDecimal(maxOutdata)) == 0;
    }

    private List<HashMap<String, Object>> getOutAdjustEntries(Object project) {
        DynamicObject[] addTeamBills;
        DynamicObject[] adjusts;
        ArrayList<HashMap<String, Object>> adjustEntries = new ArrayList();
        String selectors = "id,auditdate,type,description,chteamouterentry,chteamouterentry.id,chteamouterentry.outchmember,chteamouterentry.outchrole,chteamouterentry.outchtelno,chteamouterentry.outchnote,chteamouterentry.outchangetype,chteamouterentry.outchprerole," + String.join((CharSequence)",", "outchpreroleobj", "outchroleobj", "outchpartner", "outchbizpartner");
        QFilter filter1 = new QFilter("project", "=", project);
        QFilter filter2 = new QFilter("type", "=", (Object)BillTypeEnum.ADJUST);
        QFilter filter3 = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        for (DynamicObject obj : adjusts = BusinessDataServiceHelper.load((String)"pmas_teamadjust", (String)selectors, (QFilter[])new QFilter[]{filter1, filter2, filter3}, (String)"auditdate desc")) {
            Object auditDate = obj.get("auditdate");
            DynamicObjectCollection outTeamEntries = obj.getDynamicObjectCollection("chteamouterentry");
            for (DynamicObject entry : outTeamEntries) {
                HashMap<String, Object> outMemberMap = new HashMap<String, Object>();
                outMemberMap.put("outchmember", entry.getString("outchmember"));
                outMemberMap.put("outchrole", entry.getString("outchrole"));
                outMemberMap.put("outchtelno", entry.get("outchtelno"));
                outMemberMap.put("outchnote", entry.get("outchnote"));
                outMemberMap.put("outchchangetype", entry.get("outchangetype"));
                outMemberMap.put("outdate", auditDate);
                outMemberMap.put("outprerole", entry.get("outchprerole"));
                outMemberMap.put("outchpartner", entry.get("outchpartner"));
                outMemberMap.put("outpreroleobj", entry.get("outchpreroleobj"));
                outMemberMap.put("outchroleobj", entry.get("outchroleobj"));
                outMemberMap.put("outchbizpartner", entry.get("outchbizpartner"));
                adjustEntries.add(outMemberMap);
            }
        }
        QFilter proFilter = new QFilter("project", "=", project);
        proFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        proFilter.and("auditstatus", "=", (Object)AuditStatusEnum.AUDITED.getValue());
        for (DynamicObject addmember : addTeamBills = BusinessDataServiceHelper.load((String)"pmas_addtmemberbill", (String)("id,billstatus,auditstatus,auditdate,applytime,project,opinion,outtmemberentry.id,outtmemberentry.outmember,outtmemberentry.outrole,outtmemberentry.outtelno,outtmemberentry.outnote," + String.join((CharSequence)",", "outroleobj", "outpartner", "outbizparter")), (QFilter[])new QFilter[]{proFilter})) {
            Object auditDate = addmember.get("auditdate");
            DynamicObjectCollection outMemberEntries = addmember.getDynamicObjectCollection("outtmemberentry");
            for (DynamicObject entry : outMemberEntries) {
                HashMap<String, Object> memberMap = new HashMap<String, Object>();
                memberMap.put("outchmember", entry.get("outmember"));
                memberMap.put("outchrole", entry.get("outrole"));
                memberMap.put("outchtelno", entry.get("outtelno"));
                memberMap.put("outchnote", entry.get("outnote"));
                memberMap.put("outchchangetype", TeamAdjustTypeEnum.APPLY_IN.getValue());
                memberMap.put("outdate", auditDate);
                memberMap.put("outchroleobj", entry.get("outroleobj"));
                memberMap.put("outchpartner", entry.get("outpartner"));
                memberMap.put("outchbizpartner", entry.get("outbizparter"));
                adjustEntries.add(memberMap);
            }
        }
        adjustEntries = adjustEntries.stream().sorted(Comparator.comparing(o -> (Date)o.get("outdate")).reversed()).collect(Collectors.toList());
        return adjustEntries;
    }

    private void loadData(Object project) {
        int rowIndex;
        DynamicObject[] members;
        this.getModel().deleteEntryData("nowteamentry");
        this.getModel().deleteEntryData("chteamentry");
        this.getModel().setValue("project", project);
        DynamicObject nowTeamObj = ProjectApprovalHelper.getNowTeamObj((Object)project);
        if (nowTeamObj != null) {
            this.getModel().setValue("projleader", (Object)nowTeamObj.getDynamicObject("member"));
            this.getModel().setValue("proleadertelno", (Object)nowTeamObj.getString("telno"));
        }
        QFilter filter = new QFilter("project", "=", project);
        for (DynamicObject member : members = BusinessDataServiceHelper.load((String)"pmas_nowteam", (String)"id,project,seqno,member,ischarge,role,telno,description", (QFilter[])new QFilter[]{filter}, (String)"seqno")) {
            DynamicObject mainOrg;
            rowIndex = this.getModel().createNewEntryRow("nowteamentry");
            this.getModel().setValue("member", member.get("member"), rowIndex);
            this.getModel().setValue("role", member.get("role"), rowIndex);
            this.getModel().setValue("telno", member.get("telno"), rowIndex);
            this.getModel().setValue("ischarge", member.get("ischarge"), rowIndex);
            this.getModel().setValue("note", member.get("description"), rowIndex);
            DynamicObject person = member.getDynamicObject("member");
            if (person == null || (mainOrg = ProjectTeamHelper.getUserAdminOrgId((long)((Long)person.getPkValue()))) == null) continue;
            this.getModel().setValue("entryorg", (Object)mainOrg, rowIndex);
            this.getModel().setValue("entrycompany", (Object)OrgTreeUtils.getSuperCompanyOrg((long)((Long)mainOrg.getPkValue())), rowIndex);
        }
        List<HashMap<String, Object>> adjustEntries = this.getAdjustEntries(project);
        EntryGrid entryGrid = (EntryGrid)this.getControl("chteamentry");
        for (HashMap<String, Object> entry : adjustEntries) {
            DynamicObject mainOrg;
            rowIndex = this.getModel().createNewEntryRow("chteamentry");
            DynamicObject member = (DynamicObject)entry.get("chmember");
            DynamicObject role = (DynamicObject)entry.get("chrole");
            this.getModel().setValue("chmember", (Object)member, rowIndex);
            this.getModel().setValue("chrole", (Object)role, rowIndex);
            this.getModel().setValue("chtelno", entry.get("chtelno"), rowIndex);
            this.getModel().setValue("chnote", entry.get("chnote"), rowIndex);
            this.getModel().setValue("ischargech", entry.get("ischargech"), rowIndex);
            this.getModel().setValue("chchangetype", entry.get("chchangetype"), rowIndex);
            this.getModel().setValue("date", entry.get("date"), rowIndex);
            this.getModel().setValue("prerole", entry.get("prerole"), rowIndex);
            if (this.checkIsNowMember(member)) {
                entryGrid.setRowBackcolor("#00FFFF", new int[]{rowIndex});
            }
            if (member == null || (mainOrg = ProjectTeamHelper.getUserAdminOrgId((long)((Long)member.getPkValue()))) == null) continue;
            this.getModel().setValue("chorg", (Object)mainOrg, rowIndex);
            this.getModel().setValue("chcompany", (Object)OrgTreeUtils.getSuperCompanyOrg((long)((Long)mainOrg.getPkValue())), rowIndex);
        }
    }

    @NotNull
    private List<HashMap<String, Object>> getAdjustEntries(Object project) {
        DynamicObject[] addTeamBills;
        DynamicObject[] adjusts;
        ArrayList<HashMap<String, Object>> adjustEntries = new ArrayList();
        String selectors = "id,auditdate,type,description,chteamentry,chteamentry.id,chteamentry.chmember,chteamentry.chrole,chteamentry.ischargech,chteamentry.chtelno,chteamentry.chnote,chteamentry.changetype,chteamentry.prerole," + String.join((CharSequence)",", "chorg", "chcompany");
        QFilter filter1 = new QFilter("project", "=", project);
        QFilter filter2 = new QFilter("type", "=", (Object)BillTypeEnum.ADJUST);
        QFilter filter3 = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        for (DynamicObject obj : adjusts = BusinessDataServiceHelper.load((String)"pmas_teamadjust", (String)selectors, (QFilter[])new QFilter[]{filter1, filter2, filter3}, (String)"auditdate desc")) {
            Object auditDate = obj.get("auditdate");
            DynamicObjectCollection teamEntries = obj.getDynamicObjectCollection("chteamentry");
            for (DynamicObject entry : teamEntries) {
                DynamicObject member = entry.getDynamicObject("chmember");
                DynamicObject role = entry.getDynamicObject("chrole");
                HashMap<String, Object> memberMap = new HashMap<String, Object>();
                memberMap.put("chmember", member);
                memberMap.put("chrole", role);
                memberMap.put("chtelno", entry.get("chtelno"));
                memberMap.put("chnote", entry.get("chnote"));
                memberMap.put("ischargech", entry.get("ischargech"));
                memberMap.put("chchangetype", entry.get("changetype"));
                memberMap.put("date", auditDate);
                memberMap.put("prerole", entry.get("prerole"));
                memberMap.put("chorg", entry.get("chorg"));
                memberMap.put("chcompany", entry.get("chcompany"));
                adjustEntries.add(memberMap);
            }
        }
        QFilter proFilter = new QFilter("project", "=", project);
        proFilter.and("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        proFilter.and("auditstatus", "=", (Object)AuditStatusEnum.AUDITED.getValue());
        for (DynamicObject addmember : addTeamBills = BusinessDataServiceHelper.load((String)"pmas_addtmemberbill", (String)("id,billstatus,auditstatus,auditdate,applytime,project,opinion,tmemberentry.id,tmemberentry.member,tmemberentry.role,tmemberentry.telno,tmemberentry.note," + String.join((CharSequence)",", "insideorg", "insidecompany")), (QFilter[])new QFilter[]{proFilter})) {
            Object auditDate = addmember.get("auditdate");
            DynamicObjectCollection memberEntries = addmember.getDynamicObjectCollection("tmemberentry");
            for (DynamicObject entry : memberEntries) {
                DynamicObject member = entry.getDynamicObject("member");
                DynamicObject role = entry.getDynamicObject("role");
                HashMap<String, Object> memberMap = new HashMap<String, Object>();
                memberMap.put("chmember", member);
                memberMap.put("chrole", role);
                memberMap.put("chtelno", entry.get("telno"));
                memberMap.put("chnote", entry.get("note"));
                memberMap.put("ischargech", Boolean.FALSE);
                memberMap.put("chchangetype", TeamAdjustTypeEnum.APPLY_IN.getValue());
                memberMap.put("date", auditDate);
                memberMap.put("prerole", null);
                memberMap.put("chorg", entry.get("insideorg"));
                memberMap.put("chcompany", entry.get("insidecompany"));
                adjustEntries.add(memberMap);
            }
        }
        adjustEntries = adjustEntries.stream().sorted(Comparator.comparing(o -> (Date)o.get("date")).reversed()).collect(Collectors.toList());
        return adjustEntries;
    }

    private boolean checkIsNowMember(DynamicObject member) {
        if (member == null) {
            return false;
        }
        DynamicObjectCollection entries = this.getModel().getEntryEntity("nowteamentry");
        long count = entries.stream().filter(o -> member.getPkValue().equals(o.getDynamicObject("member").getPkValue())).count();
        return count > 0L;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        switch (operateKey) {
            case "newteam": {
                if (project == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"ProjTeamViewUIPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    break;
                }
                QFilter filter = new QFilter("project", "=", project.getPkValue());
                DynamicObjectCollection teams = QueryServiceHelper.query((String)"pmas_team", (String)"id,billname,billno,billstatus", (QFilter[])new QFilter[]{filter});
                if (teams.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u5df2\u521b\u5efa\u3002", (String)"ProjTeamViewUIPlugin_1", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("formId", "pmas_team");
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(map);
                showParameter.setCustomParam("projectId", project.getPkValue());
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setStatus(OperationStatus.ADDNEW);
                this.getView().showForm(showParameter);
                break;
            }
            case "adjustteam": {
                if (project == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9879\u76ee\u3002", (String)"ProjTeamViewUIPlugin_0", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    break;
                }
                QFilter filter1 = new QFilter("project", "=", project.getPkValue());
                DynamicObjectCollection teams1 = QueryServiceHelper.query((String)"pmas_team", (String)"id,billname,billno,billstatus", (QFilter[])new QFilter[]{filter1});
                if (teams1.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u9879\u76ee\u56e2\u961f\u3002", (String)"ProjTeamViewUIPlugin_2", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String statusA = BillStatus.A.name();
                String statusB = BillStatus.B.name();
                QFilter filter2 = new QFilter("billstatus", "in", Arrays.asList(statusA, statusB));
                QFilter filter3 = new QFilter("project", "=", project.getPkValue());
                DynamicObjectCollection teams2 = QueryServiceHelper.query((String)"pmas_team", (String)"id,billname,billno,billstatus", (QFilter[])new QFilter[]{filter2, filter3});
                if (teams2.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5ba1\u6838\u5df2\u5b58\u5728\u7684\u672a\u5ba1\u6838\u8c03\u6574\u56e2\u961f\u6216\u56e2\u961f\u3002", (String)"ProjTeamViewUIPlugin_3", (String)"pmgt-pmas-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("formId", "pmas_teamadjust");
                FormShowParameter showParameter1 = FormShowParameter.createFormShowParameter(map1);
                showParameter1.setCustomParam("projectId", project.getPkValue());
                showParameter1.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter1.setStatus(OperationStatus.ADDNEW);
                this.getView().showForm(showParameter1);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String name = e.getProperty().getName();
        Object newValue = changeData.getNewValue();
        switch (name) {
            case "project": {
                DynamicObject project = (DynamicObject)newValue;
                if (project != null) {
                    this.loadData(project.getPkValue());
                    break;
                }
                this.getModel().deleteEntryData("nowteamentry");
                this.getModel().deleteEntryData("chteamentry");
                break;
            }
        }
    }
}

