/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.pmgt.pmbs.common.enums.InvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.OutInvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.TextHelper;
import kd.pmgt.pmct.api.ContractService;

public class ContractServiceImpl
implements ContractService {
    public static final String BILLPROPERTY_BLUE = "0";
    public static final String BILLPROPERTY_RED = "1";
    public static final String INVOICESTATUS_6 = "6";
    private static final Log log = LogFactory.getLog(ContractServiceImpl.class);

    public void updateContractField(long contractPk, Map<String, BigDecimal> fieldToAmtMap) {
        if (fieldToAmtMap == null || fieldToAmtMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u5b57\u6bb5\u96c6\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u8981\u66f4\u65b0\u7684\u5b57\u6bb5\u3002", (String)"ContractServiceImpl_0", (String)"pmgt-pmct-mservice", (Object[])new Object[0]));
        }
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_outcontract");
        for (Map.Entry<String, BigDecimal> entry : fieldToAmtMap.entrySet()) {
            String fieldName = entry.getKey();
            BigDecimal amount = entry.getValue();
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"reimbursedamt")) {
                BigDecimal totalApplyOfTaxAmount = (BigDecimal)contract.get("totalapplyoftaxamount");
                contract.set("totalapplyoftaxamount", (Object)totalApplyOfTaxAmount.add(amount));
                continue;
            }
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"paidamt")) continue;
            BigDecimal totalRealOfTaxAmount = (BigDecimal)contract.get("totalrealoftaxamount");
            contract.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount.add(amount));
        }
        SaveServiceHelper.update((DynamicObject)contract);
    }

    public void updateContractPayItemField(long payItemId, Map<String, BigDecimal> fieldToAmtMap) {
        if (fieldToAmtMap == null || fieldToAmtMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u66f4\u65b0\u5b57\u6bb5\u96c6\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u8981\u66f4\u65b0\u7684\u5b57\u6bb5\u3002", (String)"ContractServiceImpl_0", (String)"pmgt-pmct-mservice", (Object[])new Object[0]));
        }
        DynamicObject payItemObj = BusinessDataServiceHelper.loadSingle((Object)payItemId, (String)"pmbs_contractpayitem");
        DynamicObject contract = (DynamicObject)payItemObj.get("contract");
        QFilter idFilter = new QFilter("id", "=", contract.getPkValue());
        contract = BusinessDataServiceHelper.loadSingle((String)"pmct_outcontract", (String)"totalapplyoftaxamount,totalrealoftaxamount", (QFilter[])new QFilter[]{idFilter});
        for (Map.Entry<String, BigDecimal> entry : fieldToAmtMap.entrySet()) {
            String fieldName = entry.getKey();
            BigDecimal amount = entry.getValue();
            BigDecimal oldAmount = (BigDecimal)payItemObj.get(fieldName);
            payItemObj.set(fieldName, (Object)oldAmount.add(amount));
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"reimbursedamt")) {
                BigDecimal totalApplyOfTaxAmount = (BigDecimal)contract.get("totalapplyoftaxamount");
                contract.set("totalapplyoftaxamount", (Object)totalApplyOfTaxAmount.add(amount));
                continue;
            }
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"paidamt")) continue;
            BigDecimal totalRealOfTaxAmount = (BigDecimal)contract.get("totalrealoftaxamount");
            contract.set("totalrealoftaxamount", (Object)totalRealOfTaxAmount.add(amount));
        }
        SaveServiceHelper.update((DynamicObject)payItemObj);
        SaveServiceHelper.update((DynamicObject)contract);
    }

    public JSONObject updateContractInvoiceInfo(JSONObject jsonObject) {
        log.info("doCustomService params:{}", (Object)jsonObject);
        return this.updateInvoiceInfo(jsonObject);
    }

    private void calAmount(DynamicObject singleContract) {
        QFilter filter = new QFilter("contract", "=", (Object)Long.parseLong(singleContract.getPkValue().toString()));
        filter.and(new QFilter("invoicestatus", "!=", (Object)OutInvoiceStatusEnum.CANCEL_6.getValue()));
        filter.and(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalOfTaxAmount = BigDecimal.ZERO;
        DynamicObject[] outInvoices = BusinessDataServiceHelper.load((String)"pmct_outinvoice", (String)"totaloftaxamount,totalamount", (QFilter[])new QFilter[]{filter});
        if (outInvoices != null && outInvoices.length > 0) {
            for (DynamicObject outInvoice : outInvoices) {
                totalAmount = totalAmount.add(outInvoice.getBigDecimal("totalamount"));
                totalOfTaxAmount = totalOfTaxAmount.add(outInvoice.getBigDecimal("totaloftaxamount"));
            }
        }
        singleContract.set("totalinvoiceamount", (Object)totalAmount);
        singleContract.set("totalinvoiceoftaxamount", (Object)totalOfTaxAmount);
    }

    protected JSONObject updateInvoiceInfo(JSONObject jsonObject) {
        JSONObject invoiceData = jsonObject.getJSONObject("invoiceData");
        JSONArray billInfo = jsonObject.getJSONArray("BillInfos");
        String invoiceNo = invoiceData.getString("invoiceno");
        String invoiceCode = invoiceData.getString("invoicecode");
        String oriInvoiceCode = invoiceData.getString("originalinvoicecode");
        String oriInvoiceNo = invoiceData.getString("originalinvoiceno");
        String billNo = billInfo.getJSONObject(0).getString("contractno");
        String resultStatus = invoiceData.getString("invoicestatus");
        String formType = invoiceData.getString("issuetype");
        String sourceType = billInfo.getJSONObject(0).getString("systemsource").split("_")[2];
        JSONObject result = new JSONObject();
        if (StringUtils.equals((CharSequence)formType, (CharSequence)BILLPROPERTY_RED)) {
            if (StringUtils.equals((CharSequence)resultStatus, (CharSequence)INVOICESTATUS_6)) {
                result = this.cancelOutInvoice(BILLPROPERTY_RED, invoiceNo, invoiceCode, oriInvoiceCode, oriInvoiceNo);
                if (result.isEmpty()) {
                    this.updateContractInfo(sourceType, billNo);
                }
            } else {
                result = this.createRedInvoice(jsonObject);
            }
        } else if (StringUtils.equals((CharSequence)formType, (CharSequence)BILLPROPERTY_BLUE)) {
            if (StringUtils.equals((CharSequence)resultStatus, (CharSequence)INVOICESTATUS_6)) {
                result = this.cancelOutInvoice(BILLPROPERTY_BLUE, invoiceNo, invoiceCode, oriInvoiceCode, oriInvoiceNo);
                if (result.isEmpty()) {
                    this.updateContractInfo(sourceType, billNo);
                }
            } else {
                result = this.createBlueInvoice(jsonObject);
            }
        }
        if (result.isEmpty()) {
            result.put("errorcode", (Object)"0000");
            result.put("errormsg", (Object)"success");
        }
        return result;
    }

    private JSONObject createBlueInvoice(JSONObject jsonObject) {
        JSONObject invoiceData = jsonObject.getJSONObject("invoiceData");
        DynamicObject outInvoice = this.createInvoiceInfo(jsonObject);
        outInvoice.set("invoicestatus", (Object)InvoiceStatusEnum.NORMAL_0.getValue());
        BigDecimal totalAmount = invoiceData.getBigDecimal("invoiceamount");
        outInvoice.set("totalamount", (Object)totalAmount);
        BigDecimal totalOfTaxAmount = invoiceData.getBigDecimal("totalamount");
        outInvoice.set("totaloftaxamount", (Object)totalOfTaxAmount);
        outInvoice.set("totaltax", (Object)NumberHelper.subtract((Object)totalOfTaxAmount, (Object)totalAmount));
        OperationResult operationResultSubmit = OperationServiceHelper.executeOperate((String)"submit", (String)"pmct_outinvoice", (DynamicObject[])new DynamicObject[]{outInvoice}, (OperateOption)this.create(OperateOption.create()));
        return this.doInvoiceAuditOP(outInvoice, operationResultSubmit);
    }

    private JSONObject createRedInvoice(JSONObject jsonObject) {
        JSONObject invoiceData = jsonObject.getJSONObject("invoiceData");
        DynamicObject outInvoiceDynamicObj = this.createInvoiceInfo(jsonObject);
        outInvoiceDynamicObj.set("invoicestatus", (Object)InvoiceStatusEnum.NORMAL_0.getValue());
        BigDecimal totalAmount = invoiceData.getBigDecimal("invoiceamount");
        outInvoiceDynamicObj.set("totalamount", (Object)totalAmount);
        BigDecimal totalOfTaxAmount = invoiceData.getBigDecimal("totalamount");
        outInvoiceDynamicObj.set("totaloftaxamount", (Object)totalOfTaxAmount);
        outInvoiceDynamicObj.set("totaltax", (Object)NumberHelper.subtract((Object)totalOfTaxAmount, (Object)totalAmount));
        String oriInvoiceNo = invoiceData.getString("originalinvoiceno");
        String oriInvoiceCode = invoiceData.getString("originalinvoicecode");
        DynamicObject oriInvoiceDynamicObj = this.loadInvoice(oriInvoiceNo, oriInvoiceCode, null);
        if (oriInvoiceDynamicObj != null) {
            String reverseInvoiceId = oriInvoiceDynamicObj.getPkValue().toString();
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_outinvoice");
            DynamicObject invoiceF7 = BusinessDataServiceHelper.loadSingle((Object)reverseInvoiceId, (DynamicObjectType)dt);
            DynamicObjectCollection reverseInvoiceCollection = outInvoiceDynamicObj.getDynamicObjectCollection("reverseinvoice");
            DynamicObject reverseInvoice = new DynamicObject(reverseInvoiceCollection.getDynamicObjectType());
            reverseInvoice.set("fbasedataid", (Object)invoiceF7);
            reverseInvoiceCollection.add((Object)reverseInvoice);
        }
        OperationResult operationResultSubmit = OperationServiceHelper.executeOperate((String)"submit", (String)"pmct_outinvoice", (DynamicObject[])new DynamicObject[]{outInvoiceDynamicObj}, (OperateOption)this.create(OperateOption.create()));
        JSONObject result = this.doInvoiceAuditOP(outInvoiceDynamicObj, operationResultSubmit);
        return result;
    }

    private JSONObject doInvoiceAuditOP(DynamicObject outInvoice, OperationResult operationResultSubmit) {
        JSONObject result = new JSONObject();
        StringBuilder errors = new StringBuilder();
        if (operationResultSubmit.isSuccess()) {
            OperationResult operationResultAudit = OperationServiceHelper.executeOperate((String)"audit", (String)"pmct_outinvoice", (DynamicObject[])new DynamicObject[]{outInvoice}, (OperateOption)this.create(OperateOption.create()));
            if (!operationResultAudit.isSuccess()) {
                ValidateResultCollection validateResult = operationResultAudit.getValidateResult();
                List validateErrors = validateResult.getValidateErrors();
                for (ValidateResult errorInfo : validateErrors) {
                    errorInfo.getAllErrorInfo().forEach(item -> errors.append(item.getMessage()));
                }
                result.put("errorcode", (Object)"2001");
                result.put("errormsg", (Object)errors.toString());
                return result;
            }
        } else {
            ValidateResultCollection validateResult = operationResultSubmit.getValidateResult();
            List validateErrors = validateResult.getValidateErrors();
            for (ValidateResult errorInfo : validateErrors) {
                errorInfo.getAllErrorInfo().forEach(item -> errors.append(item.getMessage()));
            }
            result.put("errorcode", (Object)"2001");
            result.put("errormsg", (Object)errors.toString());
            return result;
        }
        return result;
    }

    private JSONObject cancelOutInvoice(String formType, String invoiceNo, String invoiceCode, String oriInvoiceCode, String oriInvoiceNo) {
        JSONObject result = new JSONObject();
        QFilter qFilter = new QFilter("invoicestatus", "<>", (Object)OutInvoiceStatusEnum.CANCEL_6.getValue());
        DynamicObject outInvoiceObj = this.loadInvoice(invoiceNo, invoiceCode, qFilter);
        if (outInvoiceObj == null) {
            String errorCode = formType.equals(BILLPROPERTY_RED) ? "4040" : "1001";
            result.put("errorcode", (Object)errorCode);
            result.put("errormsg", (Object)String.format(ResManager.loadKDString((String)"\u9700\u8981\u4f5c\u5e9f\u7684\u53d1\u7968\u4e3a\u7a7a\uff0c\u53d1\u7968\u7f16\u7801\u201c%s\u201d\u3002", (String)"ContractServiceImpl_4", (String)"pmgt-pmct-mservice", (Object[])new Object[0]), invoiceNo));
            return result;
        }
        outInvoiceObj.set("invoicestatus", (Object)OutInvoiceStatusEnum.CANCEL_6.getValue());
        if (formType.equals(BILLPROPERTY_RED)) {
            this.updateBlueInvoiceInfo(oriInvoiceNo, oriInvoiceCode, outInvoiceObj);
        }
        SaveServiceHelper.update((DynamicObject)outInvoiceObj);
        return result;
    }

    private void updateBlueInvoiceInfo(String oriInvoiceNo, String oriInvoiceCode, DynamicObject outInvoiceObj) {
        DynamicObject oriInvoiceDynamicObj = this.loadInvoice(oriInvoiceNo, oriInvoiceCode, null);
        if (oriInvoiceDynamicObj == null) {
            return;
        }
        DynamicObjectCollection reverseInvoices = oriInvoiceDynamicObj.getDynamicObjectCollection("reverseinvoice");
        String invoiceStatus = outInvoiceObj.getString("invoicestatus");
        if (OutInvoiceStatusEnum.CANCEL_6.getValue().equals(invoiceStatus)) {
            if (!reverseInvoices.isEmpty()) {
                reverseInvoices.removeIf(reverseInvoice -> reverseInvoice.getDynamicObject("fbasedataid").get("id").equals(outInvoiceObj.getPkValue()));
            }
        } else {
            DynamicObjectType dt = reverseInvoices.getDynamicObjectType();
            DynamicObject reverseInvoice2 = new DynamicObject(dt);
            reverseInvoice2.set("fbasedataid", (Object)outInvoiceObj);
            reverseInvoices.add((Object)reverseInvoice2);
        }
        if (reverseInvoices.size() > 0) {
            Set reverseIds = reverseInvoices.stream().map(reverse -> Long.parseLong(reverse.getDynamicObject("fbasedataid").get("id").toString())).collect(Collectors.toSet());
            DynamicObject[] redInvoices = BusinessDataServiceHelper.load((String)"pmct_outinvoice", (String)"totaloftaxamount", (QFilter[])new QFilter[]{new QFilter("id", "in", reverseIds)});
            BigDecimal totalOfTaxAmount = BigDecimal.ZERO;
            for (DynamicObject redInvoice : redInvoices) {
                totalOfTaxAmount = totalOfTaxAmount.add(BigDecimal.ZERO.subtract(redInvoice.getBigDecimal("totaloftaxamount")));
            }
            if (oriInvoiceDynamicObj.getBigDecimal("totaloftaxamount").compareTo(totalOfTaxAmount) == 0) {
                oriInvoiceDynamicObj.set("invoicestatus", (Object)InvoiceStatusEnum.REDPUNCHING_3.getValue());
            } else {
                oriInvoiceDynamicObj.set("invoicestatus", (Object)InvoiceStatusEnum.NORMAL_0.getValue());
            }
        } else {
            oriInvoiceDynamicObj.set("invoicestatus", (Object)InvoiceStatusEnum.NORMAL_0.getValue());
        }
        SaveServiceHelper.update((DynamicObject)oriInvoiceDynamicObj);
    }

    private DynamicObject loadInvoice(String invoiceNo, String invoiceCode, QFilter qFilter) {
        DynamicObject invoice;
        if (qFilter == null) {
            qFilter = new QFilter("invoiceno", "=", (Object)invoiceNo);
        } else {
            qFilter.and("invoiceno", "=", (Object)invoiceNo);
        }
        if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
            qFilter.and("invoicecode", "=", (Object)invoiceCode);
        }
        if ((invoice = BusinessDataServiceHelper.loadSingle((String)"pmct_outinvoice", (String)"id", (QFilter[])new QFilter[]{qFilter})) != null) {
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"pmct_outinvoice");
        }
        return invoice;
    }

    private void updateContractInfo(String sourceType, String billNo) {
        switch (sourceType) {
            case "INCONTRACT": 
            case "INCOMEAPPLY": 
            case "CONSETTLE": {
                this.updateContractContract(billNo);
                break;
            }
        }
    }

    private void updateContractContract(String contractNo) {
        DynamicObject contractObj = BusinessDataServiceHelper.loadSingle((String)"pmct_incontract", (String)"billno, billstatus, creator, auditor, modifier, auditdate, createtime, modifytime, contracttype, org, fiaccountorg, bizaccountorg, ismulticontract, otherpart, ismulticurrency, stdcurrency, currency, exratetable, exchangedate, exchangerate, signamount, stdtaxamount, stdoriginalamount, ismultirate, originaloftaxamount, taxrate, avgtaxrate, taxamount, originalamount, signdate, project, isonlist, contstatus, versionnumber, lastversionnumber, hasconttext, billname, description, totalsettleamount, totalsettleoftaxamount, totalapplyamount, totalapplyoftaxamount, totalrevisionamount, totalrevisionoftaxamount, totalclaimamount, totalclaimoftaxamount, totalamount, totalinvoiceamount, totalinvoiceoftaxamount, totalrealamount, totalrealoftaxamount, performtaxamount, appamount, apptaxamount, totaloftaxamount, totalcalofamt, totalcaloftaxamt, totalnotcalofamt, totalnotcaloftaxamt, paydirection, imageno, refcontract, contractstatus, signaddressdetail, signaddress, auditassign, partaperson, partaphone, partbperson, partbphone, partotherperson, partotherphone, electronicsign, signtype, usersign, customersign, thirdpartysign, totaladditionamount, totaladditionoftaxamt, parta, partb, multipartsettlement, multipaytype, radiofield, radiofield1, openedcontract, budgetitem", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)contractNo)});
        if (contractObj != null) {
            this.calAmount(contractObj);
            SaveServiceHelper.update((DynamicObject)contractObj);
        }
    }

    private DynamicObject createInvoiceInfo(JSONObject jsonObject) {
        QFilter saleFilter;
        DynamicObject seller;
        QFilter buyerFilter;
        DynamicObject buyer;
        String buyerName;
        String operator;
        boolean existCodeRule;
        JSONObject invoiceData = jsonObject.getJSONObject("invoiceData");
        Date invoiceDate = invoiceData.getDate("issuetime");
        String invoiceNo = invoiceData.getString("invoiceno");
        String invoiceCode = invoiceData.getString("invoicecode");
        String invoiceType = invoiceData.getString("invoicetype");
        JSONArray billInfo = jsonObject.getJSONArray("BillInfos");
        String billNo = billInfo.getJSONObject(0).getString("contractno");
        String sourceType = billInfo.getJSONObject(0).getString("systemsource").split("_")[2];
        QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceNo);
        if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
            qFilter.and("invoicecode", "=", (Object)invoiceCode);
        }
        if (QueryServiceHelper.exists((String)"pmct_outinvoice", (QFilter[])new QFilter[]{qFilter})) {
            return BusinessDataServiceHelper.loadSingle((String)"pmct_outinvoice", (String)"billno, billstatus, creator, auditor, org, auditdate, createtime, modifytime, modifier, invoicetype, connecttype, invoicecode, invoiceno, invoicedate, contract, project, source, invoicestatus, totalamount, totaltax, totaloftaxamount, currency, isclaimed, isprepay, isstate, buyer, buyertaxno, buyerbank, buyeraccount, buyeraddress, buyerphone, seller, sellertaxno, sellerbank, selleraccount, selleraddress, sellerphone, reverseinvoice", (QFilter[])new QFilter[]{qFilter});
        }
        MainEntityType outInvoiceType = EntityMetadataCache.getDataEntityType((String)"pmct_outinvoice");
        DynamicObject outInvoiceDynamicObj = new DynamicObject((DynamicObjectType)outInvoiceType, (Object)ORM.create().genLongId((IDataEntityType)outInvoiceType));
        outInvoiceDynamicObj.set("source", (Object)"05");
        JSONObject billOrg = invoiceData.getJSONObject("orgid");
        Long OrgId = Long.parseLong(billOrg.getString("id"));
        boolean exist = QueryServiceHelper.exists((String)"bos_org", (Object)OrgId);
        if (exist) {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)OrgId, (String)"bos_org");
            outInvoiceDynamicObj.set("org", (Object)org);
            DynamicObject currencyObj = CurrencyHelper.getCurrency((Long)org.getLong("id"));
            outInvoiceDynamicObj.set("currency", (Object)currencyObj);
        }
        if (existCodeRule = CodeRuleServiceHelper.isExist((String)"pmct_outinvoice", (DynamicObject)outInvoiceDynamicObj, (String)(OrgId + ""))) {
            CodeRuleServiceHelper.getCodeRule((String)"pmct_outinvoice", (DynamicObject)outInvoiceDynamicObj, (String)(OrgId + ""));
        } else {
            String nowTime = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date());
            SecureRandom secureRandom = new SecureRandom();
            String randomNum = String.format("%04d", secureRandom.nextInt(9999));
            outInvoiceDynamicObj.set("billno", (Object)("Output_" + nowTime + "_" + randomNum));
        }
        outInvoiceDynamicObj.set("invoiceno", (Object)invoiceNo);
        outInvoiceDynamicObj.set("invoicecode", (Object)invoiceCode);
        outInvoiceDynamicObj.set("invoicetype", (Object)invoiceType);
        outInvoiceDynamicObj.set("invoicedate", (Object)invoiceDate);
        outInvoiceDynamicObj.set("billstatus", (Object)"A");
        JSONObject invoicingOperator = invoiceData.getJSONObject("invoicingoperator");
        long userId = invoicingOperator != null ? (StringUtils.isNotEmpty((CharSequence)(operator = invoicingOperator.getString("id"))) ? Long.parseLong(operator) : RequestContext.get().getCurrUserId()) : RequestContext.get().getCurrUserId();
        if (QueryServiceHelper.exists((String)"bos_user", (Object)userId)) {
            outInvoiceDynamicObj.set("creator", (Object)BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user"));
            long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
            if (QueryServiceHelper.exists((String)"bos_org", (Object)userMainOrgId)) {
                outInvoiceDynamicObj.set("createorg", (Object)BusinessDataServiceHelper.loadSingle((Object)userMainOrgId, (String)"bos_org"));
            }
        }
        if ((buyerName = invoiceData.getString("buyername")) != null && !buyerName.isEmpty() && (buyer = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartner", (String)"name", (QFilter[])new QFilter[]{buyerFilter = new QFilter("name", "=", (Object)buyerName)})) != null) {
            outInvoiceDynamicObj.set("buyer", (Object)buyer);
        }
        outInvoiceDynamicObj.set("buyertaxno", (Object)invoiceData.getString("buyertaxno"));
        String buyerAddress = invoiceData.getString("buyeraddr");
        outInvoiceDynamicObj.set("buyeraddress", (Object)TextHelper.getAddress((String)buyerAddress));
        outInvoiceDynamicObj.set("buyerphone", (Object)TextHelper.getPhoneNum((String)buyerAddress));
        String buyerBank = invoiceData.getString("buyerbank");
        outInvoiceDynamicObj.set("buyerbank", (Object)TextHelper.getBankName((String)buyerBank));
        outInvoiceDynamicObj.set("buyeraccount", (Object)TextHelper.getPhoneNum((String)buyerBank));
        String sellerName = invoiceData.getString("salername");
        if (sellerName != null && !sellerName.isEmpty() && (seller = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{saleFilter = new QFilter("name", "=", (Object)sellerName)})) != null) {
            outInvoiceDynamicObj.set("seller", (Object)seller);
        }
        outInvoiceDynamicObj.set("sellertaxno", (Object)invoiceData.getString("salertaxno"));
        String sellerAddress = invoiceData.getString("saleraddr");
        outInvoiceDynamicObj.set("selleraddress", (Object)TextHelper.getAddress((String)sellerAddress));
        outInvoiceDynamicObj.set("sellerphone", (Object)TextHelper.getPhoneNum((String)sellerAddress));
        String sellerBank = invoiceData.getString("salerbank");
        outInvoiceDynamicObj.set("sellerbank", (Object)TextHelper.getBankName((String)sellerBank));
        outInvoiceDynamicObj.set("selleraccount", (Object)TextHelper.getBankNum((String)sellerBank));
        JSONArray entries = invoiceData.getJSONArray("items");
        DynamicObjectCollection entityEntries = outInvoiceDynamicObj.getDynamicObjectCollection("entryentity");
        for (Object json : entries) {
            JSONObject jsonEntry = (JSONObject)json;
            DynamicObject entity = entityEntries.addNew();
            entity.set("name", (Object)jsonEntry.getString("goodsname"));
            entity.set("model", (Object)jsonEntry.getString("specification"));
            entity.set("unit", this.getUnit(jsonEntry.getString("unit")));
            entity.set("qty", (Object)jsonEntry.getString("num"));
            entity.set("oftaxprice", (Object)jsonEntry.getString("taxunitprice"));
            entity.set("taxvalue", (Object)NumberHelper.multiply((Object)NumberHelper.ONE_HUNDRED, (Object)jsonEntry.getBigDecimal("taxrate"), (int)4));
            entity.set("oftaxamount", (Object)jsonEntry.getString("taxamount"));
            entity.set("tax", (Object)jsonEntry.getString("tax"));
            entity.set("price", (Object)jsonEntry.getString("unitprice"));
            entity.set("amount", (Object)jsonEntry.getString("amount"));
        }
        outInvoiceDynamicObj.set("entryentity", (Object)entityEntries);
        if (QueryServiceHelper.exists((String)"pmct_contractf7", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)})) {
            DynamicObject contractF7 = BusinessDataServiceHelper.loadSingle((String)"pmct_contractf7", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
            switch (sourceType) {
                case "INCONTRACT": 
                case "INCOMEAPPLY": 
                case "CONSETTLE": {
                    outInvoiceDynamicObj.set("contract", (Object)contractF7);
                    outInvoiceDynamicObj.set("isclaimed", (Object)true);
                    outInvoiceDynamicObj.set("isused", (Object)false);
                    outInvoiceDynamicObj.set("project", (Object)contractF7.getDynamicObject("project"));
                    break;
                }
            }
        }
        return outInvoiceDynamicObj;
    }

    protected Object getUnit(String unitName) {
        Object[] unitObjects;
        Object unitObject = null;
        if (StringUtils.isEmpty((CharSequence)unitName)) {
            return null;
        }
        boolean flag = QueryServiceHelper.exists((String)"bd_measureunits", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)unitName), new QFilter("enable", "=", (Object)BILLPROPERTY_RED)});
        if (flag && ArrayUtils.isNotEmpty((Object[])(unitObjects = BusinessDataServiceHelper.load((String)"bd_measureunits", (String)"name,number", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)unitName), new QFilter("enable", "=", (Object)BILLPROPERTY_RED)})))) {
            unitObject = unitObjects[0];
        }
        return unitObject;
    }

    private OperateOption create(OperateOption option) {
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        return option;
    }
}

