/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.webapi.esign;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.AESHelper;
import kd.pmgt.pmbs.business.helper.SignInfoHelper;

public class ESignCallBack
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(ESignCallBack.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        log.info("doCustomService params:{}", params);
        String signCode = (String)params.get("sign");
        if (signCode == null || signCode.isEmpty()) {
            String msg = "sign is null or empty";
            return this.getResult(msg, "1", false);
        }
        String kdAppId = (String)params.get("kdAppId");
        if (kdAppId == null || kdAppId.isEmpty()) {
            String msg = "kdAppId is null or empty";
            return this.getResult(msg, "2", false);
        }
        String uuid = SignInfoHelper.getContractSubjectUUIDByKDAppId((Object)kdAppId);
        log.info("uuid is : " + uuid);
        String sign = AESHelper.decrypt((String)uuid, (String)signCode);
        log.info("decode sign is {}: ", (Object)sign);
        JSONObject signObj = JSONObject.parseObject((String)sign);
        String userId = signObj.getString("userId");
        String contractNo = signObj.getString("contractNo");
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((String)"pmct_contracttpl", (String)"usersign,customersign", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)contractNo)});
        if (contract == null) {
            String msg = "contract is null";
            return this.getResult(msg, "3", false);
        }
        String contractSubjectFid = SignInfoHelper.getContractSubjectByCompanyId((Object)userId);
        if (contractSubjectFid != null) {
            contract.set("usersign", (Object)true);
            SaveServiceHelper.update((DynamicObject)contract);
            return this.getResult("success", "0", true);
        }
        String companyAuthId = SignInfoHelper.getCompanyAuthByCompanyId((Object)userId);
        if (companyAuthId != null) {
            contract.set("customersign", (Object)true);
            SaveServiceHelper.update((DynamicObject)contract);
            return this.getResult("success", "0", true);
        }
        String msg = "can not find ContractSubject or CompanyAuth";
        return this.getResult(msg, "4", false);
    }

    private ApiResult getResult(String msg, String errorCode, boolean success) {
        ApiResult apiResult = new ApiResult();
        apiResult.setData(null);
        apiResult.setSuccess(success);
        apiResult.setMessage(msg);
        apiResult.setErrorCode(errorCode);
        return apiResult;
    }
}

