/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmct.common.enums.ReferBillTypeEnum;

public class ContractSettlePayItemDetailOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fields = e.getFieldKeys();
        fields.add("payitemdetailentry");
        fields.add("referbilltype");
        fields.add("referbillid");
        fields.add("referentryid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new ContractSettlePayItemDetailValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operationKey = e.getOperationKey();
        DynamicObject[] settleBillArr = e.getDataEntities();
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)operationKey) || StringUtils.equals((CharSequence)"unaudit", (CharSequence)operationKey)) {
            for (int i = 0; i < settleBillArr.length; ++i) {
                int j;
                HashSet<Long> claimBillIdSet = new HashSet<Long>(16);
                HashSet<Long> performRecordBillIdSet = new HashSet<Long>(16);
                HashSet<Long> performRecordEntryIdSet = new HashSet<Long>(16);
                DynamicObject settleBill = settleBillArr[i];
                DynamicObjectCollection payItemDetailEntryCol = settleBill.getDynamicObjectCollection("payitemdetailentry");
                for (DynamicObject payItemDetailEntry : payItemDetailEntryCol) {
                    String referBillType = payItemDetailEntry.getString("referbilltype");
                    Long referBillId = payItemDetailEntry.getLong("referbillid");
                    if (StringUtils.equals((CharSequence)"claim", (CharSequence)referBillType)) {
                        claimBillIdSet.add(referBillId);
                        continue;
                    }
                    if (!StringUtils.equals((CharSequence)"perform", (CharSequence)referBillType)) continue;
                    Long performRecordEntryId = payItemDetailEntry.getLong("referentryid");
                    performRecordBillIdSet.add(referBillId);
                    performRecordEntryIdSet.add(performRecordEntryId);
                }
                DynamicObject[] updateClaimBillArr = BusinessDataServiceHelper.load((String)"pmct_outclaimbill", (String)"id,issettle", (QFilter[])new QFilter[]{new QFilter("id", "in", claimBillIdSet)});
                DynamicObject[] updatePerformRecordBillArr = BusinessDataServiceHelper.load((String)"pmct_outperformrecords", (String)"entryentity.issettle", (QFilter[])new QFilter[]{new QFilter("id", "in", performRecordBillIdSet)});
                String isSettle = "1";
                if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)operationKey)) {
                    isSettle = "0";
                }
                for (j = 0; j < updateClaimBillArr.length; ++j) {
                    updateClaimBillArr[j].set("issettle", (Object)isSettle);
                }
                SaveServiceHelper.save((DynamicObject[])updateClaimBillArr);
                for (j = 0; j < updatePerformRecordBillArr.length; ++j) {
                    DynamicObjectCollection entryentity = updatePerformRecordBillArr[j].getDynamicObjectCollection("entryentity");
                    for (DynamicObject dynamicObject : entryentity) {
                        if (!performRecordEntryIdSet.contains(dynamicObject.getPkValue())) continue;
                        dynamicObject.set("issettle", (Object)isSettle);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])updatePerformRecordBillArr);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] settleBillArr = e.getDataEntities();
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)operationKey) || StringUtils.equals((CharSequence)"unaudit", (CharSequence)operationKey)) {
            Object pkValue = settleBillArr[0].getPkValue();
            settleBillArr[0].get("settleoftaxamount");
            DynamicObject settle = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pmct_incontract_settle");
            settle.get("settleoftaxamount");
            SaveServiceHelper.save((DynamicObject[])settleBillArr);
        }
    }

    private static class ContractSettlePayItemDetailValidator
    extends AbstractValidator {
        private ContractSettlePayItemDetailValidator() {
        }

        public void validate() {
            String operateKey = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (StringUtils.equals((CharSequence)"audit", (CharSequence)operateKey)) {
                QFilter isNotSettledFilter = new QFilter("issettle", "=", (Object)"0");
                for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                    DynamicObject settle = extendedDataEntity.getDataEntity();
                    DynamicObjectCollection payItemDetailEntryCol = settle.getDynamicObjectCollection("payitemdetailentry");
                    for (int i = 0; i < payItemDetailEntryCol.size(); ++i) {
                        DynamicObject payItemDetailEntry = (DynamicObject)payItemDetailEntryCol.get(i);
                        String referBillType = payItemDetailEntry.getString("referbilltype");
                        Long referBillId = payItemDetailEntry.getLong("referbillid");
                        String formatText = String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u9879\u660e\u7ec6\u5206\u5f55\u7684\u7b2c%s\u884c\u5df2\u7ed3\u7b97\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u3002", (String)"ContractSettlePayItemDetailOp_0", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), i + 1);
                        if (StringUtils.equals((CharSequence)ReferBillTypeEnum.CLAIM.getValue(), (CharSequence)referBillType)) {
                            boolean isNotSettled = QueryServiceHelper.exists((String)"pmct_outclaimbill", (QFilter[])new QFilter[]{isNotSettledFilter, new QFilter("id", "=", (Object)referBillId)});
                            if (isNotSettled) continue;
                            this.addErrorMessage(extendedDataEntity, formatText);
                            continue;
                        }
                        if (!StringUtils.equals((CharSequence)ReferBillTypeEnum.PERFORM.getValue(), (CharSequence)referBillType)) continue;
                        Long performRecordEntryId = payItemDetailEntry.getLong("referentryid");
                        QFilter billIdFilter = new QFilter("id", "=", (Object)referBillId);
                        QFilter entryIdFilter = new QFilter("entryentity.id", "=", (Object)performRecordEntryId);
                        QFilter entrySettledFilter = new QFilter("entryentity.issettle", "=", (Object)"0");
                        boolean isNotSettled = QueryServiceHelper.exists((String)"pmct_outperformrecords", (QFilter[])new QFilter[]{billIdFilter, entryIdFilter, entrySettledFilter});
                        if (isNotSettled) continue;
                        this.addErrorMessage(extendedDataEntity, formatText);
                    }
                }
            }
        }
    }
}

