/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;

public class CreateImageOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CreateImageOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("billno");
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("imageno");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block32: {
            super.beginOperationTransaction(e);
            if ("submit".equals(e.getOperationKey())) {
                boolean openImageSys;
                Object appParameter = SystemParamHelper.getAppParameter((String)"openimagesys", (String)"pmct");
                boolean bl = openImageSys = appParameter == null ? false : (Boolean)appParameter;
                if (!openImageSys) {
                    return;
                }
                DynamicObject[] dataEntities = e.getDataEntities();
                try (TXHandle h = TX.requiresNew();){
                    try {
                        this.getImageNo(dataEntities);
                        break block32;
                    }
                    catch (Throwable e1) {
                        h.markRollback();
                        throw e1;
                    }
                }
            }
            if (StringUtils.equals((CharSequence)"delete", (CharSequence)e.getOperationKey())) {
                DynamicObject[] dataEntities = e.getDataEntities();
                try (TXHandle h = TX.requiresNew();){
                    try {
                        String userName = RequestContext.get().getUserName();
                        for (DynamicObject elem : dataEntities) {
                            if (elem.getString("imageno").trim().length() <= 0) continue;
                            ImageServiceHelper.deleteImage((String)elem.getString("imageno"), (String)userName, null);
                        }
                    }
                    catch (Throwable e1) {
                        h.markRollback();
                        throw e1;
                    }
                }
            }
        }
    }

    private boolean getImageNo(DynamicObject[] dataEntities) {
        boolean flag = false;
        for (DynamicObject elem : dataEntities) {
            Long orgId = (Long)elem.getDynamicObject("org").getPkValue();
            if (elem.getString("imageno").trim().length() > 0) continue;
            String imageNumber = this.getImgNum(elem, orgId);
            elem.set("imageno", (Object)imageNumber);
            flag = true;
        }
        return flag;
    }

    public String getImgNum(DynamicObject dataEntry, Long orgId) {
        String billNumber = dataEntry.getString("billno");
        if (StringUtils.isEmpty((CharSequence)billNumber)) {
            return "";
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_billimagemap");
        DynamicObject getImgNumParam = new DynamicObject((DynamicObjectType)type);
        DynamicObject creator = dataEntry.getDynamicObject("creator");
        DynamicObject modifier = dataEntry.getDynamicObject("modifier");
        Date createTime = dataEntry.getDate("createtime");
        Date modifyTime = dataEntry.getDate("modifytime");
        Long billId = dataEntry.getLong("id");
        getImgNumParam.set("billid", (Object)billId);
        getImgNumParam.set("billnumber", (Object)billNumber);
        getImgNumParam.set("billtype", (Object)dataEntry.getDataEntityType().getName());
        getImgNumParam.set("imagestate", (Object)"0");
        if (creator == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u521b\u5efa\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreateImageOp_2", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), billNumber));
        }
        getImgNumParam.set("creator", (Object)creator);
        getImgNumParam.set("createtime", (Object)createTime);
        if (modifier == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u4fee\u6539\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreateImageOp_3", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), billNumber));
        }
        getImgNumParam.set("modifier", (Object)modifier);
        getImgNumParam.set("modifytime", (Object)modifyTime);
        try {
            String imageNo = ImageServiceHelper.excuteImageStrategy((DynamicObject)getImgNumParam, (Long)orgId);
            return imageNo;
        }
        catch (Exception ex) {
            logger.error(String.format("generate imageno error cause: %s", ex));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\uff0c\u751f\u6210\u5f71\u50cf\u7f16\u7801\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CreateImageOp_4", (String)"pmgt-pmct-opplugin", (Object[])new Object[0]), billNumber));
        }
    }
}

