/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.opplugin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmct.business.helper.ContractRelationBillValidateHelper;
import kd.pmgt.pmct.business.helper.IncomePlanChangeHelper;
import kd.pmgt.pmct.business.helper.UnAuditHelper;
import kd.pmgt.pmct.business.model.ContractValidateResult;
import kd.pmgt.pmct.opplugin.validator.ContractRelationBillUnAuditValidator;

public class InContractRevisionOp
extends AbstractOperationServicePlugIn {
    protected IncomePlanChangeHelper incomePlanChangeHelper = new IncomePlanChangeHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("revisionoftaxamount");
        e.getFieldKeys().add("contract");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("currency");
        e.getFieldKeys().add("stdcurrency");
        e.getFieldKeys().add("exchangerate");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("isbasedonlist");
        e.getFieldKeys().add("kapianentry");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("subchangetype");
        e.getFieldKeys().add("hsbgje");
        e.getFieldKeys().add("oftax");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("billname");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("latestamountoftax");
        e.getFieldKeys().add("revisionoftaxamount");
        e.getFieldKeys().add("conplanitemid");
        e.getFieldKeys().add("incomeamountoftax");
        e.getFieldKeys().add("nodesetting");
        e.getFieldKeys().add("nodesettingsource");
        e.getFieldKeys().add("ctrlstrategy");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new ContractRelationBillUnAuditValidator());
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    String key = this.getOperateKey();
                    if (!StringUtils.equals((CharSequence)"submit", (CharSequence)key)) continue;
                    String visible = (String)this.getOption().getVariables().get("visible");
                    if (!Boolean.TRUE.toString().equals(visible)) continue;
                    this.checkContractCollectItem(dataEntity);
                }
            }

            private void checkContractCollectItem(ExtendedDataEntity dataEntity) {
                DynamicObject curDataEntity = dataEntity.getDataEntity();
                DynamicObjectCollection inChangePlanEntry = curDataEntity.getDynamicObjectCollection("incomeplanentry");
                if (!inChangePlanEntry.isEmpty()) {
                    BigDecimal latestAmountOfTax;
                    ContractValidateResult result;
                    boolean isOpenedContract;
                    DynamicObject contract = curDataEntity.getDynamicObject("contract");
                    boolean bl = isOpenedContract = null != contract.getDynamicObjectType().getProperty("openedcontract") ? contract.getBoolean("openedcontract") : Boolean.FALSE.booleanValue();
                    if (!isOpenedContract && (result = ContractRelationBillValidateHelper.checkOriginalOfTaxAmount((BigDecimal)(latestAmountOfTax = (BigDecimal)dataEntity.getValue("latestamountoftax")), (DynamicObjectCollection)inChangePlanEntry, (String)PayDirectionEnum.IN.getValue())).error()) {
                        this.addErrorMessage(dataEntity, result.getMsg());
                        return;
                    }
                    ContractValidateResult result2 = ContractRelationBillValidateHelper.checkCollectAmount((DynamicObjectCollection)inChangePlanEntry);
                    if (result2.error()) {
                        this.addWarningMessage(dataEntity, result2.getMsg().substring(0, result2.getMsg().length() - 1));
                    }
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block4: {
            DynamicObject[] dataEntities;
            String operationKey;
            block3: {
                super.beginOperationTransaction(e);
                operationKey = e.getOperationKey();
                dataEntities = e.getDataEntities();
                if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"audit")) break block3;
                for (DynamicObject dataEntity : dataEntities) {
                    DynamicObject curInRevision = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)"pmct_incontractrevision");
                    DynamicObject contract = curInRevision.getDynamicObject("contract");
                    QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
                    QFilter autogenFilter = new QFilter("autogenerated", "=", (Object)DefaultEnum.NO.getValue());
                    QFilter sourceFilter = new QFilter("sourcebilltype", "!=", (Object)PayPlanSourceEnum.PERFORM.getValue());
                    DynamicObject[] incomeItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"", (QFilter[])new QFilter[]{contractFilter, autogenFilter, sourceFilter});
                    if (incomeItems.length > 0) {
                        this.generateFundPlanChangeObj(curInRevision);
                    }
                    new ContractCollectItemHelper().doSave(dataEntity, PayPlanSourceEnum.MODIFY);
                }
                break block4;
            }
            if (!StringUtils.equals((CharSequence)operationKey, (CharSequence)"unaudit")) break block4;
            for (DynamicObject dataEntity : dataEntities) {
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontractrevision"));
                DynamicObject contract = bill.getDynamicObject("contract");
                contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontract"));
                DynamicObjectCollection planEntry = bill.getDynamicObjectCollection("incomeplanentry");
                UnAuditHelper.updateLastVersionData((DynamicObject)bill, (DynamicObjectCollection)planEntry);
            }
        }
    }

    private void generateFundPlanChangeObj(DynamicObject curInRevision) {
        Object sourceId = curInRevision.getPkValue();
        Object contractId = ((DynamicObject)curInRevision.get("contract")).getPkValue();
        String changeType = PayPlanSourceEnum.MODIFY.getValue();
        DynamicObjectCollection changeIncomePlans = curInRevision.getDynamicObjectCollection("incomeplanentry");
        DynamicObject fundPlanChangeObj = this.incomePlanChangeHelper.buildFundPlanChangeEntry(sourceId, contractId, changeType, (DynamicObject[])changeIncomePlans.toArray((Object[])new DynamicObject[0]), "pmct_incontractrevision", true);
        fundPlanChangeObj.set("sourcebillid", curInRevision.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fundPlanChangeObj});
    }
}

